/**
 * @file  constants.h

 * @author Ángel González Redondo
 * @author Dulce Isis Segarra López
 * @author Tomás Alemañ Baeza
 * @author Rómulo Espinosa Montoya
 * @author Jorge Torregrosa Lloret
 * @date   September, 2013
 * @brief  Main file of the game.
 *
 * This file contain the main loop of our game.
 * The game is made for the Retroconsolas Alicante 2013 event.
 *
 * It is released under a GPL 3.0 license.
 *	Copyright (C) 2013  Cocos
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Special thanks to Mochilote from CPCMANIA(www.cpcmania.com) for the info
 * and Raúl Simarro for the library. 
 *
 *   ____  _____  _  _    ____  __  __  ____   ___  __      __    ____
 *  ( ___)(  _  )( \/ )  (  _ \(  )(  )(  _ \ / __)(  )    /__\  (  _ \
 *   )__)  )(_)(  )  (    ) _ < )(__)(  )   /( (_-. )(__  /(__)\  )   /
 *  (__)  (_____)(_/\_)  (____/(______)(_)\_) \___/(____)(__)(__)(_)\_)
 *
 */

#ifndef CONSTANTS_H
#define CONSTANTS_H

#define PLAYER_WIDTH	11
#define PLAYER_HEIGHT	34
#define PLAYER_SIZE	    374

#define TILE_HEIGHT 8	//pixel
#define TILE_WIDTH 2	//pixel (4 bytes)	
#define MODE0_HEIGHT 200
#define MODE0_WIDTH 80
#define NUM_TILES_WIDTH 16
#define NUM_TILES_HEIGHT 32


#define INVINCIBLE_TIME   1500

#define GROUND_Y		8*16

#define MAP_MAX_X 			58
#define MAP_MAX_Y 			180

#define MAP_MIN_X 			0
#define MAP_MIN_Y 			0

#define L1_N_SPRITES	3


#define KEY_LEFT_P1	    0
#define KEY_RIGHT_P1	1
#define KEY_UP_P1		2
#define KEY_DOWN_P1	    3

#define KEY_LEFT_P2	    4
#define KEY_RIGHT_P2	5
#define KEY_UP_P2		6
#define KEY_DOWN_P2	    7

#define KEY_LEFT_P3	    8
#define KEY_RIGHT_P3	9
#define KEY_UP_P3		10
#define KEY_DOWN_P3	    11

#define KEY_ME1			12
#define KEY_ME2			13
#define KEY_ME3			14
#define KEY_ME4			15
#define KEY_ME5			16

#define KEY_ESC         17

// This access is more optimized in SDCC than array[i] reported by some users
// In recent versions this must be optimized in the same way than array[i]
#define FAST_ACCESS(p_array,index)   (*((p_array) + (index)))
#define FAST_P_ACCESS(p_array,index)   ((p_array) + (index))

#endif
