; TILEMAPCONF PARA PHANTOMAS TALES #1: MARSPORT / CPC
; (C) 2009 THE MOJON TWINS

	XLIB TileMapConf
	
	XDEF tiles
	XDEF pantalla_juego
	XDEF tiles_tocados
	XDEF posiciones_pantalla
	XDEF posiciones_super_buffer
	
	XDEF posicion_inicial_area_visible
	XDEF posicion_inicial_superbuffer
	XDEF ancho_pantalla_bytes
	XDEF alto_pantalla_bytes
	XDEF ancho_pantalla_bytes_visible
	
	XDEF tile11
	XDEF _tile_0

	XDEF mascara1
	XDEF mascara2
	
	; Voy a definir como mscara de los sprites el color 4
	
	; 0: $00, $00
	; 1: $80, $40
	; 2: $04, $08
	; 3: $44, $88
	; 4: $10, $20
	; 5: $50, $A0
	; 6: $14, $28
	; 7: $54, $A8
	; 8: $01, $02
	; 9: $41, $82
	; 10: $05, $0A
	; 11: $45, $8A
	; 12: $11, $22
	
	defc mascara1 = $10;
	defc mascara2 = $20;
	
; VALORES QUE DEFINEN EL BUFFER Y LA PANTALLA

	defc posicion_inicial_area_visible = $e8a8
	defc posicion_inicial_superbuffer = $100
	
	defc T_WIDTH = 	30 ;32 ;28 ;32 ;28 ;16			;max=40		;dimensiones de la pantalla en tiles
	defc T_HEIGHT = 20 ;16							;max=20
		
	defc ancho_pantalla_bytes = 2*T_WIDTH ; 2*T_WIDTH;		; El ancho de pantalla influye determinantemente en 
															; numerosas rutinas que hay que actualizar si se cambia
															; OJO con el modo
	defc alto_pantalla_bytes = 8*T_HEIGHT ;
	
	defc ancho_pantalla_bytes_visible = 2*T_WIDTH ;32  ; 64;		;dentro del area definida, cuanto se debe mostrar. 2*T_WIDTH

;El tamao del buffer es ancho_pantalla_bytes*alto_pantalla_bytes


.TileMapConf
;Con la definicin del mapeado hay que tener en cuenta que las coordenadas son:
;ANCHO=64 bytes (128 pixels en modo 0)
;ALTO=128 pixels

;el mximo que entra en el CPC es 20 lneas
;SI NO SE VAN A USAR TODAS LAS LINEAS, PARA AHORRA MEMORIA ES INTERESANTE COMENTARLAS

.posiciones_pantalla		;Posiciones en las que se dibujan los tiles
	defw posicion_inicial_area_visible+$50*0
	defw posicion_inicial_area_visible+$50*1  
	defw posicion_inicial_area_visible+$50*2
	defw posicion_inicial_area_visible+$50*3
	defw posicion_inicial_area_visible+$50*4
	defw posicion_inicial_area_visible+$50*5 
	defw posicion_inicial_area_visible+$50*6 
	defw posicion_inicial_area_visible+$50*7 
	defw posicion_inicial_area_visible+$50*8 
	defw posicion_inicial_area_visible+$50*9 
	defw posicion_inicial_area_visible+$50*10 
	defw posicion_inicial_area_visible+$50*11 
	defw posicion_inicial_area_visible+$50*12 
	defw posicion_inicial_area_visible+$50*13 
	defw posicion_inicial_area_visible+$50*14 
	defw posicion_inicial_area_visible+$50*15
	defw posicion_inicial_area_visible+$50*16
	defw posicion_inicial_area_visible+$50*17
	defw posicion_inicial_area_visible+$50*18
	defw posicion_inicial_area_visible+$50*19

.posiciones_super_buffer	;muestra el inicio de cada lnea (son 10 tiles de 8x16 de alto)

	;defw $1000, $1200, $1400, $1600, $1800, $1a00, $1c00, $1e00, $2000, $2200, $2400, $2600, $2800, $2a00, $2c00, $2f00
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*0
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*1
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*2
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*3
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*4
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*5
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*6
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*7
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*8
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*9
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*10
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*11
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*12
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*13
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*14
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*15
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*16
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*17
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*18
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*19
	
	;defw $1000, $1480, $1900, $1d80, $2200, $2680, $2b00, $2f80, $3400, $3880
	
;Rutinas para transferir bloques independientes a la pantalla

;Se busca el subbloque de 8x8 correspondiente a las coordenadas x,y
;el bloque se calcula dividiendo la coordenada x /8

.pantalla_actual 
	defw 0

.pantalla_juego  ;en tiles
	defs T_WIDTH*T_HEIGHT
	defb $FF	;Este byte es importante, marca el fin de la pantalla.

.tiles_tocados defs 150 ;150	;cuando un tile es tocado, se marca en esta tabla para luego restaurarlo. Es una tabla sin duplicados.

.tiles ;Son de 2x8 bytes
._tiles

._tile_0

._tile_0_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_1

._tile_1_DATA
defb $0, $0
defb $11, $0
defb $11, $0
defb $11, $0
defb $11, $0
defb $0, $0
defb $11, $0
defb $0, $0
._tile_2

._tile_2_DATA
defb $0, $0
defb $77, $22
defb $77, $22
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_3

._tile_3_DATA
defb $0, $0
defb $77, $22
defb $FF, $AA
defb $77, $22
defb $77, $22
defb $FF, $AA
defb $77, $22
defb $0, $0
._tile_4

._tile_4_DATA
defb $0, $0
defb $11, $0
defb $77, $AA
defb $77, $0
defb $77, $AA
defb $11, $AA
defb $77, $AA
defb $11, $0
._tile_5

._tile_5_DATA
defb $0, $0
defb $BB, $AA
defb $FF, $22
defb $11, $0
defb $11, $0
defb $77, $AA
defb $BB, $AA
defb $0, $0
._tile_6

._tile_6_DATA
defb $0, $0
defb $11, $0
defb $77, $0
defb $11, $0
defb $77, $AA
defb $BB, $22
defb $77, $AA
defb $0, $0
._tile_7

._tile_7_DATA
defb $0, $0
defb $11, $0
defb $11, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_8

._tile_8_DATA
defb $0, $0
defb $0, $AA
defb $55, $0
defb $55, $0
defb $55, $0
defb $55, $0
defb $0, $AA
defb $0, $0
._tile_9

._tile_9_DATA
defb $0, $0
defb $AA, $0
defb $55, $0
defb $55, $0
defb $55, $0
defb $33, $0
defb $AA, $0
defb $0, $0
._tile_10

._tile_10_DATA
defb $0, $0
defb $0, $0
defb $55, $22
defb $11, $0
defb $77, $AA
defb $11, $0
defb $55, $22
defb $0, $0
._tile_11

._tile_11_DATA
defb $0, $0
defb $0, $0
defb $55, $0
defb $55, $0
defb $FF, $AA
defb $55, $0
defb $55, $0
defb $0, $0
._tile_12

._tile_12_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $11, $0
defb $11, $0
defb $11, $0
._tile_13

._tile_13_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $77, $AA
defb $0, $0
defb $0, $0
defb $0, $0
._tile_14

._tile_14_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $55, $0
defb $55, $0
defb $0, $0
._tile_15

._tile_15_DATA
defb $0, $0
defb $0, $0
defb $0, $AA
defb $11, $22
defb $11, $0
defb $11, $0
defb $33, $0
defb $0, $0
._tile_16

._tile_16_DATA
defb $0, $0
defb $77, $22
defb $BB, $AA
defb $BB, $AA
defb $BB, $AA
defb $BB, $AA
defb $77, $22
defb $0, $0
._tile_17

._tile_17_DATA
defb $0, $0
defb $55, $0
defb $77, $0
defb $55, $0
defb $55, $0
defb $55, $0
defb $77, $AA
defb $0, $0
._tile_18

._tile_18_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $0, $AA
defb $77, $22
defb $AA, $0
defb $FF, $AA
defb $0, $0
._tile_19

._tile_19_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $11, $22
defb $0, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_20

._tile_20_DATA
defb $0, $0
defb $55, $0
defb $77, $0
defb $FF, $0
defb $77, $0
defb $FF, $AA
defb $55, $0
defb $0, $0
._tile_21

._tile_21_DATA
defb $0, $0
defb $FF, $AA
defb $AA, $0
defb $FF, $22
defb $0, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_22

._tile_22_DATA
defb $0, $0
defb $77, $22
defb $AA, $0
defb $FF, $22
defb $AA, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_23

._tile_23_DATA
defb $0, $0
defb $FF, $AA
defb $0, $AA
defb $11, $22
defb $55, $0
defb $55, $0
defb $11, $0
defb $0, $0
._tile_24

._tile_24_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $77, $22
defb $AA, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_25

._tile_25_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $AA, $AA
defb $77, $AA
defb $0, $AA
defb $77, $22
defb $0, $0
._tile_26

._tile_26_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $11, $0
defb $0, $0
defb $0, $0
defb $11, $0
defb $0, $0
._tile_27

._tile_27_DATA
defb $0, $0
defb $0, $0
defb $55, $0
defb $0, $0
defb $0, $0
defb $55, $0
defb $55, $0
defb $AA, $0
._tile_28

._tile_28_DATA
defb $0, $0
defb $0, $0
defb $55, $AA
defb $55, $0
defb $55, $0
defb $55, $0
defb $55, $AA
defb $0, $0
._tile_29

._tile_29_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $77, $AA
defb $0, $0
defb $77, $AA
defb $0, $0
defb $0, $0
._tile_30

._tile_30_DATA
defb $0, $0
defb $0, $0
defb $11, $0
defb $11, $0
defb $11, $22
defb $11, $0
defb $11, $0
defb $0, $0
._tile_31

._tile_31_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $11, $22
defb $11, $0
defb $0, $0
defb $11, $0
defb $0, $0
._tile_32

._tile_32_DATA
defb $0, $0
defb $77, $22
defb $BB, $AA
defb $FF, $AA
defb $FF, $AA
defb $AA, $0
defb $77, $22
defb $0, $0
._tile_33

._tile_33_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $AA, $AA
defb $FF, $AA
defb $AA, $AA
defb $AA, $AA
defb $0, $0
._tile_34

._tile_34_DATA
defb $0, $0
defb $FF, $22
defb $AA, $AA
defb $FF, $22
defb $AA, $AA
defb $AA, $AA
defb $FF, $22
defb $0, $0
._tile_35

._tile_35_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $AA, $0
defb $AA, $0
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_36

._tile_36_DATA
defb $0, $0
defb $FF, $0
defb $BB, $22
defb $AA, $AA
defb $AA, $AA
defb $BB, $22
defb $FF, $0
defb $0, $0
._tile_37

._tile_37_DATA
defb $0, $0
defb $FF, $AA
defb $AA, $0
defb $FF, $22
defb $AA, $0
defb $AA, $0
defb $FF, $AA
defb $0, $0
._tile_38

._tile_38_DATA
defb $0, $0
defb $FF, $AA
defb $AA, $0
defb $FF, $22
defb $AA, $0
defb $AA, $0
defb $AA, $0
defb $0, $0
._tile_39

._tile_39_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $AA, $0
defb $BB, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_40

._tile_40_DATA
defb $0, $0
defb $AA, $AA
defb $AA, $AA
defb $FF, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $0, $0
._tile_41

._tile_41_DATA
defb $0, $0
defb $77, $AA
defb $11, $0
defb $11, $0
defb $11, $0
defb $11, $0
defb $77, $AA
defb $0, $0
._tile_42

._tile_42_DATA
defb $0, $0
defb $0, $AA
defb $0, $AA
defb $0, $AA
defb $AA, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_43

._tile_43_DATA
defb $0, $0
defb $AA, $22
defb $BB, $AA
defb $FF, $0
defb $BB, $0
defb $FF, $22
defb $AA, $AA
defb $0, $0
._tile_44

._tile_44_DATA
defb $0, $0
defb $AA, $0
defb $AA, $0
defb $AA, $0
defb $AA, $0
defb $AA, $0
defb $FF, $AA
defb $0, $0
._tile_45

._tile_45_DATA
defb $0, $0
defb $AA, $AA
defb $FF, $AA
defb $FF, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $0, $0
._tile_46

._tile_46_DATA
defb $0, $0
defb $FF, $22
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $0, $0
._tile_47

._tile_47_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_48

._tile_48_DATA
defb $0, $0
defb $FF, $22
defb $AA, $AA
defb $AA, $AA
defb $FF, $22
defb $AA, $0
defb $AA, $0
defb $0, $0
._tile_49

._tile_49_DATA
defb $0, $0
defb $77, $22
defb $AA, $AA
defb $AA, $AA
defb $BB, $AA
defb $BB, $AA
defb $77, $22
defb $0, $0
._tile_50

._tile_50_DATA
defb $0, $0
defb $FF, $22
defb $AA, $AA
defb $AA, $AA
defb $FF, $22
defb $BB, $22
defb $AA, $AA
defb $0, $0
._tile_51

._tile_51_DATA
defb $0, $0
defb $77, $22
defb $AA, $0
defb $77, $22
defb $0, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_52

._tile_52_DATA
defb $0, $0
defb $FF, $AA
defb $55, $0
defb $55, $0
defb $55, $0
defb $55, $0
defb $55, $0
defb $0, $0
._tile_53

._tile_53_DATA
defb $0, $0
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $77, $22
defb $0, $0
._tile_54

._tile_54_DATA
defb $0, $0
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $77, $22
defb $55, $0
defb $0, $0
._tile_55

._tile_55_DATA
defb $0, $0
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $AA, $AA
defb $FF, $AA
defb $77, $22
defb $0, $0
._tile_56

._tile_56_DATA
defb $0, $0
defb $AA, $BB
defb $77, $22
defb $55, $0
defb $55, $0
defb $77, $22
defb $AA, $AA
defb $0, $0
._tile_57

._tile_57_DATA
defb $0, $0
defb $AA, $AA
defb $BB, $AA
defb $77, $22
defb $55, $0
defb $55, $0
defb $55, $0
defb $0, $0
._tile_58

._tile_58_DATA
defb $0, $0
defb $FF, $AA
defb $11, $22
defb $11, $0
defb $11, $0
defb $33, $0
defb $FF, $AA
defb $0, $0
._tile_59

._tile_59_DATA
defb $0, $0
defb $55, $AA
defb $55, $0
defb $55, $0
defb $55, $0
defb $55, $0
defb $55, $AA
defb $0, $0
._tile_60

._tile_60_DATA
defb $0, $0
defb $0, $0
defb $AA, $0
defb $77, $0
defb $55, $0
defb $11, $0
defb $0, $AA
defb $0, $0
._tile_61

._tile_61_DATA
defb $0, $0
defb $FF, $0
defb $55, $0
defb $55, $0
defb $55, $0
defb $55, $0
defb $FF, $0
defb $0, $0
._tile_62

._tile_62_DATA
defb $0, $0
defb $11, $0
defb $77, $0
defb $FF, $22
defb $11, $0
defb $11, $0
defb $11, $0
defb $0, $0
._tile_63

._tile_63_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $FF, $FF
._tile_64

._tile_64_DATA
defb $0, $0
defb $40, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_65

._tile_65_DATA
defb $0, $0
defb $0, $0
defb $40, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_66

._tile_66_DATA
defb $A, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $A
defb $0, $0
defb $0, $0
defb $0, $0
._tile_67

._tile_67_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $5
defb $0, $0
defb $0, $0
._tile_68

._tile_68_DATA
defb $FA, $F0
defb $91, $F0
defb $0, $D0
defb $62, $0
defb $33, $85
defb $93, $33
defb $F0, $93
defb $FA, $F0
._tile_69

._tile_69_DATA
defb $F0, $F0
defb $F0, $F0
defb $FF, $E0
defb $62, $0
defb $0, $4A
defb $85, $91
defb $33, $63
defb $E1, $F0
._tile_70

._tile_70_DATA
defb $91, $F0
defb $0, $D0
defb $62, $0
defb $33, $85
defb $93, $33
defb $F0, $93
defb $F0, $E1
defb $F0, $F0
._tile_71

._tile_71_DATA
defb $F0, $F0
defb $FF, $E0
defb $62, $0
defb $0, $1B
defb $85, $91
defb $33, $63
defb $63, $F0
defb $F0, $F0
._tile_72

._tile_72_DATA
defb $40, $0
defb $1A, $A
defb $CC, $48
defb $8C, $48
defb $E, $2D
defb $5, $CA
defb $E, $C4
defb $C5, $C
._tile_73

._tile_73_DATA
defb $40, $80
defb $1A, $C8
defb $4E, $4D
defb $84, $4D
defb $24, $2D
defb $8C, $80
defb $48, $4A
defb $2D, $0
._tile_74

._tile_74_DATA
defb $F, $94
defb $40, $C7
defb $5, $7
defb $81, $1F
defb $95, $1F
defb $5, $7
defb $40, $2F
defb $0, $C5
._tile_75

._tile_75_DATA
defb $8F, $8D
defb $9A, $48
defb $C4, $C
defb $84, $C
defb $1C, $48
defb $68, $85
defb $8E, $A
defb $85, $0
._tile_76

._tile_76_DATA
defb $0, $5
defb $5, $40
defb $1A, $C0
defb $4C, $4D
defb $E, $3C
defb $4A, $E
defb $45, $C0
defb $5, $4E
._tile_77

._tile_77_DATA
defb $5, $A
defb $40, $C0
defb $84, $2D
defb $64, $48
defb $30, $D
defb $8C, $D
defb $4C, $48
defb $2C, $2D
._tile_78

._tile_78_DATA
defb $40, $64
defb $C0, $2C
defb $1E, $34
defb $1A, $8C
defb $14, $1C
defb $40, $68
defb $5, $C0
defb $0, $F
._tile_79

._tile_79_DATA
defb $48, $85
defb $85, $C0
defb $C5, $85
defb $8E, $2D
defb $CC, $48
defb $E, $2D
defb $4F, $80
defb $5, $A
._tile_80

._tile_80_DATA
defb $A, $A
defb $AA, $AA
defb $AF, $A0
defb $A5, $A0
defb $F0, $A0
defb $F2, $A2
defb $5A, $5
defb $40, $5
._tile_81

._tile_81_DATA
defb $5, $0
defb $40, $A
defb $14, $80
defb $1A, $D
defb $4E, $D
defb $2C, $68
defb $94, $48
defb $C0, $68
._tile_82

._tile_82_DATA
defb $5, $C0
defb $4A, $F
defb $90, $60
defb $6C, $8C
defb $1E, $C
defb $4A, $1C
defb $5, $C0
defb $0, $5
._tile_83

._tile_83_DATA
defb $4A, $85
defb $5, $A
defb $A, $F
defb $85, $48
defb $85, $68
defb $85, $80
defb $A, $0
defb $0, $A
._tile_84

._tile_84_DATA
defb $0, $0
defb $5, $A
defb $4F, $6D
defb $3C, $3C
defb $3C, $3C
defb $9E, $3C
defb $4F, $6D
defb $5, $CF
._tile_85

._tile_85_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $4F, $0
defb $4F, $A
defb $4F, $28
defb $4F, $2D
defb $1E, $6D
._tile_86

._tile_86_DATA
defb $4F, $F
defb $9E, $CF
defb $9E, $3C
defb $1E, $6D
defb $1E, $8F
defb $45, $6D
defb $5, $3C
defb $0, $CF
._tile_87

._tile_87_DATA
defb $9E, $CF
defb $3C, $6D
defb $3C, $CF
defb $3C, $8F
defb $CF, $8A
defb $4F, $A
defb $8F, $0
defb $0, $0
._tile_88

._tile_88_DATA
defb $41, $A2
defb $5B, $B7
defb $7B, $F3
defb $5, $1F
defb $7B, $F3
defb $4B, $B7
defb $15, $2A
defb $0, $0
._tile_89

._tile_89_DATA
defb $0, $0
defb $0, $0
defb $A, $0
defb $91, $A
defb $1B, $91
defb $0, $22
defb $0, $8
defb $40, $88
._tile_90

._tile_90_DATA
defb $0, $85
defb $11, $4C
defb $27, $0
defb $80, $0
defb $40, $40
defb $91, $4C
defb $0, $22
defb $0, $40
._tile_91

._tile_91_DATA
defb $5, $8
defb $8C, $62
defb $80, $A
defb $0, $0
defb $0, $0
defb $31, $A
defb $8C, $85
defb $C, $48
._tile_92

._tile_92_DATA
defb $0, $0
defb $AA, $5
defb $10, $5A
defb $14, $F0
defb $5, $FA
defb $50, $FA
defb $5A, $F0
defb $52, $E1
._tile_93

._tile_93_DATA
defb $0, $0
defb $A, $14
defb $A5, $28
defb $D3, $8A
defb $F1, $A
defb $C3, $A2
defb $F1, $A7
defb $C3, $A7
._tile_94

._tile_94_DATA
defb $52, $F0
defb $4B, $E1
defb $51, $D2
defb $5, $C3
defb $45, $F3
defb $14, $B
defb $28, $5
defb $0, $0
._tile_95

._tile_95_DATA
defb $D3, $7
defb $C3, $A7
defb $F3, $2
defb $83, $A
defb $A3, $8A
defb $7, $8A
defb $A, $45
defb $0, $0
._tile_96

._tile_96_DATA
defb $F, $A
defb $E3, $C3
defb $53, $F3
defb $3, $3
defb $F, $F
defb $C3, $A3
defb $F3, $A7
defb $3, $7
._tile_97

._tile_97_DATA
defb $F, $F
defb $C3, $A3
defb $F3, $A7
defb $3, $7
defb $F, $A
defb $E3, $C3
defb $53, $F3
defb $3, $3
._tile_98

._tile_98_DATA
defb $F, $A
defb $E3, $C3
defb $53, $F3
defb $3, $3
defb $F, $F
defb $C3, $A3
defb $F3, $A7
defb $3, $7
._tile_99

._tile_99_DATA
defb $F, $F
defb $C3, $A3
defb $F3, $A7
defb $3, $7
defb $F, $A
defb $E3, $C3
defb $53, $F3
defb $3, $3
._tile_100

._tile_100_DATA
defb $CF, $CF
defb $3C, $6D
defb $9E, $6D
defb $6D, $6D
defb $6D, $DE
defb $6D, $6D
defb $6D, $DE
defb $FC, $FC
._tile_101

._tile_101_DATA
defb $DE, $CF
defb $ED, $DE
defb $CF, $DE
defb $CF, $DE
defb $DE, $CF
defb $CF, $DE
defb $CF, $DE
defb $FC, $FC
._tile_102

._tile_102_DATA
defb $CF, $CF
defb $ED, $DE
defb $ED, $CF
defb $DE, $DE
defb $CF, $CF
defb $CF, $DE
defb $DE, $DE
defb $FC, $FC
._tile_103

._tile_103_DATA
defb $9E, $CF
defb $6D, $CF
defb $9E, $DE
defb $3C, $6D
defb $9E, $7C
defb $3C, $6D
defb $6D, $DE
defb $FC, $FC
._tile_104

._tile_104_DATA
defb $0, $C0
defb $40, $CC
defb $44, $CC
defb $C4, $CC
defb $CC, $CC
defb $CC, $CC
defb $CC, $85
defb $94, $F
._tile_105

._tile_105_DATA
defb $80, $0
defb $68, $A
defb $C, $85
defb $8C, $68
defb $8C, $48
defb $C, $48
defb $C, $68
defb $4A, $85
._tile_106

._tile_106_DATA
defb $40, $51
defb $0, $41
defb $0, $5A
defb $0, $5A
defb $0, $D2
defb $0, $F0
defb $0, $E3
defb $0, $5B
._tile_107

._tile_107_DATA
defb $A2, $0
defb $A2, $0
defb $82, $0
defb $A5, $0
defb $D3, $0
defb $F1, $0
defb $D3, $0
defb $A7, $0
._tile_108

._tile_108_DATA
defb $FF, $BE
defb $2D, $F
defb $3C, $BC
defb $3C, $1E
defb $7C, $7C
defb $2D, $2D
defb $3C, $BC
defb $3C, $1E
._tile_109

._tile_109_DATA
defb $6D, $DE
defb $3, $5E
defb $FC, $ED
defb $5E, $5E
defb $7C, $CF
defb $2D, $5E
defb $ED, $CF
defb $5E, $5E
._tile_110

._tile_110_DATA
defb $7C, $7C
defb $AD, $AD
defb $7C, $ED
defb $FC, $5E
defb $DE, $DE
defb $AD, $3
defb $CF, $CF
defb $F, $F
._tile_111

._tile_111_DATA
defb $CF, $CF
defb $AD, $4F
defb $ED, $ED
defb $5E, $4F
defb $CF, $CF
defb $F, $4F
defb $CF, $CF
defb $F, $F
._tile_112

._tile_112_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $11
defb $11, $5
defb $11, $A
defb $0, $22
defb $0, $22
._tile_113

._tile_113_DATA
defb $0, $0
defb $0, $0
defb $11, $0
defb $11, $A
defb $0, $A
defb $0, $0
defb $0, $0
defb $0, $0
._tile_114

._tile_114_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $22, $0
defb $27, $0
defb $5, $0
defb $11, $11
defb $0, $0
._tile_115

._tile_115_DATA
defb $0, $0
defb $0, $0
defb $0, $11
defb $11, $11
defb $5, $11
defb $0, $A
defb $0, $22
defb $0, $0
._tile_116

._tile_116_DATA
defb $0, $0
defb $5, $A
defb $40, $80
defb $E, $2D
defb $E, $7C
defb $1E, $D4
defb $5, $AD
defb $40, $4A
._tile_117

._tile_117_DATA
defb $5, $0
defb $A, $A
defb $0, $80
defb $5, $48
defb $E, $1C
defb $E, $2D
defb $E8, $85
defb $FC, $A
._tile_118

._tile_118_DATA
defb $90, $D4
defb $98, $48
defb $CC, $5C
defb $C, $2D
defb $1E, $D4
defb $40, $AD
defb $0, $F
defb $0, $0
._tile_119

._tile_119_DATA
defb $AD, $0
defb $5E, $85
defb $4A, $E0
defb $C0, $E0
defb $D0, $92
defb $90, $E6
defb $4A, $A5
defb $5, $20
._tile_120

._tile_120_DATA
defb $0, $0
defb $F, $F
defb $17, $17
defb $3, $2B
defb $17, $17
defb $F, $F
defb $F1, $7B
defb $F3, $B7
._tile_121

._tile_121_DATA
defb $0, $0
defb $F, $F
defb $3F, $2F
defb $3F, $2F
defb $3F, $2F
defb $F, $F
defb $3F, $2F
defb $B7, $2F
._tile_122

._tile_122_DATA
defb $F3, $F3
defb $F3, $B7
defb $F3, $7B
defb $F3, $B7
defb $F3, $7B
defb $B7, $B7
defb $F, $F
defb $0, $0
._tile_123

._tile_123_DATA
defb $3F, $2F
defb $B7, $2F
defb $3F, $2F
defb $B7, $2F
defb $3F, $2F
defb $3F, $2F
defb $F, $F
defb $0, $0
._tile_124

._tile_124_DATA
defb $FF, $FF
defb $BE, $3C
defb $BE, $6D
defb $BE, $8F
defb $BE, $F
defb $EF, $F
defb $EF, $F
defb $BE, $F
._tile_125

._tile_125_DATA
defb $FF, $BE
defb $3C, $6D
defb $9E, $6D
defb $4F, $6D
defb $F, $6D
defb $F, $CF
defb $F, $CF
defb $F, $6D
._tile_126

._tile_126_DATA
defb $BE, $8F
defb $BE, $8F
defb $BE, $F
defb $EF, $F
defb $2D, $F
defb $2D, $F
defb $BE, $3C
defb $6D, $CF
._tile_127

._tile_127_DATA
defb $4F, $6D
defb $4F, $6D
defb $F, $6D
defb $F, $CF
defb $F, $4F
defb $F, $4F
defb $3C, $6D
defb $CF, $8F
._tile_128

._tile_128_DATA
defb $0, $0
defb $3, $1
defb $53, $4B
defb $D3, $3
defb $53, $43
defb $43, $43
defb $B, $83
defb $1, $C3
._tile_129

._tile_129_DATA
defb $0, $0
defb $2, $3
defb $87, $83
defb $83, $C3
defb $3, $43
defb $83, $43
defb $F3, $B
defb $D3, $B
._tile_130

._tile_130_DATA
defb $0, $53
defb $5, $C3
defb $1, $3
defb $1, $43
defb $1, $3
defb $3, $1
defb $5, $0
defb $0, $0
._tile_131

._tile_131_DATA
defb $43, $0
defb $C3, $A
defb $E3, $2
defb $D3, $2
defb $3, $2
defb $82, $3
defb $0, $A
defb $0, $0
._tile_132

._tile_132_DATA
defb $0, $5
defb $0, $11
defb $0, $F
defb $5, $D3
defb $11, $B3
defb $11, $33
defb $5, $F
defb $51, $D3
._tile_133

._tile_133_DATA
defb $A, $0
defb $22, $0
defb $F, $0
defb $73, $A
defb $B3, $22
defb $33, $22
defb $F, $0
defb $B7, $2A
._tile_134

._tile_134_DATA
defb $51, $D3
defb $15, $F3
defb $15, $F3
defb $5, $F3
defb $0, $7B
defb $0, $3F
defb $0, $1F
defb $0, $5
._tile_135

._tile_135_DATA
defb $F3, $2A
defb $B7, $2A
defb $3F, $2A
defb $B7, $A
defb $3F, $0
defb $B7, $0
defb $2F, $0
defb $A, $0
._tile_136

._tile_136_DATA
defb $0, $0
defb $0, $F
defb $5F, $BE
defb $7D, $A
defb $BE, $0
defb $BE, $0
defb $7D, $A
defb $4F, $3C
._tile_137

._tile_137_DATA
defb $0, $0
defb $A, $0
defb $3C, $A
defb $1E, $8A
defb $45, $28
defb $45, $28
defb $1E, $8A
defb $3C, $A
._tile_138

._tile_138_DATA
defb $0, $4F
defb $0, $45
defb $0, $14
defb $14, $3C
defb $0, $1E
defb $45, $9E
defb $45, $8F
defb $0, $0
._tile_139

._tile_139_DATA
defb $A, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_140

._tile_140_DATA
defb $0, $0
defb $5, $A
defb $5, $A
defb $4A, $85
defb $4A, $85
defb $5, $A
defb $5, $A
defb $0, $0
._tile_141

._tile_141_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $80
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_142

._tile_142_DATA
defb $0, $0
defb $0, $0
defb $40, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $40
defb $0, $0
._tile_143

._tile_143_DATA
defb $0, $0
defb $5, $0
defb $4A, $A
defb $5, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_144

._tile_144_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_145

._tile_145_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_146

._tile_146_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_147

._tile_147_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_148

._tile_148_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_149

._tile_149_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_150

._tile_150_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_151

._tile_151_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_152

._tile_152_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_153

._tile_153_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_154

._tile_154_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_155

._tile_155_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_156

._tile_156_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_157

._tile_157_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_158

._tile_158_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_159

._tile_159_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_160

._tile_160_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_161

._tile_161_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_162

._tile_162_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_163

._tile_163_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_164

._tile_164_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_165

._tile_165_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_166

._tile_166_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_167

._tile_167_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_168

._tile_168_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_169

._tile_169_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_170

._tile_170_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_171

._tile_171_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_172

._tile_172_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_173

._tile_173_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_174

._tile_174_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_175

._tile_175_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_176

._tile_176_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_177

._tile_177_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_178

._tile_178_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_179

._tile_179_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_180

._tile_180_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_181

._tile_181_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_182

._tile_182_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_183

._tile_183_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_184

._tile_184_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_185

._tile_185_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_186

._tile_186_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_187

._tile_187_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_188

._tile_188_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_189

._tile_189_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_190

._tile_190_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_191

._tile_191_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_192

._tile_192_DATA
defb $0, $0
defb $5, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_193

._tile_193_DATA
defb $0, $0
defb $0, $0
defb $5, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_194

._tile_194_DATA
defb $A, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $A
defb $0, $0
defb $0, $0
defb $0, $0
._tile_195

._tile_195_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $5
defb $0, $0
defb $0, $0
._tile_196

._tile_196_DATA
defb $E1, $C3
defb $4A, $C3
defb $0, $4B
defb $85, $0
defb $C0, $F
defb $62, $C0
defb $C3, $62
defb $E1, $C3
._tile_197

._tile_197_DATA
defb $C3, $C3
defb $C3, $C3
defb $F0, $87
defb $85, $0
defb $0, $F
defb $F, $4A
defb $C0, $91
defb $93, $C3
._tile_198

._tile_198_DATA
defb $4A, $C3
defb $0, $4B
defb $85, $0
defb $C0, $F
defb $62, $C0
defb $C3, $62
defb $C3, $93
defb $C3, $C3
._tile_199

._tile_199_DATA
defb $C3, $C3
defb $F0, $87
defb $85, $0
defb $0, $4A
defb $F, $4A
defb $C0, $91
defb $91, $C3
defb $C3, $C3
._tile_200

._tile_200_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_201

._tile_201_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_202

._tile_202_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_203

._tile_203_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_204

._tile_204_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_205

._tile_205_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_206

._tile_206_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_207

._tile_207_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_208

._tile_208_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_209

._tile_209_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_210

._tile_210_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_211

._tile_211_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_212

._tile_212_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_213

._tile_213_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_214

._tile_214_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_215

._tile_215_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_216

._tile_216_DATA
defb $51, $2A
defb $1F, $2F
defb $1F, $3F
defb $5, $F
defb $1F, $3F
defb $5B, $2F
defb $5, $A
defb $0, $0
._tile_217

._tile_217_DATA
defb $0, $0
defb $0, $0
defb $A, $0
defb $1B, $A
defb $1B, $1B
defb $0, $22
defb $0, $80
defb $5, $22
._tile_218

._tile_218_DATA
defb $0, $F
defb $11, $91
defb $27, $0
defb $A, $0
defb $5, $5
defb $1B, $91
defb $0, $22
defb $0, $5
._tile_219

._tile_219_DATA
defb $5, $80
defb $62, $27
defb $A, $A
defb $0, $0
defb $0, $0
defb $31, $A
defb $62, $F
defb $C0, $85
._tile_220

._tile_220_DATA
defb $0, $0
defb $28, $5
defb $14, $4B
defb $45, $C3
defb $5, $E1
defb $41, $E1
defb $4B, $C3
defb $4B, $D3
._tile_221

._tile_221_DATA
defb $0, $0
defb $A, $45
defb $87, $8A
defb $A3, $8A
defb $83, $A
defb $F3, $2
defb $83, $7
defb $F3, $7
._tile_222

._tile_222_DATA
defb $4B, $C3
defb $5B, $D3
defb $1, $E3
defb $5, $F3
defb $45, $3
defb $45, $F
defb $8A, $5
defb $0, $0
._tile_223

._tile_223_DATA
defb $A3, $F
defb $F3, $7
defb $3, $A
defb $A7, $A
defb $7, $8A
defb $F, $8A
defb $A, $45
defb $0, $0
._tile_224

._tile_224_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_225

._tile_225_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_226

._tile_226_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_227

._tile_227_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_228

._tile_228_DATA
defb $FC, $FC
defb $CF, $DE
defb $ED, $DE
defb $DE, $DE
defb $DE, $AD
defb $DE, $DE
defb $DE, $AD
defb $F, $F
._tile_229

._tile_229_DATA
defb $AD, $FC
defb $5E, $AD
defb $FC, $AD
defb $FC, $AD
defb $AD, $FC
defb $FC, $AD
defb $FC, $AD
defb $F, $F
._tile_230

._tile_230_DATA
defb $FC, $FC
defb $5E, $AD
defb $5E, $FC
defb $AD, $AD
defb $FC, $FC
defb $FC, $AD
defb $AD, $AD
defb $F, $F
._tile_231

._tile_231_DATA
defb $ED, $FC
defb $DE, $FC
defb $ED, $AD
defb $CF, $DE
defb $ED, $8F
defb $CF, $DE
defb $DE, $AD
defb $F, $F
._tile_232

._tile_232_DATA
defb $0, $F
defb $5, $3C
defb $14, $3C
defb $1E, $3C
defb $3C, $3C
defb $3C, $3C
defb $3C, $F
defb $4A, $F
._tile_233

._tile_233_DATA
defb $A, $0
defb $85, $A
defb $CF, $F
defb $6D, $85
defb $6D, $8F
defb $CF, $8F
defb $CF, $85
defb $F, $F
._tile_234

._tile_234_DATA
defb $5, $15
defb $0, $51
defb $0, $4B
defb $0, $4B
defb $0, $E3
defb $0, $C3
defb $0, $7B
defb $0, $1F
._tile_235

._tile_235_DATA
defb $2A, $0
defb $2A, $0
defb $A2, $0
defb $87, $0
defb $B7, $0
defb $97, $0
defb $B7, $0
defb $2F, $0
._tile_236

._tile_236_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_237

._tile_237_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_238

._tile_238_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_239

._tile_239_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_240

._tile_240_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $5
defb $5, $0
defb $5, $0
defb $0, $A
defb $0, $A
._tile_241

._tile_241_DATA
defb $0, $0
defb $0, $0
defb $5, $0
defb $5, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_242

._tile_242_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $A, $0
defb $A, $0
defb $0, $0
defb $5, $5
defb $0, $0
._tile_243

._tile_243_DATA
defb $0, $0
defb $0, $0
defb $0, $5
defb $5, $5
defb $0, $5
defb $0, $0
defb $0, $A
defb $0, $0
._tile_244

._tile_244_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_245

._tile_245_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_246

._tile_246_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_247

._tile_247_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_248

._tile_248_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_249

._tile_249_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_250

._tile_250_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_251

._tile_251_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_252

._tile_252_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_253

._tile_253_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_254

._tile_254_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
._tile_255

._tile_255_DATA
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
defb $0, $0
