;; Blood Brothers (Gremlin)
;;
;; Instruction loader
;;
;; To load ROMs must be disabled

003c  00        nop     
003d  00        nop     
003e  00        nop     
003f  00        nop     
0040  ca2200    jp      z,#0022
0043  00        nop     
0044  00        nop     
0045  00        nop     
0046  00        nop     
0047  00        nop     
0048  00        nop     
0049  00        nop     
004a  08        ex      af,af'
004b  1032      djnz    #007f           ; (50)
004d  34        inc     (hl)
004e  3803      jr      c,#0053         ; (3)
0050  41        ld      b,c
0051  00        nop     
0052  c0        ret     nz

0053  2200ff    ld      (#ff00),hl
0056  fa955c    jp      m,#5c95
0059  c7        rst     #0
005a  f0        ret     p

005b  ff        rst     #38

;; initial palette (defined using firmware colour values)
005c  
defb &00,&06,&02,&1a

;; initial border colour (defined using firmware colour values)
0060  
defb &00

0061  2000      jr      nz,#0063        ; (0)
0063  27        daa     
0064  00        nop     
0065  c0        ret     nz

0066  80        add     a,b
0067  c7        rst     #0

;;---------------------------------------------------------
;; start address of font pixel data
0068  d8        ret     c
0069  ad        xor     l
;;---------------------------------------------------------

006a  2000      jr      nz,#006c        ; (0)
006c  00        nop     
006d  00        nop     
006e  00        nop     
006f  00        nop     
;;---------------------------------------------------------
0070 
defb " (C) D.G.COOKE 1987"
;;---------------------------------------------------------

;; set mode
0082  3e01      ld      a,#01
0084  cd0ebc    call    #bc0e			; set mode

;;---------------------------------------------------------
;; set palette
0087  215c00    ld      hl,#005c
008a  af        xor     a
008b  46        ld      b,(hl)
008c  48        ld      c,b
008d  f5        push    af
008e  e5        push    hl
008f  cd32bc    call    #bc32			; set pen colour
0092  e1        pop     hl
0093  23        inc     hl
0094  f1        pop     af
0095  3c        inc     a
0096  fe04      cp      #04
0098  38f1      jr      c,#008b         

;;---------------------------------------------------------
;; set border
009a  46        ld      b,(hl)
009b  48        ld      c,b
009c  cd38bc    call    #bc38

;;---------------------------------------------------------
;; setup function to download ROM's font pixel data to RAM
009f  21d100    ld      hl,#00d1
00a2  1100bf    ld      de,#bf00
00a5  010800    ld      bc,#0008
00a8  edb0      ldir    

;;---------------------------------------------------------
; delay to allow colours to be set

00aa  060a      ld      b,#0a
00ac  76        halt    
00ad  10fd      djnz    #00ac           

;;---------------------------------------------------------

;; copy system font from the rom into ram
00af  210039    ld      hl,#3900		; start of " " (space) character in ROM
00b2  ed5b6800  ld      de,(#0068)		; address to download to
00b6  0603      ld      b,#03			; size of data to download/256
00b8  cd00bf    call    #bf00			; do download

;;----------------------------------------------------------
00bb  f3        di      

;;----------------------------------------------------------
;; read pilot
00bc  cdd900    call    #00d9
00bf  d20000    jp      nc,#0000
;;----------------------------------------------------------

;; initialise checksum
00c2  2600      ld      h,#00
;; setup initial size of data to load 
00c4  dd21a601  ld      ix,#01a6
00c8  113001    ld      de,#0130
00cb  cd7301    call    #0173

;;----------------------------------------------------------
;; continue loading some more
00ce  c3c302    jp      #02c3

;;--------------------------------------------------------------

00d1  cd06b9    call    #b906
00d4  edb0      ldir    
00d6  c309b9    jp      #b909

;;--------------------------------------------------------------

;; start tape motor
00d9  3e10      ld      a,#10
00db  0100f6    ld      bc,#f600
00de  ed79      out     (c),a

;; wait some time for tape motor to achieve full rotational speed
00e0  219001    ld      hl,#0190
00e3  10fe      djnz    #00e3           
00e5  2b        dec     hl
00e6  7c        ld      a,h
00e7  b5        or      l
00e8  20f9      jr      nz,#00e3        

;;-------------------------------------------

;; get initial state of cassette input 
00ea  3ef5      ld      a,#f5
00ec  db00      in      a,(#00)
00ee  4f        ld      c,a

;; up to 2000 attempts allow
00ef  21d007    ld      hl,#07d0		;; (2000)
00f2  cd5b01    call    #015b           ; read pulse
00f5  3806      jr      c,#00fd         ; within range?
00f7  2b        dec     hl
00f8  7c        ld      a,h
00f9  b5        or      l
00fa  20f6      jr      nz,#00f2        
00fc  c9        ret     

;;--------------------------------------------------------------

00fd  44        ld      b,h
00fe  cd5701    call    #0157        ;; read wave
0101  30ec      jr      nc,#00ef      ; retry

;; read pilot waves
0103  069c      ld      b,#9c
0105  cd5701    call    #0157        ;; read wave
0108  30e5      jr      nc,#00ef      ; retry
010a  3ec6      ld      a,#c6
010c  b8        cp      b
010d  30e0      jr      nc,#00ef       ; retry
010f  24        inc     h
0110  20f1      jr      nz,#0103        

;; look for first sync pulse
0112  06c9      ld      b,#c9
0114  cd5b01    call    #015b           ; read pulse
0117  30d6      jr      nc,#00ef        ; retry
0119  78        ld      a,b
011a  fed4      cp      #d4
011c  30f4      jr      nc,#0112        

;; got sync pulse
011e  c35b01    jp      #015b           ;; read pulse

;;--------------------------------------------------------------

0121  d5        push    de
0122  1109fc    ld      de,#fc09
0125  cb15      rl      l
0127  cd5701    call    #0157        ;; read wave
012a  301c      jr      nc,#0148        ; (28)

012c  3ecb      ld      a,#cb
012e  b8        cp      b
012f  3801      jr      c,#0132         ; (1)
0131  14        inc     d
0132  06b0      ld      b,#b0
0134  1d        dec     e
0135  20ee      jr      nz,#0125        ; (-18)
0137  9f        sbc     a,a
0138  ad        xor     l
0139  6f        ld      l,a
013a  04        inc     b
013b  37        scf     
013c  1807      jr      #0145           ; (7)
;;---

013e  cd5701    call    #0157        ;; read wave
0141  3005      jr      nc,#0148        ; (5)
0143  06b0      ld      b,#b0
0145  15        dec     d
0146  20f6      jr      nz,#013e        ; (-10)
0148  d1        pop     de
0149  c9        ret     

;;--------------------------------------------------------------
;; L = bitmask used to define number of waves to read
;;
;; the significance of these waves is ignored.
;;
;; &80 -> 1 bit 
;; &40 -> 2 bits 
;; &20 -> 3 bits
;; &10 -> 4 bits
;; &08 -> 5 bits
;; &04 -> 6 bits
;; &02 -> 7 bits
;; &01 -> 8 bits

014a  06b0      ld      b,#b0
014c  cd5701    call    #0157        ;; read wave
014f  d0        ret     nc
0150  cb15      rl      l
0152  30f6      jr      nc,#014a        ; (-10)
0154  2eff      ld      l,#ff
0156  c9        ret     

;;--------------------------------------------------------------

0157  cd5b01    call    #015b           ;; read pulse
015a  d0        ret     nc

;;--------------------------------------------------------------
015b  3e19      ld      a,#19
015d  3d        dec     a
015e  c25d01    jp      nz,#015d
0161  a7        and     a
0162  04        inc     b
0163  c8        ret     z

0164  3ef5      ld      a,#f5
0166  db00      in      a,(#00)
0168  a9        xor     c
0169  e680      and     #80
016b  d8        ret     c

016c  28f4      jr      z,#0162         ; (-12)
016e  79        ld      a,c
016f  2f        cpl     
0170  4f        ld      c,a
0171  37        scf     
0172  c9        ret     

;;--------------------------------------------------------------

0173  06b0      ld      b,#b0
0175  cd5701    call    #0157			;; read wave
0178  d20000    jp      nc,#0000		;; reset computer

017b  06b0      ld      b,#b0

;; DE = number of bytes to read
;; IX = address to write data to
017d  cd2101    call    #0121
0180  d20000    jp      nc,#0000
0183  dd7500    ld      (ix+#00),l		;; write byte to RAM
0186  dd23      inc     ix				;; update write pointer

;; adjust timing value
0188  04        inc     b
0189  04        inc     b
018a  04        inc     b

018b  cd9e01    call    #019e			;; update checksum
018e  1b        dec     de
018f  7a        ld      a,d
0190  b3        or      e
0191  20ea      jr      nz,#017d        

0193  cd2101    call    #0121
0196  d20000    jp      nc,#0000		;; reset computer

0199  7c        ld      a,h
019a  ad        xor     l
019b  c20000    jp      nz,#0000		;; reset computer

;;------------------------------------------------------
;; update checksum
019e  7c        ld      a,h
019f  ad        xor     l
01a0  67        ld      h,a

01a1  3a4a00    ld      a,(#004a)
01a4  3d        dec     a
01a5  f8        ret     m
01a6  324a00    ld      (#004a),a
01a9  c0        ret     nz
01aa  3e08      ld      a,#08
01ac  324a00    ld      (#004a),a
01af  3a4f00    ld      a,(#004f)
01b2  47        ld      b,a
01b3  2e02      ld      l,#02
01b5  cb40      bit     0,b
01b7  280a      jr      z,#01c3         ; (10)
01b9  3a4b00    ld      a,(#004b)
01bc  3d        dec     a
01bd  cce702    call    z,#02e7
01c0  324b00    ld      (#004b),a
01c3  cb48      bit     1,b
01c5  2809      jr      z,#01d0         ; (9)
01c7  3a5000    ld      a,(#0050)
01ca  3d        dec     a
01cb  280d      jr      z,#01da         ; (13)
01cd  325000    ld      (#0050),a

01d0  cd4a01    call    #014a			; read some waves

01d3  06b2      ld      b,#b2
01d5  38c7      jr      c,#019e         ; (-57)
01d7  c30000    jp      #0000			; reset computer

;;--------------------------------------------------------------

01da  d9        exx     
01db  2a5600    ld      hl,(#0056)
01de  3a4f00    ld      a,(#004f)
01e1  cb5f      bit     3,a
01e3  2011      jr      nz,#01f6        ; (17)
01e5  7e        ld      a,(hl)
01e6  23        inc     hl
01e7  225600    ld      (#0056),hl
01ea  fe04      cp      #04
01ec  200d      jr      nz,#01fb        ; execute function
01ee  214f00    ld      hl,#004f
01f1  cb8e      res     1,(hl)
01f3  d9        exx     
01f4  18da      jr      #01d0           ; (-38)

;;------------------------------------------------------------------

01f6  cda705    call    #05a7			; 
01f9  1843      jr      #023e           ; (67)

;;------------------------------------------------------------------
;; A = function code
01fb  fe20      cp      #20
01fd  3005      jr      nc,#0204        ; (5)
01ff  cd4b03    call    #034b			; do function
0202  183a      jr      #023e           ;

;;------------------------------------------------------------------


0204  2a5100    ld      hl,(#0051)
0207  ed5b5300  ld      de,(#0053)
020b  cb23      sla     e
020d  1600      ld      d,#00
020f  19        add     hl,de
0210  eb        ex      de,hl
0211  ed4b5400  ld      bc,(#0054)
0215  cd6002    call    #0260

0218  215300    ld      hl,#0053
021b  34        inc     (hl)
021c  3a6300    ld      a,(#0063)
021f  be        cp      (hl)
0220  301c      jr      nc,#023e        ; (28)
0222  3a6200    ld      a,(#0062)
0225  77        ld      (hl),a
0226  2a5100    ld      hl,(#0051)
0229  015000    ld      bc,#0050
022c  09        add     hl,bc
022d  44        ld      b,h
022e  4d        ld      c,l
022f  2a6600    ld      hl,(#0066)
0232  ed42      sbc     hl,bc
0234  3004      jr      nc,#023a        ; (4)
0236  ed4b6400  ld      bc,(#0064)
023a  ed435100  ld      (#0051),bc

;;------------------------------------------------------------------

023e  d9        exx     
023f  06b0      ld      b,#b0
0241  cd6101    call    #0161
0244  3091      jr      nc,#01d7        ; reset computer
0246  cd5b01    call    #015b           ; read pulse
0249  308c      jr      nc,#01d7        ; reset computer
024b  cb25      sla     l
024d  cb7d      bit     7,l
024f  2889      jr      z,#01da         

0251  06b0      ld      b,#b0
0253  cd5701    call    #0157			; read wave
0256  d2d701    jp      nc,#01d7		; reset computer
0259  2eff      ld      l,#ff
025b  06b2      ld      b,#b2
025d  c39e01    jp      #019e

;;--------------------------------------------------------------

0260  6f        ld      l,a
0261  2600      ld      h,#00
0263  29        add     hl,hl			;x2
0264  29        add     hl,hl			;x4
0265  29        add     hl,hl			;x8
0266  3a6800    ld      a,(#0068)		
0269  85        add     a,l
026a  6f        ld      l,a
026b  3a6900    ld      a,(#0069)
026e  3d        dec     a
026f  8c        adc     a,h
0270  67        ld      h,a
0271  e5        push    hl
0272  78        ld      a,b
0273  a9        xor     c
0274  47        ld      b,a
0275  d9        exx     
0276  e3        ex      (sp),hl
0277  7e        ld      a,(hl)
0278  23        inc     hl
0279  d9        exx     
027a  6f        ld      l,a
027b  0f        rrca    
027c  0f        rrca    
027d  0f        rrca    
027e  0f        rrca    
027f  ad        xor     l
0280  67        ld      h,a
0281  e60f      and     #0f
0283  ad        xor     l
0284  a0        and     b
0285  a9        xor     c
0286  12        ld      (de),a
0287  13        inc     de
0288  7c        ld      a,h
0289  e6f0      and     #f0
028b  ad        xor     l
028c  a0        and     b
028d  a9        xor     c
028e  12        ld      (de),a
028f  1b        dec     de
0290  7a        ld      a,d
0291  c608      add     a,#08
0293  57        ld      d,a
0294  d9        exx     
0295  30e0      jr      nc,#0277        ; (-32)
0297  e1        pop     hl
0298  d9        exx     
0299  c9        ret     

;;--------------------------------------------------------------

029a  42        ld      b,d
029b  4c        ld      c,h
029c  4f        ld      c,a
029d  4f        ld      c,a
029e  44        ld      b,h
029f  2042      jr      nz,#02e3        ; (66)
02a1  52        ld      d,d
02a2  4f        ld      c,a
02a3  54        ld      d,h
02a4  48        ld      c,b
02a5  45        ld      b,l
02a6  52        ld      d,d
02a7  53        ld      d,e
02a8  2020      jr      nz,#02ca        ; (32)
02aa  2020      jr      nz,#02cc        ; (32)
02ac  3030      jr      nc,#02de        ; (48)
02ae  3020      jr      nc,#02d0        ; (32)
02b0  204e      jr      nz,#0300        ; (78)
02b2  6f        ld      l,a
02b3  3a3133    ld      a,(#3331)
02b6  3036      jr      nc,#02ee        ; (54)
02b8  3838      jr      c,#02f2         ; (56)
02ba  04        inc     b
02bb  00        nop     
02bc  00        nop     
02bd  00        nop     
02be  00        nop     
02bf  00        nop     
02c0  00        nop     
02c1  00        nop     
02c2  00        nop     

;;---------------------------------------------------------------

02c3  3e08      ld      a,#08
02c5  324a00    ld      (#004a),a
02c8  3a4f00    ld      a,(#004f)
02cb  cbcf      set     1,a
02cd  324f00    ld      (#004f),a
02d0  117500    ld      de,#0075
02d3  cd7301    call    #0173
02d6  3a4f00    ld      a,(#004f)
02d9  cbc7      set     0,a
02db  324f00    ld      (#004f),a
02de  110503    ld      de,#0305
02e1  cd7301    call    #0173
02e4  c33d05    jp      #053d

02e7  d9        exx     
02e8  214e00    ld      hl,#004e
02eb  0603      ld      b,#03
02ed  37        scf     
02ee  7e        ld      a,(hl)
02ef  de00      sbc     a,#00
02f1  27        daa     
02f2  fe30      cp      #30
02f4  cbe7      set     4,a
02f6  77        ld      (hl),a
02f7  2b        dec     hl
02f8  10f4      djnz    #02ee           ; (-12)
02fa  300a      jr      nc,#0306        ; (10)
02fc  214f00    ld      hl,#004f
02ff  cb86      res     0,(hl)
0301  d9        exx     
0302  cbfd      set     7,l
0304  182a      jr      #0330           ; (42)
0306  ed5b5800  ld      de,(#0058)
030a  d9        exx     
030b  cbe5      set     4,l
030d  06b0      ld      b,#b0
030f  cd6101    call    #0161
0312  d20000    jp      nc,#0000
0315  cd5b01    call    #015b           ;; read pulse
0318  d20000    jp      nc,#0000
031b  79        ld      a,c
031c  1f        rra     
031d  cb15      rl      l
031f  d9        exx     
0320  23        inc     hl
0321  7e        ld      a,(hl)
0322  d5        push    de
0323  e5        push    hl
0324  ed4b5a00  ld      bc,(#005a)
0328  cd6002    call    #0260			
032b  e1        pop     hl
032c  d1        pop     de
032d  13        inc     de
032e  13        inc     de
032f  d9        exx     
0330  06b0      ld      b,#b0
0332  cd6101    call    #0161
0335  d20000    jp      nc,#0000
0338  cd5b01    call    #015b           ;; read pulse
033b  d20000    jp      nc,#0000
033e  79        ld      a,c
033f  1f        rra     
0340  cb15      rl      l
0342  30db      jr      nc,#031f        ; (-37)
0344  3a4f00    ld      a,(#004f)
0347  47        ld      b,a
0348  3e14      ld      a,#14


;;-----------------------------------------------------
034a  c9        ret     


;;-----------------------------------------------------
;; A = function code
034b  fe0c      cp      #0c
034d  2857      jr      z,#03a6         ; (87)

034f  fe0e      cp      #0e
0351  282f      jr      z,#0382         ; (47)

0353  fe1d      cp      #1d
0355  2816      jr      z,#036d         ; (22)

;; delay
0357  2614      ld      h,#14
0359  25        dec     h
035a  c25903    jp      nz,#0359

035d  87        add     a,a				; x2
035e  6f        ld      l,a				; HL = offset within table

035f  11e805    ld      de,#05e8		; base address of function table
0362  19        add     hl,de

;; HL = address of entry in function table

0363  5e        ld      e,(hl)
0364  23        inc     hl
0365  56        ld      d,(hl)

;; DE = address of function handler 
0366  2a5600    ld      hl,(#0056)
0369  7e        ld      a,(hl)
036a  23        inc     hl
036b  eb        ex      de,hl
;; execute function handler
036c  e9        jp      (hl)

;;--------------------------------------------------------------

036d  7e        ld      a,(hl)
036e  3d        dec     a
036f  ed5b6300  ld      de,(#0063)
0373  1c        inc     e
0374  bb        cp      e
0375  3802      jr      c,#0379         ; (2)
0377  1d        dec     e
0378  7b        ld      a,e
0379  ed5b5300  ld      de,(#0053)
037d  bb        cp      e
037e  2059      jr      nz,#03d9        ; (89)
0380  1821      jr      #03a3           ; (33)

;;------------------------------------------------------------------

0382  3a4f00    ld      a,(#004f)
0385  cb57      bit     2,a
0387  2009      jr      nz,#0392        ; (9)
0389  cbd7      set     2,a
038b  324f00    ld      (#004f),a
038e  7e        ld      a,(hl)
038f  326b00    ld      (#006b),a
0392  3a6b00    ld      a,(#006b)
0395  3d        dec     a
0396  326b00    ld      (#006b),a
0399  203e      jr      nz,#03d9        ; (62)
039b  3a4f00    ld      a,(#004f)
039e  cb97      res     2,a
03a0  324f00    ld      (#004f),a
03a3  23        inc     hl
03a4  1834      jr      #03da           ; (52)

;;------------------------------------------------------------------

03a6  3a4f00    ld      a,(#004f)
03a9  cb57      bit     2,a
03ab  2015      jr      nz,#03c2        ; (21)
03ad  cbd7      set     2,a
03af  324f00    ld      (#004f),a
03b2  3a6200    ld      a,(#0062)
03b5  325300    ld      (#0053),a
03b8  ed5b6400  ld      de,(#0064)
03bc  ed535100  ld      (#0051),de
03c0  1817      jr      #03d9           ; (23)
03c2  3a5300    ld      a,(#0053)
03c5  ed5b6200  ld      de,(#0062)
03c9  bb        cp      e
03ca  200d      jr      nz,#03d9        ; (13)
03cc  eb        ex      de,hl
03cd  2a5100    ld      hl,(#0051)
03d0  ed4b6400  ld      bc,(#0064)
03d4  ed42      sbc     hl,bc
03d6  eb        ex      de,hl
03d7  280b      jr      z,#03e4         ; (11)
03d9  2b        dec     hl
03da  225600    ld      (#0056),hl
03dd  e1        pop     hl
03de  3a6a00    ld      a,(#006a)
03e1  c30402    jp      #0204
03e4  214f00    ld      hl,#004f
03e7  cb96      res     2,(hl)
03e9  2614      ld      h,#14
03eb  25        dec     h
03ec  c2eb03    jp      nz,#03eb
03ef  c9        ret     

;;-----------------------------------------------------
03f0  325000    ld      (#0050),a
03f3  ed535600  ld      (#0056),de
03f7  e1        pop     hl
03f8  d9        exx     
03f9  c3d001    jp      #01d0
;;-----------------------------------------------------

03fc  215300    ld      hl,#0053
03ff  35        dec     (hl)
0400  3a6200    ld      a,(#0062)
0403  3d        dec     a
0404  be        cp      (hl)
0405  f8        ret     m
0406  3a6300    ld      a,(#0063)
0409  77        ld      (hl),a
040a  2a5100    ld      hl,(#0051)
040d  01b0ff    ld      bc,#ffb0
0410  09        add     hl,bc
0411  225100    ld      (#0051),hl
0414  ed4b6400  ld      bc,(#0064)
0418  a7        and     a
0419  ed42      sbc     hl,bc
041b  d0        ret     nc
041c  2a6600    ld      hl,(#0066)
041f  225100    ld      (#0051),hl
0422  c9        ret     
;;-----------------------------------------------------

0423  e1        pop     hl
0424  c31802    jp      #0218
;;-----------------------------------------------------

0427  3a6200    ld      a,(#0062)
042a  325300    ld      (#0053),a
042d  e1        pop     hl
042e  c32602    jp      #0226

;;-----------------------------------------------------
;; copy loaded font character pixel data
;; to font pixel data in ram
;;
;; (&0056) is updated with the next address to copy to (so multiple characters can 
;; be copied one after each other without additional setup)
;;
;; A = ASCII character code
;; DE = memory address to copy pixel data from

0431  d620      sub     #20
0433  d8        ret     c

0434  6f        ld      l,a
0435  2600      ld      h,#00
0437  29        add     hl,hl			; x2
0438  29        add     hl,hl			; x4
0439  29        add     hl,hl			; x8
043a  ed4b6800  ld      bc,(#0068)		; start of font pixel data
043e  09        add     hl,bc

;; HL = start of font pixel data for selected character

;; copy 8 bytes of font pixel data
043f  010800    ld      bc,#0008
0442  eb        ex      de,hl
0443  edb0      ldir    

;; store next address to copy font pixel data to
0445  225600    ld      (#0056),hl
0448  c9        ret     

;;-----------------------------------------------------
;; set pen colour
;;
;; A = pen index
0449  e603      and     #03
044b  4f        ld      c,a
044c  1a        ld      a,(de)
044d  13        inc     de
044e  1802      jr      #0452           ; (2)

;;-----------------------------------------------------------
;; set border colour
0450  0e10      ld      c,#10

;;-----------------------------------------------------------
0452  ed535600  ld      (#0056),de

0456  fe1b      cp      #1b
0458  d0        ret     nc

;;-----------------------------------------------------------

0459  5f        ld      e,a
045a  1600      ld      d,#00
045c  212806    ld      hl,#0628
045f  19        add     hl,de
0460  067f      ld      b,#7f
0462  7e        ld      a,(hl)
0463  ed49      out     (c),c
0465  ed79      out     (c),a
0467  c9        ret     

;;-----------------------------------------------------------

0468  215400    ld      hl,#0054
046b  1803      jr      #0470           ; (3)
;;-----------------------------------------------------

046d  215500    ld      hl,#0055

;;-----------------------------------------------------

0470  ed535600  ld      (#0056),de
0474  1f        rra     
0475  4f        ld      c,a
0476  9f        sbc     a,a
0477  e6f0      and     #f0
0479  cb19      rr      c
047b  4f        ld      c,a
047c  9f        sbc     a,a
047d  e60f      and     #0f
047f  b1        or      c
0480  77        ld      (hl),a

;;----------------------------------------------------
0481  c9        ret     

;;-----------------------------------------------------
;; swap bytes of #0054
0482  2a5400    ld      hl,(#0054)
0485  7c        ld      a,h
0486  65        ld      h,l
0487  6f        ld      l,a
0488  225400    ld      (#0054),hl
048b  c9        ret     

;;-----------------------------------------------------

048c  6f        ld      l,a
048d  1a        ld      a,(de)
048e  13        inc     de
048f  ed535600  ld      (#0056),de
0493  ed5b6200  ld      de,(#0062)
0497  83        add     a,e
0498  3805      jr      c,#049f         ; (5)
049a  14        inc     d
049b  ba        cp      d
049c  3802      jr      c,#04a0         ; (2)
049e  15        dec     d
049f  7a        ld      a,d
04a0  325300    ld      (#0053),a
04a3  cdbd04    call    #04bd			; HL = HL * 80
04a6  ed5b6400  ld      de,(#0064)
04aa  19        add     hl,de
04ab  3809      jr      c,#04b6         ; (9)
04ad  eb        ex      de,hl
04ae  2a6600    ld      hl,(#0066)
04b1  ed52      sbc     hl,de
04b3  eb        ex      de,hl
04b4  3003      jr      nc,#04b9        ; (3)
04b6  2a6600    ld      hl,(#0066)
04b9  225100    ld      (#0051),hl
04bc  c9        ret     

;;----------------------------------------------------
;; HL = HL * 80

04bd  2600      ld      h,#00
04bf  44        ld      b,h
04c0  4d        ld      c,l
04c1  29        add     hl,hl			; x2
04c2  29        add     hl,hl			; x4
04c3  09        add     hl,bc			; x5
04c4  29        add     hl,hl			; x10
04c5  29        add     hl,hl			; x20
04c6  29        add     hl,hl			; x40
04c7  29        add     hl,hl			; x80
04c8  c9        ret     
;;----------------------------------------------------

04c9  ed535600  ld      (#0056),de
04cd  326a00    ld      (#006a),a
04d0  c9        ret     
;;----------------------------------------------------

04d1  6f        ld      l,a
04d2  1a        ld      a,(de)
04d3  13        inc     de
04d4  bd        cp      l
04d5  3003      jr      nc,#04da        ; (3)
04d7  67        ld      h,a
04d8  7d        ld      a,l
04d9  6c        ld      l,h
04da  67        ld      h,a
04db  fe28      cp      #28
04dd  3803      jr      c,#04e2         ; (3)
04df  210027    ld      hl,#2700
04e2  226200    ld      (#0062),hl
04e5  7d        ld      a,l
04e6  325300    ld      (#0053),a
04e9  1a        ld      a,(de)
04ea  6f        ld      l,a
04eb  13        inc     de
04ec  1a        ld      a,(de)
04ed  13        inc     de
04ee  ed535600  ld      (#0056),de
04f2  5f        ld      e,a
04f3  bd        cp      l
04f4  3002      jr      nc,#04f8        ; (2)
04f6  eb        ex      de,hl
04f7  7b        ld      a,e
04f8  fe19      cp      #19
04fa  3804      jr      c,#0500         ; (4)
04fc  1e18      ld      e,#18
04fe  2e00      ld      l,#00
0500  cdbd04    call    #04bd			; HL = HL * 80
0503  7c        ld      a,h
0504  c6c0      add     a,#c0
0506  67        ld      h,a
0507  226400    ld      (#0064),hl
050a  225100    ld      (#0051),hl
050d  eb        ex      de,hl
050e  cdbd04    call    #04bd			; HL = HL * 80
0511  7c        ld      a,h
0512  c6c0      add     a,#c0
0514  67        ld      h,a
0515  226600    ld      (#0066),hl
0518  c9        ret     

0519  6f        ld      l,a
051a  cdbd04    call    #04bd			; HL = HL * 80
051d  1a        ld      a,(de)
051e  13        inc     de
051f  87        add     a,a
0520  4f        ld      c,a
0521  06c0      ld      b,#c0
0523  09        add     hl,bc
0524  226e00    ld      (#006e),hl
0527  eb        ex      de,hl
0528  56        ld      d,(hl)
0529  23        inc     hl
052a  5e        ld      e,(hl)
052b  23        inc     hl
052c  225600    ld      (#0056),hl
052f  ed536c00  ld      (#006c),de
0533  af        xor     a
0534  326b00    ld      (#006b),a
0537  214f00    ld      hl,#004f
053a  cbde      set     3,(hl)
053c  c9        ret     

;;------------------------------------------------------------------

053d  dd2a4306  ld      ix,(#0643)
0541  ed5b4506  ld      de,(#0645)
0545  7a        ld      a,d
0546  b3        or      e
0547  c47301    call    nz,#0173

054a  3a4f00    ld      a,(#004f)
054d  cbcf      set     1,a
054f  324f00    ld      (#004f),a
0552  3a4b06    ld      a,(#064b)
0555  325000    ld      (#0050),a
0558  ed5b6400  ld      de,(#0064)
055c  ed535100  ld      (#0051),de
0560  3a6200    ld      a,(#0062)
0563  325300    ld      (#0053),a
0566  dd2a4706  ld      ix,(#0647)
056a  dd225600  ld      (#0056),ix
056e  ed5b4906  ld      de,(#0649)
0572  cd7301    call    #0173

0575  dd2a4c06  ld      ix,(#064c)
0579  dde5      push    ix
057b  ed5b4e06  ld      de,(#064e)

057f  7a        ld      a,d
0580  d640      sub     #40
0582  3809      jr      c,#058d         ; (9)

0584  57        ld      d,a
0585  d5        push    de
0586  110040    ld      de,#4000
0589  cd7301    call    #0173
058c  d1        pop     de

;;---
058d  7a        ld      a,d
058e  d640      sub     #40
0590  3809      jr      c,#059b         ; (9)

0592  57        ld      d,a
0593  d5        push    de
0594  110040    ld      de,#4000
0597  cd7301    call    #0173
059a  d1        pop     de

;;---

059b  7a        ld      a,d
059c  b3        or      e
059d  c47301    call    nz,#0173

;;---
;; stop tape motor; loading is complete
05a0  af        xor     a
05a1  0100f6    ld      bc,#f600
05a4  ed79      out     (c),a
05a6  c9        ret     

;;----------------------------------------------------

05a7  eb        ex      de,hl
05a8  2a6e00    ld      hl,(#006e)
05ab  3a6b00    ld      a,(#006b)
05ae  4f        ld      c,a
05af  0600      ld      b,#00
05b1  09        add     hl,bc			
05b2  09        add     hl,bc			


05b3  0608      ld      b,#08

;; DE = character font data
;; HL = screen address
05b5  1a        ld      a,(de)
05b6  13        inc     de
05b7  77        ld      (hl),a
05b8  2c        inc     l
05b9  1a        ld      a,(de)
05ba  13        inc     de
05bb  77        ld      (hl),a
05bc  2d        dec     l
05bd  7c        ld      a,h
05be  c608      add     a,#08
05c0  67        ld      h,a
05c1  10f2      djnz    #05b5           ; (-14)

05c3  ed535600  ld      (#0056),de
05c7  0c        inc     c
05c8  79        ld      a,c
05c9  326b00    ld      (#006b),a
05cc  3a6c00    ld      a,(#006c)
05cf  91        sub     c
05d0  c0        ret     nz

05d1  326b00    ld      (#006b),a
05d4  2a6e00    ld      hl,(#006e)
05d7  0e50      ld      c,#50
05d9  09        add     hl,bc
05da  226e00    ld      (#006e),hl
05dd  216d00    ld      hl,#006d
05e0  35        dec     (hl)
05e1  c0        ret     nz

05e2  214f00    ld      hl,#004f
05e5  cb9e      res     3,(hl)
05e7  c9        ret     

05e8  
defw &034a   ;; nothing
defw &034a   ;; nothing
defw &034a   ;; nothing
defw &03f0
defw &034a   ;; nothing
defw &04c9
defw &034a   ;; nothing
defw &034a   ;; nothing
defw &03fc
defw &0423
defw &042d
defw &040a
defw &034a   ;; nothing
defw &0427
defw &034a   ;; nothing
defw &0519
defw &046d
defw &0468
defw &0481  ;; nothing
defw &0481  ;; nothing
defw &034a   ;; nothing
defw &034a   ;; nothing
defw &048c
defw &034a   ;; nothing
defw &0482
defw &0431	 ;;  copy loaded font character pixel data to font pixel data in ram
defw &04d1
defw &034a   ;; nothing
defw &0449		;; set pen colour
defw &034a   ;; nothing
defw &0450		;; set border colour
defw &034a   ;; nothing

;; colour palette

0628  54        ld      d,h
0629  44        ld      b,h
062a  55        ld      d,l
062b  5c        ld      e,h
062c  58        ld      e,b
062d  5d        ld      e,l
062e  4c        ld      c,h
062f  45        ld      b,l
0630  4d        ld      c,l
0631  56        ld      d,(hl)
0632  46        ld      b,(hl)
0633  57        ld      d,a
0634  5e        ld      e,(hl)
0635  40        ld      b,b
0636  5f        ld      e,a
0637  4e        ld      c,(hl)
0638  47        ld      b,a
0639  4f        ld      c,a
063a  52        ld      d,d
063b  42        ld      b,d
063c  53        ld      d,e
063d  5a        ld      e,d
063e  59        ld      e,c
063f  5b        ld      e,e
0640  4a        ld      c,d
0641  43        ld      b,e
0642  4b        ld      c,e

0643  18ae      jr      #05f3           ; (-82)
0645  e8        ret     pe

0646  02        ld      (bc),a
0647  c39515    jp      #1595
064a  18ff      jr      #064b           ; (-1)
064c  ad        xor     l
064d  0a        ld      a,(bc)
064e  d27b00    jp      nc,#007b
0651  00        nop     


