; _CHAIN32.ASM is a fixed version of Borland C++ 4.0's _chain_intr()
; function.  The one supplied in the RTL still assumes that 16-bit
; registers have been pushed on the stack by the interrupt function 
; entry code.  As BC++ 4.0 actually saves all 32-bit registers, 
; _chain_intr() fails miserably.
; Use this _chain_intr32() instead, until Borland fixes the bug.
;
; Note that this file assumes large model.  Change the model directive
; and remove the FAR modifier below if you need to use it in a smallish
; model.

	ideal
	jumps
	model large,c
	p386

	codeseg
	public c _chain_intr32

PROC	_chain_intr32 FAR

	pop	eax			; discard of return ptr
	mov	eax, [bp+1ah]		; get old eax
	pop	[dword ptr bp+1ah]	; promote parameter ptr to return ptr
					; (cute!)
	mov	sp, bp
	pop	bp
	pop	edi
	pop	esi
	pop	ds
	pop	es
	pop	edx
	pop	ecx
	pop	ebx

	cli
	retf				; 'return' to parameter ptr

ENDP	_chain_intr32

END
