#include <iostream.h>
#include <stdio.h>
#include <dos.h>
#include <stdarg.h>			// for gprintf
#include <string.h>			// for path ops in setTweakMode
#include <conio.h>

#include "vga.hpp"

extern "C"
	{
	#include "twkuser.h"
	}

char *vga = (char *)MK_FP(0xa000,0); // the usual pointer to screen memory
int screenWidth;			// physical width of screen in pixels
int screenWidthBytes;		// physical width of screen in bytes
int screenHeight;			// physical height of screen in pixels/bytes
unsigned pageSize;			// page size of the current screen mode
unsigned activePage;		// offset to the active screen page
unsigned inactivePage;		// offset to the inactive screen page
unsigned activePlane;		// active planes (bitmask)
unsigned lineOffset[MAX_SCREENHEIGHT];
							// offsets of screen lines into video memory

// Tweaked modes data

char *modeDir = ".\\";
TweakMode modes[] =
	{
	"256x240.256", 256, 240,
	"256x256.256", 256, 256,
	"320x200.256", 320, 200,
	"320x240.256", 320, 240,
	"360x270.256", 360, 270,
	"360x360.256", 360, 360,
	"400x300.256", 400, 300,
	};
int noOfModes = sizeof(modes)/sizeof(modes[0]);


// Tweaked mode operations

void TweakMode::print()
	{
	cout << name;
	}

void TweakMode::set()
	{
	RegisterPtr rarray;
	int rsize;
	char modePath[63];
	strcpy(modePath, modeDir);
	strcat(modePath, name);
	rsize = loadRegArray(modePath, &rarray);
	outRegArray(rarray, rsize);
	screenWidth = width;
	screenWidthBytes = screenWidth >> 2;
	screenHeight = height;
	pageSize = screenWidthBytes * screenHeight;
	for (int y=0; y<screenHeight; y++)
		lineOffset[y] = screenWidthBytes * y;
	setPlane(0x0f);
	vga[0] = 0;
	memset(vga+1, 0, 0xffff);
	}

int selectTweakMode()
	{
	for (int mode=0; mode<noOfModes; ++mode)
		{
		cout << mode+1 << ". ";
		modes[mode].print();
		cout << endl;
		}
	cout << "Note: 400x300 might not work on all monitors!" << endl
		 << "Select a screen mode: ";
	do	mode = getch() - '0';
	while (mode < 1 || mode > noOfModes);
	cout << mode << endl;
	return mode-1;
	}

void setTweakMode(int mode)
	{
	modes[mode].set();
	}


// setStartAdress(adr) sets the Screen Start Adress register.

void setStartAdress(unsigned adr)
	{
	outpw(CRTC_ADDR, adr & 0xff00 | 0x0c);
	outpw(CRTC_ADDR, ((adr & 0xff)<<8) | 0x0d);
	waitRetraceStart();
	}



// putPixel(x,y,color) sets the given pixel on the screen to the given
// color if it is inside the physical screen window.

void putPixel(int x, int y, char color)
	{
	if (x<screenWidth && y<screenHeight && x>=0 && y>=0)
		{
		setPlane(1<<(x&3));
		*(vga+activePage+lineOffset[y]+(x>>2)) = color;
		}
	}

// getFont8x8() returns a pointer to the standard 8x8 VGA font.

char *getFont8x8()
	{
	int segm, offs;
	asm	{
		push	bp
		mov		ax, 1130h
		mov		bh, 3
		int		10h
		mov		ax, bp
		pop		bp
		mov		[segm], es
		mov		[offs], ax
		}
	return (char *)MK_FP(segm, offs);
	}

// font8x8 points to the standard VGA 8x8 font.

char *font8x8 = getFont8x8();

// putText(x,y,color,str) writes str to the VGA screen with the upper
// left corner at (x,y), in color.

void putText(int x, int y, char color, char *str)
	{
	if (y>=screenHeight)
		return;
	unsigned char ch,
		plane = 1<<(x&3),
		*pix = vga+activePage+lineOffset[y]+(x>>2);
	while ((ch = *(str++)) != 0)
		{
		unsigned char *bits = font8x8 + (ch<<3);
		unsigned char bit = 128;
		for (int i=0; i<8; ++i)
			{
			setPlane(plane);
			unsigned char *pix2 = pix;
			for (int j=0; j<8; ++j)
				{
				if (bits[j] & bit)
					*pix2 = color;
				pix2 += screenWidthBytes;
				}
			bit >>= 1;
			if (bit == 0)
				bit = 128;
			plane <<= 1;
			if (plane == 0x10)
				{
				plane = 1;
				pix++;
				}
			}
		}
	}

// gprintf(x,y,color,fmt,...) does a printf to the VGA screen, by using
// putText().

int gprintf(int x, int y, char color, char *fmt, ...)
	{
	char buf[80];
	va_list argptr;
	va_start(argptr, fmt);
	int cnt = vsprintf(buf, fmt, argptr);
	va_end(argptr);
	putText(x+1, y+1, 0, buf);
	putText(x, y, color, buf);
	return cnt;
	}

// hline() draws a horizontal line in a Mode X-style mode, of length l, in
// color c.

void hline(int x, int y, int len, char c)
	{
	char *pix = vga + activePage + lineOffset[y] + (x>>2);
	int frac = x&3;
	if (frac)
		{
		int mask = len >= 4 ? 0x0f : 0x0f >> (4-len) << (4-len);
		setPlane(mask << frac);
		*(pix++) = c;
		len -= frac;
		}
	int count = len >> 2;
	if (count)
		{
		setPlane(0x0f);
		do	*(pix++) = c;
		while (--count);
		}
	frac = len & 3;
	if (frac)
		{
		setPlane(0x0f >> (4-frac));
		*pix = c;
		}
	}

// box() fills a single-colored rectangle on the screen, of width w and
// height h.

void box(int x, int y, int w, int h, char c)
	{
	while (h--)
		hline(x, y++, w, c);
	}
