#include <math.h>
#include <fstream.h>

#define ANGLES 1024

/*
 * TRIGTAB.CPP
 * 
 * Creates a file with sin and cos tables suitable for including in an 
 * assembly source file.
 *
 * The tables cover a total of ANGLES angles.  No redundancy is exploited,
 * i.e. the entire tables are calculated for both sin and cos.  This
 * favours code efficiency. 
 *
 * 0 deg -> 0
 * 45 deg -> 32
 * 90 deg -> 64
 * 180 deg -> 128
 * 360 deg -> 0
 *
 * The values are stored as 16.16 fixed point numbers.  The total size is
 * thus: 2*ANGLES*4.
 */

main()
	{
	ofstream o("trigtab.inc");		// open the output file
	int leftOnLine;

	o << "; " << ANGLES << " cosine values" << endl;
	leftOnLine = 0;
	for (int i=0; i < ANGLES; i++)
		{
		if (!leftOnLine)
			{
			leftOnLine = 8;
			o << endl << "dd ";
			}
		else
			o << ", ";
		o << hex << "0" << long(floor(cos(2.0*M_PI*i/ANGLES)*65536.0)) << "h";
		--leftOnLine;
		}

	o << endl << "; ANGLES sine values" << endl;
	leftOnLine = 0;
	for (i=0; i < ANGLES; i++)
		{
		if (!leftOnLine)
			{
			leftOnLine = 8;
			o << endl << "dd ";
			}
		else
			o << ", ";
		o << hex << "0" << long(floor(sin(2.0*M_PI*i/ANGLES)*65536.0)) << "h";
		--leftOnLine;
		}
	}
