#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <assert.h>
#include "keyboard.hpp"

int Keyboard::instances = 0;
Keyboard keyboard;

#ifdef POLL_KEYS

BOOL Keyboard::chainInt09 = TRUE;
ISR oldInt09Handler = 0;

#if __BORLANDC__ > 0x410
// _chain_intr32 is defined in _CHAIN32.ASM.  See comments in that file!
extern "C" void _chain_intr32(ISR);
#endif

void interrupt newInt09Handler(...)
	{
	if (Keyboard::instances)
		keyboard.handler();
	if (Keyboard::chainInt09)
#if __BORLANDC__ > 0x410
		_chain_intr32(oldInt09Handler);
#else
		_chain_intr(oldInt09Handler);
#endif
	else
		{
		outp(0x61, inp(0x61) | 0x80);	// signal character received
		outp(0x20, 0x20);				// signal end of interrupt
		}
	}

void hookInt09Handler()
	{
	if (!oldInt09Handler)
		{
		oldInt09Handler = getvect(0x09);
		setvect(0x09, newInt09Handler);
		}
	}

void resetInt09Handler()
	{
	if (oldInt09Handler)
		{
		setvect(0x09, oldInt09Handler);
		oldInt09Handler = 0;
		}
	}

#pragma startup hookInt09Handler
#pragma exit resetInt09Handler

void Keyboard::handler()
	{
	UCHAR scancode = inp(0x60);
	if (scancode >= KEY_SCANCODES)
		key[scancode - KEY_SCANCODES].release();
	else
		key[scancode].press();
	}

#endif

Keyboard::Keyboard()
	{
	assert(("Only one Keyboard instance allowed", instances == 0));
	++instances;
	}

Keyboard::~Keyboard()
	{
	--instances;
	}

// Return the next key in the keyboard buffer - wait for a keypress if
// the buffer is empty.

KeyCode Keyboard::get()
	{
	KeyCode key;
	if (!(key=KeyCode(getch())) && kbhit())
		key = KeyCode(getch()) << 8;
	return key;
	}

// Empty the keyboard buffer, but return the last key pressed.  If the
// buffer is already empty, return 0.

KeyCode Keyboard::flush()
	{
	KeyCode key = 0;
	while (kbhit())
		key = get();
	return key;
	}


