/*
 * Copyright (c) James Fidell 1994.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the copyright holder
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission. The
 * copyright holder makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */


#include	<stdio.h>
#include	<unistd.h>

#include "Config.h"
#include "ADC.h"

static unsigned char	Channel;
static unsigned char	FlagInput;
static unsigned char	TenBitConversion;

unsigned char
ReadADConverter ( int addr )
{
	/*
	 * FIX ME
	 *
	 * Some dummy stuff just to get us going.
	 *
	 * Channel is whatever was set in the last write.
	 * 8/10 bit mode is whatever was set in the last write.
	 * Conversion value = 0
	 * ADC is not busy
	 * conversion is complete
	 */

	unsigned char			ret;

	switch ( addr )
	{
		case 0x0 :
			ret = Channel | TenBitConversion | 0x40;
			break;

		case 0x1 :
			ret = 0;
			break;

		case 0x2 :
			ret = 0;
			break;

		default :
			fprintf ( stderr, "Illegal read on ADC (addr = %x)\n", addr );
			exit ( 1 );
			break;
	}

	return ( ret );
}


void
WriteADConverter ( int addr, unsigned char val )
{
	if ( addr == 0 )
	{
		/*
		 * FIX ME
		 *
		 * This should initiate a conversion which, if interrupts are
		 * enabled, will cause an IRQ when complete.  This interrupt
		 * is generated by taking the CB1 line of the system VIA high.
		 *
		 */

		Channel = val & 0x3;
		FlagInput = val & 0x4;
		TenBitConversion = val & 0x8;
#ifdef	INFO
		printf ( "ADC started on channel %d, %d-bit conversion\n",
			Channel, TenBitConversion ? 10 : 8 );
#endif

		/*
		 * The rest of the bits are unused
		 */
	}
	else
	{
		fprintf ( stderr, "write to A/D converter (addr = %x)", addr );
		fprintf ( stderr, " address is illegal\n" );
		exit ( 1 );
	}
	return;
}


int
SaveADC ( int fd )
{
	unsigned char		adc [ 8 ];

	adc [ 0 ] = Channel | FlagInput | TenBitConversion;

	/*
	 * FIX ME
	 *
	 * Ought to have the value of the last conversion in here ?
	 */

	if ( write ( fd, adc, 8 ) != 8 )
		return -1;

	return 0;
}


int
RestoreADC ( int fd, unsigned int ver )
{
	unsigned char		adc [ 8 ];

	if ( ver > 1 )
		return -1;

	if ( read ( fd, adc, 8 ) != 8 )
		return -1;

	Channel = adc [ 0 ] & 0x3;
	FlagInput = adc [ 0 ] & 0x4;
	TenBitConversion = adc [ 0 ] & 0x8;

	/*
	 * FIX ME
	 *
	 * Ought to have the value of the last conversion in here ?
	 */

	return 0;
}
