
/*
 *apple.h -- Globals' xdefs and equates for system calls for Apple ][ Emulator
 *(C) 1989 Ben Koning [556498717 408/738-1763 ben@apple.com]
 */



/* Character which ends the emulation: */

#define		MEGAQUITKEY		001		/* Control-A */



/* XENIX/BSD - Compatible includes: */

#ifndef BUFSIZ
#include <stdio.h>
#endif

#ifndef isalpha
#include <ctype.h>
#endif

#ifndef CBREAK
#include <sgtty.h>
#endif

#ifndef TIOCGETP
#include <sys/ioctl.h>
#endif

#ifndef O_NDELAY
#include <fcntl.h>
#endif

#define BYTE unsigned char
#define ADDR int



/* 6502 Globals: */

extern int A,X,Y,P,S;
extern ADDR PPC;





/* Emulation Globals: */

extern BYTE MMemory[];
extern BYTE Rom[];

extern BYTE MegaQuitDetect;
extern int DebugSingle;
extern int DebugTrace;
extern ADDR DebugBreak;


/* Apple ROM Contents: */

extern BYTE MegaGetMem();


/* Termcap stuff: */


extern void Debugger();
extern void MegaShutDown();
extern void MegaStartUp();
extern void MegaPutMem();


extern void CPUShutDown();
extern void CPUReset();
extern void CPUExecute();

