#ifndef T65_6502DISASSEMBLER_H_
#define T65_6502DISASSEMBLER_H_

#include "t65.h"

namespace t65 {
	struct InstrInfo {
		typedef char *(*AddrModeDisFn)(char *buf,const byte *bytes,Word bytes_base);
		
		const char *mnemonic;
		AddrModeDisFn addr_mode_fn;
		unsigned operand_size;
	};

	template<class T>
	struct Disassembler6502 {
		static InstrInfo dis_table[256];

		static int Disassemble(Word addr,const t65::byte *bytes_buf,char *opcode_buf,
			char *operand_buf)
		{
			const InstrInfo *ii=&dis_table[bytes_buf[0]];
			if(opcode_buf) {
				strcpy(opcode_buf,ii->mnemonic);
			}
			if(operand_buf) {
				(*ii->addr_mode_fn)(operand_buf,bytes_buf+1,addr);
			}
			return 1+ii->operand_size;
		}

		template<class ReadByteFn>
		static Word Disassemble(ReadByteFn read_byte_fn,Word addr,char *opcode_buf,char *operand_buf,byte *bytes_buf) {
			static byte tmp_bytes_buf[64];
			byte *my_bytes_buf=bytes_buf?bytes_buf:tmp_bytes_buf;
			Word my_addr=addr;

			my_bytes_buf[0]=read_byte_fn(my_addr);
			++my_addr.w;
			const InstrInfo *ii=&dis_table[my_bytes_buf[0]];
			if(opcode_buf) {
				strcpy(opcode_buf,ii->mnemonic);
			}
			if(operand_buf||bytes_buf) {
				Word bytes_base=addr;
				for(unsigned i=0;i<ii->operand_size;++i) {
					my_bytes_buf[1+i]=read_byte_fn(my_addr);
					++my_addr.w;
				}
				if(operand_buf) {
					(*ii->addr_mode_fn)(operand_buf,my_bytes_buf+1,bytes_base);
				}
			}
			return t65::MakeWord(addr.w+1+ii->operand_size);
		}
	};

	template<class T>
	InstrInfo Disassembler6502<T>::dis_table[256]={
		{T::Opcode00::InstrType::Mnemonic(),&T::Opcode00::AddrModeType::Disassemble,T::Opcode00::AddrModeType::operand_size,},
		{T::Opcode01::InstrType::Mnemonic(),&T::Opcode01::AddrModeType::Disassemble,T::Opcode01::AddrModeType::operand_size,},
		{T::Opcode02::InstrType::Mnemonic(),&T::Opcode02::AddrModeType::Disassemble,T::Opcode02::AddrModeType::operand_size,},
		{T::Opcode03::InstrType::Mnemonic(),&T::Opcode03::AddrModeType::Disassemble,T::Opcode03::AddrModeType::operand_size,},
		{T::Opcode04::InstrType::Mnemonic(),&T::Opcode04::AddrModeType::Disassemble,T::Opcode04::AddrModeType::operand_size,},
		{T::Opcode05::InstrType::Mnemonic(),&T::Opcode05::AddrModeType::Disassemble,T::Opcode05::AddrModeType::operand_size,},
		{T::Opcode06::InstrType::Mnemonic(),&T::Opcode06::AddrModeType::Disassemble,T::Opcode06::AddrModeType::operand_size,},
		{T::Opcode07::InstrType::Mnemonic(),&T::Opcode07::AddrModeType::Disassemble,T::Opcode07::AddrModeType::operand_size,},
		{T::Opcode08::InstrType::Mnemonic(),&T::Opcode08::AddrModeType::Disassemble,T::Opcode08::AddrModeType::operand_size,},
		{T::Opcode09::InstrType::Mnemonic(),&T::Opcode09::AddrModeType::Disassemble,T::Opcode09::AddrModeType::operand_size,},
		{T::Opcode0A::InstrType::Mnemonic(),&T::Opcode0A::AddrModeType::Disassemble,T::Opcode0A::AddrModeType::operand_size,},
		{T::Opcode0B::InstrType::Mnemonic(),&T::Opcode0B::AddrModeType::Disassemble,T::Opcode0B::AddrModeType::operand_size,},
		{T::Opcode0C::InstrType::Mnemonic(),&T::Opcode0C::AddrModeType::Disassemble,T::Opcode0C::AddrModeType::operand_size,},
		{T::Opcode0D::InstrType::Mnemonic(),&T::Opcode0D::AddrModeType::Disassemble,T::Opcode0D::AddrModeType::operand_size,},
		{T::Opcode0E::InstrType::Mnemonic(),&T::Opcode0E::AddrModeType::Disassemble,T::Opcode0E::AddrModeType::operand_size,},
		{T::Opcode0F::InstrType::Mnemonic(),&T::Opcode0F::AddrModeType::Disassemble,T::Opcode0F::AddrModeType::operand_size,},
		{T::Opcode10::InstrType::Mnemonic(),&T::Opcode10::AddrModeType::Disassemble,T::Opcode10::AddrModeType::operand_size,},
		{T::Opcode11::InstrType::Mnemonic(),&T::Opcode11::AddrModeType::Disassemble,T::Opcode11::AddrModeType::operand_size,},
		{T::Opcode12::InstrType::Mnemonic(),&T::Opcode12::AddrModeType::Disassemble,T::Opcode12::AddrModeType::operand_size,},
		{T::Opcode13::InstrType::Mnemonic(),&T::Opcode13::AddrModeType::Disassemble,T::Opcode13::AddrModeType::operand_size,},
		{T::Opcode14::InstrType::Mnemonic(),&T::Opcode14::AddrModeType::Disassemble,T::Opcode14::AddrModeType::operand_size,},
		{T::Opcode15::InstrType::Mnemonic(),&T::Opcode15::AddrModeType::Disassemble,T::Opcode15::AddrModeType::operand_size,},
		{T::Opcode16::InstrType::Mnemonic(),&T::Opcode16::AddrModeType::Disassemble,T::Opcode16::AddrModeType::operand_size,},
		{T::Opcode17::InstrType::Mnemonic(),&T::Opcode17::AddrModeType::Disassemble,T::Opcode17::AddrModeType::operand_size,},
		{T::Opcode18::InstrType::Mnemonic(),&T::Opcode18::AddrModeType::Disassemble,T::Opcode18::AddrModeType::operand_size,},
		{T::Opcode19::InstrType::Mnemonic(),&T::Opcode19::AddrModeType::Disassemble,T::Opcode19::AddrModeType::operand_size,},
		{T::Opcode1A::InstrType::Mnemonic(),&T::Opcode1A::AddrModeType::Disassemble,T::Opcode1A::AddrModeType::operand_size,},
		{T::Opcode1B::InstrType::Mnemonic(),&T::Opcode1B::AddrModeType::Disassemble,T::Opcode1B::AddrModeType::operand_size,},
		{T::Opcode1C::InstrType::Mnemonic(),&T::Opcode1C::AddrModeType::Disassemble,T::Opcode1C::AddrModeType::operand_size,},
		{T::Opcode1D::InstrType::Mnemonic(),&T::Opcode1D::AddrModeType::Disassemble,T::Opcode1D::AddrModeType::operand_size,},
		{T::Opcode1E::InstrType::Mnemonic(),&T::Opcode1E::AddrModeType::Disassemble,T::Opcode1E::AddrModeType::operand_size,},
		{T::Opcode1F::InstrType::Mnemonic(),&T::Opcode1F::AddrModeType::Disassemble,T::Opcode1F::AddrModeType::operand_size,},
		{T::Opcode20::InstrType::Mnemonic(),&T::Opcode20::AddrModeType::Disassemble,T::Opcode20::AddrModeType::operand_size,},
		{T::Opcode21::InstrType::Mnemonic(),&T::Opcode21::AddrModeType::Disassemble,T::Opcode21::AddrModeType::operand_size,},
		{T::Opcode22::InstrType::Mnemonic(),&T::Opcode22::AddrModeType::Disassemble,T::Opcode22::AddrModeType::operand_size,},
		{T::Opcode23::InstrType::Mnemonic(),&T::Opcode23::AddrModeType::Disassemble,T::Opcode23::AddrModeType::operand_size,},
		{T::Opcode24::InstrType::Mnemonic(),&T::Opcode24::AddrModeType::Disassemble,T::Opcode24::AddrModeType::operand_size,},
		{T::Opcode25::InstrType::Mnemonic(),&T::Opcode25::AddrModeType::Disassemble,T::Opcode25::AddrModeType::operand_size,},
		{T::Opcode26::InstrType::Mnemonic(),&T::Opcode26::AddrModeType::Disassemble,T::Opcode26::AddrModeType::operand_size,},
		{T::Opcode27::InstrType::Mnemonic(),&T::Opcode27::AddrModeType::Disassemble,T::Opcode27::AddrModeType::operand_size,},
		{T::Opcode28::InstrType::Mnemonic(),&T::Opcode28::AddrModeType::Disassemble,T::Opcode28::AddrModeType::operand_size,},
		{T::Opcode29::InstrType::Mnemonic(),&T::Opcode29::AddrModeType::Disassemble,T::Opcode29::AddrModeType::operand_size,},
		{T::Opcode2A::InstrType::Mnemonic(),&T::Opcode2A::AddrModeType::Disassemble,T::Opcode2A::AddrModeType::operand_size,},
		{T::Opcode2B::InstrType::Mnemonic(),&T::Opcode2B::AddrModeType::Disassemble,T::Opcode2B::AddrModeType::operand_size,},
		{T::Opcode2C::InstrType::Mnemonic(),&T::Opcode2C::AddrModeType::Disassemble,T::Opcode2C::AddrModeType::operand_size,},
		{T::Opcode2D::InstrType::Mnemonic(),&T::Opcode2D::AddrModeType::Disassemble,T::Opcode2D::AddrModeType::operand_size,},
		{T::Opcode2E::InstrType::Mnemonic(),&T::Opcode2E::AddrModeType::Disassemble,T::Opcode2E::AddrModeType::operand_size,},
		{T::Opcode2F::InstrType::Mnemonic(),&T::Opcode2F::AddrModeType::Disassemble,T::Opcode2F::AddrModeType::operand_size,},
		{T::Opcode30::InstrType::Mnemonic(),&T::Opcode30::AddrModeType::Disassemble,T::Opcode30::AddrModeType::operand_size,},
		{T::Opcode31::InstrType::Mnemonic(),&T::Opcode31::AddrModeType::Disassemble,T::Opcode31::AddrModeType::operand_size,},
		{T::Opcode32::InstrType::Mnemonic(),&T::Opcode32::AddrModeType::Disassemble,T::Opcode32::AddrModeType::operand_size,},
		{T::Opcode33::InstrType::Mnemonic(),&T::Opcode33::AddrModeType::Disassemble,T::Opcode33::AddrModeType::operand_size,},
		{T::Opcode34::InstrType::Mnemonic(),&T::Opcode34::AddrModeType::Disassemble,T::Opcode34::AddrModeType::operand_size,},
		{T::Opcode35::InstrType::Mnemonic(),&T::Opcode35::AddrModeType::Disassemble,T::Opcode35::AddrModeType::operand_size,},
		{T::Opcode36::InstrType::Mnemonic(),&T::Opcode36::AddrModeType::Disassemble,T::Opcode36::AddrModeType::operand_size,},
		{T::Opcode37::InstrType::Mnemonic(),&T::Opcode37::AddrModeType::Disassemble,T::Opcode37::AddrModeType::operand_size,},
		{T::Opcode38::InstrType::Mnemonic(),&T::Opcode38::AddrModeType::Disassemble,T::Opcode38::AddrModeType::operand_size,},
		{T::Opcode39::InstrType::Mnemonic(),&T::Opcode39::AddrModeType::Disassemble,T::Opcode39::AddrModeType::operand_size,},
		{T::Opcode3A::InstrType::Mnemonic(),&T::Opcode3A::AddrModeType::Disassemble,T::Opcode3A::AddrModeType::operand_size,},
		{T::Opcode3B::InstrType::Mnemonic(),&T::Opcode3B::AddrModeType::Disassemble,T::Opcode3B::AddrModeType::operand_size,},
		{T::Opcode3C::InstrType::Mnemonic(),&T::Opcode3C::AddrModeType::Disassemble,T::Opcode3C::AddrModeType::operand_size,},
		{T::Opcode3D::InstrType::Mnemonic(),&T::Opcode3D::AddrModeType::Disassemble,T::Opcode3D::AddrModeType::operand_size,},
		{T::Opcode3E::InstrType::Mnemonic(),&T::Opcode3E::AddrModeType::Disassemble,T::Opcode3E::AddrModeType::operand_size,},
		{T::Opcode3F::InstrType::Mnemonic(),&T::Opcode3F::AddrModeType::Disassemble,T::Opcode3F::AddrModeType::operand_size,},
		{T::Opcode40::InstrType::Mnemonic(),&T::Opcode40::AddrModeType::Disassemble,T::Opcode40::AddrModeType::operand_size,},
		{T::Opcode41::InstrType::Mnemonic(),&T::Opcode41::AddrModeType::Disassemble,T::Opcode41::AddrModeType::operand_size,},
		{T::Opcode42::InstrType::Mnemonic(),&T::Opcode42::AddrModeType::Disassemble,T::Opcode42::AddrModeType::operand_size,},
		{T::Opcode43::InstrType::Mnemonic(),&T::Opcode43::AddrModeType::Disassemble,T::Opcode43::AddrModeType::operand_size,},
		{T::Opcode44::InstrType::Mnemonic(),&T::Opcode44::AddrModeType::Disassemble,T::Opcode44::AddrModeType::operand_size,},
		{T::Opcode45::InstrType::Mnemonic(),&T::Opcode45::AddrModeType::Disassemble,T::Opcode45::AddrModeType::operand_size,},
		{T::Opcode46::InstrType::Mnemonic(),&T::Opcode46::AddrModeType::Disassemble,T::Opcode46::AddrModeType::operand_size,},
		{T::Opcode47::InstrType::Mnemonic(),&T::Opcode47::AddrModeType::Disassemble,T::Opcode47::AddrModeType::operand_size,},
		{T::Opcode48::InstrType::Mnemonic(),&T::Opcode48::AddrModeType::Disassemble,T::Opcode48::AddrModeType::operand_size,},
		{T::Opcode49::InstrType::Mnemonic(),&T::Opcode49::AddrModeType::Disassemble,T::Opcode49::AddrModeType::operand_size,},
		{T::Opcode4A::InstrType::Mnemonic(),&T::Opcode4A::AddrModeType::Disassemble,T::Opcode4A::AddrModeType::operand_size,},
		{T::Opcode4B::InstrType::Mnemonic(),&T::Opcode4B::AddrModeType::Disassemble,T::Opcode4B::AddrModeType::operand_size,},
		{T::Opcode4C::InstrType::Mnemonic(),&T::Opcode4C::AddrModeType::Disassemble,T::Opcode4C::AddrModeType::operand_size,},
		{T::Opcode4D::InstrType::Mnemonic(),&T::Opcode4D::AddrModeType::Disassemble,T::Opcode4D::AddrModeType::operand_size,},
		{T::Opcode4E::InstrType::Mnemonic(),&T::Opcode4E::AddrModeType::Disassemble,T::Opcode4E::AddrModeType::operand_size,},
		{T::Opcode4F::InstrType::Mnemonic(),&T::Opcode4F::AddrModeType::Disassemble,T::Opcode4F::AddrModeType::operand_size,},
		{T::Opcode50::InstrType::Mnemonic(),&T::Opcode50::AddrModeType::Disassemble,T::Opcode50::AddrModeType::operand_size,},
		{T::Opcode51::InstrType::Mnemonic(),&T::Opcode51::AddrModeType::Disassemble,T::Opcode51::AddrModeType::operand_size,},
		{T::Opcode52::InstrType::Mnemonic(),&T::Opcode52::AddrModeType::Disassemble,T::Opcode52::AddrModeType::operand_size,},
		{T::Opcode53::InstrType::Mnemonic(),&T::Opcode53::AddrModeType::Disassemble,T::Opcode53::AddrModeType::operand_size,},
		{T::Opcode54::InstrType::Mnemonic(),&T::Opcode54::AddrModeType::Disassemble,T::Opcode54::AddrModeType::operand_size,},
		{T::Opcode55::InstrType::Mnemonic(),&T::Opcode55::AddrModeType::Disassemble,T::Opcode55::AddrModeType::operand_size,},
		{T::Opcode56::InstrType::Mnemonic(),&T::Opcode56::AddrModeType::Disassemble,T::Opcode56::AddrModeType::operand_size,},
		{T::Opcode57::InstrType::Mnemonic(),&T::Opcode57::AddrModeType::Disassemble,T::Opcode57::AddrModeType::operand_size,},
		{T::Opcode58::InstrType::Mnemonic(),&T::Opcode58::AddrModeType::Disassemble,T::Opcode58::AddrModeType::operand_size,},
		{T::Opcode59::InstrType::Mnemonic(),&T::Opcode59::AddrModeType::Disassemble,T::Opcode59::AddrModeType::operand_size,},
		{T::Opcode5A::InstrType::Mnemonic(),&T::Opcode5A::AddrModeType::Disassemble,T::Opcode5A::AddrModeType::operand_size,},
		{T::Opcode5B::InstrType::Mnemonic(),&T::Opcode5B::AddrModeType::Disassemble,T::Opcode5B::AddrModeType::operand_size,},
		{T::Opcode5C::InstrType::Mnemonic(),&T::Opcode5C::AddrModeType::Disassemble,T::Opcode5C::AddrModeType::operand_size,},
		{T::Opcode5D::InstrType::Mnemonic(),&T::Opcode5D::AddrModeType::Disassemble,T::Opcode5D::AddrModeType::operand_size,},
		{T::Opcode5E::InstrType::Mnemonic(),&T::Opcode5E::AddrModeType::Disassemble,T::Opcode5E::AddrModeType::operand_size,},
		{T::Opcode5F::InstrType::Mnemonic(),&T::Opcode5F::AddrModeType::Disassemble,T::Opcode5F::AddrModeType::operand_size,},
		{T::Opcode60::InstrType::Mnemonic(),&T::Opcode60::AddrModeType::Disassemble,T::Opcode60::AddrModeType::operand_size,},
		{T::Opcode61::InstrType::Mnemonic(),&T::Opcode61::AddrModeType::Disassemble,T::Opcode61::AddrModeType::operand_size,},
		{T::Opcode62::InstrType::Mnemonic(),&T::Opcode62::AddrModeType::Disassemble,T::Opcode62::AddrModeType::operand_size,},
		{T::Opcode63::InstrType::Mnemonic(),&T::Opcode63::AddrModeType::Disassemble,T::Opcode63::AddrModeType::operand_size,},
		{T::Opcode64::InstrType::Mnemonic(),&T::Opcode64::AddrModeType::Disassemble,T::Opcode64::AddrModeType::operand_size,},
		{T::Opcode65::InstrType::Mnemonic(),&T::Opcode65::AddrModeType::Disassemble,T::Opcode65::AddrModeType::operand_size,},
		{T::Opcode66::InstrType::Mnemonic(),&T::Opcode66::AddrModeType::Disassemble,T::Opcode66::AddrModeType::operand_size,},
		{T::Opcode67::InstrType::Mnemonic(),&T::Opcode67::AddrModeType::Disassemble,T::Opcode67::AddrModeType::operand_size,},
		{T::Opcode68::InstrType::Mnemonic(),&T::Opcode68::AddrModeType::Disassemble,T::Opcode68::AddrModeType::operand_size,},
		{T::Opcode69::InstrType::Mnemonic(),&T::Opcode69::AddrModeType::Disassemble,T::Opcode69::AddrModeType::operand_size,},
		{T::Opcode6A::InstrType::Mnemonic(),&T::Opcode6A::AddrModeType::Disassemble,T::Opcode6A::AddrModeType::operand_size,},
		{T::Opcode6B::InstrType::Mnemonic(),&T::Opcode6B::AddrModeType::Disassemble,T::Opcode6B::AddrModeType::operand_size,},
		{T::Opcode6C::InstrType::Mnemonic(),&T::Opcode6C::AddrModeType::Disassemble,T::Opcode6C::AddrModeType::operand_size,},
		{T::Opcode6D::InstrType::Mnemonic(),&T::Opcode6D::AddrModeType::Disassemble,T::Opcode6D::AddrModeType::operand_size,},
		{T::Opcode6E::InstrType::Mnemonic(),&T::Opcode6E::AddrModeType::Disassemble,T::Opcode6E::AddrModeType::operand_size,},
		{T::Opcode6F::InstrType::Mnemonic(),&T::Opcode6F::AddrModeType::Disassemble,T::Opcode6F::AddrModeType::operand_size,},
		{T::Opcode70::InstrType::Mnemonic(),&T::Opcode70::AddrModeType::Disassemble,T::Opcode70::AddrModeType::operand_size,},
		{T::Opcode71::InstrType::Mnemonic(),&T::Opcode71::AddrModeType::Disassemble,T::Opcode71::AddrModeType::operand_size,},
		{T::Opcode72::InstrType::Mnemonic(),&T::Opcode72::AddrModeType::Disassemble,T::Opcode72::AddrModeType::operand_size,},
		{T::Opcode73::InstrType::Mnemonic(),&T::Opcode73::AddrModeType::Disassemble,T::Opcode73::AddrModeType::operand_size,},
		{T::Opcode74::InstrType::Mnemonic(),&T::Opcode74::AddrModeType::Disassemble,T::Opcode74::AddrModeType::operand_size,},
		{T::Opcode75::InstrType::Mnemonic(),&T::Opcode75::AddrModeType::Disassemble,T::Opcode75::AddrModeType::operand_size,},
		{T::Opcode76::InstrType::Mnemonic(),&T::Opcode76::AddrModeType::Disassemble,T::Opcode76::AddrModeType::operand_size,},
		{T::Opcode77::InstrType::Mnemonic(),&T::Opcode77::AddrModeType::Disassemble,T::Opcode77::AddrModeType::operand_size,},
		{T::Opcode78::InstrType::Mnemonic(),&T::Opcode78::AddrModeType::Disassemble,T::Opcode78::AddrModeType::operand_size,},
		{T::Opcode79::InstrType::Mnemonic(),&T::Opcode79::AddrModeType::Disassemble,T::Opcode79::AddrModeType::operand_size,},
		{T::Opcode7A::InstrType::Mnemonic(),&T::Opcode7A::AddrModeType::Disassemble,T::Opcode7A::AddrModeType::operand_size,},
		{T::Opcode7B::InstrType::Mnemonic(),&T::Opcode7B::AddrModeType::Disassemble,T::Opcode7B::AddrModeType::operand_size,},
		{T::Opcode7C::InstrType::Mnemonic(),&T::Opcode7C::AddrModeType::Disassemble,T::Opcode7C::AddrModeType::operand_size,},
		{T::Opcode7D::InstrType::Mnemonic(),&T::Opcode7D::AddrModeType::Disassemble,T::Opcode7D::AddrModeType::operand_size,},
		{T::Opcode7E::InstrType::Mnemonic(),&T::Opcode7E::AddrModeType::Disassemble,T::Opcode7E::AddrModeType::operand_size,},
		{T::Opcode7F::InstrType::Mnemonic(),&T::Opcode7F::AddrModeType::Disassemble,T::Opcode7F::AddrModeType::operand_size,},
		{T::Opcode80::InstrType::Mnemonic(),&T::Opcode80::AddrModeType::Disassemble,T::Opcode80::AddrModeType::operand_size,},
		{T::Opcode81::InstrType::Mnemonic(),&T::Opcode81::AddrModeType::Disassemble,T::Opcode81::AddrModeType::operand_size,},
		{T::Opcode82::InstrType::Mnemonic(),&T::Opcode82::AddrModeType::Disassemble,T::Opcode82::AddrModeType::operand_size,},
		{T::Opcode83::InstrType::Mnemonic(),&T::Opcode83::AddrModeType::Disassemble,T::Opcode83::AddrModeType::operand_size,},
		{T::Opcode84::InstrType::Mnemonic(),&T::Opcode84::AddrModeType::Disassemble,T::Opcode84::AddrModeType::operand_size,},
		{T::Opcode85::InstrType::Mnemonic(),&T::Opcode85::AddrModeType::Disassemble,T::Opcode85::AddrModeType::operand_size,},
		{T::Opcode86::InstrType::Mnemonic(),&T::Opcode86::AddrModeType::Disassemble,T::Opcode86::AddrModeType::operand_size,},
		{T::Opcode87::InstrType::Mnemonic(),&T::Opcode87::AddrModeType::Disassemble,T::Opcode87::AddrModeType::operand_size,},
		{T::Opcode88::InstrType::Mnemonic(),&T::Opcode88::AddrModeType::Disassemble,T::Opcode88::AddrModeType::operand_size,},
		{T::Opcode89::InstrType::Mnemonic(),&T::Opcode89::AddrModeType::Disassemble,T::Opcode89::AddrModeType::operand_size,},
		{T::Opcode8A::InstrType::Mnemonic(),&T::Opcode8A::AddrModeType::Disassemble,T::Opcode8A::AddrModeType::operand_size,},
		{T::Opcode8B::InstrType::Mnemonic(),&T::Opcode8B::AddrModeType::Disassemble,T::Opcode8B::AddrModeType::operand_size,},
		{T::Opcode8C::InstrType::Mnemonic(),&T::Opcode8C::AddrModeType::Disassemble,T::Opcode8C::AddrModeType::operand_size,},
		{T::Opcode8D::InstrType::Mnemonic(),&T::Opcode8D::AddrModeType::Disassemble,T::Opcode8D::AddrModeType::operand_size,},
		{T::Opcode8E::InstrType::Mnemonic(),&T::Opcode8E::AddrModeType::Disassemble,T::Opcode8E::AddrModeType::operand_size,},
		{T::Opcode8F::InstrType::Mnemonic(),&T::Opcode8F::AddrModeType::Disassemble,T::Opcode8F::AddrModeType::operand_size,},
		{T::Opcode90::InstrType::Mnemonic(),&T::Opcode90::AddrModeType::Disassemble,T::Opcode90::AddrModeType::operand_size,},
		{T::Opcode91::InstrType::Mnemonic(),&T::Opcode91::AddrModeType::Disassemble,T::Opcode91::AddrModeType::operand_size,},
		{T::Opcode92::InstrType::Mnemonic(),&T::Opcode92::AddrModeType::Disassemble,T::Opcode92::AddrModeType::operand_size,},
		{T::Opcode93::InstrType::Mnemonic(),&T::Opcode93::AddrModeType::Disassemble,T::Opcode93::AddrModeType::operand_size,},
		{T::Opcode94::InstrType::Mnemonic(),&T::Opcode94::AddrModeType::Disassemble,T::Opcode94::AddrModeType::operand_size,},
		{T::Opcode95::InstrType::Mnemonic(),&T::Opcode95::AddrModeType::Disassemble,T::Opcode95::AddrModeType::operand_size,},
		{T::Opcode96::InstrType::Mnemonic(),&T::Opcode96::AddrModeType::Disassemble,T::Opcode96::AddrModeType::operand_size,},
		{T::Opcode97::InstrType::Mnemonic(),&T::Opcode97::AddrModeType::Disassemble,T::Opcode97::AddrModeType::operand_size,},
		{T::Opcode98::InstrType::Mnemonic(),&T::Opcode98::AddrModeType::Disassemble,T::Opcode98::AddrModeType::operand_size,},
		{T::Opcode99::InstrType::Mnemonic(),&T::Opcode99::AddrModeType::Disassemble,T::Opcode99::AddrModeType::operand_size,},
		{T::Opcode9A::InstrType::Mnemonic(),&T::Opcode9A::AddrModeType::Disassemble,T::Opcode9A::AddrModeType::operand_size,},
		{T::Opcode9B::InstrType::Mnemonic(),&T::Opcode9B::AddrModeType::Disassemble,T::Opcode9B::AddrModeType::operand_size,},
		{T::Opcode9C::InstrType::Mnemonic(),&T::Opcode9C::AddrModeType::Disassemble,T::Opcode9C::AddrModeType::operand_size,},
		{T::Opcode9D::InstrType::Mnemonic(),&T::Opcode9D::AddrModeType::Disassemble,T::Opcode9D::AddrModeType::operand_size,},
		{T::Opcode9E::InstrType::Mnemonic(),&T::Opcode9E::AddrModeType::Disassemble,T::Opcode9E::AddrModeType::operand_size,},
		{T::Opcode9F::InstrType::Mnemonic(),&T::Opcode9F::AddrModeType::Disassemble,T::Opcode9F::AddrModeType::operand_size,},
		{T::OpcodeA0::InstrType::Mnemonic(),&T::OpcodeA0::AddrModeType::Disassemble,T::OpcodeA0::AddrModeType::operand_size,},
		{T::OpcodeA1::InstrType::Mnemonic(),&T::OpcodeA1::AddrModeType::Disassemble,T::OpcodeA1::AddrModeType::operand_size,},
		{T::OpcodeA2::InstrType::Mnemonic(),&T::OpcodeA2::AddrModeType::Disassemble,T::OpcodeA2::AddrModeType::operand_size,},
		{T::OpcodeA3::InstrType::Mnemonic(),&T::OpcodeA3::AddrModeType::Disassemble,T::OpcodeA3::AddrModeType::operand_size,},
		{T::OpcodeA4::InstrType::Mnemonic(),&T::OpcodeA4::AddrModeType::Disassemble,T::OpcodeA4::AddrModeType::operand_size,},
		{T::OpcodeA5::InstrType::Mnemonic(),&T::OpcodeA5::AddrModeType::Disassemble,T::OpcodeA5::AddrModeType::operand_size,},
		{T::OpcodeA6::InstrType::Mnemonic(),&T::OpcodeA6::AddrModeType::Disassemble,T::OpcodeA6::AddrModeType::operand_size,},
		{T::OpcodeA7::InstrType::Mnemonic(),&T::OpcodeA7::AddrModeType::Disassemble,T::OpcodeA7::AddrModeType::operand_size,},
		{T::OpcodeA8::InstrType::Mnemonic(),&T::OpcodeA8::AddrModeType::Disassemble,T::OpcodeA8::AddrModeType::operand_size,},
		{T::OpcodeA9::InstrType::Mnemonic(),&T::OpcodeA9::AddrModeType::Disassemble,T::OpcodeA9::AddrModeType::operand_size,},
		{T::OpcodeAA::InstrType::Mnemonic(),&T::OpcodeAA::AddrModeType::Disassemble,T::OpcodeAA::AddrModeType::operand_size,},
		{T::OpcodeAB::InstrType::Mnemonic(),&T::OpcodeAB::AddrModeType::Disassemble,T::OpcodeAB::AddrModeType::operand_size,},
		{T::OpcodeAC::InstrType::Mnemonic(),&T::OpcodeAC::AddrModeType::Disassemble,T::OpcodeAC::AddrModeType::operand_size,},
		{T::OpcodeAD::InstrType::Mnemonic(),&T::OpcodeAD::AddrModeType::Disassemble,T::OpcodeAD::AddrModeType::operand_size,},
		{T::OpcodeAE::InstrType::Mnemonic(),&T::OpcodeAE::AddrModeType::Disassemble,T::OpcodeAE::AddrModeType::operand_size,},
		{T::OpcodeAF::InstrType::Mnemonic(),&T::OpcodeAF::AddrModeType::Disassemble,T::OpcodeAF::AddrModeType::operand_size,},
		{T::OpcodeB0::InstrType::Mnemonic(),&T::OpcodeB0::AddrModeType::Disassemble,T::OpcodeB0::AddrModeType::operand_size,},
		{T::OpcodeB1::InstrType::Mnemonic(),&T::OpcodeB1::AddrModeType::Disassemble,T::OpcodeB1::AddrModeType::operand_size,},
		{T::OpcodeB2::InstrType::Mnemonic(),&T::OpcodeB2::AddrModeType::Disassemble,T::OpcodeB2::AddrModeType::operand_size,},
		{T::OpcodeB3::InstrType::Mnemonic(),&T::OpcodeB3::AddrModeType::Disassemble,T::OpcodeB3::AddrModeType::operand_size,},
		{T::OpcodeB4::InstrType::Mnemonic(),&T::OpcodeB4::AddrModeType::Disassemble,T::OpcodeB4::AddrModeType::operand_size,},
		{T::OpcodeB5::InstrType::Mnemonic(),&T::OpcodeB5::AddrModeType::Disassemble,T::OpcodeB5::AddrModeType::operand_size,},
		{T::OpcodeB6::InstrType::Mnemonic(),&T::OpcodeB6::AddrModeType::Disassemble,T::OpcodeB6::AddrModeType::operand_size,},
		{T::OpcodeB7::InstrType::Mnemonic(),&T::OpcodeB7::AddrModeType::Disassemble,T::OpcodeB7::AddrModeType::operand_size,},
		{T::OpcodeB8::InstrType::Mnemonic(),&T::OpcodeB8::AddrModeType::Disassemble,T::OpcodeB8::AddrModeType::operand_size,},
		{T::OpcodeB9::InstrType::Mnemonic(),&T::OpcodeB9::AddrModeType::Disassemble,T::OpcodeB9::AddrModeType::operand_size,},
		{T::OpcodeBA::InstrType::Mnemonic(),&T::OpcodeBA::AddrModeType::Disassemble,T::OpcodeBA::AddrModeType::operand_size,},
		{T::OpcodeBB::InstrType::Mnemonic(),&T::OpcodeBB::AddrModeType::Disassemble,T::OpcodeBB::AddrModeType::operand_size,},
		{T::OpcodeBC::InstrType::Mnemonic(),&T::OpcodeBC::AddrModeType::Disassemble,T::OpcodeBC::AddrModeType::operand_size,},
		{T::OpcodeBD::InstrType::Mnemonic(),&T::OpcodeBD::AddrModeType::Disassemble,T::OpcodeBD::AddrModeType::operand_size,},
		{T::OpcodeBE::InstrType::Mnemonic(),&T::OpcodeBE::AddrModeType::Disassemble,T::OpcodeBE::AddrModeType::operand_size,},
		{T::OpcodeBF::InstrType::Mnemonic(),&T::OpcodeBF::AddrModeType::Disassemble,T::OpcodeBF::AddrModeType::operand_size,},
		{T::OpcodeC0::InstrType::Mnemonic(),&T::OpcodeC0::AddrModeType::Disassemble,T::OpcodeC0::AddrModeType::operand_size,},
		{T::OpcodeC1::InstrType::Mnemonic(),&T::OpcodeC1::AddrModeType::Disassemble,T::OpcodeC1::AddrModeType::operand_size,},
		{T::OpcodeC2::InstrType::Mnemonic(),&T::OpcodeC2::AddrModeType::Disassemble,T::OpcodeC2::AddrModeType::operand_size,},
		{T::OpcodeC3::InstrType::Mnemonic(),&T::OpcodeC3::AddrModeType::Disassemble,T::OpcodeC3::AddrModeType::operand_size,},
		{T::OpcodeC4::InstrType::Mnemonic(),&T::OpcodeC4::AddrModeType::Disassemble,T::OpcodeC4::AddrModeType::operand_size,},
		{T::OpcodeC5::InstrType::Mnemonic(),&T::OpcodeC5::AddrModeType::Disassemble,T::OpcodeC5::AddrModeType::operand_size,},
		{T::OpcodeC6::InstrType::Mnemonic(),&T::OpcodeC6::AddrModeType::Disassemble,T::OpcodeC6::AddrModeType::operand_size,},
		{T::OpcodeC7::InstrType::Mnemonic(),&T::OpcodeC7::AddrModeType::Disassemble,T::OpcodeC7::AddrModeType::operand_size,},
		{T::OpcodeC8::InstrType::Mnemonic(),&T::OpcodeC8::AddrModeType::Disassemble,T::OpcodeC8::AddrModeType::operand_size,},
		{T::OpcodeC9::InstrType::Mnemonic(),&T::OpcodeC9::AddrModeType::Disassemble,T::OpcodeC9::AddrModeType::operand_size,},
		{T::OpcodeCA::InstrType::Mnemonic(),&T::OpcodeCA::AddrModeType::Disassemble,T::OpcodeCA::AddrModeType::operand_size,},
		{T::OpcodeCB::InstrType::Mnemonic(),&T::OpcodeCB::AddrModeType::Disassemble,T::OpcodeCB::AddrModeType::operand_size,},
		{T::OpcodeCC::InstrType::Mnemonic(),&T::OpcodeCC::AddrModeType::Disassemble,T::OpcodeCC::AddrModeType::operand_size,},
		{T::OpcodeCD::InstrType::Mnemonic(),&T::OpcodeCD::AddrModeType::Disassemble,T::OpcodeCD::AddrModeType::operand_size,},
		{T::OpcodeCE::InstrType::Mnemonic(),&T::OpcodeCE::AddrModeType::Disassemble,T::OpcodeCE::AddrModeType::operand_size,},
		{T::OpcodeCF::InstrType::Mnemonic(),&T::OpcodeCF::AddrModeType::Disassemble,T::OpcodeCF::AddrModeType::operand_size,},
		{T::OpcodeD0::InstrType::Mnemonic(),&T::OpcodeD0::AddrModeType::Disassemble,T::OpcodeD0::AddrModeType::operand_size,},
		{T::OpcodeD1::InstrType::Mnemonic(),&T::OpcodeD1::AddrModeType::Disassemble,T::OpcodeD1::AddrModeType::operand_size,},
		{T::OpcodeD2::InstrType::Mnemonic(),&T::OpcodeD2::AddrModeType::Disassemble,T::OpcodeD2::AddrModeType::operand_size,},
		{T::OpcodeD3::InstrType::Mnemonic(),&T::OpcodeD3::AddrModeType::Disassemble,T::OpcodeD3::AddrModeType::operand_size,},
		{T::OpcodeD4::InstrType::Mnemonic(),&T::OpcodeD4::AddrModeType::Disassemble,T::OpcodeD4::AddrModeType::operand_size,},
		{T::OpcodeD5::InstrType::Mnemonic(),&T::OpcodeD5::AddrModeType::Disassemble,T::OpcodeD5::AddrModeType::operand_size,},
		{T::OpcodeD6::InstrType::Mnemonic(),&T::OpcodeD6::AddrModeType::Disassemble,T::OpcodeD6::AddrModeType::operand_size,},
		{T::OpcodeD7::InstrType::Mnemonic(),&T::OpcodeD7::AddrModeType::Disassemble,T::OpcodeD7::AddrModeType::operand_size,},
		{T::OpcodeD8::InstrType::Mnemonic(),&T::OpcodeD8::AddrModeType::Disassemble,T::OpcodeD8::AddrModeType::operand_size,},
		{T::OpcodeD9::InstrType::Mnemonic(),&T::OpcodeD9::AddrModeType::Disassemble,T::OpcodeD9::AddrModeType::operand_size,},
		{T::OpcodeDA::InstrType::Mnemonic(),&T::OpcodeDA::AddrModeType::Disassemble,T::OpcodeDA::AddrModeType::operand_size,},
		{T::OpcodeDB::InstrType::Mnemonic(),&T::OpcodeDB::AddrModeType::Disassemble,T::OpcodeDB::AddrModeType::operand_size,},
		{T::OpcodeDC::InstrType::Mnemonic(),&T::OpcodeDC::AddrModeType::Disassemble,T::OpcodeDC::AddrModeType::operand_size,},
		{T::OpcodeDD::InstrType::Mnemonic(),&T::OpcodeDD::AddrModeType::Disassemble,T::OpcodeDD::AddrModeType::operand_size,},
		{T::OpcodeDE::InstrType::Mnemonic(),&T::OpcodeDE::AddrModeType::Disassemble,T::OpcodeDE::AddrModeType::operand_size,},
		{T::OpcodeDF::InstrType::Mnemonic(),&T::OpcodeDF::AddrModeType::Disassemble,T::OpcodeDF::AddrModeType::operand_size,},
		{T::OpcodeE0::InstrType::Mnemonic(),&T::OpcodeE0::AddrModeType::Disassemble,T::OpcodeE0::AddrModeType::operand_size,},
		{T::OpcodeE1::InstrType::Mnemonic(),&T::OpcodeE1::AddrModeType::Disassemble,T::OpcodeE1::AddrModeType::operand_size,},
		{T::OpcodeE2::InstrType::Mnemonic(),&T::OpcodeE2::AddrModeType::Disassemble,T::OpcodeE2::AddrModeType::operand_size,},
		{T::OpcodeE3::InstrType::Mnemonic(),&T::OpcodeE3::AddrModeType::Disassemble,T::OpcodeE3::AddrModeType::operand_size,},
		{T::OpcodeE4::InstrType::Mnemonic(),&T::OpcodeE4::AddrModeType::Disassemble,T::OpcodeE4::AddrModeType::operand_size,},
		{T::OpcodeE5::InstrType::Mnemonic(),&T::OpcodeE5::AddrModeType::Disassemble,T::OpcodeE5::AddrModeType::operand_size,},
		{T::OpcodeE6::InstrType::Mnemonic(),&T::OpcodeE6::AddrModeType::Disassemble,T::OpcodeE6::AddrModeType::operand_size,},
		{T::OpcodeE7::InstrType::Mnemonic(),&T::OpcodeE7::AddrModeType::Disassemble,T::OpcodeE7::AddrModeType::operand_size,},
		{T::OpcodeE8::InstrType::Mnemonic(),&T::OpcodeE8::AddrModeType::Disassemble,T::OpcodeE8::AddrModeType::operand_size,},
		{T::OpcodeE9::InstrType::Mnemonic(),&T::OpcodeE9::AddrModeType::Disassemble,T::OpcodeE9::AddrModeType::operand_size,},
		{T::OpcodeEA::InstrType::Mnemonic(),&T::OpcodeEA::AddrModeType::Disassemble,T::OpcodeEA::AddrModeType::operand_size,},
		{T::OpcodeEB::InstrType::Mnemonic(),&T::OpcodeEB::AddrModeType::Disassemble,T::OpcodeEB::AddrModeType::operand_size,},
		{T::OpcodeEC::InstrType::Mnemonic(),&T::OpcodeEC::AddrModeType::Disassemble,T::OpcodeEC::AddrModeType::operand_size,},
		{T::OpcodeED::InstrType::Mnemonic(),&T::OpcodeED::AddrModeType::Disassemble,T::OpcodeED::AddrModeType::operand_size,},
		{T::OpcodeEE::InstrType::Mnemonic(),&T::OpcodeEE::AddrModeType::Disassemble,T::OpcodeEE::AddrModeType::operand_size,},
		{T::OpcodeEF::InstrType::Mnemonic(),&T::OpcodeEF::AddrModeType::Disassemble,T::OpcodeEF::AddrModeType::operand_size,},
		{T::OpcodeF0::InstrType::Mnemonic(),&T::OpcodeF0::AddrModeType::Disassemble,T::OpcodeF0::AddrModeType::operand_size,},
		{T::OpcodeF1::InstrType::Mnemonic(),&T::OpcodeF1::AddrModeType::Disassemble,T::OpcodeF1::AddrModeType::operand_size,},
		{T::OpcodeF2::InstrType::Mnemonic(),&T::OpcodeF2::AddrModeType::Disassemble,T::OpcodeF2::AddrModeType::operand_size,},
		{T::OpcodeF3::InstrType::Mnemonic(),&T::OpcodeF3::AddrModeType::Disassemble,T::OpcodeF3::AddrModeType::operand_size,},
		{T::OpcodeF4::InstrType::Mnemonic(),&T::OpcodeF4::AddrModeType::Disassemble,T::OpcodeF4::AddrModeType::operand_size,},
		{T::OpcodeF5::InstrType::Mnemonic(),&T::OpcodeF5::AddrModeType::Disassemble,T::OpcodeF5::AddrModeType::operand_size,},
		{T::OpcodeF6::InstrType::Mnemonic(),&T::OpcodeF6::AddrModeType::Disassemble,T::OpcodeF6::AddrModeType::operand_size,},
		{T::OpcodeF7::InstrType::Mnemonic(),&T::OpcodeF7::AddrModeType::Disassemble,T::OpcodeF7::AddrModeType::operand_size,},
		{T::OpcodeF8::InstrType::Mnemonic(),&T::OpcodeF8::AddrModeType::Disassemble,T::OpcodeF8::AddrModeType::operand_size,},
		{T::OpcodeF9::InstrType::Mnemonic(),&T::OpcodeF9::AddrModeType::Disassemble,T::OpcodeF9::AddrModeType::operand_size,},
		{T::OpcodeFA::InstrType::Mnemonic(),&T::OpcodeFA::AddrModeType::Disassemble,T::OpcodeFA::AddrModeType::operand_size,},
		{T::OpcodeFB::InstrType::Mnemonic(),&T::OpcodeFB::AddrModeType::Disassemble,T::OpcodeFB::AddrModeType::operand_size,},
		{T::OpcodeFC::InstrType::Mnemonic(),&T::OpcodeFC::AddrModeType::Disassemble,T::OpcodeFC::AddrModeType::operand_size,},
		{T::OpcodeFD::InstrType::Mnemonic(),&T::OpcodeFD::AddrModeType::Disassemble,T::OpcodeFD::AddrModeType::operand_size,},
		{T::OpcodeFE::InstrType::Mnemonic(),&T::OpcodeFE::AddrModeType::Disassemble,T::OpcodeFE::AddrModeType::operand_size,},
		{T::OpcodeFF::InstrType::Mnemonic(),&T::OpcodeFF::AddrModeType::Disassemble,T::OpcodeFF::AddrModeType::operand_size,},
	};
}

#endif
