hex_digits="0123456789ABCDEF"

def hex2(v):
    return hex_digits[(v>>4)&15]+hex_digits[v&15]

# Read the opcodes
f=open("6502_opcodes.txt")
opcodes=[]
for i in range(256):
    opcodes.append(f.readline().split())
f.close()

# Read the instructions
f=open("instr_types.txt")
op_types={}
done=0
while not done:
    l=f.readline()
    if l=="":
        done=1
    elif not l.startswith("//"):
        #op_name,op_type=l.split()
        #op_types[op_name]=op_type
        l=l.split()
        if len(l)==2:
            op_types[l[0].lower()]=l[1]#.lower()
f.close()

print "#ifndef GENERIC6502INSTRUCTIONSET_H_"
print "#define GENERIC6502INSTRUCTIONSET_H_"
print "// Automatically generated by mkg.py"
print "// Don't bother editing!"
print ""
print "namespace t65 {"
print "\ttemplate<class ProcessorType>"
print "\tstruct Generic6502InstructionSet {"
print "\t\ttypedef ProcessorType P;"
for name,addr_mode,opcode,is_illegal in opcodes:
    #    print name+" "+type+" "+opcode+" "+is_illegal
    l="\t\ttypedef "
    if is_illegal=="y":
        l+="P::Implied<P::InstrILL,P::ModeIMP>"
    else:
        if not op_types.has_key(name.lower()):
            print "FATAL: What type is "+name+"?"
        else:
            l+="P::"+op_types[name.lower()]+"<P::Instr"+name+",P::Mode"+addr_mode+">"
    l+=" Opcode"+hex2(int(opcode))+";"
    print l
print "\t};"
print "}"
print "#endif"

#	print "\ttypedef "
#	if illegal[i] then
#		print "P::Implied<P::InstrILL,P::ModeIMP>"
#	else
#		typ=instruction_types{lcase(op_name[i])}
#		if typ=undef then
#			print "FATAL: What type is \""&op_name[i]&"\"?\n"
#			stop
#		end if
#		print "P::"&typ
#		print "<"
#		print "P::Instr"&ucase(op_name[i])
#		print ","
#		print "P::Mode"&ucase(addrmode[i])
#		print ">"
#	end if
#	print " Opcode"& hexstr(i,2)
#	print ";\n"
    