#include "pch.h"
#include "mbMisc.h"

bool mbSaveFile(const wxString &filename,const std::vector<wxByte> &contents) {
	wxFileOutputStream out(filename);
	if(!out.Ok()) {
		return false;
	}
	out.Write(&contents[0],contents.size());
	if(!out.Ok()) {
		return false;
	}
	return true;
}

bool mbLoadFile(const wxString &filename,std::vector<wxByte> &contents) {
	contents.clear();
	wxFileSystem fs;
	wxFSFile *f=fs.OpenFile(filename);
	if(!f) {
		return false;
	}
	wxInputStream *stream=f->GetStream();
	if(!stream) {
		delete f;
		return false;
	}
	stream->SeekI(0,wxFromEnd);
	off_t length=stream->TellI();
	stream->SeekI(0,wxFromStart);
	contents.resize(length);
	if(!stream->Read(&contents[0],length).IsOk()) {
		delete f;
		return false;
	}
	delete f;
	return true;
}

void mbGetMatchingFileNames(const wxFileName &root,const wxString &name_spec,
	std::vector<wxFileName> *file_names)
{
	wxASSERT(file_names);
	wxFileName spec=root;
	spec.SetName(name_spec);
	wxLogDebug("mbGetMatchingFileNames: files: \"%s\"...",spec.GetFullPath().c_str());
	wxFileSystem fs;
	wxString name=fs.FindFirst(spec.GetFullPath(),wxFILE);
	while(!name.empty()) {
		file_names->push_back(name);
		name=fs.FindNext();
	}
	wxLogDebug("mbGetMatchingFileNames: files: %u found",file_names->size());
}

void mbGetDirectoryNames(const wxFileName &root,std::vector<wxFileName> *dir_names) {
	wxASSERT(dir_names);
	wxFileName spec=root;
	spec.SetName("*");
	wxLogDebug("mbGetDirectoryNames: \"%s\"...",spec.GetFullPath().c_str());
	wxFileSystem fs;
	wxString name=fs.FindFirst(spec.GetFullPath(),wxDIR);
	while(!name.empty()) {
		if(name!="."&&name!="..") {
			dir_names->push_back(wxFileName::DirName(name));
		}
		name=fs.FindNext();
	}
	wxLogDebug("mbGetDirectoryNames: %u found",dir_names->size());
}

wxString mbNormalizedFileName(const wxString &file_name) {
	wxFileName f=wxFileName::FileName(file_name);
	f.Normalize();
	return f.GetFullPath();
}

wxString mbRelativeFileName(const wxString &file_name,const wxString &base_dir) {
	wxFileName f=wxFileName::FileName(file_name);
	f.MakeRelativeTo(base_dir);
	return f.GetFullPath();
}
