#ifndef bbcVIDEO_H_
#define bbcVIDEO_H_

#include <string>
#include <vector>

class bbcVideo {
public:
#ifdef bbcDEBUG_VIDEO
	static bool show_all_;//don't change this by hand
	static unsigned show_all_offset_;
	static void SetShowAll(bool new_show_all);
	static void LogFrames(const char *filename,int num_frames,bool with_disassembly);
	static int num_log_frames_left_;
	static FILE *log_frames_h_;
	static bool show_t1_timeouts_;
#endif
	static void SetPixelFixedBits(t65::byte fixed_bits);
	static bool SetBufferDimensions(int width,int height);

	enum Registers {
		ULA_BEGIN=0,

		//Palette -- 16 registers
		ULA_PALETTE=ULA_BEGIN,

		//ULA control register
		ULA_CTRL=ULA_PALETTE+16,

		ULA_END,

		//CRTC -- 18 registers
		CRTC_BEGIN=ULA_END,
		CRTC_BASE=CRTC_BEGIN,
		CRTC_END=CRTC_BEGIN+18,

		//Invalid (ignored)
		DUMMY,

		NUM_REGS,
	};
	
//	bbcVideo();
//	~bbcVideo();

	static void Init();
	static void Shutdown();

	static void Reset();

	static void Write(unsigned reg,t65::byte value);

	static void SetScreenWrapSize(t65::word new_wrap_size);
	static void Update(int cycles);

	static t65::byte Read6845(t65::byte offset);

	static void Write6845(t65::byte offset,t65::byte val);
	static void WriteUla(t65::byte offset,t65::byte val);
	static void WritePalette(t65::byte offset,t65::byte val);

	//Sets pointer to where video RAM is.
	static void SetVideoRam(const t65::byte *video_ram);

	static int buffer_width;
	static int buffer_height;
	static int buffer_size;
	static t65::byte *buffer;
	static std::vector<t65::byte> buffer_vector;
	static bool buffer_dirty;
	
	static void DebugDump(FILE *h);
protected:
private:
	static const t65::byte *video_ram_;

	static std::string reg_names_[NUM_REGS];
	static t65::byte cpu_current_[NUM_REGS];//as the CPU sees them
	static t65::byte video_current_[NUM_REGS];//as the video system sees them
	static int last_flush_at_;

	//Display list entry
	struct DlEntry {
		int when;
		t65::byte reg;
		t65::byte val;
	};

	//This will always be sufficient.
	//Max throughput is STA, one write/4 cycles; max cycle count per scanline
	//is 512 (256 x 2 for slow 6845 clock) so 128 writes.
	enum {
		dlq_num_entries=128,
	};

	static DlEntry dlq_[dlq_num_entries];
	static int dlq_read_;
	static int dlq_write_;

	//runs from 'start_idx' until 'stop_cycles' is reached; returns new index.
	static int DlqRun(int stop_cycles,int start_idx);

	//Used at end of render to copy current settings to those used as the starting
	//ones for the next update.
//	static void CopyCurrentToStarting();

	//Used at start of render to copy starting settings to those used currently by
	//the video render. (current_ must be updated whilst CPU is running too, so that
	//reading readable registers works correctly.)
//	static void CopyStartingToCurrent();
	
	enum VideoRegFlags {
		READABLE=256,
		WRITABLE=512,
	};

	static unsigned reg_6845_select_;
	static const int reg_6845_flags_[18];

//	static void *dest_;

	static t65::word read_address_;
//	unsigned scanline_;

	//dest -- where in buffer to draw
	//src -- where in beeb ram to draw from
	//subline -- which subline to draw
	static void RenderFastClockScanline(t65::byte *dest,t65::word src);
	static void RenderSlowClockScanline(t65::byte *dest,t65::word src);
	static void RenderTeletextScanline(t65::byte *dest,t65::word src);

	static void RebuildFastClockPaletteTables();
	static void RebuildSlowClockPaletteTables();
	
	//6845 state
	static int cur_line_,cur_subline_;
//	static int vsync_left_;
	static t65::word framebuffer_base_;


	//Index of scanline -- -ve after vsync, +ve before
	static int cur_scanline_;

	//Set according to R5 as appropriate -- number of blank scanlines to insert
	//right now.
	static int num_blank_scanlines_;

	//# scanlines total for the last frame.
	static int num_total_scanlines_;

	static int frame_count_;

	static t65::word wrap_size_;
	static bool palette_dirty_3bit_;
	static bool palette_dirty_slow_;
	static bool palette_dirty_fast_;

	static int DlqNext(int v);
	static void SetupTables();

	static t65::qword expand_1bit_slow_[16];
	static t65::dword expand_1bit_fast_[16];
	static t65::byte rearrange_2bit_[256];
	static t65::byte rearrange_4bit_[256];

	static bool is_teletext_frame_;
	//Index of last line on which was displayed the top half of double height characters.
	static int last_double_height_line_;
	
	//hblank value (in fast-6845-clock units) at which the
	//beeb's display will be on the left of the virtal screen.
	//98 for bitmap modes
	//
	static int hblank_leftaligned_;

	bbcVideo();
	bbcVideo(const bbcVideo &);
	bbcVideo &operator=(const bbcVideo &);

	static void Rebuild3bitPalette();

	static t65::byte palette_3bit_[16];

	static void DrawCursor();

	static t65::byte pixel_fixed_bits_;
};

inline int bbcVideo::DlqNext(int v) {
	return (v+1)%dlq_num_entries;
}

inline void bbcVideo::SetScreenWrapSize(t65::word new_wrap_size) {
	wrap_size_=new_wrap_size;
}

inline void bbcVideo::SetVideoRam(const t65::byte *video_ram) {
	video_ram_=video_ram;
}

#endif
