#include "pch.h"
#include "bbcComputer.h"
#include "bbcSystemVIA.h"
#include "bbcSound.h"
#include "bbcKeys.h"
#include "bbcKeyboardMatrix.h"

bbcSystemVIA bbc_system_via;

bool bbcSystemVIA::CapslockLedLit() {
	return capslock_led_;
}

bool bbcSystemVIA::ShiftlockLedLit() {
	return shiftlock_led_;
}

const t65::word bbcSystemVIA::wraptbl_[4]={
    0x4000,
    0x2000,
    0x5000,
    0x2800,
};

bbcSystemVIA::bbcSystemVIA():
bbcVIA(IRQ_SYSVIA,"SysVIA")
{
	std::fill(latch_,latch_+8,false);
	capslock_led_=false;
	shiftlock_led_=false;
}

// The top 4 input bits on PB are for the joystick and speech system.
// %1111 means 'do nothing'.
void bbcSystemVIA::ReadingPb() {
    pb_|=0xF0;
}

void bbcSystemVIA::ReadingPa() {
	pa_&=0x7F;
	if(bbcKeyboardMatrix::ManualScanFlag()) {
		pa_|=0x80;
	}
}

// Presumably multiple devices can be written to?
void bbcSystemVIA::WrittenPa() {
    if(!latch_[0]) {
        // Write enable to sound generator
		//        soundhardware->write(PA);
		bbcSound::Write(pa_);
    }
    if(!latch_[3]) {
        // write enable to keyboard -- IRQ only if current PA pins (keycode)
		// demand it
        bbcKeyboardMatrix::SetInput(pa_);
		if(bbcKeyboardMatrix::NeedsIrq()) {
			this->CA2(true);
		}
    }
}

// Port B on the system VIA is attached to the addressable latch. PB[012]
// supply the bit number, 0-7, and PB3 supplies the new value for that
// bit.
// This code is based on the code from James Bonfield's emulator.
void bbcSystemVIA::WrittenPb() {
//	bool old=latch[PB&7];
    latch_[pb_&7]=(pb_&8)?true:false;
    switch(pb_&7) {
	case 0:     // "Write enable to the sound generator IC"
		if(!latch_[0]) {
			bbcSound::Write(pa_);
			//                soundhardware->write(PA);
		}
		break;
	case 1:     // "Read select on the speech processor"
		break;
	case 2:     // "Write select on the speech processor"
		break;
	case 3:     // "Keyboard write enable" (0 = en 1 = dis)
		if(latch_[3]) {
			//dis
			bbcKeyboardMatrix::SetWriteEnabled(false);
		} else {
			//en -- maybe new input
			bbcKeyboardMatrix::SetWriteEnabled(true);
			bbcKeyboardMatrix::SetInput(pa_);
		}
		break;
	case 4:
	case 5:     // Select screen wrap size
		//			bbc_video_hardware.set_screen_wrap_size(wraptbl[(latch[4]?1:0)|(latch[5]?2:0)]);
		{
			unsigned v=(latch_[4]?1:0)|(latch_[5]?2:0);
			bbcVideo::SetScreenWrapSize(wraptbl_[v]);
		}
		break;
	case 6:     // Caps lock LED status
		capslock_led_=!latch_[6];
		break;
	case 7:     // Shift lock LED status
		shiftlock_led_=!latch_[7];
		break;
    }
}

//this is the keyboard scan type affair -- it only occurs when the keyboard is
//not enabled for write.
//causes a +ve active edge on CA2 if the keyboard wants it.
//don't ask me how i know it's a +ve one -- i think i looked at the relevant
//via register to work out what's required to get the interrupt to fire.
//
// fix -- keystate updated at any time, only when disabled for write will
// the interrupt fire though. [19/3/2003]
void bbcSystemVIA::SetKeyState(bbcKey key,bool state) {
	bbcKeyboardMatrix::SetKeyState(key,state);
//	if(latch[3]&&KeyboardMatrix::NeedsIrq()) {
//		CA2(true);
//	}
}

//	if(latch[3]) {
//		if(KeyboardMatrix::SetKeyState(key,state)) {
//			CA2(true);
//		}
//	}
//}

void bbcSystemVIA::DoKeyboardIrq() {
	if(bbcKeyboardMatrix::NeedsIrq()) {
		this->CA2(true);
	}
}
