#include "pch.h"
#include "bbcSound.h"
#include "bbcComputer.h"

//http://web.inter.nl.net/users/J.Kortink/home/articles/sn76489/index.htm
//http://www.smspower.org/maxim/smschecker/SN76489.txt for the details

#ifdef CRAPPY_DEBUG
#include <windows.h>
#endif

t65::byte bbcSound::latch_;
unsigned bbcSound::write_idx_;
bbcSound::SoundWriteEntry bbcSound::writes_[bbcSound::max_num_writes+1];
bbcSound::SoundRegister bbcSound::cur_regs_[4];//012 3=noise
int bbcSound::last_render_at_;
//bbcSound::sample bbcSound::volumes_16bit_[16];
//bbcSound::fixedpoint bbcSound::freq_mul_;
bbcSound::fixedpoint bbcSound::samples_per_switch_[1024];
int bbcSound::hz_from_tone_[1024];
t65::word bbcSound::noise_seed_;
int bbcSound::noise_bit_;
bool bbcSound::is_stereo_left_[4];
bool bbcSound::is_stereo_right_[4];

bbcSound::Render8BitTraits::sample_type bbcSound::Render8BitTraits::volumes[16];
bbcSound::Render16BitTraits::sample_type bbcSound::Render16BitTraits::volumes[16];

bool bbcSound::is_recording_;
std::deque<bbcSound::SoundWriteEntry> bbcSound::recorded_writes_;

//THingies for incoming values
#define VAL_IS_LATCH(V) (!!((V)&0x80))

#define VAL_LATCH_REG(V) (((V)>>4)&7)
#define VAL_LATCH_DATA(V) ((V)&15)
#define VAL_DATA_DATA(V) ((V)&63)

//Internal register number thingies
#define REG_IS_VOLUME(R) (!!((R)&1))
#define REG_CHANNEL(R) (((R)>>1)&3)
//4bit registers used for volume and noise settings
#define REG_IS_4BIT(R) (REG_IS_VOLUME(R)||(REG_CHANNEL(R)==3))

void bbcSound::Init() {
	unsigned i;

	write_idx_=0;
	latch_=0;
	last_render_at_=bbcSOUND_CYCLES();

	//Reset registers
	//
	//Volumes initially set to %1111 (silent)
	//Tone/noise set to 0
	for(i=0;i<4;++i) {
		SoundRegister *reg=&cur_regs_[i];
		reg->counter=bbcFIXED_OF(0);
		reg->pitch=1023;
		reg->vol=0;//silent
		reg->mul=1;
	}

	//44100Hz is the frequency at the mo'
	//freq_mul_=bbcFIXED_OF(250000/44100.f);

	for(i=1;i<1024;++i) {
		hz_from_tone_[i]=4000000/(32*i);
	}
	hz_from_tone_[0]=hz_from_tone_[1];
	
	SetFrequency(44100);

	for(i=0;i<16;++i) {
		int v=i^15;
		Render8BitTraits::volumes[i]=Render8BitTraits::sample_type(v/15.f*127);
		Render16BitTraits::volumes[i]=Render16BitTraits::sample_type(v/15.f*32767);
	}

	noise_seed_=0x4000;
	noise_bit_=0;//I don't think it really matters.

	is_recording_=false;
}

void bbcSound::SetFrequency(int hz) {
	for(unsigned i=0;i<1024;++i) {
		samples_per_switch_[i]=bbcFIXED_OF(float(hz)/hz_from_tone_[i]/2.f);
		if(samples_per_switch_[i]<bbcFIXED_OF(1)) {
			//This fixed the sound pretty much entirely...
			samples_per_switch_[i]=bbcFIXED_OF(0);
		}
	}
	samples_per_switch_[0]=bbcFIXED_OF(0);//Special.
}

void bbcSound::Write(t65::byte v) {
	if(write_idx_==0||writes_[write_idx_-1].cycles!=bbcSOUND_CYCLES()) {
		if(write_idx_==max_num_writes) {
			printf("bbcSound::Write: overflow. Resetting. Some sound will be lost.\n");
			write_idx_=0;
		} else {
			SoundWriteEntry *swe=&writes_[write_idx_];
			swe->cycles=bbcSOUND_CYCLES();
			swe->val=v;
			++write_idx_;
		}
		if(is_recording_) {
			SoundWriteEntry *swe=&*recorded_writes_.insert(recorded_writes_.end(),
				SoundWriteEntry());
			swe->cycles=bbcSOUND_CYCLES();
			swe->val=v;
		}
	}
}

//Updates current settings as if byte 'v' were just written
//register value is CCV
//CC bits dictate channel (0,1,2,3=noise)
//V dictates channel data -- 1=Volume, 0=Tone (for ch3, aka noise)

//#define REG_P(R) (((R)&1)?&cur_regs_[(R)>>1].vol:&cur_regs_[(R)>>1].pitch)

void bbcSound::DoByte(t65::byte v) {
	t65::byte data;
	int shift;
	t65::word mask;
	if(VAL_IS_LATCH(v)) {
		latch_=VAL_LATCH_REG(v);
		data=VAL_LATCH_DATA(v);
		shift=0;
		mask=0x3f0;//%1111110000
	} else {
		data=VAL_DATA_DATA(v);
		if(REG_IS_4BIT(latch_)) {
			mask=0;
			shift=0;//4 bit registers get the lower 4 bits of the data
		} else {
			shift=4;
			mask=0x00f;
		}
	}
	SoundRegister *sreg=&cur_regs_[latch_>>1];
	t65::word *reg;
	if(latch_&1) {
		reg=&sreg->vol;
	} else {
		reg=&sreg->pitch;
//		sreg->counter=bbcFIXED_OF(0);
//		sreg->mul=1;
	}
	*reg&=mask;
	*reg|=(data<<shift)&~mask;
	if(latch_==6) {
		//Noise register write -- this resets the noise
		//seed
		noise_seed_=0x4000;
	}
}

int bbcSound::NextNoiseBit() {
	bool new_bit=!((noise_seed_^(noise_seed_>>1))&1);
	noise_seed_=(noise_seed_>>1)|(new_bit?(1<<14):0);
	return noise_seed_&1;
}

void bbcSound::SetChannelStereoLeftRight(int channel,bool is_left,bool is_right) {
	is_stereo_left_[channel]=is_left;
	is_stereo_right_[channel]=is_right;
}

bool bbcSound::IsRecording() {
	return is_recording_;
}

void bbcSound::StartRecording() {
	is_recording_=true;
	recorded_writes_.clear();
}

void bbcSound::StopRecording() {
	is_recording_=false;
}

void bbcSound::GetRecordedVgmData(std::vector<t65::byte> *vgm_data) {
	struct VgmHeader {
		char id[4];
		size_t end_offset;
		unsigned version;
		unsigned psg_speed;
		unsigned fm_speed;
		unsigned gd3_offset;
		unsigned num_samples;
		unsigned loop_offset;
		unsigned samples_per_loop;
		unsigned frame_rate;
	};

	BASSERT(vgm_data);
	vgm_data->clear();
	//INit header
	VgmHeader hdr;
	hdr.end_offset=0;//vgm_data_size-4;
	hdr.fm_speed=0;
	hdr.frame_rate=50;
	hdr.gd3_offset=0;
	hdr.id[0]='V';
	hdr.id[1]='g';
	hdr.id[2]='m';
	hdr.id[3]=' ';
	hdr.loop_offset=0;
	hdr.num_samples=0;//TBD
	hdr.psg_speed=4000000;
	hdr.samples_per_loop=0;
	hdr.version=0x101;
	
	//Will probably need 5 bytes per write -- 2 bytes for the write, and 3
	//bytes for the following pause.
	//Also 0x40 for the header.
	vgm_data->resize(0x40+recorded_writes_.size()*5,0);
	std::deque<SoundWriteEntry>::const_iterator write;
	bool first_write=true;
	int last_cycles;
	for(write=recorded_writes_.begin();write!=recorded_writes_.end();++write) {
		//If there was a previous one, we'll need a pause.
		if(!first_write) {
			//0x61 0xCD 0xAB (pause for 0xABCD samples [44100Hz])
			BASSERT(write->cycles-last_cycles>0);
			int wait_samples=int(((write->cycles-last_cycles)/250000.f)*44100.f);
			hdr.num_samples+=wait_samples;
			while(wait_samples>0) {
				vgm_data->push_back(0x61);
				vgm_data->push_back(wait_samples&0xff);
				vgm_data->push_back(wait_samples>>8);
				wait_samples-=65536;
			}
		}
		first_write=false;
		last_cycles=write->cycles;

		//Save this register write
		vgm_data->push_back(0x50);
		vgm_data->push_back(write->val);
	}
	vgm_data->push_back(0x66);
	hdr.end_offset=vgm_data->size()-4;
	memcpy(&vgm_data->at(0),&hdr,sizeof hdr);
}
