#ifndef bbcROMSLOT_H_
#define bbcROMSLOT_H_

#include "bbcCommon.h"
#include <algorithm>

struct bbcRomSlot {
	bbcRomSlot();
	void GetPages(t65::byte **read_pages,t65::byte **write_pages) const;
	//This is just for B+ mode.
	void GetTop4kPages(t65::byte **read_pages,t65::byte **write_pages) const;
	void ResetContents();
	void SetContents(const t65::byte *src,unsigned num_bytes);
	void SetWriteable(bool is_writeable);
	void WriteByte(t65::word offset,t65::byte val);
private:
	void ResetPages();
	t65::byte *read_pages_[64];
	t65::byte *write_pages_[64];
	bool is_writeable_;
	t65::byte contents_[16384];
	static t65::byte dummy_page[256];//where writes to non-writeable ROMs go.
};

inline void bbcRomSlot::GetPages(t65::byte **read_pages,t65::byte **write_pages) const {
	std::copy(read_pages_,read_pages_+64,read_pages);
	std::copy(write_pages_,write_pages_+64,write_pages);
}

inline void bbcRomSlot::GetTop4kPages(t65::byte **read_pages,t65::byte **write_pages)
	const
{
	std::copy(read_pages_+48,read_pages_+64,read_pages);
	std::copy(write_pages_+48,write_pages_+64,write_pages);
}

inline void bbcRomSlot::SetWriteable(bool is_writeable) {
	is_writeable_=is_writeable;
	this->ResetPages();
}

inline void bbcRomSlot::WriteByte(t65::word offset,t65::byte val) {
	BASSERT(offset<16384);
	contents_[offset]=val;
}

#endif
