#ifndef bbcMODELB_H_
#define bbcMODELB_H_

//
//bbcModelB is one of the Beeb models
//
//each model "X" has 4 classes:
//
//bbcXConfig
//bbcXCpu
//bbcXInstructionSet
//bbcXSim
//bbcX -- derived from bbcModel, just has functions.

//The ram_ memory map is as follows:
//
//	+0x00000	BBC RAM
//	+0x08000	Unused
//	+0x20000	END

#include "bbcSY6502A.h"
#include "bbcModel.h"
#include "bbcModelBConfig.h"

typedef bbcSY6502A<bbcModelBConfig> bbcModelBCpu;
typedef bbcSY6502AInstructionSet<bbcModelBCpu> bbcModelBInstructionSet;
typedef t65::Sim6502<bbcModelBCpu,bbcModelBInstructionSet> bbcModelBSim;

typedef bbcModelGeneric<bbcModelBSim> bbcModelB;

#endif
