#ifndef bbcKEYS_H_
#define bbcKEYS_H_

#include <string>

enum bbcKey {
	bbcKEY_SPACE=0x62,
	bbcKEY_COMMA=0x66,
	bbcKEY_MINUS=0x17,
	bbcKEY_STOP=0x67,
	bbcKEY_SLASH=0x68,
	bbcKEY_0=0x27,
	bbcKEY_1=0x30,
	bbcKEY_2=0x31,
	bbcKEY_3=0x11,
	bbcKEY_4=0x12,
	bbcKEY_5=0x13,
	bbcKEY_6=0x34,
	bbcKEY_7=0x24,
	bbcKEY_8=0x15,
	bbcKEY_9=0x26,
	bbcKEY_COLON=0x48,
	bbcKEY_SEMICOLON=0x57,
	bbcKEY_AT=0x47,
	bbcKEY_A=0x41,
	bbcKEY_B=0x64,
	bbcKEY_C=0x52,
	bbcKEY_D=0x32,
	bbcKEY_E=0x22,
	bbcKEY_F=0x43,
	bbcKEY_G=0x53,
	bbcKEY_H=0x54,
	bbcKEY_I=0x25,
	bbcKEY_J=0x45,
	bbcKEY_K=0x46,
	bbcKEY_L=0x56,
	bbcKEY_M=0x65,
	bbcKEY_N=0x55,
	bbcKEY_O=0x36,
	bbcKEY_P=0x37,
	bbcKEY_Q=0x10,
	bbcKEY_R=0x33,
	bbcKEY_S=0x51,
	bbcKEY_T=0x23,
	bbcKEY_U=0x35,
	bbcKEY_V=0x63,
	bbcKEY_W=0x21,
	bbcKEY_X=0x42,
	bbcKEY_Y=0x44,
	bbcKEY_Z=0x61,
	bbcKEY_LSQBRACKET=0x38,
	bbcKEY_BACKSLASH=0x78,
	bbcKEY_RSQBRACKET=0x58,
	bbcKEY_TILDE=0x18,
	bbcKEY_UNDERLINE=0x28,
	bbcKEY_ESCAPE=0x70,
	bbcKEY_TAB=0x60,
	bbcKEY_CAPSLOCK=0x40,
	bbcKEY_CTRL=0x1,
	bbcKEY_SHIFTLOCK=0x50,
	bbcKEY_SHIFT=0x0,
	bbcKEY_DELETE=0x59,
	bbcKEY_COPY=0x69,
	bbcKEY_RETURN=0x49,
	bbcKEY_UP=0x39,
	bbcKEY_DOWN=0x29,
	bbcKEY_LEFT=0x19,
	bbcKEY_RIGHT=0x79,
	bbcKEY_F0=0x20,
	bbcKEY_F1=0x71,
	bbcKEY_F2=0x72,
	bbcKEY_F3=0x73,
	bbcKEY_F4=0x14,
	bbcKEY_F5=0x74,
	bbcKEY_F6=0x75,
	bbcKEY_F7=0x16,
	bbcKEY_F8=0x76,
	bbcKEY_F9=0x77,
	//Keyboard links
	bbcKEY_KEYLINKS=0x2,

	//Special keys have their top bit set.
	// These are special keys,
//	bbcKEY_QUICKQUIT=0x80,
//	bbcKEY_REDRAW=0xFC,
//	bbcKEY_CONTROL=0xFD,
	bbcKEY_BREAK=0x80,

	//Start system-specific ones from here!
	bbcKEY_HOST_KEYS_START,

	//Special.
	bbcKEY_NONE=0xFF,
};

bbcKey bbcCodeFromKeyName(const char *name);
const char *bbcKeyNameFromCode(bbcKey code);

#endif
