#include "pch.h"
#include "bbcFdd.h"
#include <vector>
#include <algorithm>

#define DISC_HEXDUMP

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////
//
bbcDiscSide *bbcFdd::drives[bbcFdd::num_drives]={0,};

const int bbcFdd::other_side_of[num_drives]={
	2,
	3,
	0,
	1,
};

//////////////////////////////////////////////////////////////////////////
// Sector on a disc
struct bbcDiscSector {
	std::vector<t65::byte> data;
};

//////////////////////////////////////////////////////////////////////////
// Track on a disc
struct bbcDiscTrack {
	std::vector<bbcDiscSector> sectors;
};

//////////////////////////////////////////////////////////////////////////
// Side on a disc
struct bbcDiscSide {
	bool is_side2,changed;
	std::vector<bbcDiscTrack> tracks;

	bbcDiscSide();
};

bbcDiscSide::bbcDiscSide():
is_side2(false),
changed(false)
{
}

/*
bool BeebDiscImage::GetImage(std::vector<t65::byte> &contents) const {
	//How many tracks? (PITA)
	unsigned ntracks=std::_cpp_max(this->sides[0]?this->sides[0]->tracks.size():0,
		this->sides[1]?this->sides[1]->tracks.size():0);
	if(ntracks==0) {
		return false;
	}

	contents.clear();
	for(unsigned i=0;i<ntracks;++i) {
		for(unsigned j=0;j<2;++j) {
			const BeebDiscSide *side=this->sides[j];
			if(side) {
				if(i<side->tracks.size()) {
					const BeebDiscTrack *track=&side->tracks.at(i);
					for(unsigned k=0;k<track->sectors.size();++k) {
						const BeebDiscSector *sector=&track->sectors.at(k);
						std::copy(sector->data.begin(),sector->data.end(),std::back_inserter(contents));
					}
				} else {
					//Unformatted/not-present track...
					std::fill_n(std::back_inserter(contents),256,0xE5);
				}
			}
		}
	}
	return true;
}
*/

/*
//////////////////////////////////////////////////////////////////////////
//
static void DumpBytes(FILE *h,const std::vector<t65::byte> &data) {
	for(unsigned i=0;i<data.size();i+=16) {
		unsigned j;
		char ascii[17];
		char hex[49];

		memset(ascii,0,sizeof ascii);
		memset(hex,0,sizeof hex);
		for(j=0;j<16;++j) {
			bool ok=i+j<data.size();
			if(!ok) {
				strncpy(&hex[j*3],"   ",3);//3 spaces
				ascii[j]=' ';
			} else {
				t65::byte b=data.at(i+j);
				sprintf(&hex[j*3],"%02X ",b);
				ascii[j]=b>=32&&b<=126?char(b):'.';
			}
		}
		fprintf(h,"%04X: %s %s\n",i,hex,ascii);
	}
}

static void DumpDiscImage(BeebDiscImage *di,const char *name) {
	FILE *h=fopen(name,"wt");
	if(!h) {
		return;
	}
	for(unsigned side=0;side<2;++side) {
		if(!di->sides[side]) {
			fprintf(h,"Side %u not present\n",side);
		} else {
			for(unsigned t=0;t<di->sides[side]->tracks.size();++t) {
				for(unsigned sec=0;sec<di->sides[side]->tracks.at(t).sectors.size();++sec) {
					fprintf(h,"side %u track %u sector %d:\n",side,t,sec);
					DumpBytes(h,di->sides[side]->tracks.at(t).sectors.at(sec).data);
					fprintf(h,"\n");
				}
			}
		}
	}
	fclose(h);
}
*/

//////////////////////////////////////////////////////////////////////////
// Initialises the disc drives stuff
void bbcFdd::Init() {
	for(unsigned i=0;i<num_drives;++i) {
		drives[i]=0;
	}
}

//////////////////////////////////////////////////////////////////////////
// Shuts down drive stuff
void bbcFdd::Shutdown() {
	for(unsigned i=0;i<num_drives;++i) {
		delete drives[i];
		drives[i]=0;
	}
}

//////////////////////////////////////////////////////////////////////////
// Load disc image into the specified drives.
// TODO only SSD supported at the mo'.

bool bbcFdd::LoadDsDiscImage(int drive,int sectors_per_track,
	const std::vector<t65::byte> &disc_image)
{
	bool ok;
	int side2drive=other_side_of[drive];

	ok=LoadDiscSide(drive,sectors_per_track,0,sectors_per_track*256*2,disc_image);
	ok=ok&&LoadDiscSide(side2drive,sectors_per_track,sectors_per_track*256,
		sectors_per_track*256*2,disc_image);
	if(ok) {
		drives[side2drive]->is_side2=true;
	}
	return ok;
}

bool bbcFdd::LoadSsDiscImage(int drive,int sectors_per_track,
	const std::vector<t65::byte> &disc_image)
{
	bool ok=LoadDiscSide(drive,sectors_per_track,0,sectors_per_track*256,disc_image);
	return ok;
}

bool bbcFdd::LoadDiscSide(int drive,int sectors_per_track,
	unsigned start,unsigned track_size,const std::vector<t65::byte> &side_image)
{
	unsigned i,j;
	BASSERT(DriveStatus(drive)==DRIVE_EMPTY);
	BASSERT(sectors_per_track==10||sectors_per_track==16||sectors_per_track==18);
	if(side_image.size()%256!=0) {
		fprintf(stderr,"image is not multiple of 256 bytes in length\n");
		return false;
	}

	//Basic disc geometry setup
	bbcDiscSide *side=new bbcDiscSide;
	side->tracks.resize(80);
	for(j=0;j<side->tracks.size();++j) {
		bbcDiscTrack *track=&side->tracks.at(j);
		track->sectors.resize(sectors_per_track);
		for(unsigned k=0;k<track->sectors.size();++k) {
			track->sectors.at(k).data.resize(256);
		}
	}
	
	//Read the data
	int src=0;
	for(int track=0;track<side->tracks.size()&&src<side_image.size();++track) {
		src=start+track*track_size;
		for(int sector=0;sector<sectors_per_track&&src<side_image.size();++sector) {
			for(i=0;i<256;++i) {
				side->tracks[track].sectors[sector].data[i]=side_image.at(src);
				++src;
			}
		}
	}
	drives[drive]=side;

	return true;
}

//////////////////////////////////////////////////////////////////////////
//
bbcFdd::DriveStatusType bbcFdd::DriveStatus(int drive) {
	if(!drives[drive]) {
		return DRIVE_EMPTY;
	}
	if(drives[drive]->is_side2) {
		BASSERT(!drives[other_side_of[drive]]->is_side2);
		return DRIVE_SIDE2;//use other_side_of for true status!
	}
	if(drives[drive]->changed) {
		return DRIVE_CHANGED;
	}
	return DRIVE_LOADED;
}

void bbcFdd::UnloadDiscImage(int drive) {
	if(drives[drive]) {
		bbcDiscSide **other=&drives[other_side_of[drive]];
		if(*other&&(*other)->is_side2) {
			//joined
			delete *other;
			*other=0;
		}
		delete drives[drive];
		drives[drive]=0;
	}
}

void bbcFdd::SetDriveChangedStatus(int drive,bool changed) {
	BASSERT(drives[drive]);
	if(drives[drive]->is_side2) {
		BASSERT(drives[other_side_of[drive]]);
		drives[other_side_of[drive]]->changed=changed;
	} else {
		drives[drive]->changed=changed;
	}
}

int bbcFdd::DriveFromFdcAddress(int fdc_drive,int fdc_side) {
	BASSERT(fdc_drive==0||fdc_drive==1);
	BASSERT(fdc_side==0||fdc_side==1);
	
	int drive=fdc_drive;
	if(fdc_side==1) {
		drive=other_side_of[drive];
	}
	return drive;
}

bool bbcFdd::GetByteFdc(int fdc_drive,int fdc_side,int fdc_track,
	int fdc_sector,int fdc_offset,t65::byte *result)
{
	t65::byte *ptr=FdcBytePtr(fdc_drive,fdc_side,fdc_track,fdc_sector,fdc_offset);
	if(!ptr) {
		return false;
	}
	*result=*ptr;
	return true;
}

bool bbcFdd::SetByteFdc(int fdc_drive,int fdc_side,int fdc_track,
	int fdc_sector,int fdc_offset,t65::byte value)
{
	t65::byte *ptr=FdcBytePtr(fdc_drive,fdc_side,fdc_track,fdc_sector,fdc_offset);
	if(!ptr) {
		return false;
	}
	*ptr=value;
	SetDriveChangedStatus(DriveFromFdcAddress(fdc_drive,fdc_side),true);
	return true;
}

t65::byte *bbcFdd::FdcBytePtr(int fdc_drive,int fdc_side,int fdc_track,
	int fdc_sector,int fdc_offset)
{
	int drive=DriveFromFdcAddress(fdc_drive,fdc_side);
	bbcDiscSide *side=drives[drive];
	if(!side) {
		return 0;
	}
	if(fdc_track<0||unsigned(fdc_track)>=side->tracks.size()) {
		return 0;
	}
	bbcDiscTrack *track=&side->tracks[fdc_track];
	if(fdc_sector<0||unsigned(fdc_sector)>=track->sectors.size()) {
		return 0;
	}
	bbcDiscSector *sector=&track->sectors[fdc_sector];
	if(fdc_offset<0||unsigned(fdc_offset)>=sector->data.size())
	{
		return 0;
	}
	return &sector->data[fdc_offset];
}

bool bbcFdd::IsOkAddressFdc(int fdc_drive,int fdc_side,int fdc_track,
	int fdc_sector)
{
	t65::byte *p=FdcBytePtr(fdc_drive,fdc_side,fdc_track,fdc_sector,0);
	return !!p;
}

bool bbcFdd::IsDs(int drive) {
	int other=other_side_of[drive];
	return drives[other]&&drives[other]->is_side2;
}

bool bbcFdd::GetSsDiscImage(int drive,std::vector<t65::byte> *disc_image) {
	BASSERT(disc_image);
	BASSERT(drives[drive]);

	disc_image->reserve(80*18*256);//max possible.
	const bbcDiscSide *side=drives[drive];
	for(unsigned i=0;i<side->tracks.size();++i) {
		const bbcDiscTrack *track=&side->tracks[i];
		for(unsigned j=0;j<track->sectors.size();++j) {
			const bbcDiscSector *sector=&track->sectors[j];
			std::copy(sector->data.begin(),sector->data.end(),
				std::back_inserter(*disc_image));
		}
	}
	return true;
}

bool bbcFdd::GetDsDiscImage(int top,int bot,std::vector<t65::byte> *disc_image) {
	std::vector<t65::byte> topside;
	std::vector<t65::byte> botside;

	if(!GetSsDiscImage(top,&topside)||!GetSsDiscImage(bot,&botside)) {
		return false;
	}
	if(topside.size()!=botside.size()) {
		//can't happen now, but will remind me when I put DD stuff in.
		BASSERT(false);
		return false;
	}
	//can assume 80 tracks 10 sectors 256 bytes
	disc_image->clear();
	for(int i=0;i<80;++i) {
		//top side
		std::copy(&topside[i*2560],&topside[(i+1)*2560],
			std::back_inserter(*disc_image));
		std::copy(&botside[i*2560],&botside[(i+1)*2560],
			std::back_inserter(*disc_image));
	}
	return true;
}
