#include "pch.h"
#ifdef bbcDEBUG_TRACE
#include "bbcDebugTrace.h"
#include "bbcComputer.h"

bbcDebugTrace::bbcDebugTrace() {
}

bbcDebugTrace::~bbcDebugTrace() {
}

bbcDebugTrace::Ent *bbcDebugTrace::NewEnt(Type type) {
	Ent *ent=&*ents_.insert(ents_.end(),Ent());
	ent->type=type;
	ent->cycles=bbcComputer::cycles;
	ent->next_stop=bbcComputer::next_stop;
	return ent;
}

bool bbcDebugTrace::WriteTrace(FILE *out,ProgressFn progress_fn,void *context) const {
	int hundredth=ents_.size()/100;
	int n=0;
	std::deque<Ent>::const_iterator ent;
	for(ent=ents_.begin();ent!=ents_.end();++ent) {
		const bbcDebugTrace::Irq *irq=&ent->irq;
		const bbcDebugTrace::Instr *ins=&ent->instr;
		
		
		if(progress_fn&&n%hundredth==0) {
			if(!(*progress_fn)(n/hundredth,context)) {
				//Cancelled
				return false;
			}
		}
		++n;
		int left_margin=fprintf(out,"%-9d (@%-9d) ",ent->cycles,ent->next_stop);
		switch(ent->type) {
		default:
			BASSERT(false);
			fprintf(out,"unknown entry type %d (shouldn't ever see this)\n",
				ent->type);
			break;
		case bbcDebugTrace::ENT_IRQ:
			fprintf(out,"flags 0x%X.\n",irq->irqflags);
			fprintf(out,"%-*sSysVIA: IER=&%02X IFR=&%02X ACR=&%02X\n",
				left_margin,"",irq->sys.ier,irq->sys.ifr,irq->sys.acr);
			fprintf(out,"%-*sUsrVIA: IER=&%02X IFR=&%02X ACR=&%02X\n",
				left_margin,"",irq->usr.ier,irq->usr.ifr,irq->usr.acr);
			fprintf(out,"%-*s1770  : Status=&%02X\n",
				left_margin,"",irq->fdc_status);
			break;
		case bbcDebugTrace::ENT_INSTR:
			{
				char opcode_buf[10],operand_buf[15];
				int len=bbcComputer::DisassembleBytes(ins->bytes,ins->pc,opcode_buf,
					operand_buf);
				const char *nullbytes="  ";
				char bytes[3][3];
				static const char hex_digits[]="0123456789ABCDEF";
				for(int i=0;i<3;++i) {
					bytes[i][0]=hex_digits[ins->bytes[i]>>4];
					bytes[i][1]=hex_digits[ins->bytes[i]&0xf];
					bytes[i][2]=0;
				}
				
				fprintf(out,"%04X: %-5s %-10s %s %s %s -> A:%02X X:%02X Y:%02X S:%02X P:%c%c%c%c%c%c%c%c\n",
					ins->pc.w,opcode_buf,operand_buf,
					len>0?bytes[0]:nullbytes,
					len>1?bytes[1]:nullbytes,
					len>2?bytes[2]:nullbytes,
					ins->a,ins->x,ins->y,ins->s,
					ins->p&t65::N_MASK?'N':'-',
					ins->p&t65::V_MASK?'V':'-',
					ins->p&t65::U_MASK?'-':'-',
					ins->p&t65::B_MASK?'B':'-',
					ins->p&t65::D_MASK?'D':'-',
					ins->p&t65::I_MASK?'I':'-',
					ins->p&t65::Z_MASK?'Z':'-',
					ins->p&t65::C_MASK?'C':'-');
			}
			break;
		}
	}
	return true;
}

#endif//bbcDEBUG_TRACE
