#ifndef COMMON_H_
#define COMMON_H_

#include <t65.h>

#ifdef _DEBUG
#define BASSERT(X) do{if(!(X)){_asm {int 3}}}while(false)
#else
#define BASSERT(X)
#endif

//using t65::byte;
//using t65::word;
//using t65::Word;

//////////////////////////////////////////////////////////////////////////
//If defined, sync clocks on VIA access only
//Otherwise, anywhere in Sheila (not sure which is right)
//#define BBC_SYNCCLOCKS_VIA_ONLY

//Sync clocks for access to JIM and FRED
#define BBC_SYNCCLOCKS_JIM
#define BBC_SYNCCLOCKS_FRED

static const unsigned IRQ_SYSVIA=1;
static const unsigned IRQ_USERVIA=2;
static const unsigned IRQ_NMI=0x80000000;


//////////////////////////////////////////////////////////////////////////
//If defined, do a quickstart by 'holding down SHIFT' until the disc
//drive is first accessed (which means the DFS is booting, we guess).
//Otherwise, quickstart is done by setting the keylinks so that normal
//(no shift)+BREAK does a disc boot, then resetting the keylink once
//this is done. This needs an OS hack (see bbcComputer::InstallOsHacks)
//because normally the OS doesn't reread the keylinks until Ctrl+BREAK
//which is a right pain (and also needs to be redone afresh for each
//different OS *yawn*).
#define bbcQUICKSTART_BY_SHIFT

//////////////////////////////////////////////////////////////////////////
// Beeb debug features
#ifdef _DEBUG

//Enable the debug tracingfacilities
#define bbcDEBUG_TRACE

//Enable the debug panel stuff
#define bbcDEBUG_PANELS

//Misc video debugging features:
//	Show VIA T1 timeouts
//	Show All feature
//	Frame Logging
#define bbcDEBUG_VIDEO

//If defined, use much simpler main loop. Emulator behaves the same (in theory,
//that's the point) but runs much more slowly.
//#define bbcDEBUG_MAIN_LOOP

#endif

//////////////////////////////////////////////////////////////////////////
// functions for reading and writing memory mapped i/o

typedef void (*bbcWriteMmioFn)(t65::byte offset,t65::byte value);
typedef t65::byte (*bbcReadMmioFn)(t65::byte offset);


#endif
