#ifndef FDCOPUSCHALLENGER_H_
#define FDCOPUSCHALLENGER_H_

#include "bbc1770Interface.h"
#include <vector>

struct bbc1770OpusChallenger {
public:
	static const bbc1770Interface disc_interface_256k;
	static const bbc1770Interface disc_interface_512k;
	
	static void Init256k();
	static void Init512k();
	
	static t65::byte ReadJim(t65::byte offset);
	static void WriteJim(t65::byte offset,t65::byte val);
	static t65::byte ReadPagingLsb(t65::byte);
	static void WritePagingLsb(t65::byte,t65::byte val);
	static t65::byte ReadPagingMsb(t65::byte);
	static void WritePagingMsb(t65::byte,t65::byte val);
	static t65::byte ReadUnknownFred(t65::byte);
	static void WriteUnknownFred(t65::byte,t65::byte val);

	static void GetByteFromDriveControl(const bbc1770DriveControl &src,
		t65::byte *dest);
	static void GetDriveControlFromByte(t65::byte src,bbc1770DriveControl *dest);
	//private:
	static t65::Word paging_;
	static std::vector<t65::byte> ram_;

private:
	static int ByteIdx(t65::byte offset);
	static void InitCommon();
};

#endif
