//////////////////////////////////////////////////////////////////////////
// Opus Challenger 3in1
//
#include "pch.h"
#include "bbc1770OpusChallenger.h"
#include "bbc1770.h"

//////////////////////////////////////////////////////////////////////////
//
const bbcComputer::MmioFnInit mmio_fns[]={
#ifdef _DEBUG
	{0xfce0,0x18,&bbc1770OpusChallenger::ReadUnknownFred,&bbc1770OpusChallenger::WriteUnknownFred},
	{0xfcfd,1,&bbc1770OpusChallenger::ReadUnknownFred,&bbc1770OpusChallenger::WriteUnknownFred},
#endif
	{0xfcfe,1,&bbc1770OpusChallenger::ReadPagingMsb,&bbc1770OpusChallenger::WritePagingMsb,},
	{0xfcff,1,&bbc1770OpusChallenger::ReadPagingLsb,&bbc1770OpusChallenger::WritePagingLsb,},
	{0xfd00,256,&bbc1770OpusChallenger::ReadJim,&bbc1770OpusChallenger::WriteJim},
	{0,0,0,0,},
};

const bbc1770Interface bbc1770OpusChallenger::disc_interface_256k={
	"Opus CHALLENGER 256K",
	0xfcf8,
	0xfcfc,
	&bbc1770OpusChallenger::GetDriveControlFromByte,
	&bbc1770OpusChallenger::GetByteFromDriveControl,
	&bbc1770OpusChallenger::Init256k,
	bbc1770Interface::DISABLE_RESTORE_IRQ,//disable_restore_irq,
	mmio_fns,
};

const bbc1770Interface bbc1770OpusChallenger::disc_interface_512k={
	"Opus CHALLENGER 512K",
	0xfcf8,
	0xfcfc,
	&bbc1770OpusChallenger::GetDriveControlFromByte,
	&bbc1770OpusChallenger::GetByteFromDriveControl,
	&bbc1770OpusChallenger::Init512k,
	bbc1770Interface::DISABLE_RESTORE_IRQ,//disable_restore_irq,
	mmio_fns,
};

t65::Word bbc1770OpusChallenger::paging_;
std::vector<t65::byte> bbc1770OpusChallenger::ram_;

void bbc1770OpusChallenger::Init256k() {
	ram_.resize(262144,0);
	InitCommon();
}

void bbc1770OpusChallenger::Init512k() {
	ram_.resize(524288,0);
	InitCommon();
}

void bbc1770OpusChallenger::InitCommon() {
	paging_.l=0;
	paging_.h=0;
}

t65::byte bbc1770OpusChallenger::ReadJim(t65::byte offset) {
	unsigned idx=(paging_.w<<8)|offset;
	if(idx<ram_.size()) {
		return ram_[idx];
	} else {
		return 0xFF;
	}
}

void bbc1770OpusChallenger::WriteJim(t65::byte offset,t65::byte val) {
	unsigned idx=(paging_.w<<8)|offset;
	if(idx<ram_.size()) {
		ram_[idx]=val;
	}
}

t65::byte bbc1770OpusChallenger::ReadPagingLsb(t65::byte) {
	return paging_.l;
}

void bbc1770OpusChallenger::WritePagingLsb(t65::byte,t65::byte val) {
	paging_.l=val;
}

t65::byte bbc1770OpusChallenger::ReadPagingMsb(t65::byte) {
	return paging_.h;
}

void bbc1770OpusChallenger::WritePagingMsb(t65::byte,t65::byte val) {
	paging_.h=val;
}

t65::byte bbc1770OpusChallenger::ReadUnknownFred(t65::byte offset) {
	printf("bbc1770OpusChallenger::ReadUnknownFred: offset=%02X\n",offset);
	return 0xFF;
}

void bbc1770OpusChallenger::WriteUnknownFred(t65::byte offset,t65::byte val) {
	printf("bbc1770OpusChallenger::WriteUnknownFred: offset=%02X val=%02X\n",offset,val);
}

//////////////////////////////////////////////////////////////////////////
//
// Drive control format guessed as:
//
// Bit
//	7 0x80
//	6 0x40
//	5 0x20  Unknown (always set?)
//	4 0x10  Density select -- 0=double 1=single (guessed using *FORMAT)
//	3 0x08
//	2 0x04	Select drive 1 (external)
//	1 0x02	Select drive 0 (internal to Challenger)
//	0 0x01	Physical side -- 0=0, 1=1
void bbc1770OpusChallenger::GetByteFromDriveControl(const bbc1770DriveControl &src,
	t65::byte *dest)
{
	//Seems to be write only on the Beeb...
	*dest=0xff;
}

void bbc1770OpusChallenger::GetDriveControlFromByte(t65::byte src,
	bbc1770DriveControl *dest)
{
	dest->drive=0;//TODO should be -ve for 'none selected'
	if(src&2) {
		dest->drive=0;
	} else if(src&4) {
		dest->drive=1;
	}
	dest->side=src&1;
	dest->is_double_density=!(src&0x20);
	dest->disable_irq=false;
}
