#include "pch.h"
#include "bbc1770.h"
#include "bbc1770Interface.h"

bbcComputer::MmioFnInit MkMmioFnInit(t65::word start,unsigned count,
	bbcReadMmioFn read_fn,bbcWriteMmioFn write_fn)
{
	bbcComputer::MmioFnInit fn_init;

	fn_init.start=start;
	fn_init.count=count;
	fn_init.read_fn=read_fn;
	fn_init.write_fn=write_fn;
	return fn_init;
}

bbc1770Interface2::bbc1770Interface2(t65::word fdc_base,t65::word fdc_control):
fdc_base_(fdc_base),
fdc_control_(fdc_control)
{
}

void bbc1770Interface2::GetMmioFnInits(std::vector<bbcComputer::MmioFnInit> *fn_inits)
{
	BASSERT(fn_inits);
	fn_inits->push_back(MkMmioFnInit(fdc_base_,4,&bbc1770::ReadFdc,
		&bbc1770::WriteFdc));
	fn_inits->push_back(MkMmioFnInit(fdc_control_,1,&bbc1770::ReadControl,
		&bbc1770::WriteControl));
}
