/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "gui.h"
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "gfx.h"
#include "file.h"
#include "uef.h"
#include "snapshot.h"

#include "tape.h"
extern C_Tape tape;

#include "wd1770.h"
extern C_WD1770 disk;

extern C_gfx_api gfxdrvr;
char *cdir, *truename;
struct filetree *sel, *tree;
int firstfile, entries;

gui_messages gui_output_list(gui_messages message, int x, int y, gui_element *owner);
gui_messages gui_claim_draw_rect(gui_messages message, int x, int y, gui_element *owner);
gui_messages gui_button(gui_messages message, int x, int y, gui_element *owner);
void finish_load(void);
void finish_load_quit(void);

gui_element loadscreen[] =
{
	{0, FONT_H+3, 640, 511, 0, gui_draw_rect},

	{322, 511-((int)(FONT_H*2.5))-7, 639, 511-((int)(FONT_H*1.5))-1, 160, gui_button, "Okay", finish_load},
	{322, 511-FONT_H-6, 639, 511, 160, gui_button, "Okay & Back", finish_load_quit},
	{0, (int)(FONT_H*1.5), 639, (int)(FONT_H*2.5), 184, gui_centre_string, "Load UEF"},

	{0, (int)(FONT_H*2.5), 320, (int)(FONT_H*3.5), 130, gui_up_arrow, &firstfile},
	{0, 511-FONT_H, 320, 511, 130, gui_down_arrow, &firstfile},

	{0, (int)(FONT_H*3.5), 320, 511-FONT_H, 0, gui_output_list},

	{321, (int)(FONT_H*4), 639, (int)(FONT_H*5), 160, gui_centre_string, "Provisionally selected :"},
	{321, (int)(FONT_H*5), 639, (int)(FONT_H*6), 176, gui_centre_string, "<none>"},

	{321, (int)(FONT_H*7), 639, (int)(FONT_H*8), 160, gui_centre_string, ""},
	{321, (int)(FONT_H*8), 639, (int)(FONT_H*9), 160, gui_centre_string, ""},

	{0, 0, 0, 0, 0, NULL}
};

#define NAME_POS 8
#define DESC1_POS 9
#define DESC2_POS 10

#include "config.h"
extern C_config settings;

void seed_cdir(void)
{
	char *temp;

	if(!settings.FindSetting("startdir"))
		cdir = strdup("/");
	else
	{
		temp = settings.ReadSetting().result_string;

		if(valid_path(temp))
			cdir = strdup(temp);
		else
			cdir = strdup("/");
	}

	tree = NULL;
	truename = NULL;
}

void kill_cdir(void)
{
	config_setting cfg;
	cfg.result_type = STRING_RESULT;
	cfg.result_string = strdup(cdir);

	settings.FindSetting("startdir");
	settings.WriteSetting(cfg);

	free(cdir);
}

void finish_load(void)
{
	if(sel)
	{
		if(entries&1)
			tape.Open(truename);

		if(entries&2)
			disk.Open(truename);

		if(entries&4)
			LoadSnapshot(truename);
	}

	free_filetree(tree); tree = NULL;
	if(truename) free(truename); truename = NULL;
	set_default_behind();
}

void finish_load_quit(void)
{
	done = true;
	finish_load();
}

char *uefnames[] =
{
	"uef", ""
};

void seed_list(void)
{
	free_filetree(tree);
	tree = get_filetree(cdir, uefnames);
	sel = NULL;
	firstfile = 0;
	if(truename) free(truename); truename = NULL;
	loadscreen[NAME_POS].data = "<none>";
	loadscreen[DESC1_POS].data = "";
	loadscreen[DESC2_POS].data = "";
}

gui_messages gui_output_list(gui_messages message, int x, int y, gui_element *owner)
{
	switch(message)
	{
		case GUIMSG_DRAW :
			unsigned int ypos, y2;
			int c, low;
			struct filetree *trav;

			ypos = owner->y1;
			gfxdrvr.Rectangle(owner->x1, owner->y1, owner->x2, owner->y2, 0);

			trav = tree;
			c = 0;
			while(trav)
			{
				c++;
				trav = trav->next;
			}

			if(firstfile < 0)
				firstfile = 0;

			low = c - ((owner->y2 - owner->y1) / FONT_H);
			if(low < 0)
				low = 0;

			if(firstfile > low)
				firstfile = low;

			trav = tree;
			c = firstfile;
			while(trav && c--)
			{
				trav = trav->next;
			}

			while(trav && ypos < owner->y2)
			{
				y2 = ypos + FONT_H;
				if(y2 > owner->y2)
					y2 = owner->y2;
				gfxdrvr.SetTextArea(owner->x1, ypos, owner->x2, y2);
				gfxdrvr.WriteString(trav->fname, 2, ypos, trav->dir ? 160 : 176);
				trav = trav->next;
				ypos += FONT_H;
			}

		return GUIMSG_NONE;

		case GUIMSG_LCLICK :
			int selnum;
			char *temp;
			C_UEF test;

			selnum = ((y - owner->y1) / FONT_H) + firstfile;

			sel = tree;
			while(sel && selnum--)
			{
				sel = sel->next;
			}

			if(sel)
			{
				if(sel->dir)
				{
					if(!strcmp(cdir, "/"))
						sprintf(cdir, "");
					else
					{
						temp = cdir + strlen(cdir) - 1;
						*temp = '\0';
					}

					temp = (char *)malloc(strlen(cdir)+3+strlen(sel->fname));

					sprintf(temp, "%s/%s/", cdir, sel->fname);

					free(cdir);
					cdir = temp;

					temp = cdir + strlen(cdir);
					if(temp-cdir > 2)
					{
						temp -= 2;

						if(*temp == '.')
						{
							while(*temp == '.')
								temp--;
							temp--;
							while(*temp != '/')
								temp--;
							*(temp+1) = '\0';
						}
					}

					seed_list();
				}
				else
				{
					loadscreen[NAME_POS].data = sel->fname;

					if(truename) free(truename); truename = NULL;
					truename = (char *)malloc(strlen(cdir) + strlen(sel->fname) + 1);
					sprintf(truename, "%s%s", cdir, sel->fname);

					entries = 0;

					if(!test.Open(truename, "r", 5, 0))
					{
						if(test.FindIdMajor(0x01))
							entries |= 1;

						if(test.FindIdMajor(0x02))
							entries |= 2;

						if(test.FindIdMajor(0x04))
							entries |= 4;

						switch(entries)
						{
							case 0 : //not a disk or tape
								loadscreen[DESC1_POS].data = "Appears to contain no";
								loadscreen[DESC2_POS].data = "useful data";
							break;

							case 1 : //a tape
								loadscreen[DESC1_POS].data = "Appears to be a tape image";
								loadscreen[DESC2_POS].data = "";
							break;

							case 2 : //a disk
								loadscreen[DESC1_POS].data = "Appears to be a disc image";
								loadscreen[DESC2_POS].data = "";
							break;

							case 3 : //could be either
								loadscreen[DESC1_POS].data = "Appears to contain both";
								loadscreen[DESC2_POS].data = "disc and tape images";
							break;

							case 4 : //a state snapshot
								loadscreen[DESC1_POS].data = "Appears to be a state snapshot";
								loadscreen[DESC2_POS].data = "";
							break;

							case 5 : //a state snapshot + tape
								loadscreen[DESC1_POS].data = "Appears to contain both";
								loadscreen[DESC2_POS].data = "a state snaphot & tape image";
							break;

							case 6 : //a state snapshot + disk
								loadscreen[DESC1_POS].data = "Appears to contain both";
								loadscreen[DESC2_POS].data = "a state snaphot & disk image";
							break;

							case 7 : //all three
								loadscreen[DESC1_POS].data = "Appears to be a state snapshot,";
								loadscreen[DESC2_POS].data = "disk & tape image";
							break;
						}

						test.Close();
					}
					else
					{
							loadscreen[DESC1_POS].data = "Appears not to be a suitable";
							loadscreen[DESC2_POS].data = "UEF of any type";
					}

				}

				return GUIMSG_REDRAW;
			}
		return GUIMSG_NONE;
	}

	return GUIMSG_NONE;
}

void load_uef(void)
{
	kill_front();
	elements[0] = loadscreen;
	seed_list();
}
