/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "gfx.h"
#include "uef.h"
#include <string.h>
#include <malloc.h>

void C_gfx_api::SetTextArea(int x1, int y1, int x2, int y2)
{
	TextArea.top = y1;
	TextArea.bottom = y2;
	TextArea.left = x1;
	TextArea.right = x2;
}

int C_gfx_api::WriteChar(char letter, int x, int y, int cbase) //returns width of letter
{
	int h, c, xc, xp;
	unsigned char *line, *write;
	#ifdef TARGET_ALLEGRO
	unsigned long vptr;
	#endif

	if(letter >= charstart && letter <= charend)
	{
		letter -= charstart;
		h = y;
		c = chars[letter].h;
		line = chars[letter].data;

		#ifdef TARGET_ALLEGRO
		bmp_select(backupscr);
		while(c--)
		{
			xc = chars[letter].w;
			if(h >= TextArea.top && h < TextArea.bottom)
			{
				vptr = bmp_write_line(backupscr, h);

				xp = x;
				while((xp < TextArea.right) && xc)
				{
					bmp_write8(vptr+xp, (*line)+cbase);
					xc--;
					xp++;
					line++;
				}

				bmp_unwrite_line(backupscr);
			}
			line += xc;
			h++;
		}
		#endif

		#if TARGET_SVGALIB || TARGET_WIN32
		while(c--)
		{
			write = (unsigned char *)&backupscr[h*scw + x];
			xc = chars[letter].w;
			xp = x;
			while(xc-- && (xp < TextArea.right))
			{
				*write++ = (*line++)+cbase;
				xp++;
			}
			line += xc+1;
			h++;
		}
		#endif

		return chars[letter].w;
	}
	else
		return 0;
}

int C_gfx_api::WriteString(char *text, int x, int y, int cbase)
{
	int ox = x;
	while(*text)
	{
		x += WriteChar(*text, x, y, cbase);
		text++;
	}

	return x - ox;
}

int C_gfx_api::StrLen(char *text)
{
	int w = 0;
	while(*text)
	{
		if( (*text >= charstart) && (*text <= charend))
			w += chars[(*text) - charstart].w;

		text++;
	}

	return w;
}

void C_gfx_api::Clean(void)
{
	#ifdef TARGET_ALLEGRO
	clear(screen);
	#endif

	#ifdef TARGET_SVGALIB
	vga_setcolor(0);
	vga_clear();
	#endif
}

void C_gfx_api::HorizLine(int x1, int y1, int x2, int colour)
{
	#if TARGET_SVGALIB || TARGET_WIN32
	memset(&backupscr[y1*scw + x1], colour, x2-x1);
	#endif

	#ifdef TARGET_ALLEGRO
	hline(backupscr, x1, y1, x2, colour);
	#endif
}

void C_gfx_api::Rectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, int colour)
{
	if(x1 < 0)
		x1 = 0;
	if(y1 < 0)
		y1 = 0;
	if(x2 >= scw)
		x2 = scw;
	if(y2 >= sch)
		y2 = sch;

	unsigned int y;

	for(y = y1; y <= y2; y++)
	{
		HorizLine(x1, y, x2, colour);
	}
}

bool C_gfx_api::LoadFont(char *name)
{
	C_UEF in;
	int c, charpos;
	char *temp;

	if(in.Open(name, "r", 5, 0))
	{
		return true;
	}

	if(in.GetId() != 0xff00)
	{
		if(!in.FindId(0xff00))
		{
			return true;
		}
	}

	temp = (char *)malloc(in.GetLength());
	in.ReadAll((unsigned char *)temp);

	if(strcmp(temp, "Kelly watch the stars"))
	{
		free(temp);
		return true;
	}

	if(!in.FindId(0xff01))
	{
		free(temp);
		return true;
	}

	free(temp);
	fonth = 0;

	charstart = 32;
	charend = 256;
	chars = (struct character *)calloc(charend-charstart, sizeof(struct character));
	charpos = 0;

	c = charend-charstart;
	while(c--)
	{
		in.ReadSome(&chars[charpos].w, 1);
		in.ReadSome(&chars[charpos].h, 1);

		if(chars[charpos].h > fonth)
			fonth = chars[charpos].h;

		chars[charpos].data = (unsigned char *)malloc(chars[charpos].w*chars[charpos].h);
		in.ReadSome(chars[charpos].data, chars[charpos].w*chars[charpos].h);
		charpos++;
	}

	#ifdef TARGET_ALLEGRO
	char *cursor;
	int mwidth, mheight;
	#endif

	unsigned char tx, ty;

	#if TARGET_SVGALIB || TARGET_ALLEGRO
	if(!in.FindId(0xff02))
		return true;

	in.ReadSome(&tx, 1);
	in.ReadSome(&ty, 1);

	mwidth = (int)tx;
	mheight = (int)ty;

	cursor = (char *)malloc(mwidth*mheight);
	in.ReadSome((unsigned char *)cursor, mwidth*mheight);
	#endif

	#ifdef TARGET_ALLEGRO
	curs = create_bitmap(mwidth, mheight);
	tx = mwidth;
	while(tx--)
	{
		ty = mheight;
		while(ty--)
		{
			putpixel(curs, tx, ty, cursor[ty*mwidth + tx]);
		}
	}
	set_mouse_sprite(curs);
	free(cursor);
	#endif

	//background logo

	#ifdef TARGET_ALLEGRO
	char *blogo;
	int lwidth, lheight, lx, ly;
	#endif

	unsigned char r, g, b;

	if(!in.FindId(0xff03))
		return true;

	in.ReadSome(&tx, 1);
	in.ReadSome(&ty, 1);

	lwidth = (int)tx | ((int)ty << 8);

	in.ReadSome(&tx, 1);
	in.ReadSome(&ty, 1);
	lheight = (int)tx | ((int)ty << 8);

	c = 32;
	while(c--)
	{
		in.ReadSome(&r, 1);
		in.ReadSome(&g, 1);
		in.ReadSome(&b, 1);
		SetPaletteEntry(32+c, (float)r/256.0f, (float)g/256.0f, (float)b/256.0f);
	}

	blogo = (char *)malloc(lwidth*lheight);
	in.ReadSome((unsigned char *)blogo, lwidth*lheight);

	c = lwidth*lheight;
	while(c--)
		blogo[c] += 32;

	#ifdef TARGET_ALLEGRO
	logo = create_bitmap(lwidth, lheight);
	ly = lheight;
	while(ly--)
	{
		lx = lwidth;
		while(lx--)
		{
			putpixel(logo, lx, ly, blogo[ly*lwidth + lx]);
		}
	}
	free(blogo);
	#endif

	in.Close();
	return false;
}
