/*

	ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

	This is open software, distributed under the GPL 2, see 'Copying' for details

	escrbig.cpp
	===========

	Draws Electron pixel scanlines, 1 pixel to 2x2 pixels at Electron 320x256

*/
#include "6502.h"
#include "elecscreen.h"
#include <string.h>
#include "tape.h"

extern C_Tape tape;
extern C_screen elec_screen;
extern C_6502ULA electron;

void C_screen_big::DrawBlankLine(void)
{
	unsigned __int32 *vptr;

	vptr = (unsigned __int32 *)img.GetLinePtr(elec_screen.line << 1);
	memset(vptr, 7, 640);
	img.ReleaseLinePtr();

	vptr = (unsigned __int32 *)img.GetLinePtr(1+(elec_screen.line<<1));
	memset(vptr, 7, 640);
	img.ReleaseLinePtr();
}

void C_screen_big::DrawPelLine(void)
{
	int p_ptr, x;
	unsigned __int32 *vptr, *vptr2;
	unsigned __int8 col;

	vptr = (unsigned __int32 *)img.GetLinePtr(elec_screen.line << 1);
	vptr2 = vptr + (img.pitch >> 2);
	p_ptr = l_ptr;

	if(c_table->wide)
	{
		electron.ram_available = electron.wide_line;
		x = 80;
		while(!(p_ptr&32768) && x--)
		{
			col = mptr[p_ptr];
			p_ptr += 8;

			*vptr2++ = *vptr++ = c_table->b_table_wide[col].l1.a;
			*vptr2++ = *vptr++ = c_table->b_table_wide[col].h1.a;
		}

		if(p_ptr&32768)
		{
			p_ptr -= c_table->pitch;
			while(x--)
			{
				col = mptr[p_ptr];
				p_ptr += 8;

				*vptr2++ = *vptr++ = c_table->b_table_wide[col].l1.a;
				*vptr2++ = *vptr++ = c_table->b_table_wide[col].h1.a;
			}
		}
	}
	else
	{
		electron.ram_available = electron.thin_line;
		x = 40;
		while(!(p_ptr&32768) && x--)
		{
			col = mptr[p_ptr];
			p_ptr += 8;

			*vptr2++ = *vptr++ = c_table->b_table_wide[col].l1.a;
			*vptr2++ = *vptr++ = c_table->b_table_wide[col].l2.a;
			*vptr2++ = *vptr++ = c_table->b_table_wide[col].h1.a;
			*vptr2++ = *vptr++ = c_table->b_table_wide[col].h2.a;
		}

		if(p_ptr&32768)
		{
			p_ptr -= c_table->pitch;
			while(x--)
			{
				col	= mptr[p_ptr];
				p_ptr += 8;

				*vptr2++ = *vptr++ = c_table->b_table_wide[col].l1.a;
				*vptr2++ = *vptr++ = c_table->b_table_wide[col].l2.a;
				*vptr2++ = *vptr++ = c_table->b_table_wide[col].h1.a;
				*vptr2++ = *vptr++ = c_table->b_table_wide[col].h2.a;
			}
		}
	}

	img.ReleaseLinePtr();
	l_ptr ++;
	elec_screen.y++;
	if(!(elec_screen.y&7))
	{
		l_ptr = p_ptr-7;
		if(c_table->spaced)
			elec_screen.blank = elec_screen.line;
	}
}

void C_screen_big::InitDisplay(void)
{
	locked = false;

//	if(!(tape.motor_on && tape.pause_display))
		if(img.BeginDraw())
		{
			locked = true;
			l_ptr = elec_screen.vid_addr.a;
			mptr = electron.GetNormalPtr(0);
			elec_screen.y = 0;
			elec_screen.blank = -3;
		}
}

void C_screen_big::EndDisplay(void)
{
	if(locked)
	{
		img.EndOperation();
		img.Blit();
	}
}

void C_screen_big::Setup(void)
{
	img.Create(*elec_screen.gfxptr, 640, 512);
}

void C_screen_big::End(void)
{
	img.Destroy();
}
