/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include "6845crtc.h"

// #define  __VSYNCERROR__ 1

#define ROWTIME 128

#define DEFAULT_VSYNC 40000

int DrawEveryXFrames=2;
int DoScanLines=0;
int SplitScanLineStartOffset=0;
int DoubleBuffering=0;
static int InterlaceTime=0;

static int DefaultVSYNCValue,VSYNCCount,VSYNCPhase,VerticalRowTimer;
// #define DEFAULT_VERTICALSYNC 40000
// 64 cycles to account for interlace alternately added to begining
// and end of screen timings.
// 128 cycles per screen row - giving 312 lines total including V blank

enum VBlankPhaseTypes { VSYNC_Blank, VSYNC_Drawing, VSYNC_VideoBlank };

#ifdef __VSYNCERROR__
static int VSYNCError;
#endif


void DoVideoStuff()
{
  static int ClearScreenCount,CurrentDisplayedCharacterRows;

  static int LastVerticalTotalInCharacters,LastVerticalSyncPosition,
             LastScanLinesInACharacterRow,LastCharacterRowsToDisplay,
             LastScreenWidthInMemoryBytes,LastLinesToSkipFromScreenTop;



    switch (VSYNCPhase)
    {
      case VSYNC_Blank : // calc the screen stuff for this draw
             
        LogicalScreen=(DWORD) LogicalScreenBase + (DWORD) LastLinesToSkipFromScreenTop*80;
        ModeXScreenStart=DefaultModeXScreenStart;
        ModeXWrap=DefaultModeXWrap;
        OldGraphicVideoMode=GraphicVideoMode;
        OldColoursChanged=ColoursChanged;

        CurrentDisplayedCharacterRows=0;
        VerticalRowTimer=LastScanLinesInACharacterRow * ROWTIME;

        VerticalSYNCTimer+=VerticalRowTimer;
        VSYNCPhase=VSYNC_Drawing;

//        IFR&=0xfd; // clear CA1 interrupt
        VSYNC_HOLD=0;
        break;


      case VSYNC_Drawing : // draw character rows

        DisplayModeXRow();
        CurrentDisplayedCharacterRows++;
          if (!TeleTextModeOn && CurrentDisplayedCharacterRows<LastCharacterRowsToDisplay)
          {  // do another row
            VerticalSYNCTimer+=VerticalRowTimer;
          }
          else // start video blanking
          {
            VerticalSYNCTimer+=( (LastVerticalSyncPosition-
                                  LastCharacterRowsToDisplay) *
                                LastScanLinesInACharacterRow )*ROWTIME;
            VSYNCPhase=VSYNC_VideoBlank;
          }
        break;


      // Actually a VSYNC, not just a 'phase' - generate CA1
      case VSYNC_VideoBlank :
        InterlaceTime^=ROWTIME;

#ifdef __VSYNCERROR__
          if (!TeleTextModeOn)
          {
            static FILE * F;
              if (F==NULL)
                F=fopen("timer1.log","wt");
            DumpUserVIA(F);
            DumpSysVIA(F);
          }

        VSYNCError=0; //-=DefaultVSYNCValue;
#endif

        // Screen Update Frequency changed?
        // check if bits of screen need blanking (and do blanking)
          if (LastVerticalTotalInCharacters!=VerticalTotalInCharacters ||
              LastScanLinesInACharacterRow!=ScanLinesInACharacterRow ||
              LastVerticalSyncPosition!=VerticalSyncPosition ||
              LastCharacterRowsToDisplay!=CharacterRowsToDisplay ||
              LastLinesToSkipFromScreenTop!=LinesToSkipFromScreenTop ||
              LastScanLinesInACharacterRow!=ScanLinesInACharacterRow ||
              LastScreenWidthInMemoryBytes!=ScreenWidthInMemoryBytes)
          {
              if (LastLinesToSkipFromScreenTop!=LinesToSkipFromScreenTop ||
                  LastCharacterRowsToDisplay!=CharacterRowsToDisplay ||
                  LastScanLinesInACharacterRow!=ScanLinesInACharacterRow ||
                  LastScreenWidthInMemoryBytes!=ScreenWidthInMemoryBytes)
                {
                  ModeXRowSize=80* (int)(ScanLinesInACharacterRow-1);
                  ClearScreenCount=2;
                }

            LastLinesToSkipFromScreenTop= (int) LinesToSkipFromScreenTop;
            LastCharacterRowsToDisplay=   (int) CharacterRowsToDisplay;
            LastScanLinesInACharacterRow= (int) ScanLinesInACharacterRow;
            LastScreenWidthInMemoryBytes= (int) ScreenWidthInMemoryBytes;
            LastVerticalSyncPosition=     (int) VerticalSyncPosition;
            LastVerticalTotalInCharacters=(int) VerticalTotalInCharacters;

            DefaultVSYNCValue=( (VerticalTotalInCharacters*
                                 ScanLinesInACharacterRow) +
                               ((int) RegisterValues6845[5]))*ROWTIME;
          }

          if (TeleTextModeOn)
            DefaultVSYNCValue=DEFAULT_VSYNC;

        VSYNCCount++;

          if (VSYNCCount % 64==0)
            AgePalettes();

        CursorBlinkCounter--;
          if (CursorBlinkCounter==0)
          {
            CursorOnFlag^=1; // toggles between 1(on) and 0(off)
            CursorBlinkCounter=DefaultCursorBlinkingCounter;
          }


          if (TeleTextModeOn || (VSYNCCount % DrawEveryXFrames!=0)) 
          { // do not draw this frame - its interlace/T-Text

            VerticalSYNCTimer+=DefaultVSYNCValue+InterlaceTime;
              
              if (TeleTextModeOn && ((VSYNCCount % DrawEveryXFrames)==0))
                DisplayMode7Screen(&AddressSpace[ScreenStartAddress],
                                   (0x8000-ScreenStartAddress));
          }
          else
          { // draw this frame

              if (DoubleBuffering>0)
              {
                // swap display pages
                DWORD Temp=PhysicalScreenBase;
                PhysicalScreenBase=LogicalScreenBase;
                LogicalScreenBase=Temp;

                while ((inp(0x3da)&1)==1); // display enable is active low (0 = active)
                outp(0x3d4,0xc);
                outp(0x3d5,(BYTE) (PhysicalScreenBase>>8));
                while ((inp(0x3da)&8)==0); // wait while not in vertical rescan
              }

              if (ClearScreenCount>0)
              {
                ClearScreenCount--;
                LogicalScreen=(DWORD) LogicalScreenBase;
                ClearModeXScreen(); // this fucks screen regs
              }

              if (DoScanLines)
              {
                VerticalSYNCTimer+=( ( (LastVerticalTotalInCharacters-
                                        LastVerticalSyncPosition) *
                                      LastScanLinesInACharacterRow)+
                                    ((int) RegisterValues6845[5]))*ROWTIME+
                                    InterlaceTime;

                VSYNCPhase=VSYNC_Blank;
//                VSYNC_HOLD=2;
              }
              else
              {
                DisplayModeXScreen();

                VerticalSYNCTimer+=DefaultVSYNCValue;                
              }
          }

        // if CA1 then IRA=PortA 
        IFR|=2; // set CA1 interrupt
        IRA=(PortA & (DDRA ^ 255)) + (ORA & DDRA);

        break;
    }
}
