/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// INITCARD.H
//
// (C) Mark Usher
// marku@magnet.at
// release 1.0  30.06.1999                                                       
*/

/* Memory map used on the board */

#define LOC_0x0000		   0x0000
#define LOC_0x0001         0x0001
#define LOC_0x0002         0x0002		/* Used in the Enter/Leave Critical section */
#define LOC_0x0003         0x0003		/* for the return handshake					*/

/* Strange as this is in the middle of the TX_CHAIN List ! */
#define LOC_0x0040         0x0040

/* Lists to keep track of handles */
#define UNUSED_LIST        0x0004       
#define OPEN_TX_LIST       0x001B
#define OPEN_TXCHAIN_LIST  0x0032
#define OPEN_RX_LIST       0x0049
#define COMPLETED_LIST     0x0060
#define ENABLED_LIST       0x0077
#define STORED_LIST        0x008E

#define EEPROM_COMMAND     0x00A5       /* EEPROM Command */
#define EEPROM_RC          0x00A6		/* Return code from EEPROM op */
#define EEPROM_ADDRESS     0x00A7		/* EEPROM Address */
#define EEPROM_DATA        0x00A8		/* EEPROM Data */
#define TIMER_COUNTER      0x00A9       /* Decremented by PC Interrupt routine */
#define TX_PAUSE_VALUE     0x00AA		/* Tx Pause value. Default = 20 */
#define TIMER_VALUE        0x00AB       /* Timer Value */
#define TXCB_OPENED_FLAG   0x00AC       /* Tx CB is open */

/* These locations are used when the card interrupt triggers */
#define COMPLETED_HANDLE   0x00AD		/* Handle to be passed */      
#define LOC_0x00AE		   0x00AE       
#define IN_INTERRUPT	   0x00AF		/* Flag to show the interrupt routine is executing */

/*
BUFFER_01				   0x00B0		/* Each buffer has a header of 0x11 bytes and then 0x500 bytes data
BUFFER_02				   0x05C1
BUFFER_03				   0x0AD2
BUFFER_04				   0x0FE3
BUFFER_05				   0x14F4
BUFFER_06				   0x1A05
BUFFER_07				   0x1F16
BUFFER_08				   0x2427
BUFFER_09				   0x2938
BUFFER_10				   0x2E49
BUFFER_11				   0x335A
BUFFER_12				   0x386B
BUFFER_13				   0x3D7C
BUFFER_14				   0x428D
BUFFER_15				   0x479E
BUFFER_16				   0x4CAF
BUFFER_17				   0x51C0
BUFFER_18				   0x56D1
BUFFER_19				   0x5BE2
BUFFER_20				   0x60F3
BUFFER_21				   0x6604
BUFFER_22				   0x6B15
*/


#define PC_STATUS          0x7026
#define LOC_0x7027         0x7027       /* PROT BYTE */
#define MACHINE_TYPE       0x7028		/* MACHINE TYPE */       
#define LOC_0x7029         0x7029       
#define MINOR_VERSION	   0x702A		/* MINOR version number */
#define MAJOR_VERSION      0x702B	    /* MAJOR version number 38 */

/* Alot of free space here ... */

/* Here are the latch locations on the board */

#define _6512_Reset        0x7FF8
#define _6512_IRQ          0x7FF9
#define PC_INT             0x7FFA
/* NOT USED                0x7FFB  */
#define Serial_Clock       0x7FFC
#define Serial_Data        0x7FFD
#define _6512_Cont_Acc     0x7FFE
#define NMI                0x7FFF

/* States for the latches */
#define LATCH_ON           0x01
#define LATCH_OFF          0x00
#define PC_INT_OFF         0x01
#define PC_INT_ON          0x00
#define LOWER              0x01
#define RAISE              0x00
#define DISABLE            0x01
#define ENABLE             0x00

/* diverse states */
#define INITIALISE_TESTING 0x80

/* Storage locations in the EEPROM */
#define EEPROM_STATION     0x00         /* Station number         */
#define EEPROM_FS          0x01         /* File server            */
#define EEPROM_FS_NET      0x02         /* File server network    */
#define EEPROM_PS          0x03         /* Printer server         */
#define EEPROM_PS_NE       0x04         /* Printer server network */

