/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ECONET.H
//
// (C) Mark Usher
// marku@magnet.at
// release 1.0  30.06.1999                                                       
*/

/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Econet specific values
*/

#define MAX_PACKET_LENGTH   0x500


#define ERR_LINE_JAMMED     0x40
#define ERR_NET_ERROR       0x41
#define ERR_NOT_LISTENING   0x42
#define ERR_NO_CLOCK        0x43
#define ERR_BAD_TRANSMIT    0x44


/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Machine types
*/

#define MC_BBC				0x01	/* BBC Computer   */
#define MC_ATOM				0x02	/* ATOM           */
#define MC_ACORN_SYSTEM34	0x03	/* SYSTEM 3 / 4   */
#define MC_ACORN_SYSTEM5    0x04	/* SYSTEM 5		  */
#define MC_MASTER			0x05	/* Master OS 3    */
#define MC_ELECTRON			0x06	/* Electron OS 0  */
#define MC_ARCHIMEDES		0x07	/* Archimedes	  */
#define MC_A2000			0x08	/* A2000		  */
#define MC_COMMUNICATOR		0x09	/* Communicator   */
#define MC_ECONET_WS		0x0A	/* Econet WS OS 4 */
#define MC_FILESTORE		0x0B	/* File Store     */
#define MC_COMPACT			0x0C	/* Compact OS 5   */
#define MC_PC				0x0D	/* IBM PC		  */
#define MC_LAST_MACHINE     0x0D