/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ECOLINK.H
//
// (C) Mark Usher
// marku@magnet.at
// release 1.0  30.06.1999                                                       
*/

/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Stuctures
*/
struct RXCBHeader
{
	byte            ControlByte     __attribute__((packed));    /* For Rx 01111111 */
	byte            Port            __attribute__((packed));	/* Port */
	unsigned short  Station         __attribute__((packed));	/* Station ID / LSB = Station ID MSB = Network ID */
	unsigned short  Length          __attribute__((packed));	/* Length max 0x0500 */
	byte 	        Event           __attribute__((packed));	/* Event default = 0x02 Stored */
	byte            Status          __attribute__((packed));	/* Status byte	*/
	byte            KillFlag        __attribute__((packed));	/* Kill flag ?	*/
	byte            CtrlByteCopy    __attribute__((packed));	/* Copy of control byte */
	byte            RPCFlag         __attribute__((packed));	/* RPC flag	*/
	unsigned short  RPCNumber       __attribute__((packed));	/* RPC Number	*/
  	byte            Timeout         __attribute__((packed));	/* Timeout	*/
        byte            E               __attribute__((packed));	/* unknown	*/
        byte            F               __attribute__((packed));	/* unknown	*/
        byte            _10             __attribute__((packed));	/* unknown	*/
        byte            _11             __attribute__((packed));	/* unknown	*/
};

struct TXCBHeader
{
	byte            ControlByte     __attribute__((packed));    /* For Tx 1xxxxxxx */
	byte            Port            __attribute__((packed));	/* Port */
	unsigned short  Station         __attribute__((packed));	/* Station ID / LSB = Station ID MSB = Network ID */
	unsigned short  Length          __attribute__((packed));	/* Length max 0x0500 */
	byte 	        Event           __attribute__((packed));	/* Event default = 0x02 Stored */
	byte            Status          __attribute__((packed));	/* Status byte	*/
	byte            KillFlag        __attribute__((packed));	/* Kill flag ?	*/
	byte            CtrlByteCopy    __attribute__((packed));	/* Copy of control byte */
	byte            RetryCount      __attribute__((packed));	/* Retry Count */
	unsigned short  BufferOffset    __attribute__((packed));	/* Tx buffer offset	*/
   	byte            Timeout         __attribute__((packed));	/* Timeout	*/
	unsigned short  E               __attribute__((packed));	/* unknown	*/
   	byte            PreviousTx      __attribute__((packed));	/* Previous Tx in chain	*/
   	byte            NextTx          __attribute__((packed));	/* Next Tx in chain	*/
};



struct ReplyBlock_PollCB
{
	byte	       CBH           __attribute__((packed));		/* Incase of wildcard poll	*/
	byte	       ControlByte   __attribute__((packed));		/* If Rx:   0x7F until received then sent Ctrl byte
									                               If Tx:
									                               bit 7:   Pending: 1= Tx not yet finished
									                               bit 6:   Fail:	 1= Transmit failed
									                               bit0..3: Error Number */
	byte	       Port          __attribute__((packed));
	unsigned short Station       __attribute__((packed));
	unsigned short Length        __attribute__((packed));
	unsigned short Zero          __attribute__((packed));
};


/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Return Codes
*/
#define	RC_COMMAND_COMPLETED_OK			0x00
#define	RC_BAD_COMMAND_IN_CONTROL_BLOCK		0x01
#define	RC_NO_HANDLES_LEFT			0x02
#define	RC_BAD_HANDLE				0x03
#define	RC_BAD_ARGUMENT_IN_COMMAND		0x04
#define	RC_DATA_SIZE_LARGER_THAN_BUFFER		0x05
#define	RC_KILL_CONDITION_FAILED		0x06
#define	RC_CONTROL_BLOCK_IN_USE			0x07
#define	RC_COMMAND_ABORTED			0x7F
#define	RC_RETRYABLE_BOARD_ERROR		0x100	/* 0x1xx  Retryable board error xx								*/
#define	RC_FATAL_BOARD_ERROR			0x200	/* 0x2xx  Fatal board error xx									*/
#define	RC_BAD_COMMAND_IN_AL			0x300	/* Bad command in AL to INT 2F									*/
#define	RC_TIMEOUT_ERROR			0x301
#define	RC_OTHER_ERRORS				0x300	/* 0x3xx  Other driver errors											*/

/* These codes were not in the original driver and specification */
#define RC_HANDLE_NOT_IN_USE                    0x08
#define RC_NO_MATCH_FOR_WILDCARD                0x09


/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// RPC Codes
*/ 
#define	RPC_ENABLED     			0x80
#define	RPC_MASKED			        0xC0
#define RPC_DISABLED                            0x00

#define	RPC_ALL					0x00
#define	RPC_PEEK				0x81
#define	RPC_POKE				0x82
#define	RPC_REMOTE_JSR				0x83
#define	RPC_REMOTE_PROCEDURE_CALL		0x84
#define	RPC_OS_PROC				0x85
#define	RPC_HALT				0x86
#define	RPC_CONTINUE				0x87
#define RPC_MACHINE_TYPE                        0x88

/*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// CBH CODES
// there are two wildcard handles
// All other valid handles are in the range 1 - 120
// Zero is an invalid handle
*/
#define	CBH_FIRST_TxCB_SENT			0xFF
#define	CBH_FIRST_RxCB_SENT			0xFE


#define	KILL_ALL				0x00
#define	KILL_TOP_BIT_ZERO			0x01
#define	KILL_TOP_BIT_SET 			0x81


/*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Command 0 Get installed state
*/
#define	NOT_INSTALLED_OK			0x00
#define	NOT_INSTALLED_NOK			0x01
#define	INSTALLED 				0xFF


/*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Command 2 / 3 Poll
*/
#define RxWILDCARD                              0xFE
#define TxWILDCARD                              0xFF

#define RxCB_TIMED_OUT                          0xFC
#define RxCB_SUCCESSFUL                         0xFD
#define TxCB_RETRY_LIMIT_EXCEEDED               0xFE
#define TxCB_SUCCESSFUL                         0xFF


/*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Command 5 Set default event action
// Command 6 Set individual event action
*/
#define	DISABLED				0x00
#define	ENABLED					0x01
#define	STORED					0x02


/*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Command 7 Test / Clear Event Status
*/
#define	TEST_EVENT				0x00
#define	TEST_AND_CLEAR_EVENT			0x01
#define	GET_FIRST_EVENT		                0xFF


/*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Command 8 Enable / Disable Event Scheduler
*/
#define	ENABLE_EVENT_SCHEDULER			0x01
#define	DISABLE_EVENT_SCHEDULER			0x02


#define NO_TIMEOUT                              0x00

#define EEPROM_NOTHING                          0x00
#define EEPROM_READ                             0x01
#define EEPROM_WRITE                            0x02

#define EEPROM_SUCCESS                          0x00
#define EEPROM_READ_WRITE_ERROR                 0xFE
#define EEPROM_INVALID_COMMAND                  0xFF

