/* OS/2 REXX /XFree86/bin/fortune.cmd */

trace off;
signal on halt name err;
signal on syntax name err;

parse arg msg_num;
if (RxFuncAdd("searchpath", "REXXUTIL", "SysSearchPath") > 1) then
   rx = err(2);
poslf = -1;
msg_pos = 1;
i = 0;
j = 1;
env = "OS2ENVIRONMENT";
fortune = value("X11ROOT", , env);
fortune = fortune || "\usr\lib\fortune.dat";
fortune = stream(fortune, "C", "QUERY EXISTS");
if (fortune == "") then
   fortune = searchpath("LIBRARY_PATH", "fortune.dat");
if (fortune == "") then
   fortune = searchpath("DPATH", "fortune.dat");
if (fortune == "") then
   fortune = searchpath("PATH", "fortune.dat");
if (fortune == "") then
   rx = err(0);
msg_tot = linein(fortune);
fortune = charin(fortune, 1, chars(fortune)) || "%%";
if (pos("0d0a"x, fortune) == 0) then
   eol = 1;
else
   eol = 0;
if (datatype(msg_tot) \= "NUM") then
   rx = err(1);
if ((datatype(msg_num) \= "NUM") | (msg_num < 1) | (msg_num > msg_tot)) then
   msg_num = random(1, msg_tot);
do msg_num * 2
   msg_pos = pos("%%", fortune, msg_pos);
   if (i == 0) then do
      msg_sps = msg_pos + 2;
      msg_pos = msg_pos + 1;
      i = 1;
   end;
   else do
      msg_eps = msg_pos;
      i = 0;
      j = j + 1;
   end;
end;
msg_bdy = substr(fortune, msg_sps, msg_eps - msg_sps);
if (eol) then do forever
   poslf = pos("0a"x, msg_bdy, poslf + 2);
   if (poslf == 0) then
      leave
   else
      msg_bdy = insert("0d"x, msg_bdy, poslf - 1);
end;
rx = charout("stdout", msg_bdy);
exit rx;

err:
   select
      when (arg(1) == 0) then do
         rx = lineout("stderr", "error: could not find `fortune.dat'");
         rx = 1;
      end;
      when (arg(1) == 1) then do
         rx = lineout("stderr", "error: malformed input file");
         rx = 2;
      end;
      when (arg(1) == 2) then do
         rx = lineout("stderr", "error: could not register `searchpath()'");
         rx = 3;
      end;
      otherwise
         rx = -1;
   end;
exit rx;