/*************************************************************************
 * This file was generated by the SOM Compiler.
 * FileName: wpfldext.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 *************************************************************************/

/*************************************************************************
 * 
 * 
 *   Module Name : WPFLDEXT
 * 
 *   Description : OS/2 Workplace Shell WPProgram Object Extension.
 *                 This extension adds the option to close the folder
 *                 to which the launching program belongs.
 * 
 *   Programmer  : Yong D. Lee
 *   Date        : Nov 21, 1993
 * 
 *   Disclaimer of warranties:
 *       The code is provided "AS IS", without warranty of any kind.  I shall
 *       not be liable for any damages arising out of your use of this code.
 * 
 *************************************************************************/

#define WPFldExt_Class_Source
#define M_WPFldExt_Class_Source

#include "wpfldext.ih"
#include "wpfldext.ph"
#include <wpdisk.h>

#include <string.h>
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>

/*************************************************************************/
/*                                                                       */
/*                     Non-method function prototype                     */
/*                                                                       */
/*************************************************************************/

MRESULT EXPENTRY FolderDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY CloseKeyDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY GoBackDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);

/*************************************************************************/
/*                                                                       */
/*               Global/Static (Non-Instance) Data Section               */
/*                                                                       */
/*************************************************************************/

UCHAR szWPFldExtClassTitle[CCHMAXPATH] = "";
HMODULE hmod = NULLHANDLE;
BOOL goBackFlag;
LONG virtualKey;

/*************************************************************************/
/*                                                                       */
/*                         Method Implementation                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************
 * 
 *  METHOD: QueryFolderClose                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    Query state of folder close flag
 * 
 *  RETURN:
 * 
 *    ULONG - folder closing option
 * 
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpfldext_QueryFolderClose(WPFldExt *somSelf)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_QueryFolderClose");

    return (ULONG)_folderClose;
}

/*************************************************************************
 *
 *  METHOD: SetFolderClose                                 ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Set state of folder close flag
 *
 *************************************************************************/

SOM_Scope VOID   SOMLINK wpfldext_SetFolderClose(WPFldExt *somSelf, ULONG flag)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_SetFolderClose");

    _folderClose = flag;
}

/*************************************************************************
 *
 *  METHOD: QueryCurrentClose                              ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Query state of current folder close flag
 *
 *  RETURN:
 *
 *    VOOL - current folder closing flag
 *
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpfldext_QueryCurrentClose(WPFldExt *somSelf)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_QueryCurrentClose");

    return (BOOL)_currentClose;
}

/*************************************************************************
 *
 *  METHOD: SetCurrentClose                                ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Set current folder close flag
 *
 *
 *************************************************************************/

SOM_Scope VOID   SOMLINK wpfldext_SetCurrentClose(WPFldExt *somSelf, BOOL flag)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_SetCurrentClose");

    _currentClose = flag;
}

/*************************************************************************
 * 
 *  METHOD: AddFolderOptionPage                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    Add the folder option page to the settings notebook
 * 
 *  RETURN:
 * 
 *    0              Unsuccessful
 *    ulPageId       Identifier for the inserted page
 * 
 * 
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpfldext_AddFolderOptionPage(WPFldExt *somSelf, HWND hwndNotebook)
{
    PAGEINFO pageinfo;
    ULONG pageId;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_AddFolderOptionPage");

    memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
    pageinfo.cb = sizeof(PAGEINFO);
    pageinfo.hwndPage = NULLHANDLE;
    pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags = BKA_LAST;
    pageinfo.pfnwp = FolderDlgProc;
    pageinfo.resid = hmod;
    pageinfo.dlgid = IDD_FOLDEROPTION;
    pageinfo.pszName = "Folder";
    pageinfo.pCreateParams = somSelf;

    /* 
     * Insert folder option page
     */
    pageId = _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);

    /* 
     * Insert status line text
     */
    WinSendMsg(hwndNotebook, BKM_SETSTATUSLINETEXT, (MPARAM)pageId, MPFROMP("Folder - Page 1 of 3 "));

    return pageId;
}

/*************************************************************************
 *
 *  METHOD: AddFolderKeyPage                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Add the folder key selection page to the settings notebook
 *
 *  RETURN:
 *
 *    0              Unsuccessful
 *    ulPageId       Identifier for the inserted page
 *
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpfldext_AddFolderKeyPage(WPFldExt *somSelf, HWND hwndNotebook)
{
    PAGEINFO pageinfo;
    ULONG pageId;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_AddFolderKeyPage");

    memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
    pageinfo.cb = sizeof(PAGEINFO);
    pageinfo.hwndPage = NULLHANDLE;
    pageinfo.usPageStyleFlags = BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags = BKA_LAST;
    pageinfo.pfnwp = CloseKeyDlgProc;
    pageinfo.resid = hmod;
    pageinfo.dlgid = IDD_FOLDERKEY;
    pageinfo.pCreateParams = somSelf;

    /* 
     * Insert folder key page
     */
    pageId = _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);

    /*
     * Insert status line text
     */
    WinSendMsg(hwndNotebook, BKM_SETSTATUSLINETEXT, (MPARAM)pageId, MPFROMP("Folder - Page 2 of 3 "));

    return pageId;
}

/*************************************************************************
 *
 *  METHOD: AddFolderGoBackPage                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Add the folder go back page to the settings notebook
 *
 *  RETURN:
 *
 *    0              Unsuccessful
 *    ulPageId       Identifier for the inserted page
 *
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpfldext_AddFolderGoBackPage(WPFldExt *somSelf, HWND hwndNotebook)
{
    PAGEINFO pageinfo;
    ULONG pageId;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_AddFolderGoBackPage");

    memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
    pageinfo.cb = sizeof(PAGEINFO);
    pageinfo.hwndPage = NULLHANDLE;
    pageinfo.usPageStyleFlags = BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags = BKA_LAST;
    pageinfo.pfnwp = GoBackDlgProc;
    pageinfo.resid = hmod;
    pageinfo.dlgid = IDD_GOBACKOPTION;
    pageinfo.pCreateParams = somSelf;

    /*
     * Insert folder key page
     */
    pageId = _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);

    /*
     * Insert status line text
     */
    WinSendMsg(hwndNotebook, BKM_SETSTATUSLINETEXT, (MPARAM)pageId, MPFROMP("Folder - Page 3 of 3 "));

    return pageId;
}

/*************************************************************************
 *
 *  METHOD: OpenParentFolder                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Open folder to which the current folder belongs
 *
 *  RETURN:
 *
 *    TRUE       Successful
 *    FALSE      Unsuccessful
 *
 *************************************************************************/

SOM_Scope VOID SOMLINK wpfldext_OpenParentFolder(WPFldExt *somSelf)
{
    INT backSlash = '\\';
    CHAR pathName[CCHMAXPATH];
    ULONG pathSize = CCHMAXPATH;
    ULONG defaultView;
    WPFldExt *wpFolder;
    WPDisk *wpDisk;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_OpenParentFolder");

    /*
     * To open the parent folder (the folder to which the current folder
     * belongs), find the full path name of the current folder
     */
    _wpQueryRealName(somSelf, pathName, &pathSize, TRUE);

    /*
     * Delete the last directory name to find the path name of parent
     * folder
     */
    *strrchr(pathName, backSlash) = '\0';

    /* 
     * If the length of path is 2, the parent folder must be WPDisk object
     */
    if (strlen(pathName) == 2) {

        /*
         * Undocumented feature - find WPDisk object to which the current folder belongs
         */

        wpDisk = _somDispatchA(somSelf, SOM_IdFromString("wpQueryDisk"), (PVOID)0);
        _wpUnlockObject(wpDisk);

        if (!WPObject_wpSwitchTo(wpDisk, OPEN_DEFAULT)) {

            if (!WPObject_wpSwitchTo(wpDisk, OPEN_TREE)) {

                if (!WPObject_wpSwitchTo(wpDisk, OPEN_DETAILS)) {

                    if (!WPObject_wpSwitchTo(wpDisk, OPEN_CONTENTS)) {
                        defaultView = _wpQueryDefaultView(wpDisk);
                        WPObject_wpOpen(wpDisk, NULLHANDLE, defaultView, NULLHANDLE);
                        WPObject_wpSwitchTo(wpDisk, defaultView);
                    }
                }
            }
        }
    } 
    else {

        /*
         * Undocumented feature - find folder to which the current folder belongs
         */
        wpFolder = _somDispatchA(somSelf, SOM_IdFromString("wpQueryContainer"), (PVOID)0);
        _wpUnlockObject(wpFolder);

        if (!_wpSwitchTo(wpFolder, OPEN_DEFAULT)) {

            if (!_wpSwitchTo(wpFolder, OPEN_TREE)) {

                if (!_wpSwitchTo(wpFolder, OPEN_DETAILS)) {

                    if (!_wpSwitchTo(wpFolder, OPEN_CONTENTS)) {
 
                         /*
                          * Open the parent folder by calling parent_wpOpen. We don't want to
                          * call wpOpen of this class, since it will try to close the parent
                          * folder (In this case, the current folder)
                          */

                         defaultView = _wpQueryDefaultView(wpFolder);
                         parent_wpOpen(wpFolder, NULLHANDLE, defaultView, 0);
                         _wpSwitchTo(wpFolder, defaultView);
                    }
                }
            }
        }
    }
}

/*************************************************************************
 *
 *  METHOD: FindKeyFromScancode                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Find key name from scancode
 *
 *************************************************************************/

SOM_Scope VOID SOMLINK wpfldext_FindKeyFromScancode(WPFldExt *somSelf, LONG scanCode, CHAR *str)
{
    SHORT keyID;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_FindKeyFromScancode");

    switch (scanCode) {
        case VK_SHIFT:
            keyID = IDSC_SHIFT;
            break;

        case VK_F1:
            keyID = IDSC_F1;
            break;

        case VK_F2:
            keyID = IDSC_F2;
            break;

        case VK_F3:
            keyID = IDSC_F3;
            break;

        case VK_F4:
            keyID = IDSC_F4;
            break;

        case VK_F5:
            keyID = IDSC_F5;
            break;

        case VK_F6:
            keyID = IDSC_F6;
            break;

        case VK_F7:
            keyID = IDSC_F7;
            break;

        case VK_F8:
            keyID = IDSC_F8;
            break;

        case VK_F9:
            keyID = IDSC_F9;
            break;

        case VK_F10:
            keyID = IDSC_F10;
            break;

        case VK_F11:
            keyID = IDSC_F11;
            break;

        case VK_F12:
            keyID = IDSC_F12;
            break;

    }

    WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), _clsQueryModuleHandle((M_WPFldExt *)_somGetClass(somSelf)), (ULONG)keyID, CCHMAXPATH, str);
}

/*************************************************************************
 *
 *  METHOD: FindScancodeFromKey                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Find scancode from keyname
 *
 *  RETURN
 *    key scancode
 *
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpfldext_FindScancodeFromKey(WPFldExt *somSelf, CHAR *str)
{
    SHORT sCount;
    CHAR keyStr[CCHMAXPATH];

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_FindScancodeFromKey");

    for (sCount = 0; sCount < MAXKEY; sCount++) {
        WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), _clsQueryModuleHandle((M_WPFldExt *)_somGetClass(somSelf)), (ULONG)(IDSC_SHIFT + sCount), CCHMAXPATH, keyStr);

        if (strcmp(str, keyStr) == 0)
            break;

    }

    switch (IDSC_SHIFT + sCount) {
        case IDSC_SHIFT:
            return VK_SHIFT;

        case IDSC_F1:
            return VK_F1;

        case IDSC_F2:
            return VK_F2;

        case IDSC_F3:
            return VK_F3;

        case IDSC_F4:
            return VK_F4;

        case IDSC_F5:
            return VK_F5;

        case IDSC_F6:
            return VK_F6;

        case IDSC_F7:
            return VK_F7;

        case IDSC_F8:
            return VK_F8;

        case IDSC_F9:
            return VK_F9;

        case IDSC_F10:
            return VK_F10;

        case IDSC_F11:
            return VK_F11;

        case IDSC_F12:
            return VK_F12;

    }

    return 0;
}

/*************************************************************************/
/*                                                                       */
/*                     Override Method Implementation                    */
/*                                                                       */
/*************************************************************************/

/*************************************************************************
 * 
 *  OVERRIDE: wpInitData
 * 
 *  DESCRIPTION:
 * 
 *    Initialize the state variables and allocate any extra memory
 *    that might be needed
 * 
 *************************************************************************/

SOM_Scope void   SOMLINK wpfldext_wpInitData(WPFldExt *somSelf)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpInitData");

    memset((PVOID)somThis, 0, sizeof(WPFldExtData));

    _folderClose = DONOTCLOSE;
    _currentClose = FALSE;

    parent_wpInitData(somSelf);
}

/*************************************************************************
 * 
 *  OVERRIDE: wpUnInitData
 * 
 *  DESCRIPTION:
 * 
 *    Clear up memory that was allocated on wpInitData
 * 
 *************************************************************************/

SOM_Scope void   SOMLINK wpfldext_wpUnInitData(WPFldExt *somSelf)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpUnInitData");

    parent_wpUnInitData(somSelf);
}

/*************************************************************************
 * 
 *  OVERRIDE: wpSaveState
 * 
 *  DESCRIPTION:
 * 
 *    Save state variable (folder close flag)
 * 
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpfldext_wpSaveState(WPFldExt *somSelf)
{
    ULONG pathSize = CCHMAXPATH;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpSaveState");

    _wpSaveLong(somSelf, szWPFldExtClassTitle, IDKEY_FOLDERCLOSE, _folderClose);
    _wpSaveLong(somSelf, szWPFldExtClassTitle, IDKEY_CURRENTCLOSE, _currentClose);

    return (parent_wpSaveState(somSelf));
}

/*************************************************************************
 * 
 *  OVERRIDE: wpRestoreState
 * 
 *  DESCRIPTION:
 * 
 *    Restore saved state variable
 * 
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpfldext_wpRestoreState(WPFldExt *somSelf, ULONG ulReserved)
{
    ULONG pathSize = CCHMAXPATH;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpRestoreState");

    _wpRestoreLong(somSelf, szWPFldExtClassTitle, IDKEY_FOLDERCLOSE, &_folderClose);
    _wpRestoreLong(somSelf, szWPFldExtClassTitle, IDKEY_CURRENTCLOSE, &_currentClose);

    return (parent_wpRestoreState(somSelf,ulReserved));
}

/*************************************************************************
 * 
 *  OVERRIDE: wpAddSettingsPages
 * 
 *  DESCRIPTION:
 * 
 *    Add folder settings page to let the user alter the flag
 * 
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpfldext_wpAddSettingsPages(WPFldExt *somSelf, HWND hwndNotebook)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpAddSettingsPages");

    if (parent_wpAddSettingsPages(somSelf, hwndNotebook) && _AddFolderOptionPage(somSelf, hwndNotebook) && _AddFolderKeyPage(somSelf, hwndNotebook) && _AddFolderGoBackPage(somSelf, hwndNotebook))
        return TRUE;
    else 
        return FALSE;
  
}

/*************************************************************************
 *
 *   OVERRIDE: wpFilterPopupMenu                           ( ) PRIVATE
 *                                                         (X) PUBLIC
 *   DESCRIPTION:
 *
 *     Check pop-up menu flags and set flags for this class
 *
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpfldext_wpFilterPopupMenu(WPFldExt *somSelf, ULONG ulFlags, HWND hwndCnr, BOOL fMultiSelect)
{
    ULONG popupMenuFlags;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpFilterPopupMenu");

    popupMenuFlags = parent_wpFilterPopupMenu(somSelf,ulFlags,hwndCnr,fMultiSelect);
 
    /* 
     * See if CTXT_WINDOW flag is set. If the flag is set, set our flag to add "Go back"
     * menu in the pop-up menu
     */
    if (popupMenuFlags & CTXT_WINDOW)
        goBackFlag = TRUE;
    else 
        goBackFlag = FALSE;

    return popupMenuFlags;
}

/*************************************************************************
 *
 *   OVERRIDE: wpModifyPopupMenu
 *
 *   DESCRIPTION:
 *
 *     Add an option to the popup-menu to open the parent folder
 *
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpfldext_wpModifyPopupMenu(WPFldExt *somSelf, HWND hwndMenu, HWND hwndCnr, ULONG iPosition)
{
    MENUITEM menuItem;
    BOOL rc;
    WPFldExt *desktopFolder;

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpModifyPopupMenu");

    rc = parent_wpModifyPopupMenu(somSelf, hwndMenu, hwndCnr, iPosition);

    /* 
     * Check if current folder is desktop, and add new menu only
     * when it's not desktop folder and goBackFlag is set to TRUE.
     */
    desktopFolder = _wpclsQueryFolder((M_WPFldExt *)_somGetClass(somSelf), "<WP_DESKTOP>", FALSE);

    if (goBackFlag && (desktopFolder != somSelf)) {

        /*
         * Insert "Go back" item at the end of popup-menu
         */
        _wpInsertPopupMenuItems(somSelf, hwndMenu, iPosition, hmod, ID_GOBACKMENU, 0);

        /* 
         * Make it conditional cascade menu
         */
        WinSendMsg(hwndMenu, MM_QUERYITEM, MPFROM2SHORT(IDM_GOBACK, TRUE), &menuItem);
        WinSetWindowBits(menuItem.hwndSubMenu, QWL_STYLE, MS_CONDITIONALCASCADE, MS_CONDITIONALCASCADE);

        /* 
         * Set default item according to currentClose flag
         */
       if (_currentClose)
           WinSendMsg(menuItem.hwndSubMenu, MM_SETDEFAULTITEMID, MPFROMSHORT(IDM_CLOSECURRENT), (MPARAM)0);
       else
           WinSendMsg(menuItem.hwndSubMenu, MM_SETDEFAULTITEMID, MPFROMSHORT(IDM_DONOTCLOSECURRENT), (MPARAM)0);

    }

    return rc;
}

/*************************************************************************
 *
 *   OVERRIDE: wpMenuItemSelected
 *
 *   DESCRIPTION:
 *
 *     Process the menu option we added
 *
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpfldext_wpMenuItemSelected(WPFldExt *somSelf, HWND hwndFrame, ULONG ulMenuId)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpMenuItemSelected");

    switch (ulMenuId) {
        case IDM_GOBACK:
 
            if (_currentClose == FALSE) {
                _OpenParentFolder(somSelf);
                break;
            }

        case IDM_CLOSECURRENT: 
            WinSendMsg(hwndFrame, WM_CLOSE, (MPARAM)0, (MPARAM)0);

        case IDM_DONOTCLOSECURRENT:
            _OpenParentFolder(somSelf);
            break;

        default:
            return (parent_wpMenuItemSelected(somSelf, hwndFrame, ulMenuId));
            break;
    }

    return TRUE;
}

/*************************************************************************
 * 
 *   METHOD: wpOpen                                        
 *                                                         
 *   DESCRIPTION:
 * 
 *     Opens the program object window. Close folder upon openning 
 *     according to folderClose flag
 * 
 *************************************************************************/

SOM_Scope HWND   SOMLINK wpfldext_wpOpen(WPFldExt *somSelf, HWND hwndCnr, ULONG ulView, ULONG param)
{
    ULONG longSize = sizeof(LONG);
    LONG keyState;
    BOOL close;
    HWND hwndTop;
    HWND hwndClient;
    CHAR className[CCHMAXPATH];

    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpOpen");

    /*
     * Get close key scancode from system profile
     */

    if (!PrfQueryProfileData(HINI_USERPROFILE, "WPFldExt", "WPFldExt", (PVOID)&virtualKey, &longSize))
        virtualKey = VK_SHIFT;

    /* 
     * Get the state of shift keys so that we can close the parent
     * folder if shift key is pressed
     */
    keyState = WinGetKeyState(HWND_DESKTOP, virtualKey);

    if (keyState & 0x8000)
        close = TRUE;
    else {

        /* 
         * Check for the flags in the Folder page in settings notebook
         */
        switch (ulView) {
 
            case OPEN_SETTINGS:
 
                if (_folderClose & CLOSENOTEBOOK)
                    close = TRUE;
                else
                    close = FALSE;
 
                break;

            case OPEN_CONTENTS:
 
                if (_folderClose & CLOSECONTENT)
                    close = TRUE;
                else
                    close = FALSE;

                break;

            case OPEN_TREE:

                if (_folderClose & CLOSETREE)
                    close = TRUE;
                else
                    close = FALSE;

                break;
 
            case OPEN_DETAILS:

                if (_folderClose & CLOSEDETAIL)
                    close = TRUE;
                else
                    close = FALSE;

                break;

            default:
                close = FALSE;

        }
    }

    if (close) {
        /* 
         * The active window before opening the new folder must be
         * the parent folder. If it's not the desktop window (if there 
         * are no window below the parent folder in z-order), close the 
         * parent window
         */
        if (((hwndTop = WinQueryActiveWindow(HWND_DESKTOP)) != NULLHANDLE) && (WinQueryWindow(hwndTop, QW_NEXT) != NULLHANDLE)) {
                
            if ((hwndClient = WinWindowFromID(hwndTop, FID_CLIENT)) != NULLHANDLE) {
                WinQueryClassName(hwndClient, sizeof(className), className);

                if (strcmp(className, "#37") == 0)
                    WinSendMsg(hwndTop, WM_CLOSE, (MPARAM)0, (MPARAM)0);

            }
        }
    }
 
    /*
     * Call the original wpOpen
     */
    hwndTop = parent_wpOpen(somSelf, hwndCnr, ulView, param);

    /* 
     * If the parent window is closed, the newly created folder loses it's focus.
     * I don't know why, but this will give it the focus back
     */
    if (close) 
       WinSetFocus(HWND_DESKTOP, hwndTop);


    return hwndTop;
}

/*************************************************************************
 * 
 *  OVERRIDE: wpSetup
 * 
 *  DESCRIPTION:
 * 
 *    Specift setup strings and do some initialization
 * 
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpfldext_wpSetup(WPFldExt *somSelf, PSZ pszSetupString)
{
    WPFldExtData *somThis = WPFldExtGetData(somSelf);
    WPFldExtMethodDebug("WPFldExt","wpfldext_wpSetup");

    return (parent_wpSetup(somSelf,pszSetupString));
}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta

/*************************************************************************/
/*                                                                       */
/*                      Class Method Implementation                      */
/*                                                                       */
/*************************************************************************/

/*************************************************************************
 *
 *  METHOD: clsQueryModuleHandle                         ( ) PRIVATE
 *                                                       (X) PUBLIC
 *  DESCRIPTION:
 *
 *    This method returns the module handle of this class.
 *
 *  RETURN:
 *
 *    0          Unsuccessful
 *    non-zero   Module handle
 *
 *************************************************************************/

SOM_Scope HMODULE   SOMLINK wpfldextM_clsQueryModuleHandle(M_WPFldExt *somSelf)
{
    zString zsPathName;
    APIRET rc;

    /* M_WPFldExtData *somThis = M_WPFldExtGetData(somSelf); */
    M_WPFldExtMethodDebug("M_WPFldExt","wpfldextM_clsQueryModuleHandle");

    if (hmod == NULLHANDLE) {

       /*
        *   Retrieve registered pathname of our module (DLL) and query the
        *   module handle.
        */
       zsPathName = _somLocateClassFile(SOMClassMgrObject, SOM_IdFromString("WPFldExt"), WPFldExt_MajorVersion, WPFldExt_MinorVersion);
       rc = DosQueryModuleHandle(zsPathName, &hmod);
    }

    return (hmod);
}

/*************************************************************************/
/*                                                                       */
/*                  Override Class Method Implementation                 */
/*                                                                       */
/*************************************************************************/

/*************************************************************************
 * 
 *  METHOD: wpclsInitData
 * 
 *  DESCRIPTION:
 * 
 *    Initialize the class data
 * 
 *************************************************************************/

SOM_Scope void   SOMLINK wpfldextM_wpclsInitData(M_WPFldExt *somSelf)
{
    /*M_WPFldExtData *somThis = M_WPFldExtGetData(somSelf);*/
    M_WPFldExtMethodDebug("M_WPFldExt","wpfldextM_wpclsInitData");

    parent_wpclsInitData(somSelf);

    /*
     * Get class title
     */

    if (!WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP),
                       _clsQueryModuleHandle(somSelf),
                       ID_TITLE,
                       sizeof(szWPFldExtClassTitle),
                       szWPFldExtClassTitle))
        strcpy(szWPFldExtClassTitle, parent_wpclsQueryTitle(somSelf));

}

/*************************************************************************
 * 
 *  METHOD: wpclsUnInitData
 * 
 *  DESCRIPTION:
 * 
 *    Free any class data
 * 
 *************************************************************************/

SOM_Scope void   SOMLINK wpfldextM_wpclsUnInitData(M_WPFldExt *somSelf)
{
    /* M_WPFldExtData *somThis = M_WPFldExtGetData(somSelf); */
    M_WPFldExtMethodDebug("M_WPFldExt","wpfldextM_wpclsUnInitData");

    parent_wpclsUnInitData(somSelf);
}

/*************************************************************************
 *
 *  METHOD: wpclsQueryTitle                                
 *                                                         
 *  DESCRIPTION:
 *
 *    Return the string "Extended Program".
 *
 *************************************************************************/

SOM_Scope PSZ   SOMLINK wpfldextM_wpclsQueryTitle(M_WPFldExt *somSelf)
{
    /* M_WPFldExtData *somThis = M_WPFldExtGetData(somSelf); */
    M_WPFldExtMethodDebug("M_WPFldExt","wpfldextM_wpclsQueryTitle");

    /*
     * Return the class title for a WPFldExt
     */
    if (szWPFldExtClassTitle[0])
        return (szWPFldExtClassTitle);
    else
        return (parent_wpclsQueryTitle(somSelf));

}

/*************************************************************************/
/*                                                                       */
/*                   Non-method function implementation                  */
/*                                                                       */
/*************************************************************************/

/************************************************************************* 
 *
 * Window procedure : FolderDlgProc
 *
 *************************************************************************/

MRESULT EXPENTRY FolderDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   WPFldExt *desktopFolder;
   PFOLDEROPTION pFolder;
   MRESULT rc;
 
   switch(msg) {
      case WM_INITDLG:
         pFolder = (PFOLDEROPTION)_wpAllocMem((WPFldExt *)mp2, sizeof(FOLDEROPTION), NULL);

         if (pFolder) {
            memset((PVOID)pFolder, 0, sizeof(FOLDEROPTION));
            pFolder->cb = sizeof(FOLDEROPTION);
            pFolder->somSelf = (WPFldExt *)mp2;
            pFolder->closeFolder = _QueryFolderClose(pFolder->somSelf);
         }
         else 
            break;

         WinSetWindowPtr(hwndDlg, QWL_USER, pFolder);

         desktopFolder = _wpclsQueryFolder((M_WPFldExt *)_somGetClass(pFolder->somSelf), "<WP_DESKTOP>", FALSE);

         if (desktopFolder == pFolder->somSelf) {
            WinEnableWindow(WinWindowFromID(hwndDlg, IDGROUP_FOLDERCLOSE), FALSE);
            WinEnableWindow(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), FALSE);
            WinEnableWindow(WinWindowFromID(hwndDlg, IDCHECK_CLOSECONTENT), FALSE);
            WinEnableWindow(WinWindowFromID(hwndDlg, IDCHECK_CLOSETREE), FALSE);
            WinEnableWindow(WinWindowFromID(hwndDlg, IDCHECK_CLOSEDETAIL), FALSE);
         }

         if (pFolder->closeFolder & CLOSENOTEBOOK)
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_SETCHECK, MPFROMSHORT(0), (MPARAM)0);

         if (pFolder->closeFolder & CLOSECONTENT)
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSECONTENT), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSECONTENT), BM_SETCHECK, MPFROMSHORT(0), (MPARAM)0);

         if (pFolder->closeFolder & CLOSETREE)
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSETREE), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSETREE), BM_SETCHECK, MPFROMSHORT(0), (MPARAM)0);

         if (pFolder->closeFolder & CLOSEDETAIL)
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEDETAIL), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEDETAIL), BM_SETCHECK, MPFROMSHORT(0), (MPARAM)0);

         return (MRESULT)TRUE;

      case WM_CLOSE:
         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pFolder == NULL) 
             break;

         _wpFreeMem(pFolder->somSelf, (PBYTE)pFolder);
         return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));

      case WM_CONTROL:
         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pFolder == NULL) 
            break;

         switch (SHORT1FROMMP(mp1)) {

            case IDCHECK_CLOSENOTEBOOK:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  rc = WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_QUERYCHECK, (MPARAM)0, (MPARAM)0);

                  if ((USHORT)rc == 1)
                     pFolder->closeFolder |= CLOSENOTEBOOK;
                  else if ((USHORT)rc == 0)
                     pFolder->closeFolder &= ~CLOSENOTEBOOK;

                  _SetFolderClose(pFolder->somSelf, pFolder->closeFolder);

                  /* 
                   * I don't know why, but the falg sometimes doesn't get saved properly
                   * Save it explicitly now
                   */
                  _wpSaveImmediate(pFolder->somSelf);
               }

               break;

            case IDCHECK_CLOSECONTENT:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  rc = WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSECONTENT), BM_QUERYCHECK, (MPARAM)0, (MPARAM)0);

                  if ((USHORT)rc == 1)
                     pFolder->closeFolder |= CLOSECONTENT;
                  else if ((USHORT)rc == 0)
                     pFolder->closeFolder &= ~CLOSECONTENT;

                  _SetFolderClose(pFolder->somSelf, pFolder->closeFolder);

                  /*
                   * I don't know why, but the falg sometimes doesn't get saved properly
                   * Save it explicitly now
                   */
                  _wpSaveImmediate(pFolder->somSelf);
               }

               break;

            case IDCHECK_CLOSETREE:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  rc = WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSETREE), BM_QUERYCHECK, (MPARAM)0, (MPARAM)0);

                  if ((USHORT)rc == 1)
                     pFolder->closeFolder |= CLOSETREE;
                  else if ((USHORT)rc == 0)
                     pFolder->closeFolder &= ~CLOSETREE;

                  _SetFolderClose(pFolder->somSelf, pFolder->closeFolder);

                  /*
                   * I don't know why, but the falg sometimes doesn't get saved properly
                   * Save it explicitly now
                   */
                  _wpSaveImmediate(pFolder->somSelf);
               }

               break;

            case IDCHECK_CLOSEDETAIL:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  rc = WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEDETAIL), BM_QUERYCHECK, (MPARAM)0, (MPARAM)0);

                  if ((USHORT)rc == 1)
                     pFolder->closeFolder |= CLOSEDETAIL;
                  else if ((USHORT)rc == 0)
                     pFolder->closeFolder &= ~CLOSEDETAIL;

                  _SetFolderClose(pFolder->somSelf, pFolder->closeFolder);

                  /*
                   * I don't know why, but the falg sometimes doesn't get saved properly
                   * Save it explicitly now
                   */
                  _wpSaveImmediate(pFolder->somSelf);
               }

               break;

         }
      
         return (MRESULT)TRUE;
   }

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));
} 

/*************************************************************************
 *
 * Window procedure : CloseKeyDlgProc
 *
 *************************************************************************/

MRESULT EXPENTRY CloseKeyDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   SHORT sCount;
   CHAR str[CCHMAXPATH];
   PFOLDERKEY pFolder;

   switch (msg) {
      case WM_INITDLG:
         pFolder = (PFOLDERKEY)_wpAllocMem((WPFldExt *)mp2, sizeof(FOLDERKEY), NULL);

         if (pFolder) {
            memset((PVOID)pFolder, 0, sizeof(FOLDERKEY));
            pFolder->cb = sizeof(FOLDERKEY);
            pFolder->somSelf = (WPFldExt *)mp2;
         }
         else
            break;

         WinSetWindowPtr(hwndDlg, QWL_USER, pFolder);

         for (sCount=0; sCount < MAXKEY; sCount++) {
            WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), _clsQueryModuleHandle((M_WPFldExt *)_somGetClass(pFolder->somSelf)), (ULONG)(IDSC_SHIFT + sCount), CCHMAXPATH, str);

            WinSendMsg(WinWindowFromID(hwndDlg, IDCOMBO_KEYSELECTION), LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(str));
         }

         _FindKeyFromScancode(pFolder->somSelf, virtualKey, str);
         WinSetWindowText(WinWindowFromID(hwndDlg, IDCOMBO_KEYSELECTION), str);
         return (MRESULT)TRUE;

      case WM_CLOSE:

         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pFolder == NULL)
             break;

         _wpFreeMem(pFolder->somSelf, (PBYTE)pFolder);
         return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));

      case WM_CONTROL:

         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pFolder == NULL)
            break;

         switch (SHORT1FROMMP(mp1)) {

            case IDCOMBO_KEYSELECTION:

               if (SHORT2FROMMP(mp1) == CBN_ENTER) {
                  WinQueryWindowText(WinWindowFromID(hwndDlg, IDCOMBO_KEYSELECTION), CCHMAXPATH, str);
                  virtualKey = _FindScancodeFromKey(pFolder->somSelf, str);
                  PrfWriteProfileData(HINI_USERPROFILE, "WPFldExt", "WPFldExt", &virtualKey, sizeof(LONG));
               }

               break;
         }

         return (MRESULT)TRUE;
   }

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}

/*************************************************************************
 *
 * Window procedure : GoBackDlgProc
 *
 *************************************************************************/

MRESULT EXPENTRY GoBackDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   WPFldExt *desktopFolder;
   PGOBACKOPTION pGoBack;
   MRESULT rc;

   switch(msg) {
      case WM_INITDLG:
         pGoBack = (PGOBACKOPTION)_wpAllocMem((WPFldExt *)mp2, sizeof(GOBACKOPTION), NULL);

         if (pGoBack) {
            memset((PVOID)pGoBack, 0, sizeof(GOBACKOPTION));
            pGoBack->cb = sizeof(GOBACKOPTION);
            pGoBack->somSelf = (WPFldExt *)mp2;
            pGoBack->closeCurrent = _QueryCurrentClose(pGoBack->somSelf);
         }
         else
            break;

         WinSetWindowPtr(hwndDlg, QWL_USER, pGoBack);

         desktopFolder = _wpclsQueryFolder((M_WPFldExt *)_somGetClass(pGoBack->somSelf), "<WP_DESKTOP>", FALSE);

         if (desktopFolder == pGoBack->somSelf) {
            WinEnableWindow(WinWindowFromID(hwndDlg, IDGROUP_GOBACK), FALSE);
            WinEnableWindow(WinWindowFromID(hwndDlg, IDRADIO_CLOSE), FALSE);
            WinEnableWindow(WinWindowFromID(hwndDlg, IDRADIO_DONOTCLOSE), FALSE);
         }

         if (pGoBack->closeCurrent)
            WinSendMsg(WinWindowFromID(hwndDlg, IDRADIO_CLOSE), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDRADIO_DONOTCLOSE), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);

         return (MRESULT)TRUE;

      case WM_CLOSE:
         pGoBack = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pGoBack == NULL)
             break;

         _wpFreeMem(pGoBack->somSelf, (PBYTE)pGoBack);
         return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));

      case WM_CONTROL:
         pGoBack = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pGoBack == NULL)
            break;

         switch (SHORT1FROMMP(mp1)) {

            case IDRADIO_CLOSE:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  pGoBack->closeCurrent = TRUE;
                  _SetCurrentClose(pGoBack->somSelf, pGoBack->closeCurrent);

                  /*
                   * I don't know why, but the falg sometimes doesn't get saved properly
                   * Save it explicitly now
                   */
                  _wpSaveImmediate(pGoBack->somSelf);
               }

               break;

            case IDRADIO_DONOTCLOSE:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  pGoBack->closeCurrent = FALSE;
                  _SetCurrentClose(pGoBack->somSelf, pGoBack->closeCurrent);

                  /*
                   * I don't know why, but the falg sometimes doesn't get saved properly
                   * Save it explicitly now
                   */
                  _wpSaveImmediate(pGoBack->somSelf);
               }

               break;
         }

         return (MRESULT)TRUE;
   }

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}

