#ifndef _BUBBLEPD_HH
#define _BUBBLEPD_HH

#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include "bubblepd.h"

#pragma SOMAsDefault(on)
#include <som.hh>
#include <somcls.hh>
#pragma SOMNoMangling(on)
#include <WPLNCHPD.hh>

#define BLDLEVEL_VENDOR		"(c) Chris Wohlgemuth (christopher.wohlgemuth@bch.siemens.de)"
#define BLDLEVEL_VERSION		"V1.02 (20.08.98)"
#define BLDLEVEL_INFO		"BubblePad -Bubblehelp for the launchpad"

class M_WPLnchCW:public M_WPLaunchPad
{
#pragma SOMClassName(*,"M_WPLnchCW")
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
public:
	virtual PSZ  wpclsQueryTitle();
		
#pragma SOMReleaseOrder()
};

class WPLnchCW:public WPLaunchPad
{
#pragma SOMClassName(*,"WPLnchCW")
#pragma SOMMetaClass(*,"M_WPLnchCW")
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
private:
public:
	ULONG noDrawers;
  ULONG  delayValue;    //delay for bubble
  ULONG  bubbleEnabled;
	ULONG  smallSizeEnabled;//For sizereducing of Launchpad
	ULONG  icondistance;// Distance of Launchpadicons from the border 
	ULONG ulOpenDrawers;//bit n  indicates open drawer #n
	RGB  background;
	RGB  foreground;
	char   fontName[FONTNAMELENGTH];
	virtual ULONG wpQueryHideDrawers(){return noDrawers;};
	virtual void wpSetHideDrawers(ULONG ulHide){noDrawers=ulHide;};
	virtual void wpRefreshDrawer(ULONG ulDrawer);
	virtual void wpSetDrawerHWND(ULONG ulDrawer,HWND hwnd);
	virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
	virtual BOOL wpAddLaunchPadPage2(HWND hwndNotebook);
	virtual BOOL wpRestoreState(ULONG ulReserved);
	virtual BOOL wpSaveState();
	virtual HWND wpOpen(HWND hwndCnr,ULONG ulView,ULONG ulParam);
	virtual ULONG AddBubblehelpPage(HWND hwndNotebook);
	virtual ULONG AddColorchangePage(HWND hwndNotebook);
	virtual ULONG AddOptionPage(HWND hwndNotebook);

#pragma SOMReleaseOrder(\
AddBubblehelpPage(HWND hwndNotebook),\
AddColorchangePage(HWND hwndNotebook),\
AddOptionPage(HWND hwndNotebook),\
wpQueryHideDrawers(),\
wpSetHideDrawers(ULONG ulHide))
};

#endif


















