/* Adapted from:
   apptype.c, Written by Eberhard Mattes and put into the public domain

Notes:
1. Qualify the filename so that DosQueryAppType does not do
   extraneous searches.

2. DosQueryAppType will return FAPPTYP_DOS on a file ending with ".com"
   (other than an OS/2 exe or Win exe with this name). Eberhard Mattes
	remarks Tue, 6 Apr 93:
	  Moreover, it reports the type of the (new and very bug ridden) Win
	  Emacs as "OS/2 executable".

3. apptype uses the filename if given, otherwise a tmp file is created
	with the contents of buf. If buf is not the complete file, apptype
	can incorrectly identify the exe type. The "-z" option of "file" is
	the reason for this ugly code.
*/


#if defined (MSDOS) || defined (__WIN32__)

int 
apptype (char *fn, char *buf, int nb)
{
	return(0); 			/* No special checks under MSDOS */
}

#else

#define INCL_DOSSESMGR
#define INCL_DOSERRORS
#include <os2.h>
#if defined (MSC)
#include "fapptyp.h"
typedef 	USHORT	APPTYPE;
#define DosQueryAppType(path, ptype)	DosQAppType(path, ptype);
#else
typedef	ULONG		APPTYPE;
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern void  ckfputs		(const char *, FILE *);

int 
apptype (char *fn, char *buf, int nb)
{
	APPTYPE	rc, type;
	char	path[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR],
			fname[_MAX_FNAME], ext[_MAX_EXT], *filename;
	FILE	*fp;

	if (fn)
		filename = fn;
	else 
		if ((filename = tempnam("./", "tmp")) == NULL) {
			error("can't create tempnam (%s).\n", strerror(errno));
			/*NOTREACHED*/
		}

	/* qualify the filename to prevent extraneous searches */
	_splitpath(filename, drive, dir, fname, ext);
	sprintf(path, "%s%s%s%s", drive,
			(*dir == '\0') ? "./" : dir,
			fname,
			(*ext == '\0') ? "." : ext);

	if (fn == NULL) {
		if ((fp = fopen(path, "wb")) == NULL) {
			error("can't open tmp file '%s' (%s).\n", path, strerror(errno));
			/*NOTREACHED*/
		}
		if (fwrite(buf, 1, nb, fp) != nb) {
			error("can't write tmp file '%s' (%s).\n", path, strerror(errno));
			/*NOTREACHED*/
		}
		fclose(fp);
	}

  	rc = DosQueryAppType (path, &type);
	
	if (fn == NULL) {
		unlink(path);
		free(filename);
	}

/*
      if (rc == ERROR_INVALID_EXE_SIGNATURE) 
        printf ("%s: not an executable file\n", fname); 
      else if (rc == ERROR_FILE_NOT_FOUND) 
        printf ("%s: not found\n", fname); 
      else if (rc == ERROR_ACCESS_DENIED)
        printf ("%s: access denied\n", fname);
      else if (rc != 0)
        printf ("%s: error code = %lu\n", fname, rc);
      else
*/

	if (rc)
		return(0);
   if (type & FAPPTYP_32BIT)
   	ckfputs("32-bit ", stdout); 
   if (type & FAPPTYP_PHYSDRV) {
    	ckfputs("physical device driver", stdout);
	}
   else if (type & FAPPTYP_VIRTDRV) {
    	ckfputs("virtual device driver", stdout);
	}
   else if (type & FAPPTYP_DLL) {
		if (type & FAPPTYP_PROTDLL)
 	   	ckfputs("protected ", stdout);
			ckfputs("DLL", stdout);
   }
   else if (type & (FAPPTYP_WINDOWSREAL|FAPPTYP_WINDOWSPROT)) {
   	ckfputs("Windows executable", stdout);
	}
   else if (type & FAPPTYP_DOS) {
		/* The API routine is partially broken on filenames ending ".com". */
		if (stricmp(ext, ".com") == 0)
			if (strncmp(buf, "MZ", 2)) return(0);
		ckfputs("DOS executable", stdout);
		/* ---------------------------------------- */
		/* Might learn more from the magic(4) entry */
		ckfputs(", magic(4)-> ", stdout);
		return(0);
		/* ---------------------------------------- */
	}
   else if (type & FAPPTYP_BOUND) {
		ckfputs("bound executable", stdout);
	}
   else if ((type & 7) == FAPPTYP_WINDOWAPI) {
 	   ckfputs("PM executable", stdout);
	}
   else
    	ckfputs("OS/2 executable", stdout);

	switch(type & (FAPPTYP_NOTWINDOWCOMPAT |
							FAPPTYP_WINDOWCOMPAT |
							FAPPTYP_WINDOWAPI)) {
		case FAPPTYP_NOTWINDOWCOMPAT:
			ckfputs(" [NOTWINDOWCOMPAT]", stdout);
			break;
		case FAPPTYP_WINDOWCOMPAT:
			ckfputs(" [WINDOWCOMPAT]", stdout);
			break;
		case FAPPTYP_WINDOWAPI:
			ckfputs(" [WINDOWAPI]", stdout);
			break;
		}
  return (1);
}
#endif
