/********************************************************************/
/* Suchen und Ersetzen von Texten in Dateien (z.B. txt, html, ...)  */
/* x-change.CMD	Version 0.62   11. berarbeitung vom 07.06.97       */
/*                                                                  */
/* Bjoern Erik Wenz, 11th version Mai 1997, sirius@poboxes.com      */
/*                                                                  */
/* Kurzbeschreibung: Sucht rekursiv alle Dateien, auf welche die    */
/* Datei-Suchmaske passt und ersetzt den Suchtext durch den neuen   */
/* Text und schreibt bei Bedarf die Liste in eine Kontroll-Datei.   */
/********************************************************************/
/*	!!!	BETA-Version	   !!!	!!!	BETA-version	!!! */
/*                                                                  */
/* Dieses Script darf beliebig weiterverwendet werden, solange es   */
/* UNverndert bleibt und dieser Header NICHT geloescht wird.       */
/*                                                                  */
/* Hinweise zur Verbesserung diese Scriptes sind IMMER WILLKOMMEN!  */
/********************************************************************/
/* Dieses Script habe ich zur dazu geschrieben, meine Web-Admin     */
/* Ttigkeit zu erleichtern, was auch geglckt ist. Ich werde ver-  */
/* suchen dieses Script zu warten und stetig zu verbessern - aber   */
/* ich versteife mich nicht darauf. Ich helfe bei Fragen gerne -    */
/* aber eine verpflichtung auf eine schnelle Antwort gibt's nicht.  */
/* Trotsdem - Fragen kostet nix!      ;-)                           */
/********************************************************************/
/* Ich werde die aktuellste Version immer hier deponieren:          */
/*      ftp.leo.org/pub/comp/os2/...                                */
/*   ftp.pmnet.uni-oldenburg.de//pub/Sortiertes/os2/tcpip/diverses  */
/*   Datei: x-change-bx_xx.zip (b=beta ,x_xx = Versionsnummer)      */
/********************************************************************/
/* Aufruf: [] = optionaler parameter, Reihenfolge beachten	    */
/* x-change datei_suchmaske suchtext neuer_text [listendatei] [opt.]*/
/*		datei_suchmaske: z.b: e:\freemind\*.htm		    */
/*		suchtext: Datei in der der Suchtext steht	    */
/*		neuer_text: Datei in der der neue Text steht	    */
/*		listendatei: Datei, in die die Liste der vernderten*/
/*				Dateien geschrieben/angehngt wird  */
/* Anmerkung: Die listendatei kann auch weggelassen werden !	    */
/*	opt.: Optionsschalter, wie folgend aufgelistet.		    */
/*		/t	dateinamen werden als text interpretiert    */
/*	oder	/t:ziel dateinamen werden als text interpretiert    */
/*           und die vernderten Dateien werden nach ziel kopiert   */
/*	oder	/h	es wird auf html-konforme-umlaute geprft   */
/*           suchtext und neuer_text dabei bitte als . angeben      */
/*	oder	/h:ziel	es wird auf html-konforme-umlaute geprft   */
/*           und die vernderten Dateien werden nach ziel kopiert   */
/* oder /c:ziel  die vernderten Dateien werden nach ziel kopiert   */
/* oder /w    es wird auf Windows-Umlaute (andere codepage) geprft */
/*              und diese werden in html-umlaute verwandelt         */
/* oder /w:ziel dto, nur mit verschieben der genderten Dateien     */
/* oder /z      Erzeugen eines Zhlers-Eintrages aus dem Dateinamen */
/* oder /z:ziel dto, nur mit verschieben der genderten Dateien     */
/* Der Zhler wird aus verschiedenen Variablen gebildet, die hier   */
/* am Anfang gesetzt werden, und an <img src=" angehngt werden.    */
/* Der Names der Zhl-Datei wird aus dem Ziel-Dateinamen gebildet   */
/* Das ganze ist auf den Counter 'Count.cgi' optimiert.             */
/*      Zhler-Variablen:                                           */
/*       count_cgi: Aufruf des cgi-scriptes (/cgi-bin/Count.cgi?)   */
/*       count_file: aufruf des files (df=fm-, fm-=opt. Namensteil) */
/*       count_name: Automatisch generierter Namens-Teil            */
/*              wird nur generiert, wenn nicht angegeben (='')      */
/*       count_end: endung des counter-files (.dat)                 */
/*       count_option: optionen fr den counter (&sh=N)             */
/*       count_img_option: optionen fr den img-Aufruf              */
/*       count_position: eine Zeile vor diesem sitzt der Counter    */
/*              solllte sinniger weise nur 1 mal vorkommen :-)      */
/*       count_call: Kompletter Counter-Aufruf-String incl. CrLf    */
/*              wird nur generiert, wenn nicht angegeben (='')      */
/*              Aber immer wird er vor count_position gesetzt       */
/*      count_vor / count_nach: CrLf vor/nach <img ...>             */
/*                                                                  */
/* Zur Zeit nur unter os2 lauffhig - Work's only under os2 yet	    */
/********************************************************************/

/* Variablen fr /z definieren */
/* Aufruf: '<img src="'||count_cgi||count_file||count_name||count_end||count_option||'"'||count_img_option||'>' */
count_cgi='http://www.freemind.de/cgi-bin/Count.cgi?';
count_prefix='fm-';
count_file='df='||count_prefix;
count_name='';
count_end='.dat';
count_option='&sh=N';
count_img_option=' border=0 width=1 height=1';
count_position='</BODY>';
count_call='';
count_vor=1;
count_nach=1;
verz_count_erst="f:\web\freemind-www-upload"; /* verzeichnis, wo die dazugehrigen Counter-Dateien erstellt werden */
verz_count_ja=1; /* ob verz_count_erst genutzt werden soll */

/* RexxUtil-Funktionen laden */
CALL RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* Argumente einlesen */
PARSE ARG datei_suchmaske suchtext neuer_text listendatei option;
if option = '' then
	do
	if left(listendatei,1) = "/" then
		do
		option = listendatei;
		listendatei = ''
		end;
	end;
if suchtext = '' then
	CALL FALSCHER_AUFRUF;
		
/************************************************************************/
/***********	Fehlerbehandlung			     ************/
/************************************************************************/
SIGNAL ON Syntax;
SIGNAL ON NoValue;
SIGNAL ON NotREADY;
SIGNAL ON Halt;
SIGNAL ON Failure;
SIGNAL ON Error;

/************************************************************************/
/***********	Hauptprogramm			             ************/
/************************************************************************/

rc=time('R');
say time()||' '||Date()

umlaute_umwandeln=0; /* 0=nicht, 1=uml->html, 2=winum->html, (3=winum->uml) */
dateien_kopieren=0;
counter_insert=0;
select
when left(option,3) = '/c:' then
	do
        dateien_kopieren=1
        dateien_ziel=substr(option,4,length(option)-3)
	suchen=DateiEinlesen(suchtext);
	ersetzen=DateiEinlesen(neuer_text);
	end;
when option = '/h' then
	do
        umlaute_umwandeln=1;
/*	suchen=DateiEinlesen(suchtext);*/
/*	ersetzen=DateiEinlesen(neuer_text);*/
/* noch auskommentiert - wenn die prfung automatisch bei jeder umwandlung durchgefhrt wird */
/* dann kommt dieser Teil zur Verwendung - dazu mu aber die Austausch-Routine anders werden */
	end;
when left(option,3) = '/h:' then
	do
        dateien_kopieren=1
        dateien_ziel=substr(option,4,length(option)-3)
        umlaute_umwandeln=1;
	end;
when option = '/t' then
	do
	suchen=suchtext;
	ersetzen=neuer_text;
	end;
when left(option,3) = '/t:' then
	do
        dateien_kopieren=1
        dateien_ziel=substr(option,4,length(option)-3)
	suchen=suchtext;
	ersetzen=neuer_text;
	end;
when option = '/w' then
	do
        umlaute_umwandeln=2;
	end;
when left(option,3) = '/w:' then
	do
        dateien_kopieren=1
        dateien_ziel=substr(option,4,length(option)-3)
        umlaute_umwandeln=2;
	end;
when option = '/z' then
	do
        suchen=count_position;
        ersetzen='';
        counter_insert=1;
	end;
when left(option,3) = '/z:' then
	do
        dateien_kopieren=1
        dateien_ziel=substr(option,4,length(option)-3)
        suchen=count_position;
        ersetzen='';
        counter_insert=1;
	end;
otherwise
	do
	suchen=DateiEinlesen(suchtext);
	ersetzen=DateiEinlesen(neuer_text);
	end;
end;

MASKE=datei_suchmaske

CALL SysFileTree MASKE, 'FILE', 'FSO'

if file.0 < 1 then
do
	Say 'Keine passenden Dateien zu ' maske ' gefunden'
	signal programm_ende
end;

d=0;
dn=0;
DO x=1 TO file.0
	say copies('*', 40);
	say x;
	Say 'Bearbeite Datei:' file.x;
	datei_veraendert=Austausch(FILE.x);
	if datei_veraendert <> '0' then
	do
		d=d+1;
		datei_liste.d = file.x;
	end;
	else
	do
		dn=dn+1;
		datei_liste_nicht.dn = file.x;
	end;
	
END;

say ''
say copies('# ', 30);
say 'Folgende ' d ' Dateien wurden verndert:'
if d <> 0 then
do x=1 to d
	say x'. ' datei_liste.x
end
else Say 'Keine Datei mute gendert werden.'

If listendatei <> '' then
do
	CrLf = D2C(13)''D2C(10);
	rc=lineout(listendatei, CrLf);
	rc=lineout(listendatei, copies('+', 50));
	rc=lineout(listendatei, time()||' '||Date()||CrLf);
	rc=lineout(listendatei, 'nderungen an '||maske)
        if counter_insert=1 then rc=lineout(listendatei, ' - Fr die folgenden dateien wurde automatisch ein Counter-eingefgt.');
        if umlaute_umwandeln=1 then rc=lineout(listendatei, ' - Nach richtigen Umlaut-Enities wurde geprft.');
        if umlaute_umwandeln=2 then rc=lineout(listendatei, ' - Nach alten Windows-Codepage-Umlaten wurde gesucht und in Umlaut-Enities gewandelt.');
        if umlaute_umwandeln=3 then rc=lineout(listendatei, ' - Nach alten Windows-Codepage-Umlaten wurde gesucht und in Umlaute gewandelt.');
	rc=lineout(listendatei, 'Es wurden '||d+dn||' Dateien am '||date()||' um '||time()||CrLf||' innerhalb von '||time('E')||' unter '||maske||' bearbeitet.');
        rc=lineout(listendatei, 'Dabei blieben '||dn||' unverndert und '||d||' wurden verndert.');
        if dateien_kopieren=1 then rc=lineout(listendatei, ' - Vernderte Dateien werden nach '||dateien_ziel||' kopiert. -');
	if d <> 0 then
	do x=1 to d
		rc=lineout(listendatei, x'.' datei_liste.x)
	end;
	else rc=lineout(listendatei, 'Keine Datei wurde verndert.');

	rc=lineout(listendatei, copies('+ ++ ', 5));

	if dn <> 0 then
	do x=1 to dn
		rc=lineout(listendatei, x'.' datei_liste_nicht.x 'blieb unverndert.')
	end;
	else rc=lineout(listendatei, 'Keine Datei blieb unverndert.');

	rc=lineout(listendatei);
        if dateien_kopieren=1 then Say ' - Vernderte Dateien werden nach '||dateien_ziel||' kopiert. -'
	Say 'Diese Dateiliste wurde in: ' listendatei ' gespeichert.'
end

programm_ende:
exit 0;

/************************************************************************/
/***********	Funktionen / Unterprogramme		     ************/
/************************************************************************/

/***********	DateiEinlesen	 **********/
/******************************************/
DateiEinlesen:
/* Einlesen einer datei in einen einzeiligen string                     */
/* Aufruf: variable_fr_dateiinhalt=DateiEinlesen(dateiname)            */
signal off notready;
CrLf = D2C(13)''D2C(10);
PARSE ARG datei; /* KEIN Punkt, damit auch Leerzeichendateinamen bertragen werden */
text = "";
rc=lineout(datei);
do while lines(datei) <> 0
	zeile = linein(datei);
	text = text || zeile || CrLf;
end;
text=left(text,length(text)-2);
rc=lineout(datei);
signal on notready;
return text;

/***********	Austausch     ***********/
/****************************************/
Austausch:
/* Durchsuchen von File nach 'suchen' und ersetzen durch 'ersetzen'.    */
/* Aufruf: Call Austausch dateiname					*/

PARSE ARG file; /* KEIN Punkt, damit auch Leerzeichendateinamen bertragen werden */

string=DateiEinlesen(file)
/*string=charin(file,1,length(file));*/

if umlaute_umwandeln=0 then
   do
        if counter_insert=1 then ersetzen=create_call(maske count_vor count_nach file);
        differenz=length(suchen)-length(ersetzen);

        /* 1a. Ermitteln der Anzahl der fundstellen in der Datei -> position.nr  */
        i=0;
        start=1;
        exit=0;
        do while exit=0 
        	i=i+1;
        	fundstelle=pos(suchen, string, start);
        	if fundstelle = 0 then exit=1;
        	else do
        		if i>0 then start=fundstelle+1;
                        fundstelle = fundstelle - ((i-1) *differenz);
        		position.i=fundstelle;
        	      end;	
        	position.0 = i-1
        end;

        If position.0 ='0' then signal nichts_gefunden;

        Say 'Es wurden ' position.0 ' zu ersetzende Stelle(n) gefunden' 

        /* 2a. Ersetzen der gefundenen strings */
        if counter_insert=1 then
           do
                if verz_count_ja=1 & 0=pos(ersetzen, string) then
                 do
                   if count_name='' then
                     verz_count_filename=verz_count_erst||'\'||count_prefix||translate(left(substr(file,lastpos('\',maske)+1),lastpos('.',substr(file,lastpos('\',maske)+1))-1),'_','\')||count_end;
                   else
                     verz_count_filename=verz_count_erst||'\'||count_prefix||count_name||count_end;
                   rc=lineout(verz_count_filename, '1');
                   rc=lineout(verz_count_filename);
                   say verz_count_filename 'wurde erstellt';
                 end /* do */ 
                   do i=1 to position.0 while 0=pos(ersetzen, string)
                	call string_ersetzen position.i;
                	If position.i<position.0 then position.i+1=pos(suchen, string, position.i);
                   end;
           end /* do */
        else
           do i=1 to position.0
        	call string_ersetzen position.i;
        	If position.i<position.0 then position.i+1=pos(suchen, string, position.i);
           end;
   end /* do */
else
   do
        /* 1b. Ermitteln der Anzahl der fundstellen in der Datei -> position.nr  */
        was_gefunden=0
	differenz=0
        DO y=1 to 7
           select
              when (y=1) & (umlaute_umwandeln=1) then umlaut=''
              when (y=2) & (umlaute_umwandeln=1) then umlaut=''
              when (y=3) & (umlaute_umwandeln=1) then umlaut=''
              when (y=4) & (umlaute_umwandeln=1) then umlaut=''
              when (y=5) & (umlaute_umwandeln=1) then umlaut=''
              when (y=6) & (umlaute_umwandeln=1) then umlaut=''
              when (y=7) & (umlaute_umwandeln=1) then umlaut=''
              when (y=1) & (umlaute_umwandeln=2) then umlaut=''
              when (y=2) & (umlaute_umwandeln=2) then umlaut=''
              when (y=3) & (umlaute_umwandeln=2) then umlaut=''
              when (y=4) & (umlaute_umwandeln=2) then umlaut=''
              when (y=5) & (umlaute_umwandeln=2) then umlaut=''
              when (y=6) & (umlaute_umwandeln=2) then umlaut=''
              when (y=7) & (umlaute_umwandeln=2) then umlaut=''
           otherwise
              SAY 'Fehler, y darf nicht > 7 sein!';
           end  /* select */
                i=0;
                start=1;
                exit=0;
                do while exit=0 
                	i=i+1;
                	fundstelle=pos(umlaut, string, start);
                	if fundstelle = 0 then exit=1;
                	else do
                		if i>0 then start=fundstelle+1;
                                fundstelle = fundstelle - ((i-1) *differenz);
                                position.i=fundstelle;
                	      end;	
                	position.0 = i-1
                end;
                if position.0 \= '0' then was_gefunden=was_gefunden+1
        end /* do */

        If was_gefunden ='0' then signal nichts_gefunden;

        Say 'Es wurden zu ersetzende Umlaute gefunden' 

        /* 2b. Ersetzen der gefundenen strings */
        select
           when umlaute_umwandeln=1 then string=htmltrans(string);
           when umlaute_umwandeln=2 then string=winhtmltrans(string);
        otherwise
        end  /* select */
   end /* do */

/* 3. Lschen der Datei und schreiben der veraenderten */
'@del' convertNameToOS(file);
rc=lineout(file, string);
rc=lineout(file);
/*rc=charout(file, string);*/
/*rc=charout(file);*/
if dateien_kopieren=1 then
do
        lokaler_pfad=left(maske,lastpos('\',maske)-1);
        zusatz_pfad_mit_datei=substr(file,length(lokaler_pfad)+1);
        zusatz_pfad=left(zusatz_pfad_mit_datei,lastpos('\',zusatz_pfad_mit_datei));
        dateien_ziel_pfad=dateien_ziel||zusatz_pfad;
   '@xcopy' convertNameToOS(file) dateien_ziel_pfad '/V'
end /* do */
was_ersetzt='1';

signal ende_austausch
nichts_gefunden:
Say 'In der datei ' file ' wurde der Suchstring nicht gefunden';
was_ersetzt='0';
ende_austausch:
return was_ersetzt;

/***********	htmltrans     ***********/
/****************************************/
htmltrans: procedure
/*   translates german umlaute to html-tags                         */
/*      Aufruf: htmltrans string-der geprft werden soll            */
parse arg line
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&szlig;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&auml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&ouml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&uuml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&Auml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&Ouml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&Uuml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
return line;

/***********   winhtmltrans   ***********/
/****************************************/
winhtmltrans: procedure
/*   translates german umlaute to html-tags                         */
/*      Aufruf: htmltrans string-der geprft werden soll            */
parse arg line
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&szlig;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&auml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&ouml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&uuml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&Auml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&Ouml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
  au=pos("",line)
  do while au <> 0
     line=left(line,au-1)||"&Uuml;"||right(line,length(line)-au)
     au=pos("",line,au+1)
  end /* do */
return line;

/***********	string_ersetzen	    ************/
/***********************************************/
string_ersetzen:
PARSE ARG stelle;

Say 'Ersetze Text an Position:' stelle
neuer_string=left(string,stelle-1) || ersetzen || substr(string,stelle+length(suchen));
string=neuer_string;
return;

/***********	  create_name	    ************/
/***********************************************/
create_name:
if count_name='' then
  do
        PARSE ARG count_name_ wildcard;
        /* count_name_: voller pfad der Zieldatei */
        /* wildcard: Suchpfad zur datei, der von dateiname abgezogen wird */
        count_name_=substr(count_name_,lastpos('\',wildcard)+1);
        count_name_=left(count_name_,lastpos('.',count_name_)-1);
        count_name_=translate(count_name_,'_','\');
  end /* do */
else
count_name_=count_name;
count_name_='<img src="'||count_cgi||count_file||count_name_||count_end||count_option||'"'||count_img_option||'>';
return count_name_;

/***********	  create_call	    ************/
/***********************************************/
create_call:
PARSE ARG file_maske anzahl_CrLf_vor anzahl_CrLf_nach file_name; /* KEIN Punkt, damit auch Leerzeichendateinamen bertragen werden */
/* count_position: string vor den der counter gesetzt wird */
if count_call='' then
do
        count_call_=create_name(file_name file_maske);
        do c=1 to anzahl_CrLf_vor by 1 while c<anzahl_CrLf_vor+1
                count_call_=CrLf||count_call_
        end /* do */
        do c=1 to anzahl_CrLf_nach by 1 while c<anzahl_CrLf_nach+1
                count_call_=count_call_||CrLf
        end /* do */
end /* do */
else
count_call_=count_call;
count_call_=count_call_||count_position;
return count_call_;

 /* ------------------------------------------------------------------ */
 /* function:  convert a file or directory name to OS conventions      */
 /*            by adding a leading and trailing quote or double quote  */
 /*                                                                    */
 /* call:      convertNameToOS dir_or_file_name                        */
 /*                                                                    */
 /* where:     dir_or_file_name = name to convert                      */
 /*                                                                    */
 /* returns:   converted file or directory name                        */
 /*                                                                    */
 ConvertNameToOS: PROCEDURE
   parse arg fileName
 
   if pos('"', fileName ) = 0 then
     fileName = '"' || fileName || '"'
   else if pos("'", filename ) = 0 then
     fileName = "'" || fileName || "'"
 
 RETURN fileName

/************************************************************************/
/***********	Fehlerbehandlungsroutinen		     ************/
/************************************************************************/
FALSCHER_AUFRUF:
SAY COPIES('*', 50)
SAY 'Falscher Aufruf! - Zuviele oder fehlende Parameter'
SAY ''
SAY 'Syntax: x-change datei_suchmaske suchtext neuer_text [listendatei] [opt.]'
SAY '           z.B: x-change e:\*.htm abc@xy.com xxx@abc.de /t'
SAY '   oder    x-change e:\*.htm peter paul liste.txt /t'
SAY '   oder    x-change e:\*.htm suchen.txt finden.txt liste.txt'
SAY '   opt.: Optionsschalter, wie folgend aufgelistet...'
SAY '           /t      dateinamen werden als text interpretiert'
SAY '   oder    /t:ziel dateinamen werden als text interpretiert'
SAY '        und die vernderten Dateien werden nach ziel kopiert'
SAY '   oder    /h      es wird auf html-konforme-umlaute geprft'
SAY '        suchtext und neuer_text dabei bitte als . angeben'
SAY '   oder    /h:ziel	es wird auf html-konforme-umlaute geprft'
SAY '        und die vernderten Dateien werden nach ziel kopiert'
SAY '   oder /c:ziel  die vernderten Dateien werden nach ziel kopiert'
SAY '   oder /w    es wird auf Windows-Umlaute (andere codepage) geprft'
SAY '              und diese werden in html-umlaute verwandelt'
SAY '   oder /w:ziel dto, nur mit verschieben der genderten Dateien'
SAY '   oder /z      Erzeugen eines Zhlers-Eintrages aus dem Dateinamen'
SAY '   oder /z:ziel dto, nur mit verschieben der genderten Dateien'
EXIT

ERROR:
SAY 'Es trat ein schwerer Fehler auf';
SAY 'Ein Syntaxfehler ' rc 'wurde festgestellt in Zeile:' sigl;
   say '-->' "ERRORTEXT"(rc)
   say "SOURCELINE"(sigl)
   trace ?r; nop
EXIT;

FAILURE:
SAY 'Es trat ein leichter Fehler auf';
SAY 'Ein Syntaxfehler ' rc 'wurde festgestellt in Zeile:' sigl;
   say '-->' "ERRORTEXT"(rc)
   say "SOURCELINE"(sigl)
   trace ?r; nop
EXIT;

HALT:
SAY 'Programm vom Nutzer abgebrochen in Zeile:' sigl;
EXIT;

NOTREADY:
SAY 'Es trat ein ein/ausgabe Fehler auf';
SAY 'Ein Syntaxfehler ' rc 'wurde festgestellt in Zeile:' sigl;
   say '-->' "ERRORTEXT"(rc)
   say "SOURCELINE"(sigl)
   trace ?r; nop
EXIT;

NOVALUE:
SAY 'Eine uninitialisierte Variable wurde bei PARSE VAR benutzt';
SAY 'Ein Syntaxfehler ' rc 'wurde festgestellt in Zeile:' sigl;
   say '-->' "ERRORTEXT"(rc)
   say "SOURCELINE"(sigl)
   trace ?r; nop
EXIT;

SYNTAX:
SAY 'Ein Syntaxfehler ' rc 'wurde festgestellt in Zeile:' sigl;
   say '-->' "ERRORTEXT"(rc)
   say "SOURCELINE"(sigl)
   trace ?r; nop
EXIT;

/**********************************************************/
/**********************************************************/
/**********************************************************/
/***********	            ENDE	       ************/
/**********************************************************/
/**********************************************************/
/**********************************************************/

/*
Versionen:
0.1	Ende Februar 97
	Die Grunddatei, mit 3 oder 4 parametern.
	Funktioniert 100%.

0.2	Anfang Mrz 97
	Schalter /t mit aufgenommen.
	Schreibfehler korrigiert und optimiert.

0.21	bug beim ersetzen repariert.
0.22    nur Schreibfehler Korrigiert

0.3     Mai 97
        Umwandeln von HTML-codes eingebunden

0.4     Mai 97
        schalter zum Kopieren der vernderten Dateien wurden hinzugefgt.
        /h:ziel - /c:ziel - /t:ziel

0.41    Mai 97
        Schalter /w und /w:ziel hinzugefgt
	Bugfix zu umlaute_umwandeln: Die strings sind gleich lang -> differenz=0

0.5     Mai 97
       	besseres 'errorhandling' eingebaut (kann aber noch optimiert werden)
        austausch: habe lineout durch charout ersetzt (doch nicht :-(, warum fehler?)

0.51    14.05.1997
	einige Bug-Fixes

0.60    15.05.1997
        schalter /z und /z: installiert

0.61    2.6.97
        Bugifx: /* alle Filenamen mit Leerzeichen in einen String mit Anfhrungszeichen verwandeln */

0.62    7.6.97
        Bugifx: Fehler beim Einlesen von Einzeiligen Dateien behoben (Falscher Abbruch weil angeblich nicht lesbar)
        Ist sie aber doch und wird auch, nur ist der Zeiger nicht auf die 2. Zeile steuerbar - deshalb der "Quasi-Fehler".
        Behoben durch SIGNAL ON NOTREADY umgeheung whrend des Einlesens. :-)

Ausblick auf weitere Versionen	(geplant):
	- option fr 'nur eine Datei', was dann auch unter anderen System Funktioniert.
	- optionale dll, die Sysfiletree simuliert, damit system-portabel (z.B: dosRexx)
          Achtung: wer will oder kann mir eine SysFileTree (simple C-Programmierung aufgrund DisFindFirst/Next) schreiben?
          (Als DLL zum einbinden.) Mail bitte an sirius@poboxes.com
	- optimierte und besser steuerbare Listenausgabe ber Schalter
####        (- umstellung der Schalterauswertung: Seit 0.60 Implementiert, oder wer hat 'ne bessere Idee?)
        - schalter /s, mit dem alle Dateien der Suchmaske gescannt werden, und sollte eine
                Zeile lnger als 255 Zeichen sein, beim letzten Leerzeichen oder zwischen
                den Tags (also zw. ><) einen Zeilenumbruch erzeigt.

Tips und Anregungen nehme ich gerne unter sirius@poboxes.com, Subject:x-change.cmd entgegen.
*/
