/* Copyright (c)1997 Kari Jackson for InnoVal Systems Solutions, Inc. */

/*---------------------------------------------*/
/* Export NetExtra or WebWilly bookmarks to a  */
/* text file for import into the opposite      */
/* program or another installation of the same */
/* program.                                    */
/*---------------------------------------------*/
/* Instructions:                               */
/* To export one folder, specify that folder's */
/* complete pathname as BKMK2ASC.CMD's command */
/* line argument.  Or to export all of the     */
/* folders at once, execute without arguments  */
/* while the program's BOOKS subdirectory is   */
/* the session's current directory.  Either    */
/* way, the bookmarks will be exported into a  */
/* file named BOOKMARK.ASC in the current      */
/* directory.  ASC2BKMK.CMD can then create    */
/* WebWilly or NetExtra bookmarks from that    */
/* text file.                                  */
/*---------------------------------------------*/
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
signal on syntax name NoREXX
call SysLoadFuncs
signal on syntax name Syntax
"@ECHO OFF"
parse upper arg args
testdir=args
if testdir="" then testdir=translate(directory())
parse var testdir before "\BOOK" after
if after="S" | left(after,2)="S\" then do
   neticon=stream(before"\neticon.dll","c","query exists")
   pgevalid=stream(before"\pgevalid.dll","c","query exists")
   webdate=stream(before"\webdate.dll","c","query exists")
   if neticon="" & pgevalid<>"" & webdate<>"" then fromprog="WEBWILLY"
   if neticon<>"" & pgevalid="" & webdate="" then fromprog="NETEXTRA"
end
if fromprog="FROMPROG" then do
   say ""
   say "Input WebWilly for Windows, or NetExtra/WebWilly for OS/2 format?  (W/O)"
   do until answer="W" | answer="O"
      answer=translate(sysgetkey())
   end
   if answer="O" then fromprog="NETEXTRA"
   else fromprog="WEBWILLY"
end
if args<>"" then do
   call sysfiletree args,"folders.","O"
   if folders.0<>1 then do
      say ""
      say "There are either zero or multiple directories named" args"."
      say "Please type one single existing directory name."
      exit
   end
   foldername=substr(folders.1,lastpos("\",folders.1)+1)
   if fromprog="NETEXTRA" then call SysGetEA folders.1,"WEBEXFOLDERNAME","title"
   else do
      title=""
      do while lines(folders.1"\"foldername".ES")
         title=linein(folders.1"\"foldername".ES")
      end
      if stream(folders.1"\"foldername".ES")<>"UNKNOWN" then call lineout folders.1"\"foldername".ES"
   end
   if title="" then title=foldername
   folders.1=folders.1 title
end
else do
   currdir=directory()
   if translate(right(currdir,6))<>"\BOOKS" then do
      say
      say "Please execute this program from within WebWilly's or NetExtra's BOOKS"
      say "subdirectory or else specify the full path to the folder to be exported."
      exit
   end
   folders.0=0
   filename="fldindex.nix"
   do while lines(filename)
      line=linein(filename)
      parse var line dirname "09"x title "09"x parent "09"x .
      if fromprog="NETEXTRA" then call SysGetEA parent"\"dirname,"WEBEXFOLDERNAME","chktitle"
      else do
         chktitle=""
         do while lines(parent"\"dirname"\"dirname".ES")
            chktitle=linein(parent"\"dirname"\"dirname".ES")
         end
         if stream(parent"\"dirname"\"dirname".ES")<>"UNKNOWN" then call lineout parent"\"dirname"\"dirname".ES"
      end
      if chktitle="" then chktitle=title
      folders.0=folders.0+1
      number=folders.0
      folders.number=parent"\"dirname chktitle
   end
   if stream(filename,"c","query exists")<>"" & stream(FILENAME)<>"UNKNOWN" then call lineout FILENAME
   drop currdir filename line dirname title parent number
   call sysfiletree "*.*","dirs","DSO"
   do i=1 to dirs.0
      folders.0=folders.0+1
      number=folders.0
      foldername=substr(dirs.i,lastpos("\",dirs.i)+1)
      drop title
      if fromprog="NETEXTRA" then call SysGetEA dirs.i,"WEBEXFOLDERNAME","title"
      else do
         title=""
         do while lines(dirs.i"\"foldername".ES")
            title=linein(dirs.i"\"foldername".ES")
         end
         if stream(dirs.i"\"foldername".ES")<>"UNKNOWN" then call lineout dirs.i"\"foldername".ES"
      end
      if title="" then title=foldername
      folders.number=dirs.i title
   end
   drop dirs. number title
end
outfile="bookmark.asc"
do i=1 to folders.0
   call lineout outfile, ""
   call lineout outfile, center(subword(folders.i,2),80)
   call lineout outfile, center(word(folders.i,1),80)
   call lineout outfile, center(copies("-",60),80)
   call sysfiletree word(folders.i,1)"\*.URL","files","FT"
   do j=1 to files.0
      parse var files.j y "/" mo "/" d "/" h "/" min size attrib name
      name=strip(name)
      if fromprog="WEBWILLY" then do
         currentfolder=word(folders.i,1)
         spot=lastpos("\",currentfolder)
         foldername=substr(currentfolder,spot+1)
         if translate(name)=translate(currentfolder||"\"||foldername||".URL") then iterate
         eas=""
         do while lines(name)
            eas=linein(name)
         end
         if stream(name)<>"UNKNOWN" then call lineout name
         if eas="" then iterate
      end
      else do
         call SysGetEA name,"URLFILEBUFFER","eas"
         if eas='' then iterate
      end
      parse var eas . "17"x title "09"x url "09"x date "09"x time "09"x sticky "09"x . "09"x userid "09"x password "09"x .
      if length(date)=5 then do
         if wordpos(y,"96 97 98 99")>0 then y="19"||y
         else y="20"||y
         date=y||"/"||date
      end
      if length(date)=8 then do
         parse var date mm "/" dd "/" yy
         if yy>95 then yy="19"yy
         else yy="20"yy
         date=yy"/"mm"/"dd
      end
      if fromprog="NETEXTRA" & sticky="01"x then do
         call SysGetEA name,"STICKEYDATE","stickydate"
         call sysgetea name,"STICKEYTEXT","stickytext"
         call sysgetea name,"STICKEYFOLLOWUP","stickyfollowup"
         check=""
         do until stickytext=""
            parse var stickytext this "0D"x stickytext
            this=translate(this," ","0A"x)
            if strip(this)="" then iterate
            if check="" then check=strip(this)
            else check=check||"09"x||strip(this)
         end
         stickytext=check
      end
      else if sticky="01"x then do
         stickyfollowup=0
         stickycontents=""
         stickyfile=substr(name,1,lastpos(".",name))||"STK"
         do while lines(stickyfile)
            stickyline=linein(stickyfile)
            if strip(stickyline)="" then iterate
            if stickycontents="" then stickycontents=stickyline
            else stickycontents=stickycontents||"09"x||stickyline
         end
         if stream(stickyfile)<>"UNKNOWN" then call lineout stickyfile
         parse var stickycontents stickydate 9 stickytext
      end
      if stickytext="STICKYTEXT" then stickytext=""
      if stickydate="STICKYDATE" then stickydate=""
      if stickyfollowup="STICKYFOLLOWUP" then stickyfollowup=""
      call lineout outfile, title||"09"x||url||"09"x||date||"09"x||time||"09"x||sticky||"09"x||userid||"09"x||password||"09"x||stickydate||"09"x||stickyfollowup||"09"x||stickytext
   end
end
exit
Syntax:
  say "Error" rc": " errortext(rc)
  say "Line" sigl": " sourceline(sigl)
  exit
return
NoREXX:
   say "Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file"
   say "is not on the LIBPATH or REXX support is not installed on this system."
   exit
return
