/* WebMail/2 v5.0 Dimitris 'sehh' Michelinakis <dimitris@michelinakis.gr> */

Globals.!serv=127.0.0.1 /* IP address of the machine running WebManager */
Globals.!port=1924      /* Port that WebManager listens to */
Globals.!WMPath=""      /* Path to .WM files, default is %etc%\webmailhtml */
Globals.!MaxEmails=10   /* Maximum emails listed per page */

/* WebMail/2 */
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'SockLoadFuncs','RxSock','SockLoadFuncs'
call SockLoadFuncs(1)
call RxFuncAdd 'DCLoadFuncs','rxDCplus','DCLoadFuncs'
call DCLoadFuncs
Globals.!myinfo="WebMail/2 for OS/2"
Globals.!myself=value("SCRIPT_NAME",,'os2environment')
if Globals.!WMPath="" then Globals.!WMPath=value("ETC",,'os2environment')||"\webmailhtml"
if value("REQUEST_METHOD",,'os2environment')="GET" then do
 if pos(Globals.!myself,value("HTTP_REFERER",,'os2environment'))<1 then call UserLoginScreen
 Globals.!querystring=URLDecode(value("QUERY_STRING",,'os2environment'))
 parse value Globals.!querystring with Globals.!stat1 "&" Globals.!stat2 "&" Globals.!stat3
 if pos("refresh",Globals.!stat1)=1 then call CheckLogon "checkemail"
 else if pos("read",Globals.!stat1)=1 then call CheckLogon "read"
 else if pos("new",Globals.!stat1)=1 then call CheckLogon "new"
 else if pos("delete",Globals.!stat1)=1 then call CheckLogon "delete"
 else if pos("logoff",Globals.!stat1)=1 then call CheckLogon "logoff"
 else if pos("download",Globals.!stat1)=1 then call CheckLogon "download"
 else if pos("help",Globals.!stat1)=1 then call CheckLogon "help"
 else if pos("addr",Globals.!stat1)=1 then call CheckLogon "addr"
 else if pos("userscr",Globals.!stat1)=1 then call NewUserScreen
end; else do
 Globals.!ContentLength=value("CONTENT_LENGTH",,'os2environment')
 if Globals.!ContentLength>0 then Globals.!querystring=charin(,,Globals.!ContentLength)
 Globals.!ContentType=value("CONTENT_TYPE",,'os2environment')
 if pos("multipart/form-data",Globals.!ContentType)>0 then do
  if pos(Globals.!myself,value("HTTP_REFERER",,'os2environment'))<1 then call UserLoginScreen
  Globals.!stat1="postnew"
  call CheckLogon "postnew"
 end; else do
  Globals.!querystring=URLDecode(Globals.!querystring)
  parse value Globals.!querystring with Globals.!stat1 "&" Globals.!stat2 "&" Globals.!stat3
  if pos("flogin=",Globals.!stat1)=1 then call CheckLogon "fcheckemail"
  if pos("userreg=",Globals.!stat1)=1 then call NewUser
  if pos("addressbadd=",Globals.!stat1)=1 then call CheckLogon "addr"
 end
end
call UserLoginScreen
return

AddrScreen: procedure expose Globals.
Globals.!ServerErr=""
Globals.!AddrAlias=""
Globals.!AddrName=""
Globals.!AddrEmail=""
if Globals.!stat1="addressbadd=1" then do
 parse value Globals.!querystring with . "&returnto=" Globals.!stat2 "&a=" Globals.!AddrAlias "&n=" Globals.!AddrName "&e=" Globals.!AddrEmail
 if pos(":",Globals.!AddrAlias)>0 then Globals.!ServerErr="Invalid characters detected"
 else if pos("@",Globals.!AddrEmail)<1 then Globals.!ServerErr="Invalid email address"
 else if Globals.!AddrAlias=""&Globals.!AddrName="" then Globals.!ServerErr="The alias and name fields are both incomplete"
 else if Globals.!AddrEmail="" then Globals.!ServerErr="Email field is incomplete"
 else do
  call ConnectManager
  Globals.!clientIP=value("REMOTE_ADDR",,'os2environment')
  if Globals.!clientIP="" then call ErrorScreen 1,"CheckLogon: Can't detect your client"
  cookie=substr(Globals.!Cookie,pos("WEBMAIL2=",Globals.!Cookie)+9,33)
  call SendData "6:"||cookie||":"||Globals.!clientIP||":"||Globals.!AddrAlias||":"||Globals.!AddrName||":"||Globals.!AddrEmail
  call ReceiveData
  if newData=1 then Globals.!ServerErr="User added successfully"
  else if newData=3 then Globals.!ServerErr="Alias already exists"
  else if newData=2 then Globals.!ServerErr="Name already exists"
  else if newData=4 then Globals.!ServerErr="Email address already exists"
 end
 if Globals.!stat2>0 then do
  Globals.!stat3=""
  call ReceiveEmail
 end
 Globals.!stat2="a"
 Globals.!stat3=""
end
if Globals.!stat2="a" then do
 i=0
 if Globals.!stat3<>"" then do
  parse value Globals.!stat3 with i "&" Globals.!stat3
  Globals.!stat3=RXB64decode(Globals.!stat3)
  if pos(" ",Globals.!stat3)>0 then do
   Globals.!AddrEmail=substr(Globals.!stat3,lastpos(" ",Globals.!stat3)+1)
   Globals.!AddrName=substr(Globals.!stat3,1,lastpos(" ",Globals.!stat3)-1)
  end; else
   Globals.!AddrEmail=Globals.!stat3
  if pos("<",Globals.!AddrEmail)>0 then Globals.!AddrEmail=translate(Globals.!AddrEmail,"","<")
  if pos(">",Globals.!AddrEmail)>0 then Globals.!AddrEmail=translate(Globals.!AddrEmail,"",">")
  Globals.!AddrEmail=space(Globals.!AddrEmail)
  if pos('"',Globals.!AddrName)>0 then Globals.!AddrName=space(translate(Globals.!AddrName,"",'"'))
 end
 call ParseHTML Globals.!WMPath||"\header.wm",1
 call ParseHTML Globals.!WMPath||"\addressb-add.wm"
 call ParseHTML Globals.!WMPath||"\footer.wm"
 exit
end
if Globals.!stat2="d" then do
 call ConnectManager
 Globals.!clientIP=value("REMOTE_ADDR",,'os2environment')
 if Globals.!clientIP="" then call ErrorScreen 1,"CheckLogon: Can't detect your client"
 cookie=substr(Globals.!Cookie,pos("WEBMAIL2=",Globals.!Cookie)+9,33)
 call SendData "7:"||cookie||":"||Globals.!clientIP||":"||Globals.!stat3
 call ReceiveData
 if newData=1 then Globals.!ServerErr="Removed email "||Globals.!stat3
 else if newData=2 then Globals.!ServerErr="Couldn't remove email "||Globals.!stat3
end
call ConnectManager
Globals.!clientIP=value("REMOTE_ADDR",,'os2environment')
if Globals.!clientIP="" then call ErrorScreen 1,"CheckLogon: Can't detect your client"
cookie=substr(Globals.!Cookie,pos("WEBMAIL2=",Globals.!Cookie)+9,33)
call SendData "5:"||cookie||":"||Globals.!clientIP||":"
book=""
do while pos("."||'0d0a'x,book)<1
 call ReceiveData 32768
 book=book||newData
end
rc=SockSoClose(socket)
if rc=-1 then call ErrorScreen 1,"CheckLogon: Error on SockSoClose"
if ARG(1)=1 then return book
call ParseHTML Globals.!WMPath||"\header.wm",1
Globals.!AddrTable=""
if pos(":",book)>0 then do
 do while pos(":",book)>0
  parse value book with Globals.!AddrAlias ":" Globals.!AddrName ":" Globals.!AddrEmail '0d0a'x book
  Globals.!AddrTable=Globals.!AddrTable||ParseHTML(Globals.!WMPath||"\addressb-table.wm",0,1)
 end
end
call ParseHTML Globals.!WMPath||"\addressb.wm"
call ParseHTML Globals.!WMPath||"\footer.wm"
exit

CheckEmail: procedure expose Globals.
call ConnectPOP
call SendData "STAT"||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"CheckEmail: Email server couldn't get status"
end
parse value newData with . Globals.!totalmail Globals.!totalsize
if datatype(Globals.!totalmail,"N")<>1 then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"CheckEmail: Server returned wrong value"
end
jumpnumber=0
Globals.!JumpTable=""
if Globals.!totalmail>Globals.!MaxEmails then do
 jumpnumber=Globals.!totalmail / Globals.!MaxEmails
 if pos(".",jumpnumber)>0 then jumpnumber=substr(jumpnumber,1,pos(".",jumpnumber)-1)+1
 do zz=1 to jumpnumber
  if zz=Globals.!stat2 then iterate
  Globals.!JumpPage=zz
  Globals.!JumpTable=Globals.!JumpTable||ParseHTML( Globals.!WMPath||"\jump-table.wm",0,1 )
 end
end
if Globals.!stat2<=jumpnumber & Globals.!totalmail>=1 then do
 Globals.!SetCookiePage=Globals.!stat2
 zz=Globals.!stat2 * Globals.!MaxEmails
 EmailStart=zz - Globals.!MaxEmails + 1
 if zz>Globals.!totalmail then zz=Globals.!totalmail
 Globals.!totalmail=zz
end; else if Globals.!totalmail>=1 then do
 Globals.!SetCookiePage=1
 if Globals.!totalmail>Globals.!MaxEmails then Globals.!totalmail=Globals.!MaxEmails
 EmailStart=1
end; else EmailStart=0
zz=0
if Globals.!totalmail>0 then do
 do i=EmailStart to Globals.!totalmail
  call SendData "TOP "||i||" 0"||'0d0a'x
  call ReceiveData(3)
  if substr(newData,1,3)="+OK" then do
   oldData=""
   do while pos('0d0a'x||"."||'0d0a'x,oldData)<1
    call ReceiveData 32768
    oldData=oldData||newData
   end
   zz=zz+1
   ListMail.i.!h=oldData
  end
 end
end
ListMail.0=zz
call SendData "QUIT"||'0d0a'x
rc=SockSoClose(socket)
if rc=-1 then call ErrorScreen 3,"CheckEmail: Error on SockSoClose"
call ParseHTML Globals.!WMPath||"\header.wm",1
if ListMail.0>0 then do
 Globals.!ListTable=""
 do i=EmailStart to Globals.!totalmail
  call ScanHeaders 1
  if ListMail.i.!ContentType="YES" then Globals.!ContentType=ParseHTML(Globals.!WMPath||"\attachment-yes.wm",0,1)
  else Globals.!ContentType=ParseHTML(Globals.!WMPath||"\attachment-no.wm",0,1)
  if ListMail.i.!Priority="High" then Globals.!Priority=ParseHTML(Globals.!WMPath||"\priority-high.wm",0,1)
  else do
   if ListMail.i.!Priority="Low" then Globals.!Priority=ParseHTML(Globals.!WMPath||"\priority-low.wm",0,1)
   else Globals.!Priority=ParseHTML(Globals.!WMPath||"\priority-normal.wm",0,1)
  end 
  Globals.!ListTable=Globals.!ListTable||ParseHTML(Globals.!WMPath||"\listemails-table.wm",0,1)
 end
 call ParseHTML Globals.!WMPath||"\listemails.wm"
end; else call ParseHTML Globals.!WMPath||"\nomail.wm"
call ParseHTML Globals.!WMPath||"\footer.wm"
exit

CheckLogon: procedure expose Globals.
Globals.!ServerErr=""
call ConnectManager
Globals.!clientIP=value("REMOTE_ADDR",,'os2environment')
if Globals.!clientIP="" then call ErrorScreen 1,"CheckLogon: Can't detect your client"
if ARG(1)="fcheckemail" then tmp1=0
else if ARG(1)="logoff" then tmp1=2
else tmp1=1
Globals.!Cookie=value("HTTP_COOKIE",,'os2environment')
if pos("WEBMAIL2",Globals.!Cookie)<1 then do
 rc=SockSoClose(socket)
 if rc=-1 then call ErrorScreen 1,"CheckLogon: Error on SockSoClose"
 call SysSleep 6
 call ErrorScreen 1,"Login refused"
end
if tmp1=0 then do
 Globals.!user=substr(Globals.!stat2,3,length(Globals.!stat2)-2)
 Globals.!pazz=substr(Globals.!stat3,3,length(Globals.!stat3)-2)
 call SendData tmp1||":"||Globals.!user||":"||Globals.!pazz||":"||Globals.!clientIP||":"
end; else do
 cookie=substr(Globals.!Cookie,pos("WEBMAIL2=",Globals.!Cookie)+9,33)
 call SendData tmp1||":"||cookie||":"||Globals.!clientIP||":"
end
if tmp1<>2 then do
 call ReceiveData
 rc=SockSoClose(socket)
 if rc=-1 then call ErrorScreen 1,"CheckLogon: Error on SockSoClose"
 if pos("[WebManager2] OK",newData)<1 then do
  call SysSleep 6
  call ErrorScreen 1,"Login refused"
 end
 parse value newData with . ":" Globals.!pop3 ":" Globals.!pop3p ":" Globals.!smtp ":" Globals.!smtpp ":" Globals.!AuthID ":" Globals.!user ":" Globals.!pazz ":" Globals.!realname ":"
 if ARG(1)="fcheckemail" then do
  Globals.!SetCookie="SET"
  Globals.!SetCookiePage=1
  Globals.!stat2=1
  Globals.!stat3=""
  call CheckEmail
 end; else if ARG(1)="checkemail" then call CheckEmail
 else if ARG(1)="read" then call ReceiveEmail
 else if ARG(1)="new" then call NewEmailScreen
 else if ARG(1)="postnew" then call NewEmail
 else if ARG(1)="delete" then call DeleteEmail
 else if ARG(1)="download" then call Download
 else if ARG(1)="help" then call HelpScreen
 else if ARG(1)="addr" then call AddrScreen
end; else call UserLoginScreen
call SysSleep 6
call ErrorScreen 1,"Login refused"
return

ConnectManager: procedure expose Globals. socket newData
socket=SockSocket("AF_INET","SOCK_STREAM",0)
if socket=-1 then call ErrorScreen 1,"CheckLogon: Error open socket"
call SockSetSockOpt socket,"SOL_SOCKET","SO_RCVTIMEO","10"
call SockSetSockOpt socket,"SOL_SOCKET","SO_SNDTIMEO","10"
server.!family="AF_INET"
server.!port=Globals.!port
server.!addr=Globals.!serv
rc=SockConnect(socket,"server.!")
if rc=-1 then call ErrorScreen 1,"CheckLogon: Error on Socket/Port connection"
return

ConnectPOP: procedure expose Globals. socket
socket=SockSocket("AF_INET","SOCK_STREAM",0)
if socket=-1 then call ErrorScreen 3,"ConnectPOP: Error open socket"
call SockSetSockOpt socket,"SOL_SOCKET","SO_RCVTIMEO","10"
call SockSetSockOpt socket,"SOL_SOCKET","SO_SNDTIMEO","10"
server.!family="AF_INET"
server.!port=Globals.!pop3p
server.!addr=Globals.!pop3
rc=SockConnect(socket,"server.!")
if rc=-1 then call ErrorScreen 3,"ConnectPOP: Error on Socket/Port connection"
call ReceiveData
if substr(newData,1,3)<>"+OK" then call ErrorScreen 2,"ConnectPOP: Server refused connection"
if right(Globals.!AuthID,1)<>5 then parse value Globals.!user with tmpuser "@" tmpdomain
else tmpuser=Globals.!user
call SendData "USER "||tmpuser||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"ConnectPOP: Server refused user login"
end
call SendData "PASS "||Globals.!pazz||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"ConnectPOP: Failed login, your account is locked, retry later."
end
return

DeleteEmail: procedure expose Globals.
call ConnectPOP
if pos("all",Globals.!stat2)>0 then do
 call SendData "STAT"||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"+OK" then do
  call SendData "QUIT"||'0d0a'x
  call ErrorScreen 2,"DeleteEmail: Email server couldn't get status"
 end
 parse value newData with . Globals.!totalmail .
 if datatype(Globals.!totalmail,"N")<>1 then do
  call SendData "QUIT"||'0d0a'x
  call ErrorScreen 2,"DeleteEmail: Server returned wrong value"
 end
 do i=1 to Globals.!totalmail
  call SendData "DELE "||i||'0d0a'x
  call ReceiveData
  if substr(newData,1,3)<>"+OK" then do
   call SendData "QUIT"||'0d0a'x
   call ErrorScreen 2,"DeleteEmail: Server couldn't delete email or email already deleted"
  end
 end
end; else do
 call SendData "DELE "||Globals.!stat2||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"+OK" then do
  call SendData "QUIT"||'0d0a'x
  call ErrorScreen 2,"DeleteEmail: Server couldn't delete email or email already deleted"
 end
end
call SendData "QUIT"||'0d0a'x
rc=SockSoClose(socket)
if rc=-1 then call ErrorScreen 3,"DeleteEmail: Error on SockSoClose"
if Globals.!stat3<>"" then do
 Globals.!stat2=Globals.!stat3-1
 if Globals.!stat2=0 then do
  Globals.!stat2=1
  Globals.!stat3=""
  call CheckEmail
 end; else do
  Globals.!stat3=""
  call ReceiveEmail
 end
end; else do
 if pos("WEBMAIL2PAGE=",Globals.!Cookie)>0 then do
  Globals.!stat2=substr(Globals.!Cookie,pos("WEBMAIL2PAGE=",Globals.!Cookie)+13,1)
  Globals.!stat3=""
 end; else do
  Globals.!stat2=""
  Globals.!stat3=""
 end
 call CheckEmail
end
return

Download: procedure expose Globals.
parse value Globals.!stat2 with Globals.!stat2 ":" FileName
if FileName="unknown" then call ErrorScreen 2,"Download: Unknown file attachment"
call ReceiveEmail 4
ListMail.i.!h=translate(ListMail.i.!h," ",'09'x)
poz=pos('0d0a'x,ListMail.i.!h)+2
do while poz<length(ListMail.i.!h)
 rc=substr(ListMail.i.!h,poz,1)
 if rc=" " then ListMail.i.!h=substr(ListMail.i.!h,1,poz-3)||" "||space(substr(ListMail.i.!h,poz+1))
 poz=pos('0d0a'x,ListMail.i.!h,poz)+2
end
h1=translate(ListMail.i.!h)
if pos("CONTENT-TYPE:",h1)>0 then do
 tmp1=pos("CONTENT-TYPE:",h1)+13
 tmp2=pos('0d0a'x,h1,tmp1)
 tmp3=space(substr(ListMail.i.!h,tmp1,tmp2-tmp1))
 if pos("MULTIPART/MIXED;",translate(tmp3))>0 then do
  boundary=substr(tmp3,pos("BOUNDARY=",translate(tmp3))+9)
  if pos('"',boundary)=1 then boundary=substr(boundary,2,length(boundary)-2)
  boundary="--"||boundary
  pozlength=1
  zi=0
  do while pos(boundary||'0d0a'x,ListMail.i.!b,pozlength)>0
   poz=pos(boundary||'0d0a'x,ListMail.i.!b,pozlength)
   pozlength=pos('0d0a'x||'0d0a'x,ListMail.i.!b,poz)+4
   headerz=substr(ListMail.i.!b,poz,pozlength-poz)
   if pos(FileName,headerz)>0&pos("BASE64",translate(headerz))>0 then do
    pozlength2=pos(boundary,ListMail.i.!b,pozlength)
    ListMail.i.!b=substr(ListMail.i.!b,pozlength,pozlength2-pozlength)
    say 'Content-Type: application/octet-stream'
    say 'Content-Disposition: attachment; filename="'||FileName||'"'
    say 'Content-Length: '||length(ListMail.i.!b)
    say "Cache-Control: private"
    say "Pragma: no-cache"
    say ""
    poz=1
    buf=""
    do while poz<=length(ListMail.i.!b)
     fpoz=pos('0d0a'x,ListMail.i.!b,poz)
     if fpoz-poz<1 then leave
     buf=buf||RXB64decode(substr(ListMail.i.!b,poz,fpoz-poz))
     poz=fpoz+2
     if length(buf)>=3000 then do
      call charout ,buf
      buf=""
     end
    end
    if length(buf)>0 then call charout ,buf
    exit
   end
  end
 end; else call ErrorScreen 2,"Download: Unknown file attachment"
end; else call ErrorScreen 2,"Download: Unknown file attachment"
exit

ErrorScreen: procedure expose Globals.
Globals.!ServerErr=ARG(2)
if ARG(1)=1 then do
 Globals.!SetCookie="SET"
 Globals.!AuthID=""
 call ParseHTML Globals.!WMPath||"\loginerror.wm",1
end; else if ARG(1)=2 then do
 call ParseHTML Globals.!WMPath||"\header.wm",1
 call ParseHTML Globals.!WMPath||"\servererror.wm"
 call ParseHTML Globals.!WMPath||"\footer.wm"
end; else if ARG(1)=3 then do
 socket=SockSocket("AF_INET","SOCK_STREAM",0)
 call SockSetSockOpt socket,"SOL_SOCKET","SO_RCVTIMEO","10"
 call SockSetSockOpt socket,"SOL_SOCKET","SO_SNDTIMEO","10"
 server.!family="AF_INET"
 server.!port=Globals.!port
 server.!addr=Globals.!serv
 call SockConnect socket,"server.!"
 call SockSend socket,"3:"||ARG(2)
 call SockSoClose socket
 call ErrorScreen 2,"Email Server Error!"
end
exit

HelpScreen: procedure expose Globals.
call ParseHTML Globals.!WMPath||"\header.wm",1
call ParseHTML Globals.!WMPath||"\help.wm"
call ParseHTML Globals.!WMPath||"\footer.wm"
exit

NewEmail: procedure expose Globals.
parse value Globals.!ContentType with . "boundary=" boundary
if pos('"',boundary)=1 then boundary=substr(boundary,2,length(boundary)-2)
boundary='0d0a'x||"--"||boundary
sendto=""
replysel1=""
replyto=""
replysel2=""
ccto=""
bccto=""
subject=""
epriority="Normal"
body=""
filename=""
eol='0d0a'x||'0d0a'x
do 10
 parse value Globals.!querystring with headbody (eol) Globals.!querystring
 if headbody="" then iterate
 else headbody=headbody||'0d0a'x
 poz=pos("CONTENT-DISPOSITION:",translate(headbody))
 if poz<1 then iterate
 pozend=pos('0d0a'x,headbody,poz)
 headval=substr(headbody,poz,pozend-poz)
 if pos("FORM-DATA",translate(headval))<1 then iterate
 if pos("NAME=",translate(headval))<1 then iterate
 headval=substr(headval,pos("NAME=",translate(headval))+5)
 if pos('"',headval)=1 then headval=substr(headval,2,pos('"',headval,2)-2)
 if headval="" then call ErrorScreen 3,"NewEmail: Error reading form while posting email"
 if headval<>"upload_file" then parse value Globals.!querystring with bodyval (boundary) Globals.!querystring
 if headval="t" then sendto=bodyval
 else if headval="rb" then replysel1=bodyval
 else if headval="rt" then replyto=bodyval
 else if headval="rb2" then replysel2=bodyval
 else if headval="c" then ccto=bodyval
 else if headval="b" then bccto=bodyval
 else if headval="s" then subject=bodyval
 else if headval="p" then epriority=bodyval
 else if headval="body" then body=bodyval
 else if headval="upload_file" then do
  headval=substr(headbody,poz,pozend-poz)
  if pos("FILENAME=",translate(headval))<1 then iterate
  headval=substr(headval,pos("FILENAME=",translate(headval))+9)
  if pos('"',headval)=1 then headval=substr(headval,2,pos('"',headval,2)-2)
  if headval<>"" then do
   filename=filespec("name",headval)
   parse value Globals.!querystring with Globals.!querystring (boundary) .
  end
 end
end
if replysel1="f"&replysel2="" then nop
else if replysel1=""&replysel2="r" then sendto=replyto
else if replysel1="f"&replysel2="r" then sendto=sendto||" "||replyto
else call ErrorScreen 2,"NewEmail: You must select atleast one email target"
sendto=ResolveEmails(sendto)
if ccto<>"" then ccto=ResolveEmails(ccto)
if bccto<>"" then bccto=ResolveEmails(bccto)
socket=SockSocket("AF_INET","SOCK_STREAM",0)
if socket=-1 then call ErrorScreen 3,"NewEmail: Error open socket"
call SockSetSockOpt socket,"SOL_SOCKET","SO_RCVTIMEO","10"
call SockSetSockOpt socket,"SOL_SOCKET","SO_SNDTIMEO","10"
server.!family="AF_INET"
server.!port=Globals.!smtpp
server.!addr=Globals.!smtp
rc=SockConnect(socket,"server.!")
if rc=-1 then call ErrorScreen 3,"NewEmail: Error on Socket/Port connection"
call ReceiveData
if substr(newData,1,3)<>"220" then call ErrorScreen 2,"NewEmail: Server refused connection"
call SendData "HELO "||server.!addr||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"250" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"NewEmail: Server dropped connection"
end
if Globals.!realname="" then call SendData "MAIL FROM: <"||Globals.!user||">"||'0d0a'x
else call SendData 'MAIL FROM: "'||Globals.!realname||'" <'||Globals.!user||">"||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"250" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"NewEmail: Server rejected email transfer"
end
if pos(" ",sendto)>0 then do
 tmp=sendto
 do while tmp<>""
  parse value tmp with sendto1 tmp
  call SendData "RCPT TO: <"||sendto1||">"||'0d0a'x
  call ReceiveData
  if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
   call SendData "QUIT"||'0d0a'x
   call ErrorScreen 2,"NewEmail: Server rejected target email:"||newData
  end
 end
end; else do
 call SendData "RCPT TO: <"||sendto||">"||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
  call SendData "QUIT"||'0d0a'x
  call ErrorScreen 2,"NewEmail: Server rejected target email:"||newData
 end
end
if pos(" ",ccto)>0 then do
 tmp=ccto
 do while tmp<>""
  parse value tmp with sendto1 tmp
  call SendData "RCPT TO: <"||sendto1||">"||'0d0a'x
  call ReceiveData
  if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
   call SendData "QUIT"||'0d0a'x
   call ErrorScreen 2,"NewEmail: Server rejected target email"
  end
 end
end; else if ccto<>"" then do
 call SendData "RCPT TO: <"||ccto||">"||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
  call SendData "QUIT"||'0d0a'x
  call ErrorScreen 2,"NewEmail: Server rejected target email"
 end
end
if pos(" ",bccto)>0 then do
 tmp=bccto
 do while tmp<>""
  parse value tmp with sendto1 tmp
  call SendData "RCPT TO: <"||sendto1||">"||'0d0a'x
  call ReceiveData
  if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
   call SendData "QUIT"||'0d0a'x
   call ErrorScreen 2,"NewEmail: Server rejected target email"
  end
 end
end; else if bccto<>"" then do
 call SendData "RCPT TO: <"||bccto||">"||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
  call SendData "QUIT"||'0d0a'x
  call ErrorScreen 2,"NewEmail: Server rejected target email"
 end
end
call SendData "DATA"||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"354" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"NewEmail: Server rejected email data"
end
if Globals.!realname="" then header="From: <"||Globals.!user||">"||'0d0a'x
else header='From: "'||Globals.!realname||'" <'||Globals.!user||">"||'0d0a'x
if pos(" ",sendto)>0 then do
 tmp=sendto
 parse value tmp with sendto1 tmp
 header=header||"To: <"||sendto1||">,"||'0d0a'x
 do while tmp<>""
  parse value tmp with sendto1 tmp
  header=header||"    <"||sendto1||">"
  if tmp<>"" then header=header||","||'0d0a'x
  else header=header||'0d0a'x
 end
end; else header=header||"To: <"||sendto||">"||'0d0a'x
if pos(" ",ccto)>0 then do
 tmp=ccto
 parse value tmp with sendto1 tmp
 header=header||"Cc: <"||sendto1||">,"||'0d0a'x
 do while tmp<>""
  parse value tmp with sendto1 tmp
  header=header||"    <"||sendto1||">"
  if tmp<>"" then header=header||","||'0d0a'x
  else header=header||'0d0a'x
 end
end; else if ccto<>"" then header=header||"Cc: <"||ccto||">"||'0d0a'x
tz=value("TZ",,'os2environment')
if pos(",",tz)>0 then tz=substr(tz,1,pos(",",tz)-1)
header=header||"Date: "||substr(date("W"),1,3)||", "||date('N')||" "||time()||" "||tz||'0d0a'x
header=header||"Priority: "||epriority||'0d0a'x
header=header||"X-Mailer: "||Globals.!myinfo||'0d0a'x
header=header||"MIME-Version: 1.0"||'0d0a'x
if filename="" then header=header||"Content-Type: text/plain"||'0d0a'x
else do
 boundary="_=_=_=WBM.BOUNDARY."||date("B")||random()||"=_=_=_"
 header=header||'Content-Type: multipart/mixed; boundary="'||boundary||'"'||'0d0a'x
end
header=header||"Subject: "||subject||'0d0a'x||'0d0a'x
if filename="" then body=header||body
else do
 body=header||"--"||boundary||'0d0a'x||"Content-Type: text/plain"||'0d0a'x||"Content-Transfer-Encoding: 8bit"||'0d0a'x||'0d0a'x||body
 body=body||'0d0a'x||"--"||boundary||'0d0a'x||'Content-Type: application/octet-stream; name="'||filename||'"'||'0d0a'x||"Content-Transfer-Encoding: base64"||'0d0a'x||'0d0a'x
end
call SendData body
if filename<>"" then do
 buf=RXB64encode(Globals.!querystring)
 poz=1
 do while poz<length(buf)
  if (poz+32768)<length(buf) then call SendData substr(buf,poz,32768)
  else call SendData substr(buf,poz,length(buf)-poz+1)
  poz=poz+32768
 end
 call SendData '0d0a'x||"--"||boundary||"--"
end
call SendData '0d0a'x||"."||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"250" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"NewEmail: Server rejected email data"
end
call SendData "QUIT"||'0d0a'x
rc=SockSoClose(socket)
if rc=-1 then call ErrorScreen 3,"NewEmail: Error on SockSoClose"
if pos("WEBMAIL2PAGE=",Globals.!Cookie)>0 then do
 Globals.!stat2=substr(Globals.!Cookie,pos("WEBMAIL2PAGE=",Globals.!Cookie)+13,1)
 Globals.!stat3=""
end
call CheckEmail
return

NewEmailScreen: procedure expose Globals.
Globals.!EmailReplyTo=""
if Globals.!stat2<>"" then call ReceiveEmail 3
else do
 ListMail.i.!From=""
 ListMail.i.!Cc=""
 ListMail.i.!Subject=""
 ListMail.i.!b=""
end
call ParseHTML Globals.!WMPath||"\header.wm",1
if Globals.!stat2<>"" then
 call ParseHTML Globals.!WMPath||"\reply.wm"
else
 call ParseHTML Globals.!WMPath||"\composeemail.wm"
call ParseHTML Globals.!WMPath||"\footer.wm"
exit

NewUser: procedure expose Globals.
Globals.!clientIP=value("REMOTE_ADDR",,'os2environment')
if Globals.!clientIP="" then call ErrorScreen 1,"CheckLogon: Can't detect your client"
username=substr(Globals.!stat2,3)
parse value Globals.!stat3 with "e=" emailid "&d=" domain "&p=" password
if username=""|emailid=""|domain=""|password="" then call NewUserScreen "One or more fields are incomplete."
if length(password)<4 then call NewUserScreen "Your password must be atleast 4 characters long."
if length(emailid)<4|length(emailid)>8 then call NewUserScreen "Your email ID must be between 4 and 8 characters long."
if pos(" ",emailid)>0|pos(":",username)>0|pos(":",emailid)>0|pos(":",domain)>0|pos(":",password)>0|pos(" ",password)>0 then call NewUserScreen "Illegal character detected."
call ConnectManager
call SendData "4"||":"||username||":"||emailid||":"||domain||":"||password||":"||Globals.!clientIP||":"
call ReceiveData
rc=SockSoClose(socket)
if rc=-1 then call NewUserScreen "New users are not allowed."
if pos("[WebManager2]",newData)>0 then do
 rc=substr(newData,15,1)
 if rc=2 then call NewUserScreen "Email ID already exists."
 if rc=1 then do
  call ParseHTML Globals.!WMPath||"\newuser-thankyou.wm",1
  exit
 end
 call NewUserScreen "User registration rejected."
end
call SysSleep 6
call NewUserScreen "New users are not allowed."
exit

NewUserScreen: procedure expose Globals.
Globals.!ServerErr=ARG(1)
call ParseHTML Globals.!WMPath||"\newuser.wm",1
exit

ParseHTML: procedure expose Globals. i ListMail.
findstring.1="*!WMVERSION!*:"||Globals.!myinfo
findstring.2="*!WMUSER!*:"||Globals.!user
findstring.3="*!WMPASS!*:"||Globals.!pazz
findstring.4="*!WMFILENAME!*:"||Globals.!myself
findstring.5="*!WMEMAILNUM!*:"||i
findstring.6="*!WMEMAILFROM!*:"||ListMail.i.!From
findstring.7="*!WMEMAILSUBJECT!*:"||ListMail.i.!Subject
findstring.8="*!WMEMAILDATE!*:"||ListMail.i.!Date
findstring.9="*!WMEMAILBODY!*:"||ListMail.i.!b
findstring.10="*!WMEMAILTABLE!*:"||Globals.!ListTable
findstring.11="*!SERVERERROR!*:"||Globals.!ServerErr
findstring.12="*!WMATTACHMENT!*:"||Globals.!ContentType
findstring.13="*!WMEMAILPRIORITY!*:"||Globals.!Priority
findstring.14="*!WMAUTHID!*:"||Globals.!AuthID
findstring.15="*!WMATTACHMENTSTABLE!*:"||Globals.!AttachmentsTable
findstring.16="*!WMATTACHFILE!*:"||Globals.!AttachFile
findstring.17="*!WMJUMPTABLE!*:"||Globals.!JumpTable
findstring.18="*!WMJUMPPAGE!*:"||Globals.!JumpPage
findstring.19="*!WMPREVEMAILNUM!*:"||Globals.!PrevEmailNum
findstring.20="*!WMNEXTEMAILNUM!*:"||Globals.!NextEmailNum
findstring.21="*!WMEMAILCC!*:"||ListMail.i.!Cc
findstring.22="*!WMEMAILREPLYTO!*:"||Globals.!EmailReplyTo
if pos("WEBMAIL2PAGE=",Globals.!Cookie)>0 then findstring.23="*!WMPAGE!*:"||substr(Globals.!Cookie,pos("WEBMAIL2PAGE=",Globals.!Cookie)+13,1)
else findstring.23="*!WMPAGE!*:1"
findstring.24="*!WMTOTALSIZE!*:"||Globals.!totalsize
findstring.25="*!WMADDRBTABLE!*:"||Globals.!AddrTable
findstring.26="*!WMADDRBALIAS!*:"||Globals.!AddrAlias
findstring.27="*!WMADDRBNAME!*:"||Globals.!AddrName
findstring.28="*!WMADDREMAIL!*:"||Globals.!AddrEmail
findstring.29="*!WMFULLFROM!*:"||ListMail.i.!FullFrom
findstring.0=29
if ARG(2)=1 then do
 say "Content-type: text/html"
 say "Cache-Control: private"
 say "Pragma: no-cache"
 say "Expires: NOW"
 if Globals.!SetCookie="SET" then say "Set-Cookie: WEBMAIL2="||Globals.!AuthID
 if symbol("Globals.!SetCookiePage")="VAR" then do
  say "Set-Cookie: WEBMAIL2PAGE="||Globals.!SetCookiePage
  findstring.23="*!WMPAGE!*:"||Globals.!SetCookiePage
 end
 say ""
end
newstr=""
istr=stream(ARG(1),'c','open read')
do while lines(ARG(1))>0
 tmp=linein(ARG(1))
 do ii=1 to findstring.0
  parse value findstring.ii with tmp1 ":" tmp2
  if pos(tmp1,tmp)>0 then tmp=ReplaceStr(tmp,tmp1,tmp2)
 end
 if ARG(3)<>1 then say tmp
 else newstr=newstr||tmp||'0d0a'x
end
return newstr

ReceiveData: procedure expose socket newData
length=ARG(1)
if length="" then length=1024
call SockRecv socket,"newData",length
return

ReceiveEmail: procedure expose Globals. ListMail. i
i=Globals.!stat2
call ConnectPOP
call SendData "STAT"||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"ReceiveEmail: Email server couldn't get status"
end
parse value newData with . Globals.!totalmail .
if datatype(Globals.!totalmail,"N")<>1 then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"ReceiveEmail: Server returned wrong value"
end
call SendData "LIST "||Globals.!stat2||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"ReceiveEmail: Server couldn't list email"
end
parse value newData with . . s2 '0d0a'x
call SendData "TOP "||Globals.!stat2||" 0"||'0d0a'x
call ReceiveData(3)
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"ReceiveEmail: Server couldn't receive headers"
end
ListMail.i.!h=""
do while pos('0d0a'x||"."||'0d0a'x,ListMail.i.!h)<1
 call ReceiveData 32768
 ListMail.i.!h=ListMail.i.!h||newData
end
if pos('0d0d0a'x,ListMail.i.!h)>0 then ListMail.i.!h=ReplaceStr(ListMail.i.!h,'0d0d0a'x,'0d0a'x)
if s2<1000000 then call SendData "RETR "||Globals.!stat2||'0d0a'x
else do
 incomplete=1
 call SendData "TOP "||Globals.!stat2||" 200"||'0d0a'x
end
call ReceiveData(3)
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ErrorScreen 2,"ReceiveEmail: Server couldn't retrieve email body"
end
ListMail.i.!b=""
do while pos('0d0a'x||"."||'0d0a'x,ListMail.i.!b)<1
 call ReceiveData 32768
 ListMail.i.!b=ListMail.i.!b||newData
end
if length(ListMail.i.!b)=8 then ListMail.i.!b="X-Junkmail: Yes"||'0d0a'x||'0d0a'x||"JunkMail: This email has been detected as junk mail."||'0d0a'x||"If this message has incorrectly been identified as junk, please forward to notjunk@junkspy.com"||ListMail.i.!b
call SendData "QUIT"||'0d0a'x
rc=SockSoClose(socket)
if rc=-1 then call ErrorScreen 3,"ReceiveEmail: Error on SockSoClose"
ListMail.i.!b=substr(ListMail.i.!b,pos('0d0a'x||'0d0a'x,ListMail.i.!b)+4)
ListMail.i.!b=substr(ListMail.i.!b,1,lastpos('0d0a'x||"."||'0d0a'x,ListMail.i.!b)+1)
if arg(1)=3 then do
 call ScanHeaders 3
 if qpyes=1 then ListMail.i.!b=RXdeQuoted(ListMail.i.!b)
 tmp=1
 ListMail.i.!b=insert( ">",ListMail.i.!b)
 do while pos('0d0a'x,ListMail.i.!b,tmp)>0
  tmp=pos('0d0a'x,ListMail.i.!b,tmp)+1
  ListMail.i.!b=insert( ">",ListMail.i.!b,tmp)
 end
 return
end; else if arg(1)=4 then return
else do
 call ScanHeaders 2
 if qpyes=1 then ListMail.i.!b=RXdeQuoted(ListMail.i.!b)
 if ListMail.i.!Priority="High" then Globals.!Priority=ParseHTML(Globals.!WMPath||"\priority-high.wm",0,1)||'0d0a'x
 else if ListMail.i.!Priority="Low" then Globals.!Priority=ParseHTML(Globals.!WMPath||"\priority-low.wm",0,1)||'0d0a'x
 else Globals.!Priority=ParseHTML(Globals.!WMPath||"\priority-normal.wm",0,1)||'0d0a'x
 call ParseHTML Globals.!WMPath||"\header.wm",1
 Globals.!AttachmentsTable=""
 if ListMail.i.!ContentType="YES" then do
  Globals.!ContentType=ParseHTML(Globals.!WMPath||"\attachment-yes.wm",0,1)||'0d0a'x
  do iz=1 to Globals.!AttachFiles.0
   Globals.!AttachFile=Globals.!AttachFiles.iz
   Globals.!AttachmentsTable=Globals.!AttachmentsTable||ParseHTML(Globals.!WMPath||"\attachment-table.wm",0,1)||'0d0a'x
  end
 end; else do
  Globals.!ContentType=ParseHTML(Globals.!WMPath||"\attachment-no.wm",0,1)||'0d0a'x
  Globals.!AttachmentsTable=Globals.!ContentType
 end
 if Globals.!stat2>1 then Globals.!PrevEmailNum=Globals.!stat2-1
 else Globals.!PrevEmailNum=Globals.!totalmail
 if Globals.!stat2>=Globals.!totalmail then Globals.!NextEmailNum=1
 else Globals.!NextEmailNum=Globals.!stat2+1
 if incomplete=1 then ListMail.i.!b=ListMail.i.!b||'0d0a'x||"*************************************"||'0d0a'x||"The rest of the email body has been"||'0d0a'x||"removed because it was too big to fit"||'0d0a'x||"*************************************"||'0d0a'x
 call ParseHTML Globals.!WMPath||"\reademail.wm"
 call ParseHTML Globals.!WMPath||"\footer.wm"
end
exit

ReplaceStr: procedure
tmp1=ARG(1)
tmp2=ARG(2)
tmp3=ARG(3)
do forever
 iz=pos(tmp2,tmp1)
 if iz<1 then leave
 tmp=substr(tmp1,1,iz-1)
 tmpp=substr(tmp1,iz+length(tmp2),length(tmp1)-iz+length(tmp2))
 tmp1=tmp||tmp3||tmpp
end
return tmp1

ResolveEmails: procedure expose Globals.
sendto=ARG(1)
book=AddrScreen(1)
if pos(" ",sendto)>0 then do
  tmp1=sendto
  sendto=""
  do while length(tmp1)>0
   tmpemailfound=0
   tmp2=book
   parse value tmp1 with tmpemail tmp1
   do while pos(":",tmp2)>0
    parse value tmp2 with AddrAlias ":" AddrName ":" AddrEmail '0d0a'x tmp2
    if translate(tmpemail)=translate(AddrAlias)|translate(tmpemail)=translate(AddrName) then do
     tmpemailfound=1
     leave
    end
   end
   if tmpemailfound=1 then sendto=sendto||" "||AddrEmail
   else sendto=sendto||" "||tmpemail
  end
  sendto=space(sendto)
end; else do
 do while pos(":",book)>0
  parse value book with AddrAlias ":" AddrName ":" AddrEmail '0d0a'x book
  if translate(sendto)=translate(AddrAlias)|translate(sendto)=translate(AddrName) then sendto=AddrEmail
 end
end
return sendto

ScanHeaders: procedure expose Globals. i ListMail.
ListMail.i.!h=translate(ListMail.i.!h," ",'09'x)
poz=pos('0d0a'x,ListMail.i.!h)+2
do while poz<length(ListMail.i.!h)
 rc=substr(ListMail.i.!h,poz,1)
 if rc=" " then ListMail.i.!h=substr(ListMail.i.!h,1,poz-3)||" "||space(substr(ListMail.i.!h,poz+1))
 poz=pos('0d0a'x,ListMail.i.!h,poz)+2
end
h1=translate(ListMail.i.!h)
if pos('0d0a'x||"FROM:",h1)>0 then do
 tmp1=pos('0d0a'x||"FROM:",h1)+7
 tmp2=pos('0d0a'x,h1,tmp1)
 tmp3=space(substr(ListMail.i.!h,tmp1,tmp2-tmp1))
 if arg(1)=3&pos("<",tmp3)>0&pos(">",tmp3)>0 then do
  h5=""
  do while tmp3<>""
   parse value tmp3 with . "<" h4 ">" tmp3
    h5=h5||h4||" "
  end
  tmp3=h5
 end; else do
  ListMail.i.!FullFrom=RXB64encode(tmp3)
  if pos(" ",tmp3)>0 then do
   tmp3=substr(tmp3,1,lastpos(" ",tmp3)-1)
   if pos('"',tmp3)>0 then
    parse value tmp3 with '"' tmp3 '"'
  end; else do
   if pos("<",tmp3)>0 then tmp3=translate(tmp3,"","<")
   if pos(">",tmp3)>0 then tmp3=translate(tmp3,"",">")
  end
 end
 ListMail.i.!From=space(tmp3)
end; else ListMail.i.!From=""
if pos('0d0a'x||"SUBJECT:",h1)>0 then do
 tmp1=pos('0d0a'x||"SUBJECT:",h1)+10
 tmp2=pos('0d0a'x,h1,tmp1)
 tmp3=space(substr(ListMail.i.!h,tmp1,tmp2-tmp1))
 if arg(1)=3&pos("Re:",tmp3)<1 then ListMail.i.!Subject="Re: "||tmp3
 else do
  if pos("<",tmp3)>0 then tmp3=ReplaceStr(tmp3,"<","&lt;")
  if pos(">",tmp3)>0 then tmp3=ReplaceStr(tmp3,">","&gt;")
  ListMail.i.!Subject=tmp3
 end
end; else ListMail.i.!Subject=""
if pos('0d0a'x||"DATE:",h1)>0 then do
 tmp1=pos('0d0a'x||"DATE:",h1)+7
 ListMail.i.!Date=space(substr(ListMail.i.!h,tmp1,17))
end; else ListMail.i.!Date=""
if pos('0d0a'x||"PRIORITY:",h1)>0 then do
 tmp1=pos('0d0a'x||"PRIORITY:",h1)+11
 tmp2=pos('0d0a'x,h1,tmp1)
 tmp3=space(substr(h1,tmp1,tmp2-tmp1))
 if tmp3="HIGH" then ListMail.i.!Priority="High"
 else if tmp3="LOW" then ListMail.i.!Priority="Low"
 else ListMail.i.!Priority="Normal"
end; else ListMail.i.!Priority="Normal"
if arg(1)=1 then do
 if pos('0d0a'x||"CONTENT-TYPE:",h1)>0 then do
  tmp1=pos('0d0a'x||"CONTENT-TYPE:",h1)+15
  tmp2=pos('0d0a'x,h1,tmp1)
  tmp3=space(substr(ListMail.i.!h,tmp1,tmp2-tmp1))
  if pos("MULTIPART/MIXED;",translate(tmp3))>0 then ListMail.i.!ContentType="YES"
 end
end
if arg(1)=2|arg(1)=3 then do
 if pos('0d0a'x||"CONTENT-TYPE:",h1)>0 then do
  tmp1=pos('0d0a'x||"CONTENT-TYPE:",h1)+15
  tmp2=pos('0d0a'x,h1,tmp1)
  tmp3=space(substr(ListMail.i.!h,tmp1,tmp2-tmp1))
  if pos("MULTIPART/MIXED;",translate(tmp3))>0|pos("MULTIPART/ALTERNATIVE;",translate(tmp3))>0 then do
   boundary=substr(tmp3,pos("BOUNDARY=",translate(tmp3))+9)
   if pos('"',boundary)>0 then boundary=substr(boundary,2,length(boundary)-2)
   boundary="--"||boundary
   if pos("MULTIPART/MIXED;",translate(tmp3))>0&arg(1)<>3 then do
    pozlength=1
    zi=0
    do while pos(boundary||'0d0a'x,ListMail.i.!b,pozlength)>0
     poz=pos(boundary||'0d0a'x,ListMail.i.!b,pozlength)
     pozlength=pos('0d0a'x||'0d0a'x,ListMail.i.!b,poz)+4
     headerz=substr(ListMail.i.!b,poz,pozlength-poz)
     if pos(" text",headerz)<1 then do
      if pos("name=",headerz)>0 then do
       zi=zi+1
       parse value headerz with . "name=""" Globals.!AttachFiles.zi """" .
      end; else Globals.!AttachFiles.zi="unknown"
     end
    end
    Globals.!AttachFiles.0=zi
    if Globals.!AttachFiles.0>0 then ListMail.i.!ContentType="YES"
   end
   poz=pos(boundary||'0d0a'x,ListMail.i.!b,1)
   pozlength=pos('0d0a'x||'0d0a'x,ListMail.i.!b,poz)+4
   pozend=pos(boundary,ListMail.i.!b,pozlength)-1
   if pos("CONTENT-TRANSFER-ENCODING: QUOTED-PRINTABLE",translate(substr(ListMail.i.!b,poz,pozlength-poz)))>0 then qpyes=1
   ListMail.i.!b=substr(ListMail.i.!b,pozlength,pozend-pozlength)
  end; else do
   if pos("CONTENT-TRANSFER-ENCODING: QUOTED-PRINTABLE",h1)>0 then qpyes=1
  end
 end
end
if arg(1)=3 then do
 if pos('0d0a'x||"REPLY-TO: ",h1)>0 then do
  tmp1=pos('0d0a'x||"REPLY-TO: ",h1)+12
  tmp2=pos('0d0a'x,h1,tmp1)
  tmp3=space(substr(ListMail.i.!h,tmp1,tmp2-tmp1))
  h5=""
  if pos("<",tmp3)>0&pos(">",tmp3)>0 then do
   do while tmp3<>""
    parse value tmp3 with . "<" h4 ">" tmp3
     h5=h5||h4||" "
   end
   tmp3=h5
  end; else do
   tmp3=ReplaceStr(tmp3,"<","")
   tmp3=ReplaceStr(tmp3,">","")
  end
  Globals.!EmailReplyTo=ListMail.i.!From
  ListMail.i.!From=space(tmp3)
 end
 if pos('0d0a'x||"CC:",h1)>0 then do
  tmp1=pos('0d0a'x||"CC:",h1)+5
  tmp2=pos('0d0a'x,h1,tmp1)
  tmp3=space(substr(ListMail.i.!h,tmp1,tmp2-tmp1))
  h5=""
  if pos("<",tmp3)>0&pos(">",tmp3)>0 then do
   do while tmp3<>""
    parse value tmp3 with . "<" h4 ">" tmp3
     h5=h5||h4||" "
   end
   tmp3=h5
  end; else do
   tmp3=ReplaceStr(tmp3,"<","")
   tmp3=ReplaceStr(tmp3,">","")
  end
  ListMail.i.!Cc=space(tmp3)
 end; else ListMail.i.!Cc=""
end
return

SendData: procedure expose socket
call SockSend socket,ARG(1)
return

URLDecode: procedure
line=translate(ARG(1)," ","+")
lineLen=length(line)
newLine=''
i=1
do while i<=lineLen
 c=substr(line,i,1)
 if c\='%' then newLine=newLine||c
 else if i+2<=lineLen then do
  newLine= newLine||x2c(substr(line,i+1,2))
  i=i+2
 end
 i=i+1
end
return newLine
/* call charout "c:\tcpip\web2\cgi-bin\debug.txt",tmp */

UserLoginScreen: procedure expose Globals.
Globals.!SetCookie="SET"
Globals.!AuthID=""
Globals.!SetCookiePage=""
call ParseHTML Globals.!WMPath||"\userlogin.wm",1
exit

