/* WEBEXADD.CMD by William J. Hinkle CIS [75300,2050]                       */
/* This is freeware, ok to use and redistribute, but keep my header please! */
/*
   This Rexx script adds a new external viewer type to
   IBM WebExplorer v1.0X
   Just run it from an OS/2 command line or a desktop program object:
   WEBEXADD mimeapp extension appfile params

   for example, to add Adobe Acrobat support:
   WEBEXADD application/pdf pdf C:\ACROREAD\ACROREAD.EXE
*/
SIGNAL ON HALT

/* get the command-line (or passed) arguments */
PARSE ARG mimetype extension appfile appparams
IF (mimetype = "") | (extension = "") THEN DO
	SAY "Usage:"
	SAY
	SAY "WEBEXADD mimetype extensions [appfile [parameters...]]"
	SAY "Notes:   mimetype is in the form name/type.  Example: application/fu"
	SAY "         extensions can be a comma-delimited list. Example: fu,bar"
	SAY "         appfile and parameters are optional"
	SAY "         If no appfile, then extensions are defined for existing mimetype"
	RETURN 1
END
IF (appfile <> "") THEN DO
	IF STREAM(appfile,"C","QUERY EXISTS") = "" THEN DO
		CALL BEEP 440,50
		SAY
		SAY "Warning! The viewer file" appfile "doesn't seem to exist!"
		SAY
	END
END
/* add necessary %s parameter if not mentioned */
IF POS("%s",appparams) = 0 THEN appparams = appparams "%s"
/* break up extension list into words */
extension = TRANSLATE(extension,"  ",",;")

etcdefault = "C:\TCPIP\ETC\"
etcpath = VALUE("ETC",,"OS2ENVIRONMENT")
inifname = "EXPLORE.INI"
inibname = "EXPLORE.IBK"
iniok = ""
DO UNTIL iniok = "READY:"
    IF iniok <> "" THEN DO
		SAY inifqpname "could not be found!"
    	SAY "Please enter the drive:directory to the" inifname "file:"
	    SAY "Just [Enter] for" etcdefault "or [Ctrl+C][Enter] to quit: ";
		SAY
		PARSE PULL etcpath
		SAY
	    etcpath = STRIP(etcpath,"B")
	END
    IF etcpath = "" THEN
    	etcpath = etcdefault
    ELSE DO
	    IF RIGHT(etcpath,1) <> "\" AND RIGHT(etcpath,1) <> ":" THEN DO
		    etcpath = etcpath || "\"
	    END
    END
    inifqpname = etcpath || inifname
    iniok = STREAM(inifqpname,"C","OPEN READ")
END

/* scan for the [advanced] section of the INI file */
prelines = 0
DO WHILE CHARS(inifqpname) > 0
	strdat = LINEIN(inifqpname)
	prelines = prelines + 1
	IF TRANSLATE(WORD(strdat,1)) = "[ADVANCED]" THEN LEAVE
END
IF CHARS(inifqpname) <= 0 THEN DO
	SAY "The" inifname" file doesn't seem to be in the expected format."
	RETURN 2
END
/* capture all lines of [advanced] section */
advanced.0 = 0
trailblanks = 0
midlines = 0
DO WHILE CHARS(inifqpname) > 0
	strdat = STRIP(LINEIN(inifqpname),"B")
	IF LEFT(strdat,1) = "[" THEN LEAVE
	advanced.0 = advanced.0 + 1
	ix = advanced.0
	advanced.ix = strdat
	IF strdat = "" THEN trailblanks = trailblanks + 1
	ELSE trailblanks = 0
	midlines = midlines + 1
END
IF trailblanks > 0 THEN advanced.0 = advanced.0 - trailblanks

/* find the mailcap and extmap lines, if any */
mailcap.advix = 0
extmap.advix = 0
DO ix = 1 TO advanced.0
 /* skip blank and comment lines */
 IF (advanced.ix = "") | LEFT(advanced.ix,1) == ";" THEN ITERATE
 PARSE VAR advanced.ix varname "=" varvalue
 varname = TRANSLATE(varname)
 IF varname = "MAILCAP" THEN DO
	mailcap.advix = ix
	mailcap.fname = varvalue
 END
 ELSE IF varname = "EXTMAP" THEN DO
	extmap.advix = ix
	extmap.fname = varvalue
 END
END

mailcap.ok = ""
mailcap.opened = 0
mailcap.newfile = 0
/* check for mailcap reference, generate one if none yet */
IF (mailcap.advix = 0) | (mailcap.fname = "") THEN DO
	mailcap.fname = etcpath || "EXPLORE.CAP"
	mailcap.newfile = 1
END
/* open mailcap file if possible */
mailcap.ok = STREAM(mailcap.fname,"C","OPEN"/*read & write*/)
IF mailcap.ok = "READY:" THEN mailcap.opened = 1
ELSE SAY mailcap.fname "(mailcap= in" inifname || ") won't open:" mailcap.ok

extmap.ok = ""
extmap.opened = 0
extmap.newfile = 0
/* check for extmap reference, generate one if none yet */
IF (extmap.advix = 0) | (extmap.fname = "") THEN DO
	extmap.fname = etcpath || "EXPLORE.EXT"
	extmap.newfile = 1
END
/* open extmap file if possible */
extmap.ok = STREAM(extmap.fname,"C","OPEN"/*read & write*/)
IF extmap.ok = "READY:" THEN extmap.opened = 1
ELSE SAY extmap.fname "(extmap= in" inifname || ") won't open:" extmap.ok

IF (mailcap.ok = "READY:") & (extmap.ok = "READY:") THEN DO
	/* first check for existing definition of this mimetype */
	/* note that we don't handle \-terminated extended lines. Tough! */
	DO WHILE CHARS(mailcap.fname) > 0
		strdat = STRIP(LINEIN(mailcap.fname),"B")
		IF LEFT(strdat,1) == "#" THEN ITERATE	/* skip comments */
		IF TRANSLATE(WORD(strdat,1)) = (TRANSLATE(mimetype) || ";") THEN DO
			IF (appfile <> "") & (TRANSLATE(WORD(strdat,2)) <> TRANSLATE(appfile)) ,
			THEN SAY "Warning!   '" || WORD(strdat,2) || "' is already defined for '" || mimetype || "'"
			ELSE SAY "No update: '" || WORD(strdat,2) || "' is already defined for '" || mimetype || "'"
			     SAY "        in " mailcap.fname ||"."
			mailcap.ok = "DEFINED:"
			LEAVE
		END
	END
	/* now check for existing definition of these extensions */
	/* note that we don't handle \-terminated extended lines. Tough! */
	DO WHILE CHARS(extmap.fname) > 0
		strdat = STRIP(LINEIN(extmap.fname),"B")
		IF LEFT(strdat,1) == "#" THEN ITERATE	/* skip comments */
		ix = WORDS(strdat)
		DO WHILE ix > 1
			DO eix = 1 TO WORDS(extension)
				thisext = WORD(extension,eix)
				IF TRANSLATE(WORD(strdat,ix)) = TRANSLATE(thisext) THEN DO
					IF (TRANSLATE(WORD(strdat,1)) <> TRANSLATE(mimetype)) ,
					THEN SAY "Warning!   '" || WORD(strdat,1) || "' is already defined for '" || thisext || "'"
					ELSE SAY "No update: '" || WORD(strdat,1) || "' is already defined for '" || thisext || "'"
				         SAY "        in " extmap.fname ||"."
					extension = DELWORD(extension,eix,1)
					eix = eix - 1
				END
			END
			ix = ix - 1
		END
		IF WORDS(extension) = 0 THEN LEAVE
	END
	IF WORDS(extension) = 0 THEN extmap.ok = "DEFINED:"
END

/* write the new definition for mimetype */
IF (mailcap.ok = "READY:") & (appfile <> "") THEN DO
	mailcap.ok = STREAM(mailcap.fname,"C","SEEK < 0")
	if (mailcap.ok = "") | (DATATYPE(mailcap.ok) = "NUM") THEN DO
		mailcap.ok = "DEFINED:"
		IF LINEOUT(mailcap.fname, mimetype || ";" appfile appparams) > 0 THEN mailcap.ok = ""
	END
	IF mailcap.ok <> "DEFINED:" THEN SAY "Can't write to" mailcap.fname
	ELSE SAY "Defined '" || mimetype || "' in the" mailcap.fname "file."
END

/* write the new definition extension */
IF extmap.ok = "READY:" THEN DO
	extension = STRIP(extension,"B")
	IF mailcap.ok = "DEFINED:" THEN DO
		extmap.ok = STREAM(extmap.fname,"C","SEEK < 0")
		if (extmap.ok = "") | (DATATYPE(extmap.ok) = "NUM") THEN DO
			extmap.ok = "DEFINED:"
			IF LINEOUT(extmap.fname, mimetype extension) > 0 THEN extmap.ok = ""
		END
		IF extmap.ok <> "DEFINED:" THEN SAY "Can't write to" extmap.fname
		ELSE SAY "Defined '" || extension || "' in the" extmap.fname "file."
	END
	ELSE SAY "Can't define '" || extension || "' with '" || mimetype || "' undefined in" mailcap.fname || "."
END

/* now write the file info, if needed, to the INI file */
IF mailcap.newfile | extmap.newfile THEN DO
	SAY "Updating the" inifname "file..."

	ix = mailcap.advix
	IF ix = 0 THEN DO	/* we must add a MAILCAP line */
		ix = advanced.0 + 1
		advanced.0 = ix
	END
	advanced.ix = "mailcap=" || mailcap.fname

	ix = extmap.advix
	IF ix = 0 THEN DO	/* we must add an EXTMAP line */
		ix = advanced.0 + 1
		advanced.0 = ix
	END
	advanced.ix = "extmap=" || extmap.fname

	/* preserve the current INI file as a backup */
	inibackup = etcpath || inibname
	ADDRESS "CMD" "@COPY" inifqpname inibackup ">nul"
	IF RC > 0 THEN SAY "Can't back up" inifname ", so I give up..."
	ELSE DO	/* close and re-open input file, now backup */
		CALL STREAM inifqpname,"C","CLOSE"
		IF STREAM(inibackup,"C","OPEN READ") = "READY:" THEN DO
			/* kill off original file */
			ADDRESS "CMD" "@ERASE" inifqpname ">nul"
			IF RC > 0 THEN SIGNAL noiniup

			IF STREAM(inifqpname,"C","OPEN WRITE") = "READY:" THEN DO
				/* copy first part of EXPLORE.INI */
				DO ix = 1 to prelines
					strdat = LINEIN(inibackup)
					IF LINEOUT(inifqpname,strdat) > 0 THEN SIGNAL noiniup
				END
				/* write new advanced section */
				DO ix = 1 to advanced.0
					IF LINEOUT(inifqpname,advanced.ix) > 0 THEN SIGNAL noiniup
				END
				CALL LINEOUT inifqpname, ""	/* tack on a blank line */
				/* wind past old advanced section */
				DO ix = 1 to midlines
					call LINEIN(inibackup)
				END
				/* copy last part of EXPLORE.INI */
				DO WHILE CHARS(inibackup) > 0
					strdat = LINEIN(inibackup)
					IF LINEOUT(inifqpname,strdat) > 0 THEN SIGNAL noiniup
				END

				SAY "Update of the" inifname "file was successful!"
			END
			ELSE SIGNAL noiniup
		END
		ELSE SIGNAL noiniup
	END
END

noiniup:
CALL STREAM inifqpname,"C","CLOSE"
IF DATATYPE(SIGL) = "NUM" THEN DO
	SAY "Error at " SIGL "while updating the" inifname "file! Restoring from backup..."
	ADDRESS "CMD" "@COPY" inibackup inifqpname ">nul"
END

/* close all files */
IF mailcap.opened THEN CALL STREAM mailcap.fname,"C","CLOSE"
IF extmap.opened  THEN CALL STREAM  extmap.fname,"C","CLOSE"

IF (mailcap.advix > 0) & (extmap.advix > 0) THEN RETURN 0
ELSE RETURN 2

HALT:
EXIT 1
