/* 15 Oct 1998 -- Demo of the SREF_DIGITS and SREF_XBITMAP
   procedures.

  This will print a message, and also display the current request number
  (the reqnum argument below).

You can invoke this with:
        /TSTDIGIT?1+message
or with
     /TSTDIGIT?option_list

Where option list has the form:
   var1=val1&var2=val2&..
and Varn can be (with valn = ... ):
   MESS = a message (with + used for spaces)
   FONT = font to display message with 
   FONT2 = font to display request number with
   XBITMAP = create an xbitmap file (FONT and FONT2 are ignored)
             of the current request number. valn is 0 (plain) or
             1 (reversed)
  For example:
         mess=hello+world&font=Goldblok&font2=goldodo


Note: This procecurde  assumes that "digit/character" sets are installed 
     in the DIGITS subdirectory of the GoServe data directory (this is where
     SRE-http installs them).

*/

/* First, get arguments sent to this addon by SRE-http */
/* See STATUS.CMD (or srehttp.htm) for a description what these do */

parse arg  ddir, tempfile, reqstrg,list,verb ,uri,user, ,
          basedir ,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname,homedir,aparam,semqueue,prog_file,reqnum

if ddir='' then do
   say 'Sorry, this SRE-http addon is not meant to be run in stand alone mode'
   say ' (see COUNTER.DOC for examples of how to use this addon).'
   exit
end /* do */

/* LIST contains the arguments sent to the server by the browser */
list=packur(translate(list,' ','+'))

/* Extract  options */

amess='Test' ; doxbm=''  /* initialize */

/* defaults */
dname='GOLDBLOK' ; dname2='GOLDODO'
do forever
   if list='' then leave
   parse var list a1 '&' list
   parse var a1 a1a '=' a1b ; a1a=upper(a1a)
   if a1b='' then do
       a1b=a1a
      a1a="MESS" 
   end 
  select
         when  abbrev(translate(a1a),"MESS")=1 then amess=a1b    /* the message */
         when  a1a="XBITMAP" then   doxbm=strip(a1b)
         when  a1a='FONT2' then dname2=strip(upper(a1b))
         when  a1a="FONT"  then dname=strip(upper(a1b))
         otherwise nop
   end
end /* do */

/* if XBITMAP in list, then return an xbitmap of amess */
if doxbm<>'' then do
  foo=sref_xbitmap(amess,5,doxbm)  /* sref_gos is called from sref_xbitmap */
  return ' '
end /* do */

/* else, create and html document that contains the <IMG elements */

/* if no fonts specified ... */
if dname='' then dname='GOLDBLOK'
if dname2='' then dname2=dname



/* Write <head> of response */
call lineout tempfile,'<html><head><title>Demo of SREF_DIGITS and SREF_XBITMAP</title>'
call lineout tempfile, '</head>'

sq="'"

call lineout tempfile,' <h2>Demo of the SREF_DIGITS and SREF_XBITMAP procedures</h2>'
call lineout tempfile,'<h3>Examples:</h3><ol> '
call lineout tempfile,' <li><code> txt=sref_digits("'amess'","'dname'",,,,'sq'VALIGN="MIDDLE"'sq') </code> :'


/* create the "list" message, using the dname font (aligned in the middle) */

fooo=sref_digits(amess,dname,,,,' VALIGN="MIDDLE"')

call lineout tempfile,fooo
call lineout tempfile,' <p>'
call lineout tempfile,'<li><code> txt=sref_digits('reqnum',"'dname2'",4,1,0,'sq'VALIGN="MIDDLE"'sq') </code>:'

/* write digit message (the current request #), with min of 4 digits and use a frame. */

txt=sref_digits(reqnum,dname2,4,1,0,' VALIGN="MIDDLE" ')

/* this section will invoke XBITMAP calls back to this addon ! */

call lineout tempfile,txt'<p><li>'
call lineout tempfile,' <code>  xbm=sref_xbitmap('reqnum',5,0 and 1): </code>'
call lineout tempfile,'<img src="/tstdigit?mess='reqnum'&XBITMAP=0&nm=a.xbm">'
call lineout tempfile,'  and  '
call lineout tempfile,'<img src="/tstdigit?mess='reqnum'&XBITMAP=1&nm=a.xbm"> </ol>'

/* and some notes ... */

call lineout tempfile,' '
call lineout tempfile,'<p><b>Notes</b><menu> '
call lineout tempfile,'<li> The calling syntax for SREF_DIGITS is: <p><code>'
call lineout tempfile,' txt=sref_digits(list,dname,ndig,useframe,nobr,opts,imgsel,imgdir)><p></code>'
call lineout tempfile,' '
call lineout tempfile,' <li>and for SREF_XBITMAP: <p><code>'
call lineout tempfile,'     img=SREF_XBITMAP(anumber,ndigits,doreverse) </code><p> </menu>'

call lineout tempfile,' </body></html> '
call lineout tempfile

/* tell sre-http to send this document to the client */
return 'file type text/html name ' tempfile


                                                                        
