/* SREINIT0.CMD ****************************/
/* start srefilter -- or wait for it to finish resetting */
start_srefilter:
parse arg key_preface,reqnum,verbose,thesem,moreargs,port,gospid,enmadd,sem_maxwait      


/* this file contains the "static" parameters initialization file */
static_params_file='CFGS\INIT_STA'                /* if no .ext, then port number will be appended */

/* or.. you can include init_sta here, and set static_parms_file='' */


/*************************/

/* read the static_params_file */
signal on error name foo1 ; signal on syntax name foo1 ;

if static_params_file<>'' then do
    call read_statics
    if result=0 then return 0
end

moreargs=loadthreshold||','||backupserverlist||','||delay_seconds||','||message_scramble||','||record_cache_lines||','||logon_limit||','||ssi_extensions
moreargs=moreargs||','ssi_cache_size||','||ssi_cache_duration||','||SSI_CACHE_STAMP||','||no_no_record||','||hit_superuser_suppress||','||pmprintf_opt
MOREARGS=MOREARGS||','||NO_REMOTE_CONFIG||'!!'||custom_inits||'!!'||cgi_post_long_get||','||get_decode_options
moreargs=moreargs||','||never_publicurls||','||digest_auth||','||proxy_cache||','||suppress_gzip_te||','pre_reply_procedure


/* not in a wait state, hence must be initialize */
   servdir=directory()          /* should NOT be on-the-fly-changeable */
   oo=value(enmadd||'SERVDIR',servdir,'os2environment')

/* to avoid trouble, do not allow any other requests while SRE-http is initializing */
  if oo<>"" then do
     cl=extract('clients')
     'response HTTP/1.1 503 Service Unavailable'
     if cl=0 then do
        call pmprintf(' It appears that the SRE-http initialization failed ')
        call pmprintf(' Is your net connection working? ')
        string ' Sorry: Server Initialization Failure. '
        return 0
     end
     else do
         call pmprintf(' 2nd request while initializing: deny access for now ')
     end
     string ' Server is initializing, please try again in a few minutes. '
     return 0
  end

/* first call, start up the helper threads ! */

  initfilt_file=servdir||"\INITFILT."||port
  aa2=eventsem_close(thesem)
  afilt2=servdir'\srefmon.cmd'

  a0=extract('limitclients')
  a1=extract('fastfile')
  a2=extract('limittimewait')
  a3=extract('gmtset')
  a4=server('h')
  
  foo=rexxthread('f',afilt2,gospid,thesem,servdir,PORT,enmadd,sem_maxwait,moreargs,key_preface, ,
                 a0,a1,a3,a3,a4)


/* allow plenty of time for initialization thread to do it's business */
  do forever   /* wait for filter monitor to say "go ahead" */
       if verbose>2 then say " Waiting for activation of " thesem

        foo=eventsem_wait(thesem,2000)
        if foo<>0 then do
           call delay(.2)
           iterate
        end
        call pmprintf('SRE-http initialization complete ')
       leave
  end     /* waiting on thesem */

return 1



/***********************************/
/* read static parameter files */
read_statics:

  if pos('.',static_params_file)=0 then static_params_file=static_params_file'.'port
  jjl=stream(static_params_file,'c','query size')
  if jjl=0 | jjl='' then do
         call pmprintf(' SRE-http ERROR: missing static parameters file: 'static_params_file)
         'string Error. Missing static parameters file: 'static_params_file
         'close'
         return 0
  end

  foo=stream(static_params_file,'c','open read')
  if abbrev(translate(foo),'READY')=0 then do
         call pmprintf(' SRE-http ERROR: unable to read static parameters file: 'static_params_file)
         'string Error. Unreadable static parameters file: 'static_params_file
         'close'
         return 0
  end

  sstuff=charin(static_params_file,1,jjl)
  foo=stream(static_params_file,'c','close')   
  sstuff=translate(sstuff,'; ','0d0a'x)
  interpret  sstuff
  call pmprintf('SRE-http: success on reading ' static_params_file)
/* some variables used in srefiltr.80 */
   osse='os2environment'
   dlist='ALWAYS_CHECK_PRIVS BACKUPSERVERLIST LOADTHRESHOLD CGI_BIN_PIECES DIR_CACHE_SIZE ',
           ' DIR_CACHE_DURATION EMPTY_PATH_OKAY HIT_SUPERUSER_SUPPRESS  NCSA_ISMAP CERN_ISMAP NEVER_IMAGEMAPS ' ,
           ' HEAD_TO_GET MAIN_SERVER KEY_PREFACE LOGON_LIMIT NEVER_PUBLICURLS PUT_NO_OVERWRITE ',
           ' PROXY_CACHE QUICK_INTERP QUICK_INTERP_CODE QUICK_REPLACE RANGE_AT_END REALM_1ST_PRIV ',
           ' SSI_EXTENSIONS USER_LOGON_PROC NO_NO_RECORD WILD_SELS_OK ENABLE_ENCRYPTION DEFAULT_ENCRYPTION '
   do until dlist=''
        parse var dlist a1 dlist
        avar0=strip(a1)
        aval0=value(avar0)
        foo=value('SREF_'avar0,aval0,osse)
  end
return 1


foo1:
say "error " sigl " " rc
exit

