/* Compute md5, for sre-http, daemon.
   Contains an internal array for retaining prior results.
   This is meant to be invoked by srefmon.cmd -- it is not
   to be run in standalone mode.
*/

SIGNAL ON SYNTAX NAME WOW ; SIGNAL ON ERROR NAME WOW
parse arg stuff
parse var stuff dmnname cachelen watchpid
call pmprintf(" stuff " stuff)
verbose=1 

if dmnname='' then do
  say "This is an SRE-http daemon -- it is not meant to be run in standalone mode"
  exit
end

apid=dospid()

incache=0
nentries=0
call pmprintf("SRE-http MD5 daemon ("dmnname") on "apid" w\cache size= "cachelen)
say " This is the SRE-http MD5 daemon (on pid "apid
say " Notes:"
say "  a) This will terminate when GoServe (on "watchpid") terminates"
say "  b) If you terminate this process, Content-MD5 headers will be suppressed "

do forever

  foo=dosprocinfo('N',watchpid)
  if foo='' then do
     call pmprintf('SRE-http MD5 daemon: exiting')
     exit
  end

  foo=sref_dmn_wait('MD5_DMN_SREF',16)  
  if foo='' then DO
     if incache>cachelen then incache=clean_cache(cachelen)   /* remove old entries */
     iterate
  end

  afile=upper(sref_dmn_value(foo))
  if afile="*PID*" then do
      foo=sref_dmn_reply(foo,apid)
      iterate
  end

  nowtime=stream(afile,'c','query datetime')
  if nowtime='' then do
     call pmprintf('SRE-http MD5 daemon: no such file 'afile)
     iterate
  end

/* see if it's in storage */
   eek=csh.afile
   storeme=1
   if abbrev(eek,'CSH.')=0 then do /* in storage */
      parse var eek nn','wastime','eek 
      if wastime<>nowtime then do
         nop
      end
      else do
         storeme=0
         nn=nn+1
         csh.afile=nn||','||wastime||','||eek
         if verbose>1 then call pmprintf(' SRE-http md5: using old value for 'afile)
      end
   end
   if storeme=1 then do
        eek=fig_md5(afile)
        CSH.afile='1,'||nowtime||','||eek
        incache=incache+1
        if verbose>1 then call pmprintf(' SRE-http md5: storing value for 'afile)
        if incache>cachelen then incache=clean_cache(cachelen)   /* remove old entries */
   end
   fii=sref_dmn_reply(foo,eek)
   if fii<>1 then call pmprintf('SRE-http md5 daemon: error processing 'afile '='fii)
end


exit



/*************/
/* clean up cache */
clean_cache:procedure expose csh.  csh2.
parse arg clen

foo=cvtails(CSH,ALIST)
todrop=clen*0.33
minbeat=0
didrop=0
say "Attempting to drop "todrop " from " clen
do forever
  minbeat=minbeat+1
  do mm=1 to alist.0
     atail=alist.mm
     if atail='' then iterate
     parse var csh.atail nn',' .
     if nn = minbeat then do
       drop csh.atail ;alist.mm=''
       didrop=didrop+1
      end
     if didrop>todrop then leave  /* got rid of enough ? */
  end

  if didrop>todrop then leave  /* else, get rid of some more */
end

say " Cache cleaned (dropped entries= "didrop
return (clen-didrop)


WOW:
CALL PMPRINTF("SRE-HTTP SREDOMD5.CMD ERROR AT " SIGL' 'RC)
EXIT


/* make md5 using srx_md5 */


/***********/
fig_md5:procedure

parse arg afile

    isz=stream(afile,'c','query size')
    foo=stream(afile,'c','open read')
    in1=charin(afile,1,isz)
    foo=stream(afile,'c','close')
    a32=srx_md5(in1)

return a32




