/* SRE-http front end to tim tassonis's showdir */

show_dir:
parse arg  ddir, tempfile, reqstrg,list,verb ,uri,user, ,
          basedir ,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname,homedir
parse var list sel1 '?' .


if verb="" then do
    Say " This SRE-http add-on is NOT meant to be run from the command line! "
    Say "(see SHOWDIR.DOC for details)"
    exit
end  /* Do */

showdirp='showdir.rxx'

file=sref_do_virtual(ddir,sel1,enmadd,0,transaction,homedir,host_nickname)
/* get info from htaccess file (relative to sel1) */
  htfile=get_value('HTACCESS_FILE')
  if htfile=0 then do
     dir.build=1;dir.exclude='';dir.info=''; dir.describe=''
     dir.forbid=0
  end  /* Do */
  else do
     tmp1=sref_htaccess(0,file,htfile,0,0,0,0,0,0,0,1)   /* parse out usefull stuff */
     parse var tmp1 dir.build ',' DIR.exclude ',' dir.info  ,
                           ',' dir.describe ',' dir.forbid ',' ashow
     if strip(aSHOW)\=' ' then SHOWDIRp=ASHOW
     dir.describe=strip(dir.describe); dir.info=strip(dir.info)
     dir.exclude=strip(dir.exclude)
  end
  
  if strip(dir.build)=0 | strip(dir.forbid)=1 then do
        response('forbid','is denied.')
        return ' Forbidden directory '
  end
   sel1=strip(sel1,'l','/')
   interpret "message = "showdirp"(filespec('drive',file)||filespec('path',file), sel1, Dir.Describe, Dir.Info, Dir.Exclude)"
   foo=sref_var('VAR TYPE text/html BINARY NAME message')

return ' Directory displayed '


/* ----------- */                                                        
/* get environment value, possibly host specific */                      
/* ------------ */                                                       
get_value: procedure expose enmadd host_nickname                          
parse arg vname,hname0
if hname0=0 then 
        hname=' '
else                                                    
    hname=strip(host_nickname)                          

vname=strip(vname) ;
if hname<>' ' then do
   booger=strip(enmadd||vname||'.'||hname)
   aval=value(booger,,'os2environment')
   if aval<>' ' Then                                                     
        return aval                                                      
end                                                                      
aval=value(enmadd||vname,,'os2environment')                              
return aval                                                              



/* ----------------------------------------------------------------------- */
/* RESPONSE: Standard [mostly error] responses.                            */
/* ----------------------------------------------------------------------- */
/* This routine should stay in the main filter program.                    */
/* Arguments are: response type and extended message information.          */
/* It returns the GoServe command to handle the result file.               */
response: procedure expose tempfile  reqstrg   servername
  parse arg request, message
  select
    when request='badreq'   then use='400 Bad request syntax'
    when request='notfound' then use='404 Not found'
    when request='forbid'   then use='403 Forbidden'
    when request='unauth'   then use='401 Unauthorized'
    when request='notallowed' then use='405 Method not allowed'
    when request='notimplemented' then use='501 Not implemented'
    otherwise do
        use='406 Not acceptable'
        ss=sref_error('weird response '|| request||' '|| message,1)
      end
    end  /* Add others to this list as needed */


  /* Now set the response and build the response file */
  'RESPONSE HTTP/1.0' use     /* Set HTTP response line */
  parse var use code text
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'
  call lineout tempfile, "<html><head><title>"text"</title></head>"
  call lineout tempfile, "<body><h2>Sorry...</h2>"
  call lineout tempfile, "<p>The request from your Web client: " message"."
  call lineout tempfile, "<hr><em>HTTP response code:</em>" code '['text']'
  call lineout tempfile, "<br><em>From web server at:</em>" servername
  call lineout tempfile, "<br><em>Running:</em>" server()
  call lineout tempfile, "</body></html>"
  call lineout tempfile  /* close */
  foo=sref_gos('FILE ERASE TYPE text/html NAME' tempfile)
  return foo


