/* Utility to edit the srefiltr.80 file.
   This is especially useful when you want to remotely
   configure SREFILTR.80, as by a TELNET session */

/*--------------   Load REXX libraries ----- */
/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'

  call SysLoadFuncs
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end

if rxfuncquery('sref_fileread')<>0 then do
  ik=rxfuncadd('sref_fileread','rexxlib','LIB_FILEREAD')
  if ik<>0 then call pmprintf_sref(' SRE-http Monitor: Warning: unable to register SREF_FILEREAD')
end
if rxfuncquery('sref_filewrite')<>0 then do
  ik=rxfuncadd('sref_filewrite','rexxlib','LIB_FILEWRITE')
  if ik<>0 then call pmprintf_sref(' SRE-http Monitor: Warning: unable to register SREF_FILEWRITE')
end

/* some io stuff */
ansion=checkansi()
if ansion=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
end
else do
  say " Warning: Could not detect ANSI....  output will look ugly ! "
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;
  reverse=""
end  /* Do */

parse upper arg aval0
ii=wordpos('NOEXIT',aval0)
if ii>0 then do
    noexit=1
     aval0=delword(aval0,ii,1)
end /* do */
parse var aval0 davar daval
davar=upper(davar)
dofile0bk=''

if davar="" then do
  
   cls
   say  " " ; say

   issref=0
   say
   say cy_ye " The SRE-http INITFILT editor " normal
   say
   say " This is a simple editor for the SRE-http INITFILT parameters file."
   say " It's meant for quick and dirty use by those familiar with SRE-http."
   say "     (it's especially useful for remote (telnet) configuration ) "
   say " New users will probably want to use the www accessible configurator."
   say " "

whatfile:
   say "What " bold "  INITFILT file " normal"  file should be edited?"
   call charout , reverse "(ENTER=CFGS\INITFILT.80):" normal

   pull dofile0
   if dofile0='' then do
      dofile0='CFGS\initfilt.80'
      dofile0bk='CFGS\OLDCFGS\INIFILT.V??'
      issref=1
      say " Hint:  If you are unfamiliar with what these parameters do, "
      say "        we recommend perusing INITFILT.DOC"
      say
   end
   dofile=stream(dofile0,'c','query exists')
   if dofile=' ' then do
      say " No such file: " dofile
      signal whatfile
  end
end
else do
  dofile='CFGS\INITFILT.80'
end
foo=sref_fileread(dofile,lines,,'E')

if lines.0=0 then do
   say " Could not read " dofile
   signal byebye
end

 say " # lines in " dofile " = " lines.0


ivars=0
do ii=1 to lines.0
   lines.ii.!change=0
   lines.ii.!var=''
   if abbrev(strip(lines.ii),';')=1 then iterate
   ivars=ivars+1
   parse var lines.ii avar '=' aval ; aval=strip(strip(aval),,"'")
   lines.ii.!var=upper(strip(avar)) ; lines.ii.!val=aval
end /* do */
say " # of parameters=" ivars


do forever 

if davar="" then do
   say " "
   say bold " Enter name of variable to change. " normal
   say "     ? = List of variables "
   say "     ENTER = Done (write changes ) "
   say "     !QUIT = Exit (without writing changes "
   call charout, bold " VarName: " normal 
   parse upper pull lookvar ; lookvar=strip(lookvar)
end
else do
  lookvar=davar
end /* do */

if lookvar="" then leave

igot=0
if translate(lookvar)="!QUIT" then do
   say " Exiting without saving changes."
   call syssleep 1
   signal byebye 
end /* do */

if lookvar="?" then do
   Say bold " List of parameters (in alphabetical order) " normal
   aa=""
   ils=0 ; ikk=0
   do kk=1 to lines.0 
      if lines.kk.!var="" then iterate
      ikk=ikk+1
      hoo.ikk=lines.kk.!var
   end
   hoo.0=ikk
   foo=arraysort(hoo)
   do mm=1 to hoo.0
      if length(hoo.mm)<19 then
         aa=aa' 'left(hoo.mm,18)
      else
         aa=aa' 'left(hoo.mm,36)
      if length(aa)>70 then do
         say aa
         aa=""
         ils=ils+1
         if ils>10 then do 
              call charout, reverse " hit ENTER to continue, X to stop variable listing " normal
              fii=inkey('w')
              say
              if upper(fii)='X' then leave
              ils=0
         end /* do */
     end /* do */
   end /* do */
   if davar<>"" then do
      say
      say " Enter EDITINIT by itself for prompted actions. "
      say " Or, you can enter:" bold" EDITINIT varname  " normal" :  display current value of  varname "
      say "                   " bold" EDITINIT varname newvalue "normal " : set varname=newvalue "
      signal byebye
  end
  iterate

end /* do */

do mm=1 to lines.0
   if lines.mm.!var<>lookvar then iterate
   igot=mm
end /* do */

if igot=0 then do
    say " No such parameter: " lookvar
    if davar<>"" then signal byebye
    iterate        
end /* do */

if davar<>"" & daval="" then do
  say  bold lookvar '=' normal lines.igot.!val 
  signal byebye
end

if daval="" then do
  call charout,bold lookvar '='normal lines.igot.!val'  '
  if length(lines.igot.!val)>40 then  do
    say " " ; call charout,'      '
  end
  call charout, cy_ye'?'normal
  parse pull newval
end
else do
   newval=daval
end

newval=strip(newval,,"'")
tmp=""
do until newval=""
    parse var newval a1 "'" newval
   if newval<>"" then tmp=tmp||a1||"''"
end /* do */
tmp=tmp||a1
newval=tmp

if newval<>"" then lines.igot.!val=newval
if daval<>"" then leave

end

foy1:say " "
if daval<>"" then do
   ans='Y'
end /* do */
else do
  call charout, " Enter Y to save changes, N to quit: "
  pull ans
end
if ans='N' then do
    say " Changes " bold " not "normal " saved."
    signal byebye
end  /* Do */
if ans<>'Y' then signal foy1

ip=pos('.',dofile)
if ip=0 then do
   bakfile=dofile||'.V??'
end
else do
   bakfile=left(dofile,ip)||'V??'
end

if dofile0bk<>'' then bakfile=dofile0bk /* special case */

bakfile=dostempname(bakfile)
say ' Old version of ' dofile 
say '     is being renamed as '  bakfile
foo=dosrename(dofile,bakfile)
if foo=0 then   say " Warning: ERROR renaming! "
  

nl.0=lines.0
do mm=1 to lines.0
   if lines.mm.!var="" then do
      nl.mm=lines.mm
   end
   else do
      nl.mm=lines.mm.!var||"='"||lines.mm.!val||"'"
   end /* do */
end /* do */


nnn1=nl.0+1
nl.nnn1='; Updated on '||time('n')||' '||date('n')
nl.0=nnn1

foo=sref_filewrite(dofile,nl)
if foo=0 then do
    say ' Warning: new version of ' dofile ' was NOT written '
end
else do
  if issref=1 then do
    say " Reminder: changes to the parameters contained in " dofile  
    say "           will take effect within a few minutes. "
  end
end
signal byebye


byebye:
if noexit=1  then return 1
exit

 /* ------------------------------------------------------------------ */
 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* call:     CheckAnsi                                                */
 /*                                                                    */
 /* where:    -                                                        */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 /*                                                                    */
 /* note:     Tested with the German and the US version of OS/2 3.0    */
 /*                                                                    */
 /*                                                                    */
 CheckAnsi: PROCEDURE
   thisRC = -1

   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd

   "@ANSI 2>NUL | rxqueue 2>NUL"

   thisRC = 0

   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */

 InitAnsiEnd:
 signal off error
 RETURN thisRC




