/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    private transient ServletConfig config;

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this.service(httpServletRequest, httpServletResponse);
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (string.equals("GET") || string.equals("HEAD")) {
            long l = this.getLastModified(httpServletRequest);
            if (l < 0L) {
                this.doGet(httpServletRequest, httpServletResponse);
                return;
            }
            long l2 = httpServletRequest.getDateHeader("If-Modified-Since");
            if (l == l2) {
                httpServletResponse.sendError(304);
            } else {
                httpServletResponse.setDateHeader("Last-Modified", l);
                this.doGet(httpServletRequest, httpServletResponse);
            }
        } else if (string.equals("POST")) {
            this.doPost(httpServletRequest, httpServletResponse);
        } else if (string.equals("PUT")) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (string.equals("DELETE")) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else if (string.equals("OPTIONS")) {
            this.doOptions(httpServletRequest, httpServletResponse);
        } else if (string.equals("TRACE")) {
            this.doTrace(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(501, "Method not implemented");
        }
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getProtocol();
        String string2 = httpServletRequest.getMethod() + " not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }
}

