/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.CharScanner;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlPrinter;
import com.caucho.xml.XmlUtil;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class XslParser {
    static WriteStream dbg = LogStream.open("/caucho.com/xsl/parser");
    public boolean strictXsl;
    boolean rawText;
    int line;
    int textLine;
    ReadStream is;
    CharBuffer tag = new CharBuffer();
    CharBuffer text = new CharBuffer();
    Document xsl;
    private int peek = -1;
    private boolean seenCr;
    private String defaultMode;
    private HashMap macros = new HashMap();
    private boolean inTemplate;
    private CharScanner wsScanner = new CharScanner(" \t");
    private CharScanner delimScanner = new CharScanner(" \t;=");

    Document parse(ReadStream readStream) throws IOException {
        Node node;
        this.is = readStream;
        this.line = 1;
        this.defaultMode = null;
        this.xsl = Xml.createDocument();
        CauchoNode cauchoNode = (CauchoNode)((Object)this.xsl.createDocumentFragment());
        cauchoNode.setLocation(readStream.getUserPath(), this.line, 0);
        this.rawText = false;
        String string = null;
        int n = this.read();
        if (n == 60) {
            n = this.read();
            if (n == 63) {
                node = this.parsePi();
                if (node.getNodeName().equals("xml")) {
                    string = XmlUtil.getPIAttribute(node.getNodeValue(), "encoding");
                    if (string != null) {
                        readStream.setEncoding(string);
                    }
                } else {
                    cauchoNode.appendChild(node);
                }
                n = this.read();
            } else {
                this.peek = n;
                n = 60;
            }
        }
        this.parseNode(cauchoNode, "", true, n);
        node = null;
        Node node2 = cauchoNode.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("xsl:stylesheet")) {
                if (node != null) {
                    throw this.error("xsl:stylesheet must be sole top element");
                }
                node = (CauchoElement)node2;
            }
            node2 = node2.getNextSibling();
        }
        if (node == null) {
            node = (CauchoElement)this.xsl.createElement("xsl:stylesheet");
            node.setLocation(readStream.getUserPath(), 1, 0);
            node2 = this.xsl.createElement("xsl:output");
            node2.setAttribute("method", "xtp");
            node2.setAttribute("disable-output-escaping", "true");
            node.appendChild(node2);
            node.appendChild(cauchoNode);
        }
        if (string != null) {
            node2 = this.xsl.createElement("xsl:output");
            node2.setAttribute("encoding", string);
            node.insertBefore(node2, node.getFirstChild());
        }
        this.xsl.appendChild(node);
        if (dbg.canWrite()) {
            XmlPrinter.printXml(dbg, this.xsl);
        }
        return this.xsl;
    }

    private void parseNode(Node node, String string, boolean bl, int n) throws IOException {
        this.text.clear();
        if (string == ">>" && (n == 10 || n == 13)) {
            n = this.read();
        }
        while (n >= 0) {
            switch (n) {
                case 92: {
                    n = this.read();
                    if (n == 60) {
                        this.addText('<');
                        n = this.read();
                        break;
                    }
                    this.addText('\\');
                    break;
                }
                case 60: {
                    Object object;
                    n = this.read();
                    if (n == 47) {
                        n = this.readTag(this.read());
                        object = this.tag.toString();
                        if (((String)object).equals(string)) {
                            if ((n = this.skipWhitespace(n)) != 62) {
                                throw this.error("expected '>' at " + this.badChar(n));
                            }
                            this.addText(node);
                            if (((String)object).equals("xsl:template")) {
                                this.inTemplate = false;
                            }
                            return;
                        }
                        this.addText("</");
                        this.addText((String)object);
                        break;
                    }
                    if (n == 35) {
                        this.addText(node);
                        n = this.parseScriptlet(node);
                        break;
                    }
                    if (n == 63) {
                        this.addText(node);
                        object = this.parsePi();
                        node.appendChild((Node)object);
                        n = this.read();
                        break;
                    }
                    if (n == 33) {
                        this.addText(node);
                        n = this.parseDecl(node);
                        break;
                    }
                    if (n == 123) {
                        this.addText(node);
                        this.parseValueOf(node);
                        n = this.read();
                        break;
                    }
                    n = this.readTag(n);
                    object = this.tag.toString();
                    if (!this.rawText && !((String)object).equals("") || ((String)object).startsWith("xsl:") || ((String)object).startsWith("jsp:") || ((String)object).startsWith("xtp:") || this.macros.get(object) != null) {
                        this.addText(node);
                        this.parseElement(node, (String)object, n, bl);
                        n = this.read();
                        break;
                    }
                    this.addText("<");
                    this.addText((String)object);
                    break;
                }
                case 62: {
                    int n2 = this.read();
                    if (n2 == 62 && string == ">>") {
                        if (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == '\n') {
                            this.text.setLength(this.text.length() - 1);
                        }
                        if (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == '\r') {
                            this.text.setLength(this.text.length() - 1);
                        }
                        this.addText(node);
                        return;
                    }
                    this.addText('>');
                    n = n2;
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.addText((char)n);
                    n = this.read();
                    break;
                }
                default: {
                    if (bl) {
                        this.parseSpecial(node, n);
                        n = this.read();
                        break;
                    }
                    this.addText((char)n);
                    n = this.read();
                    break;
                }
            }
        }
        this.addText(node);
        if (!string.equals("")) {
            throw this.error("expected close of `" + string + "' (open at " + ((CauchoNode)node).getLine() + ")");
        }
    }

    private void parseText(Node node, String string, int n) throws IOException {
        while (n > 0 && n != 62) {
            n = this.read();
        }
        this.text.clear();
        n = this.read();
        while (n > 0) {
            if (n != 60) {
                this.addText((char)n);
                n = this.read();
                continue;
            }
            n = this.read();
            if (n != 47) {
                this.addText('<');
                continue;
            }
            n = this.read();
            if (!XmlChar.isNameStart(n)) {
                this.addText("</");
                continue;
            }
            n = this.readTag(n);
            String string2 = this.tag.toString();
            if (!string2.equals(string)) {
                this.addText("</");
                this.addText(string2);
                continue;
            }
            if ((n = this.skipWhitespace(n)) == 62) break;
            throw this.error("expected `>' at " + this.badChar(n));
        }
        this.addText(node);
        this.text.clear();
    }

    private Element parseElement(Node node, String string, int n, boolean bl) throws IOException {
        Object object;
        CauchoElement cauchoElement = (CauchoElement)this.xsl.createElement(string);
        cauchoElement.setLocation(this.is.getUserPath(), this.line, 0);
        n = this.parseAttributes(cauchoElement, n);
        if (string.equals("xsl:stylesheet") && cauchoElement.getAttribute("parsed-content").equals("false")) {
            this.rawText = true;
            object = this.xsl.createElement("xsl:output");
            object.setAttribute("disable-output-escaping", "yes");
            cauchoElement.appendChild((Node)object);
        }
        if (this.rawText && (string.startsWith("xsl") || string.startsWith("xtp")) && cauchoElement.getAttribute("xml:space").equals("")) {
            cauchoElement.setAttribute("xml:space", "default");
        }
        if (string.equals("xsl:template")) {
            this.inTemplate = true;
            object = cauchoElement.getAttribute("name");
            if (!((String)object).equals("")) {
                this.macros.put(object, object);
            }
        }
        object = this.defaultMode;
        if (string.equals("xtp:mode")) {
            this.defaultMode = cauchoElement.getAttribute("mode");
        } else {
            node.appendChild(cauchoElement);
            node = cauchoElement;
        }
        if (n == 62) {
            this.parseNode(node, string, bl && string.equals("xsl:stylesheet"), this.read());
        } else if (n == 47) {
            n = this.read();
            if (n != 62) {
                throw this.error("expected '>' at " + this.badChar(n));
            }
        } else {
            throw this.error("expected '>' at " + this.badChar(n));
        }
        this.defaultMode = object;
        return cauchoElement;
    }

    private int parseScriptlet(Node node) throws IOException {
        CauchoNode cauchoNode;
        String string = this.is.getUserPath();
        int n = this.line;
        int n2 = this.read();
        if (n2 == 61) {
            cauchoNode = (CauchoNode)((Object)this.xsl.createElement("xtp:expression"));
            n2 = this.read();
        } else if (n2 == 33) {
            cauchoNode = (CauchoNode)((Object)this.xsl.createElement("xtp:declaration"));
            n2 = this.read();
        } else {
            if (n2 == 64) {
                this.parseDirective(node);
                return this.read();
            }
            cauchoNode = (CauchoNode)((Object)this.xsl.createElement("xtp:scriptlet"));
        }
        cauchoNode.setLocation(this.is.getUserPath(), n, 0);
        node.appendChild(cauchoNode);
        this.text.clear();
        while (n2 >= 0) {
            if (n2 == 35) {
                n2 = this.read();
                if (n2 == 62) break;
                this.addText('#');
                continue;
            }
            this.addText((char)n2);
            n2 = this.read();
        }
        cauchoNode.appendChild(this.xsl.createTextNode(this.text.toString()));
        this.text.clear();
        return this.read();
    }

    private void parseDirective(Node node) throws IOException {
        String string;
        int n = this.skipWhitespace(this.read());
        n = this.readTag(n);
        String string2 = this.tag.toString();
        if (!string2.equals("page") && !string2.equals("cache")) {
            throw this.error("unknown directive `" + string2 + "'");
        }
        CauchoElement cauchoElement = (CauchoElement)this.xsl.createElement("xtp:directive." + string2);
        cauchoElement.setLocation(this.is.getUserPath(), this.line, 0);
        node.appendChild(cauchoElement);
        n = this.parseAttributes(cauchoElement, n);
        if (n != 35) {
            throw this.error("expected `#' at " + this.badChar(n));
        }
        n = this.read();
        if (n != 62) {
            throw this.error("expected `>' at " + this.badChar(n));
        }
        if (string2.equals("page") && !(string = cauchoElement.getAttribute("contentType")).equals("")) {
            this.parseContentType(node, string);
        }
    }

    private void parseContentType(Node node, String string) throws IOException {
        StringCharCursor stringCharCursor = new StringCharCursor(string);
        CharBuffer charBuffer = new CharBuffer();
        this.wsScanner.skip(stringCharCursor);
        this.delimScanner.scan(stringCharCursor, charBuffer);
        if (charBuffer.length() <= 0) {
            return;
        }
        Element element = this.xsl.createElement("xsl:output");
        node.appendChild(element);
        element.setAttribute("media-type", charBuffer.toString());
        this.delimScanner.skip(stringCharCursor);
        charBuffer.clear();
        this.delimScanner.scan(stringCharCursor, charBuffer);
        this.wsScanner.skip(stringCharCursor);
        if (((CharCursor)stringCharCursor).current() == '=' && charBuffer.toString().equals("charset")) {
            this.delimScanner.skip(stringCharCursor);
            charBuffer.clear();
            this.delimScanner.scan(stringCharCursor, charBuffer);
            if (charBuffer.length() > 0) {
                element.setAttribute("encoding", Encoding.getMimeName(charBuffer.toString()));
                this.is.setEncoding(charBuffer.toString());
            }
        }
    }

    private int parseAttributes(Element element, int n) throws IOException {
        n = this.skipWhitespace(n);
        while (XmlChar.isNameStart(n)) {
            n = this.readTag(n);
            String string = this.tag.toString();
            if ((n = this.skipWhitespace(n)) == 61) {
                n = this.skipWhitespace(this.read());
                n = this.readValue(n);
                n = this.skipWhitespace(n);
                element.setAttribute(string, this.tag.toString());
                continue;
            }
            element.setAttribute(string, string);
        }
        return n;
    }

    private ProcessingInstruction parsePi() throws IOException {
        int n = this.read();
        if (!XmlChar.isNameStart(n)) {
            throw this.error("expected name at " + this.badChar(n));
        }
        n = this.readTag(n);
        String string = this.tag.toString();
        this.text.clear();
        while (n >= 0) {
            if (n == 63) {
                n = this.read();
                if (n == 62) {
                    ProcessingInstruction processingInstruction = this.xsl.createProcessingInstruction(string, this.text.toString());
                    this.text.clear();
                    return processingInstruction;
                }
                this.addText('?');
                continue;
            }
            this.addText((char)n);
            n = this.read();
        }
        throw this.error("expected `?>' at end of file");
    }

    /*
     * Unable to fully structure code
     */
    private int parseDecl(Node var1_1) throws IOException {
        var2_2 = this.read();
        if (var2_2 != 45) {
            this.addText("<!");
            return var2_2;
        }
        var2_2 = this.read();
        if (var2_2 == 45) ** GOTO lbl16
        this.addText("<!-");
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var2_2 = this.read();
            if (var2_2 != 45) continue;
            var2_2 = this.read();
            while (var2_2 == 45) {
                var2_2 = this.read();
                if (var2_2 != 62) continue;
                return this.read();
            }
lbl16:
            // 3 sources

            ** while (var2_2 >= 0)
        }
lbl17:
        // 1 sources

        throw this.error("unterminated comment at end of file");
    }

    private void parseValueOf(Node node) throws IOException {
        int n = this.read();
        while (n >= 0) {
            if (n == 125) {
                n = this.read();
                if (n == 62) {
                    CauchoElement cauchoElement = (CauchoElement)this.xsl.createElement("xsl:value-of");
                    cauchoElement.setAttribute("select", this.text.toString());
                    cauchoElement.setLocation(this.is.getUserPath(), this.line, 0);
                    node.appendChild(cauchoElement);
                    this.text.clear();
                    return;
                }
                this.addText('}');
                continue;
            }
            this.addText((char)n);
            n = this.read();
        }
    }

    private void parseSpecial(Node node, int n) throws IOException {
        char c = '#';
        String string = "xtp:scriptlet";
        this.text.clear();
        String string2 = this.is.getUserPath();
        int n2 = this.line;
        while (n >= 0) {
            if (n == 60) {
                string2 = this.is.getUserPath();
                n2 = this.line;
                n = this.read();
                if (n == 35) {
                    c = '#';
                    n = this.read();
                    if (n != 61) break;
                    n = this.read();
                    string = "xtp:expression";
                    break;
                }
                if (n == 60) {
                    c = '>';
                    break;
                }
                if (n != 92) continue;
                this.addText((char)this.read());
                n = this.read();
                continue;
            }
            this.addText((char)n);
            n = this.read();
        }
        while (this.text.length() > 0 && Character.isSpace(this.text.charAt(this.text.length() - 1))) {
            this.text.setLength(this.text.length() - 1);
        }
        CauchoElement cauchoElement = (CauchoElement)this.xsl.createElement("xsl:template");
        node.appendChild(cauchoElement);
        String string3 = this.text.toString();
        cauchoElement.setAttribute("match", string3);
        boolean bl = true;
        int n3 = 0;
        while (n3 < string3.length()) {
            if (!XmlChar.isNameChar(string3.charAt(n3))) {
                bl = false;
                break;
            }
            ++n3;
        }
        if (bl) {
            // empty if block
        }
        if (this.defaultMode != null) {
            cauchoElement.setAttribute("mode", this.defaultMode);
        }
        cauchoElement.setLocation(string2, n2, 0);
        this.text.clear();
        this.inTemplate = true;
        if (c == '>') {
            if (this.rawText) {
                cauchoElement.setAttribute("xml:space", "preserve");
            }
            this.parseNode(cauchoElement, ">>", false, this.read());
            this.inTemplate = false;
            return;
        }
        CauchoNode cauchoNode = (CauchoNode)((Object)this.xsl.createElement(string));
        cauchoNode.setLocation(string2, n2, 0);
        while (n >= 0) {
            if (n == c) {
                n = this.read();
                if (n == 62) break;
                this.addText(c);
                continue;
            }
            this.addText((char)n);
            n = this.read();
        }
        cauchoNode.appendChild(this.xsl.createTextNode(this.text.toString()));
        cauchoElement.appendChild(cauchoNode);
        this.text.clear();
        this.inTemplate = false;
    }

    private void addText(char c) {
        if (this.text.length() == 0) {
            this.textLine = c == '\n' ? this.line - 1 : this.line;
        }
        this.text.append(c);
    }

    private void addText(String string) {
        if (this.text.length() == 0) {
            this.textLine = this.line;
        }
        this.text.append(string);
    }

    private int skipWhitespace(int n) throws IOException {
        while (XmlChar.isWhitespace(n)) {
            n = this.read();
        }
        return n;
    }

    private int readTag(int n) throws IOException {
        this.tag.clear();
        while (XmlChar.isNameChar(n)) {
            this.tag.append((char)n);
            n = this.read();
        }
        return n;
    }

    private int readValue(int n) throws IOException {
        this.tag.clear();
        if (n == 39) {
            n = this.read();
            while (n >= 0 && n != 39) {
                this.tag.append((char)n);
                n = this.read();
            }
            if (n != 39) {
                throw this.error("expected '");
            }
            return this.read();
        }
        if (n == 34) {
            n = this.read();
            while (n >= 0 && n != 34) {
                this.tag.append((char)n);
                n = this.read();
            }
            if (n != 34) {
                throw this.error("expected `\"'");
            }
            return this.read();
        }
        if (XmlChar.isNameChar(n)) {
            while (XmlChar.isNameChar(n)) {
                this.tag.append((char)n);
                n = this.read();
            }
            return n;
        }
        throw this.error("bad value at " + this.badChar(n));
    }

    private void addText(Node node) {
        if (this.text.getLength() != 0) {
            Text text = this.xsl.createTextNode(this.text.toString());
            CauchoNode cauchoNode = (CauchoNode)((Object)text);
            cauchoNode.setLocation(this.is.getPath().getUserPath(), this.textLine, 0);
            node.appendChild(text);
        }
        this.text.clear();
    }

    private IOException error(String string) {
        return new IOException(this.is.getPath().getUserPath() + ":" + this.line + ": " + string);
    }

    private String badChar(int n) {
        if (n < 0) {
            return "end of file";
        }
        if (n == 10 || n == 13) {
            return "end of line";
        }
        return "`" + (char)n + "'";
    }

    public int read() throws IOException {
        if (this.peek >= 0) {
            int n = this.peek;
            this.peek = -1;
            return n;
        }
        int n = this.is.readChar();
        if (n == 13) {
            n = this.is.readChar();
            if (n != 10 && n >= 0) {
                this.peek = n;
            }
            n = 10;
        }
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    XslParser() {
    }
}

