/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.JavaCompiler;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xpath.Expr;
import com.caucho.xpath.XPath;
import com.caucho.xsl.Generator;
import com.caucho.xsl.JavaGenerator;
import com.caucho.xsl.JavaScriptGenerator;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.XslParseException;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

class XslGenerator {
    static StylesheetImpl generate(Document document, Path path, Path[] pathArray, Path[] pathArray2, ClassLoader classLoader, String string) throws XslParseException {
        try {
            Object object;
            Generator generator;
            String string2;
            if (path == null) {
                path = Vfs.lookup("anonymous.xsl");
            }
            Expr expr = XPath.parseExpr("//xtp:directive.page/@language");
            String string3 = expr.evalString(document);
            if (string == null) {
                string = JavaCompiler.mangleName(path.getPath());
            }
            if ((string2 = XPath.evalString("//xsl:output/@encoding", document)) != null && string2.equals("")) {
                string2 = null;
            }
            if (string3 == null || string3.equals("") || string3.equals("java")) {
                string3 = "java";
                generator = new JavaGenerator(path, pathArray, classLoader, string, string2);
            } else if (string3.equals("ecmascript") || string3.equals("javascript")) {
                generator = new JavaScriptGenerator(path, pathArray, pathArray2, classLoader, string);
            } else {
                throw new XslParseException("unsupported language `" + string3 + "'");
            }
            Iterator iterator = XPath.select("//xtp:directive.page/@*", document);
            while (iterator.hasNext()) {
                object = (Attr)iterator.next();
                String string4 = object.getNodeName();
                String string5 = object.getNodeValue();
                if (string4.equals("errorPage")) {
                    generator.setErrorPage(string5);
                    continue;
                }
                if (string4.equals("import")) {
                    generator.addImport(string5);
                    continue;
                }
                if (string4.equals("contentType")) {
                    generator.setContentType(string5);
                    continue;
                }
                if (string4.equals("language")) {
                    if (string3.equalsIgnoreCase(string5)) continue;
                    throw new XslParseException("mismatched language `" + string5 + "'");
                }
                if (string4.equals("xml:space")) continue;
                throw new XslParseException("unknown directive `" + string4 + "'");
            }
            object = generator.generate(document);
            ((StylesheetImpl)object).init(path.getParent());
            return object;
        }
        catch (XslParseException xslParseException) {
            throw xslParseException;
        }
        catch (Exception exception) {
            throw new XslParseException(exception);
        }
    }

    XslGenerator() {
    }
}

