/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.LineMap;
import com.caucho.regexp.Regexp;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.XmlPrinter;
import com.caucho.xsl.CacheableDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.jsp.PageContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class Stylesheet {
    private ArrayList depends = new ArrayList();
    protected ArrayList cacheDepends = new ArrayList();
    private HashMap outputAttributes;
    protected String errorPage;
    boolean escapeEntities = true;

    public void init(Path path) throws Exception {
    }

    public String getOutputAttribute(String string) {
        if (this.outputAttributes == null) {
            return null;
        }
        return (String)this.outputAttributes.get(string);
    }

    void setOutputAttributes(HashMap hashMap) {
        this.outputAttributes = hashMap;
    }

    protected void setOutputAttribute(String string, String string2) {
        if (this.outputAttributes == null) {
            this.outputAttributes = new HashMap();
        }
        this.outputAttributes.put(string, string2);
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public long getLastModified() {
        long l = 0L;
        int n = 0;
        while (n < this.depends.size()) {
            Depend depend = (Depend)this.depends.get(n);
            long l2 = depend.getLastModified();
            if (l2 > l) {
                l = l2;
            }
            ++n;
        }
        return l;
    }

    public boolean isModified() {
        long l = 0L;
        int n = 0;
        while (n < this.depends.size()) {
            Depend depend = (Depend)this.depends.get(n);
            if (depend.isModified()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void addDepend(Path path) {
        this.depends.add(new Depend(path, path.getLastModified()));
    }

    protected void addDepend(Path path, long l) {
        this.depends.add(new Depend(path, l));
    }

    public ArrayList getDepends() {
        return this.depends;
    }

    protected void addCacheDepend(String string) {
        this.cacheDepends.add(string);
    }

    public ArrayList getCacheDepends() {
        return this.cacheDepends;
    }

    public abstract Document transform(Node var1, HashMap var2, Path var3, PageContext var4) throws Exception;

    public Document transform(Node node, HashMap hashMap) throws Exception {
        return this.transform(node, hashMap, Pwd.lookup(), null);
    }

    public Document transform(Node node) throws Exception {
        return this.transform(node, null, Pwd.lookup(), null);
    }

    public abstract CacheableDocument transformCacheable(Node var1, HashMap var2, Path var3, PageContext var4) throws Exception;

    public String getContentType() {
        String string = this.getOutputAttribute("media-type");
        String string2 = this.getOutputAttribute("encoding");
        if (string == null) {
            string = "text/html";
        }
        if (string2 != null) {
            return string + "; charset=" + string2;
        }
        return string;
    }

    public void print(WriteStream writeStream, Node node) throws IOException {
        this.print(writeStream, node, false);
    }

    public LineMap print(WriteStream writeStream, Node node, boolean bl) throws IOException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        Object object2;
        if (node == null) {
            return null;
        }
        String string6 = this.getOutputAttribute("method");
        if (string6 == null) {
            object2 = node.getFirstChild();
            while (object2 != null) {
                if (object2 instanceof CauchoElement) {
                    object = (CauchoElement)object2;
                    string6 = string6 == null && object.getLocalName().equalsIgnoreCase("html") && object.getNamespace().equals("") ? "html" : "xml";
                }
                object2 = object2.getNextSibling();
            }
        }
        if (string6 == null) {
            string6 = "xml";
        }
        if ((object2 = this.getOutputAttribute("encoding")) != null) {
            writeStream.setEncoding((String)object2);
        }
        if (string6.equals("text")) {
            this.printText(writeStream, node);
            return null;
        }
        if (string6.equals("xtp")) {
            boolean bl2;
            if (object2 == null) {
                writeStream.setEncoding("us-ascii");
            }
            object = new XmlPrinter(writeStream);
            string5 = this.getOutputAttribute("version");
            if (string5 == null) {
                ((XmlPrinter)object).setHtml(3.2);
            } else if (string5.compareTo("4.0") >= 0) {
                ((XmlPrinter)object).setHtml(4.0);
                ((XmlPrinter)object).setPublicId("-//W3C/DTD HTML 4.0 Frameset//EN");
                ((XmlPrinter)object).setSystemId("http://www.w3c.org/TR/REC-html40/frameset.dtd");
            } else {
                ((XmlPrinter)object).setPublicId("-//W3C/DTD HTML 3.2 Final//EN");
                ((XmlPrinter)object).setHtml(3.2);
            }
            string4 = this.getOutputAttribute("omit-html-declaration");
            if (string4 == null) {
                string4 = this.getOutputAttribute("omit-xml-declaration");
            }
            boolean bl3 = bl2 = string4 == null || string4.equals("no") || string4.equals("false");
            if (bl2) {
                ((XmlPrinter)object).setPrintDeclaration(true);
            }
            if ((string3 = this.getOutputAttribute("indent")) != null && (string3.equals("no") || string3.equals("false"))) {
                ((XmlPrinter)object).setPretty(false);
            } else {
                ((XmlPrinter)object).setPretty(true);
            }
        } else if (string6.equals("html")) {
            boolean bl4;
            if (object2 == null) {
                writeStream.setEncoding("us-ascii");
            }
            object = new XmlPrinter(writeStream);
            String string7 = this.getOutputAttribute("omit-html-declaration");
            if (string7 == null) {
                string7 = this.getOutputAttribute("omit-xml-declaration");
            }
            boolean bl5 = bl4 = string7 == null || string7.equals("no") || string7.equals("false");
            if (bl4) {
                ((XmlPrinter)object).setPrintDeclaration(true);
            }
            if ((string4 = this.getOutputAttribute("version")) == null || string4.compareTo("4.0") >= 0) {
                ((XmlPrinter)object).setHtml(4.0);
                if (bl4) {
                    ((XmlPrinter)object).setPublicId("-//W3C/DTD HTML 4.0 Frameset//EN");
                    ((XmlPrinter)object).setSystemId("http://www.w3c.org/TR/REC-html40/frameset.dtd");
                }
            } else {
                ((XmlPrinter)object).setHtml(3.2);
                if (bl4) {
                    ((XmlPrinter)object).setPublicId("-//W3C/DTD HTML 3.2 Final//EN");
                }
            }
            string3 = this.getOutputAttribute("indent");
            if (string3 != null && string3.equals("no")) {
                ((XmlPrinter)object).setPretty(false);
            } else {
                ((XmlPrinter)object).setPretty(true);
            }
        } else {
            if (object2 == null) {
                writeStream.setEncoding("utf-8");
            }
            object = new XmlPrinter(writeStream);
            string5 = this.getOutputAttribute("omit-xml-declaration");
            if (string5 == null || string5.equals("no")) {
                ((XmlPrinter)object).setPrintDeclaration(true);
            }
            ((XmlPrinter)object).setStandalone(this.getOutputAttribute("standalone"));
        }
        if (bl) {
            ((XmlPrinter)object).setLineMap(writeStream.getPath().getNativePath());
        }
        if ((string5 = this.getOutputAttribute("media-type")) != null) {
            ((XmlPrinter)object).setMimeType(string5);
        }
        if ((string2 = this.getOutputAttribute("doctype-system")) != null) {
            ((XmlPrinter)object).setSystemId(string2);
        }
        if ((string4 = this.getOutputAttribute("doctype-public")) != null) {
            ((XmlPrinter)object).setPublicId(string4);
        }
        if ((string3 = this.getOutputAttribute("indent")) != null && string3.equals("yes")) {
            ((XmlPrinter)object).setPretty(true);
        } else if (string3 != null) {
            ((XmlPrinter)object).setPretty(false);
        }
        String string8 = this.getOutputAttribute("disable-output-escaping");
        if (string8 != null && !string8.equals("no") && !string8.equals("false")) {
            ((XmlPrinter)object).setEscaping(false);
        }
        if ((string = this.getOutputAttribute("cdata-section-elements")) != null) {
            try {
                Regexp regexp = new Regexp("[,\\s]+");
                ArrayList arrayList = regexp.split(string);
                int n = 0;
                while (n < arrayList.size()) {
                    ((XmlPrinter)object).addCdataElement((String)arrayList.get(n));
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ((XmlPrinter)object).print(node);
        return ((XmlPrinter)object).getLineMap();
    }

    private void printText(WriteStream writeStream, Node node) throws IOException {
        while (node != null) {
            if (node instanceof Text) {
                writeStream.print(node.getNodeValue());
            } else {
                this.printText(writeStream, node.getFirstChild());
            }
            node = node.getNextSibling();
        }
    }

    public static class Depend {
        Path path;
        long lastModified;

        public boolean isModified() {
            return this.path.getLastModified() > this.lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public Path getPath() {
            return this.path;
        }

        Depend(Path path, long l) {
            this.path = path;
            this.lastModified = l;
        }
    }
}

