/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.es.Call;
import com.caucho.es.Script;
import com.caucho.es.ScriptClosure;
import com.caucho.vfs.Path;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathParseException;
import com.caucho.xsl.Sort;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Template;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Node;

public class JavaScriptStylesheet
extends StylesheetImpl {
    protected Expr[] _xsl_exprs;
    protected Sort[][] _xsl_sorts;
    protected NamespaceContext[] _xsl_ns;
    protected XslNumberFormat[] _xsl_formats;
    ArrayList patterns = new ArrayList();
    ArrayList callKeys = new ArrayList();
    ArrayList callValues = new ArrayList();
    ArrayList scopeList = new ArrayList();
    ArrayList values = new ArrayList();
    HashMap macros = new HashMap();
    HashMap functions = new HashMap();
    Script script;

    public long getLastModified() {
        long l;
        long l2 = this.script.getLastModified();
        if (l2 > (l = super.getLastModified())) {
            return l2;
        }
        return l;
    }

    void setScript(Script script) {
        this.script = script;
    }

    public void init(XslWriter xslWriter, HashMap hashMap) throws Exception {
        Path path;
        super.init(xslWriter, hashMap);
        if (hashMap == null) {
            hashMap = new HashMap<String, Path>();
        }
        if ((path = hashMap.put("File", xslWriter.getPwd())) != null) {
            hashMap.put("File", path);
        }
        xslWriter.setClosure(this.script.executeClosure(hashMap, this));
    }

    protected void _xsl_init(XslWriter xslWriter, Node node, Env env) throws Exception {
        ScriptClosure scriptClosure = (ScriptClosure)xslWriter.getClosure();
        scriptClosure.call("_xsl_init", xslWriter, node, env);
    }

    void addMacro(String string, String string2, double d, String string3) {
        this.macros.put(string, string3);
    }

    public void applyTemplates(Call call, int n) throws Exception {
        if (n < 3) {
            return;
        }
        XslWriter xslWriter = (XslWriter)call.getArgObject(0, n);
        Node node = (Node)call.getArgObject(1, n);
        Env env = (Env)call.getArgObject(2, n);
        Pattern pattern = null;
        if (n > 3) {
            int n2 = call.getArgInt32(3, n);
            pattern = this.getPattern(n2);
        }
        String string = null;
        if (n > 4) {
            string = call.getArgString(4, n);
        }
        int n3 = -1;
        if (n > 5) {
            n3 = call.getArgInt32(5, n);
        }
        Sort[] sortArray = null;
        if (n > 6) {
            int n4 = call.getArgInt32(6, n);
            sortArray = this._xsl_sorts[n4];
        }
        Env env2 = XPath.createEnv(env);
        this.setArgs(xslWriter, node, n3, env, env2);
        if (pattern == null) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.applyNode(xslWriter, node2, env2, string, 0, Integer.MAX_VALUE);
                node2 = node2.getNextSibling();
            }
        } else if (sortArray == null) {
            Iterator iterator = pattern.select(node, env2);
            while (iterator.hasNext()) {
                Node node3 = (Node)iterator.next();
                this.applyNode(xslWriter, node3, env2, string, 0, Integer.MAX_VALUE);
            }
        } else {
            ArrayList arrayList = this.xslSort(node, env2, pattern, sortArray);
            int n5 = 0;
            while (n5 < arrayList.size()) {
                this.applyNode(xslWriter, (Node)arrayList.get(n5), env2, string, 0, Integer.MAX_VALUE);
                ++n5;
            }
        }
        XPath.freeEnv(env2);
    }

    public void applyImports(XslWriter xslWriter, Node node, Env env, String string, int n, int n2, int n3) throws Exception {
        Env env2 = XPath.createEnv(env);
        this.setArgs(xslWriter, node, n3, env, env2);
        this.applyNode(xslWriter, node, env2, string, n, n2);
        XPath.freeEnv(env2);
    }

    public void callTemplate(XslWriter xslWriter, Node node, Env env, String string, int n) throws Exception {
        String string2 = (String)this.macros.get(string);
        ScriptClosure scriptClosure = (ScriptClosure)xslWriter.getClosure();
        Env env2 = XPath.createEnv(env);
        if (StylesheetImpl.dbg.canWrite()) {
            StylesheetImpl.dbg.print("[call: " + string + " fun=" + string2);
        }
        this.setArgs(xslWriter, node, n, env, env2);
        if (StylesheetImpl.dbg.canWrite()) {
            StylesheetImpl.dbg.println();
        }
        scriptClosure.call(string2, xslWriter, node, env2);
        if (StylesheetImpl.dbg.canWrite()) {
            StylesheetImpl.dbg.println(string + "]");
        }
        XPath.freeEnv(env2);
    }

    protected void applyNode(XslWriter xslWriter, Node node, Env env, String string, int n, int n2) throws Exception {
        if (node == null) {
            return;
        }
        Template template = this.getTemplate(node, env, string, n, n2);
        if (template == null) {
            this.applyNodeDefault(xslWriter, node, env, string);
            return;
        }
        if (StylesheetImpl.dbg.canWrite()) {
            StylesheetImpl.dbg.println("[node: " + node.getNodeName() + " mode=" + string + " " + " pat=" + template.pattern + " tmode=" + template.mode + " fun=" + template.function);
        }
        ScriptClosure scriptClosure = (ScriptClosure)xslWriter.getClosure();
        scriptClosure.call(template.function, xslWriter, node, env);
        if (StylesheetImpl.dbg.canWrite()) {
            StylesheetImpl.dbg.println(node.getNodeName() + "]");
        }
    }

    private void setArgs(XslWriter xslWriter, Node node, int n, Env env, Env env2) throws Exception {
        if (n >= 0) {
            ArrayList arrayList = (ArrayList)this.callKeys.get(n);
            ArrayList arrayList2 = (ArrayList)this.callValues.get(n);
            ScriptClosure scriptClosure = (ScriptClosure)xslWriter.getClosure();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                String string = (String)arrayList.get(n2);
                Object object = arrayList2.get(n2);
                if (object instanceof Expr) {
                    Expr expr = (Expr)object;
                    object = expr.evalObject(node, env);
                } else if (object instanceof Integer) {
                    int n3 = (Integer)object;
                    object = scriptClosure.call("_xsl_fragment_" + n3, xslWriter, node, env);
                }
                if (StylesheetImpl.dbg.canWrite()) {
                    StylesheetImpl.dbg.print(" " + string + "=" + object);
                }
                env2.addVar(string, object);
                ++n2;
            }
        }
    }

    public void writeText(XslWriter xslWriter, int n, int n2) throws IOException {
        xslWriter.write(this.text, n, n2);
    }

    public void singleNumberJs(XslWriter xslWriter, Node node, Env env, int n, int n2, int n3) throws Exception {
        Pattern pattern = this.getPattern(n);
        Pattern pattern2 = this.getPattern(n2);
        this.singleNumber(xslWriter, node, env, pattern, pattern2, this._xsl_formats[n3]);
    }

    public void multiNumberJs(XslWriter xslWriter, Node node, Env env, int n, int n2, int n3) throws Exception {
        Pattern pattern = this.getPattern(n);
        Pattern pattern2 = this.getPattern(n2);
        this.multiNumber(xslWriter, node, env, pattern, pattern2, this._xsl_formats[n3]);
    }

    public void anyNumberJs(XslWriter xslWriter, Node node, Env env, int n, int n2, int n3) throws Exception {
        Pattern pattern = this.getPattern(n);
        Pattern pattern2 = this.getPattern(n2);
        this.anyNumber(xslWriter, node, env, pattern, pattern2, this._xsl_formats[n3]);
    }

    public void exprNumberJs(XslWriter xslWriter, Node node, Env env, int n, int n2) throws Exception {
        this.exprNumber(xslWriter, node, env, this._xsl_exprs[n], this._xsl_formats[n2]);
    }

    public void printExpr(XslWriter xslWriter, Node node, Env env, int n) throws IOException {
        Object object = this._xsl_exprs[n].evalObject(node, env);
        xslWriter.valueOf(object);
    }

    public void copyOf(XslWriter xslWriter, Node node, Env env, int n) throws IOException {
        Object object = this._xsl_exprs[n].evalObject(node, env);
        xslWriter.copyOf(object);
    }

    public String stringExpr(Node node, Env env, int n) throws XPathParseException {
        return this._xsl_exprs[n].evalString(node, env);
    }

    public void pushElement(XslWriter xslWriter, String string, int n) throws IOException {
        xslWriter.pushElement(string, this._xsl_ns[n]);
    }

    public void pushAttribute(XslWriter xslWriter, String string, int n) throws IOException {
        xslWriter.pushAttribute(string, this._xsl_ns[n]);
    }

    public Iterator select(Node node, Env env, int n) throws XPathParseException {
        Pattern pattern = this.getPattern(n);
        return pattern.select(node, env);
    }

    public Iterator _xsl_sort(Node node, Env env, int n, int n2) throws Exception {
        Pattern pattern = this.getPattern(n);
        Sort[] sortArray = this._xsl_sorts[n2];
        ArrayList arrayList = this.xslSort(node, env, pattern, sortArray);
        return ((AbstractList)arrayList).iterator();
    }

    public boolean test(Node node, Env env, int n) throws XPathParseException {
        return this._xsl_exprs[n].evalBoolean(node, env);
    }

    public void setParamVariable(XslWriter xslWriter, Node node, Env env, String string, Object object) throws Exception {
        Object object2 = env.getVar(string = string.intern());
        if (object2 == null) {
            env.addVar(string, object);
        }
    }

    public void setVariable(XslWriter xslWriter, Node node, Env env, String string, Object object) throws Exception {
        env.addVar(string.intern(), object);
    }

    public Object evalExpr(Node node, Env env, int n) throws Exception {
        return this._xsl_exprs[n].evalObject(node, env);
    }

    public ArrayList getScope(int n) {
        return (ArrayList)this.scopeList.get(n);
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public Pattern getPattern(int n) {
        if (n < 0) {
            return null;
        }
        return (Pattern)this.patterns.get(n);
    }

    public void popScope(Env env, int n) throws Exception {
        env.popVars(n);
    }
}

