/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.JavaCompiler;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.IntArray;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.CauchoNode;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.Pattern;
import com.caucho.xsl.Generator;
import com.caucho.xsl.JavaScriptStylesheet;
import com.caucho.xsl.KeyFun;
import com.caucho.xsl.Sort;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Template;
import com.caucho.xsl.Xsl;
import com.caucho.xsl.XslNumberFormat;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class JavaGenerator
extends Generator {
    private static WriteStream dbg = LogStream.open("/caucho.com/xsl/java");
    private static WriteStream dbgSrc = LogStream.open("/caucho.com/xsl/source");
    private static int count;
    Path path;
    WriteStream s;
    ArrayList matchPatterns;
    ArrayList selectPatterns;
    ArrayList exprs = new ArrayList();
    HashMap exprMap = new HashMap();
    ArrayList sorts = new ArrayList();
    ArrayList namespaces = new ArrayList();
    ArrayList formats = new ArrayList();
    ArrayList functions = new ArrayList();
    int templateCount = 0;
    int unique;
    ArrayList macros = new ArrayList();
    ArrayList fragments = new ArrayList();
    ArrayList strings = new ArrayList();
    IntArray envDepth = new IntArray();
    private boolean isLineBegin;
    private int depth;
    private int callDepth;
    private int flagCount;
    private String className;
    private String pkg;
    private ClassLoader parentLoader;
    private JavaCompiler compiler;
    private boolean disableEscaping;
    JavaScriptStylesheet xslScript;

    protected void printHeader() throws IOException {
        this.println("/*");
        this.println(" * Generated by Resin");
        this.println(" */");
        this.println();
        this.println("package " + this.pkg + ";");
        this.println();
        this.println("import java.io.*;");
        this.println("import java.util.*;");
        this.println("import javax.servlet.*;");
        this.println("import javax.servlet.http.*;");
        this.println("import javax.servlet.jsp.*;");
        this.println("import org.w3c.dom.*;");
        this.println("import com.caucho.util.*;");
        this.println("import com.caucho.xml.*;");
        this.println("import com.caucho.xpath.*;");
        this.println("import com.caucho.xsl.*;");
        int n = 0;
        while (n < this.imports.size()) {
            this.println("import " + this.imports.get(n) + ";");
            ++n;
        }
        this.println();
        this.println("public class " + this.className + " extends JavaStylesheet {");
        this.pushDepth();
    }

    protected void printTemplate(Element element, String string, String string2, String string3, double d) throws Exception {
        if (string != null && !string.equals("")) {
            int n = 0;
            while (n < this.macros.size()) {
                Element element2 = (Element)this.macros.get(n);
                if (element2.getAttribute("name").equals(element.getAttribute("name"))) {
                    this.macros.set(n, element);
                }
                ++n;
            }
            if (n >= this.macros.size()) {
                this.macros.add(element);
            }
        }
        if (!string2.equals("")) {
            String string4 = this.createTemplatePattern(string, string2, string3, d, element);
            this.println("// '" + string2.replace('\n', ' ') + "'");
            this.println("private void " + string4 + "(XslWriter out, Node inputNode, Env env, String mode)");
            this.println("  throws Exception");
            this.println("{");
            this.pushDepth();
            this.println("Object _xsl_tmp;");
            this.println("Node node = inputNode;");
            if (this.isRawText) {
                this.println("boolean oldEscaping = out.disableEscaping(true);");
            } else {
                this.println("boolean oldEscaping = out.disableEscaping(false);");
            }
            this.generateChildren(element);
            if (!this.isCacheable) {
                this.println("out.setNotCacheable();");
            }
            this.println("out.disableEscaping(oldEscaping);");
            this.popDepth();
            this.println("}");
            this.println();
        }
    }

    String createTemplatePattern(String string, String string2, String string3, double d, Node node) throws Exception {
        String string4 = string != null ? this.getName(string) : this.getName(string2);
        String string5 = "_xsl_template_" + string4;
        this.functions.add(string5);
        if (string2 != null) {
            this.addPattern(this.parseMatch(string2), string3, d, string5, this.functions.size());
        }
        if (string != null) {
            this.xslScript.addMacro(string, string3, d, string5);
        }
        return string5;
    }

    protected void startDisableEscaping() throws IOException {
        if (!this.isRawText) {
            this.println("out.disableEscaping(true);");
        }
    }

    protected void endDisableEscaping() throws IOException {
        if (!this.isRawText) {
            this.println("out.disableEscaping(false);");
        }
    }

    protected void writeText(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return;
        }
        this.printLocation(this.filename, this.line);
        this.println("out.write(_xsl_string" + this.strings.size() + ", 0, " + string.length() + ");");
        this.strings.add(string);
    }

    protected void printLocation(String string, int n) throws Exception {
        if (string != null && !this.isSpecial) {
            this.println("out.setLocation(\"" + string + "\", " + n + ");");
        }
    }

    protected void printElement(Node node) throws Exception {
        CauchoElement cauchoElement = (CauchoElement)node;
        String string = node.getNodeName();
        if (string.equals("jsp:decl") || string.equals("jsp:declaration")) {
            this.println("if (out.isFlagFirst(" + this.flagCount++ + ")) {");
            this.pushDepth();
        }
        String string2 = cauchoElement.getPrefixName();
        String string3 = cauchoElement.getLocalName();
        String string4 = cauchoElement.getNamespace();
        String[] stringArray = (String[])this.namespaceAliases.get(string4);
        if (stringArray != null) {
            string2 = stringArray[0];
            string4 = stringArray[1];
        }
        if (this.excludedNamespaces.get(string4) != null) {
            string4 = null;
        }
        this.print("out.pushElement(");
        this.print(string2 == null ? "null" : "\"" + string2 + "\"");
        this.print(string3 == null ? ", null" : ", \"" + string3 + "\"");
        this.print(string4 == null ? ", null" : ", \"" + string4 + "\"");
        this.println(");");
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            CauchoNode cauchoNode = (CauchoNode)namedNodeMap.item(n);
            this.printAttribute(cauchoNode, cauchoElement);
            ++n;
        }
        this.generateChildren(node);
        this.println("out.popElement();");
        if (string.equals("jsp:decl") || string.equals("jsp:declaration")) {
            this.popDepth();
            this.print("}");
        }
    }

    private void printAttribute(CauchoNode cauchoNode, CauchoElement cauchoElement) throws Exception {
        if (cauchoNode.getNodeName().equals("xsl:use-attribute-sets")) {
            HashMap hashMap = (HashMap)this.attributeSets.get(cauchoNode.getNodeValue());
            if (hashMap == null) {
                return;
            }
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)hashMap.get(string);
                this.print("out.pushAttribute(");
                this.generateString(string, 43, cauchoElement);
                if (this.namespace != null) {
                    this.print(", _namespaces[" + this.namespaces.size());
                    this.namespaces.add(this.namespace);
                    this.print("]");
                }
                this.println(");");
                this.generateString(string2, 44, cauchoElement);
                this.println("out.popAttribute();");
            }
        } else {
            CauchoNode cauchoNode2 = cauchoNode;
            String string = cauchoNode2.getPrefixName();
            String string3 = cauchoNode2.getLocalName();
            String string4 = cauchoNode2.getNamespace();
            String[] stringArray = (String[])this.namespaceAliases.get(string4);
            if (stringArray != null) {
                string = stringArray[0];
                string4 = stringArray[1];
            }
            if (this.excludedNamespaces.get(string4) != null) {
                string4 = null;
            }
            String string5 = cauchoNode.getNodeValue();
            this.print("out.pushAttribute(");
            this.print(string == null ? "null" : "\"" + string + "\"");
            this.print(string3 == null ? ", null" : ", \"" + string3 + "\"");
            this.print(string4 == null ? ", null" : ", \"" + string4 + "\"");
            this.println(");");
            this.generateString(string5, 44, cauchoElement);
            this.println("out.popAttribute();");
        }
    }

    protected void pushCall() throws IOException {
        this.println("{");
        this.pushDepth();
        ++this.callDepth;
        this.println("Env _xsl_arg" + this.callDepth + " = XPath.createEnv(env);");
    }

    protected void popCall() throws IOException {
        this.println("XPath.freeEnv(_xsl_arg" + this.callDepth + ");");
        --this.callDepth;
        this.popDepth();
        this.println("}");
    }

    protected void printParam(String string, String string2, Element element) throws Exception {
        this.print("_xsl_arg" + this.callDepth + ".addVar(\"" + string + "\", ");
        this.generateString(string2, 43, element);
        this.println(");");
    }

    protected void printParam(String string, Object object) throws Exception {
        this.print("_xsl_arg" + this.callDepth + ".addVar(\"" + string + "\", ");
        this.printVariableValue(object);
        this.println(");");
    }

    protected void printApplyTemplates(Pattern pattern, String string, Sort[] sortArray) throws Exception {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        string = string.equals("") ? "null" : "\"" + string + "\"";
        if (pattern == null && sortArray == null) {
            this.println("for (Node _xsl_node = node.getFirstChild();");
            this.println("     _xsl_node != null;");
            this.println("     _xsl_node = _xsl_node.getNextSibling())");
            this.println("  applyNode(out, _xsl_node, _xsl_arg" + this.callDepth + ", " + string + ", " + n + ", " + n2 + ");");
        } else if (sortArray == null) {
            this.println("{");
            this.pushDepth();
            this.println("Iterator _xsl_loop = _select_patterns[" + this.selectPatterns.size() + "].select(node, env);");
            this.println("while (_xsl_loop.hasNext()) {");
            this.println("  applyNode(out, (Node) _xsl_loop.next(), _xsl_arg" + this.callDepth + ", " + string + ", " + n + ", " + n2 + ");");
            this.println("}");
            this.popDepth();
            this.println("}");
            this.selectPatterns.add(pattern);
        } else {
            this.println("{");
            this.pushDepth();
            this.println("ArrayList _xsl_list = xslSort(node, env, _select_patterns[" + this.selectPatterns.size() + "], _xsl_sorts[" + this.sorts.size() + "]);");
            this.println("for (int _xsl_i = 0; _xsl_i < _xsl_list.size(); _xsl_i++) {");
            this.println("  applyNode(out, (Node) _xsl_list.get(_xsl_i), _xsl_arg" + this.callDepth + ", " + string + ", " + n + ", " + n2 + ");");
            this.println("}");
            this.popDepth();
            this.println("}");
            this.selectPatterns.add(pattern);
            this.sorts.add(sortArray);
        }
    }

    protected void printApplyImports(String string, int n, int n2) throws Exception {
        string = string.equals("") ? "null" : "\"" + string + "\"";
        this.println("applyNode(out, node, _xsl_arg" + this.callDepth + ", " + string + ", " + n + ", " + (n2 - 1) + ");");
    }

    protected void printCallTemplate(String string, String string2) throws Exception {
        this.println("_xsl_macro_" + this.toJavaIdentifier(string) + "(out, node, _xsl_arg" + this.callDepth + ");");
    }

    protected void printParamVariable(String string, Expr expr) throws Exception {
        this.println("_xsl_tmp = env.getVar(\"" + string + "\");");
        this.println("if (_xsl_tmp == null)");
        this.print("  _xsl_tmp = ");
        this.printVariableValue(expr);
        this.println(";");
        this.println("env.addVar(\"" + string + "\", _xsl_tmp);");
    }

    protected void printParamVariable(String string, Element element) throws Exception {
        if (element.getFirstChild() != null) {
            this.println("_xsl_tmp = env.getVar(\"" + string + "\");");
            this.println("if (_xsl_tmp == null)");
            this.println("  _xsl_tmp = ");
            this.printVariableValue(element);
            this.println(";");
            this.println("env.addVar(\"" + string + "\", _xsl_tmp);");
        }
    }

    protected void printVariable(String string, Object object) throws Exception {
        this.print("env.addVar(\"");
        this.print(string);
        this.print("\", ");
        this.printVariableValue(object);
        this.println(");");
    }

    private void printVariableValue(Object object) throws Exception {
        if (object instanceof Expr) {
            this.print("_exprs[" + this.addExpr((Expr)object) + "].evalObject(node, env)");
        } else if (object instanceof Node) {
            this.print("_xsl_fragment" + this.fragments.size() + "(out, node, env)");
            this.fragments.add(object);
        } else {
            throw new RuntimeException();
        }
    }

    protected void printPopScope(int n) throws Exception {
        this.println("env.popVars(" + n + ");");
    }

    protected void printCopyOf(String string, Element element) throws Exception {
        this.println("out.copyOf(_exprs[ " + this.addExpr(string) + "].evalObject(node, env));");
    }

    protected void printSelectValue(String string, Element element) throws Exception {
        this.printStringExpr(string, element);
    }

    protected void printForEach(Element element, String string) throws Exception {
        this.println("{");
        this.pushDepth();
        this.print("Iterator _xsl_iter" + this.unique + " = _select_patterns[");
        this.print(this.createNodeSet(string, element));
        this.println("].select(node, " + this.getEnv() + ");");
        this.println("while (_xsl_iter" + this.unique + ".hasNext()) {");
        this.pushLoop();
        this.pushDepth();
        this.println("Node " + this.getElement() + " = node;");
        this.println("node = (Node) _xsl_iter" + this.unique++ + ".next();");
        Pattern pattern = this.nodeListContext;
        this.nodeListContext = this.parseMatch(string);
        this.generateChildren(element);
        this.nodeListContext = pattern;
        this.println("node = " + this.getElement() + ";");
        this.popDepth();
        this.println("}");
        this.popDepth();
        this.println("}");
        this.popLoop();
    }

    protected void printForEach(Element element, String string, Sort[] sortArray) throws Exception {
        this.println("{");
        this.pushDepth();
        this.println("ArrayList _xsl_list" + this.unique + " = xslSort(node, env" + ", _select_patterns[" + this.selectPatterns.size() + "], _xsl_sorts[" + this.sorts.size() + "]);");
        this.println("for (int _xsl_i" + this.unique + " = 0; _xsl_i" + this.unique + " < _xsl_list" + this.unique + ".size(); _xsl_i" + this.unique + "++) {");
        this.pushLoop();
        this.pushDepth();
        this.println("Node " + this.getElement() + " = node;");
        this.println("node = (Node) _xsl_list" + this.unique + ".get(_xsl_i" + this.unique + ");");
        ++this.unique;
        this.selectPatterns.add(this.parseSelect(string));
        this.sorts.add(sortArray);
        Pattern pattern = this.nodeListContext;
        this.nodeListContext = this.parseMatch(string);
        this.generateChildren(element);
        this.nodeListContext = pattern;
        this.println("node = " + this.getElement() + ";");
        this.popDepth();
        this.println("}");
        this.popLoop();
        this.popDepth();
        this.println("}");
    }

    protected void printIf(Element element, Expr expr) throws Exception {
        this.print("if (");
        this.printExprTest(expr, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    protected void printChoose(Element element, Expr expr, boolean bl) throws Exception {
        if (!bl) {
            this.print("else if (");
        } else {
            this.print("if (");
        }
        this.printExprTest(expr, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    protected void printOtherwise(Element element, boolean bl) throws Exception {
        if (!bl) {
            this.print("else ");
        }
        this.println("{");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    void printNumber(Expr expr, XslNumberFormat xslNumberFormat) throws Exception {
        this.print("exprNumber(out, node, env, _exprs[" + this.addExpr(expr) + "]");
        this.print(", _xsl_formats[" + this.formats.size() + "]");
        this.println(");");
        this.formats.add(xslNumberFormat);
    }

    void printNumber(String string, Pattern pattern, Pattern pattern2, XslNumberFormat xslNumberFormat) throws Exception {
        if (string.equals("single")) {
            this.print("singleNumber(out, ");
        } else if (string.equals("multiple")) {
            this.print("multiNumber(out, ");
        } else if (string.equals("any")) {
            this.print("anyNumber(out, ");
        } else {
            throw this.error("xsl:number cannot understand level=`" + string + "'");
        }
        this.print("node, env, ");
        this.printPattern(pattern);
        this.print(", ");
        this.printPattern(pattern2);
        this.print(", _xsl_formats[" + this.formats.size() + "]");
        this.println(");");
        this.formats.add(xslNumberFormat);
    }

    protected void printCopy(Element element) throws Exception {
        this.println("out.pushCopy(node);");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popCopy();");
    }

    protected void printCopyElement(Element element) throws Exception {
        this.print("out.pushElementCopy(node);");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popElement();");
    }

    protected void printElement(Element element, String string) throws Exception {
        this.print("out.pushElement(");
        this.generateString(string, 43, element);
        if (this.namespace != null) {
            this.print(", _namespaces[" + this.namespaces.size());
            this.namespaces.add(this.namespace);
            this.print("]");
        }
        this.println(");");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popElement();");
    }

    protected void printElement(Element element, String string, String string2) throws Exception {
        this.print("out.pushElementNs(");
        this.generateString(string, 43, element);
        this.print(", ");
        this.generateString(string2, 43, element);
        this.println(");");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popElement();");
    }

    private void printUseAttributeSet(Element element) throws Exception {
        Attr attr = ((CauchoElement)element).getFirstAttribute();
        while (attr != null) {
            HashMap hashMap;
            if (attr.getNodeName().equals("xsl:use-attribute-sets") && (hashMap = (HashMap)this.attributeSets.get(attr.getNodeValue())) != null) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = (String)hashMap.get(string);
                    this.print("out.pushAttribute(");
                    this.generateString(string, 43, element);
                    if (this.namespace != null) {
                        this.print(", _namespaces[" + this.namespaces.size());
                        this.namespaces.add(this.namespace);
                        this.print("]");
                    }
                    this.println(");");
                    this.generateString(string2, 44, element);
                    this.println("out.popAttribute();");
                }
            }
            attr = (Attr)attr.getNextSibling();
        }
    }

    protected void printAttribute(Element element, String string) throws Exception {
        this.print("out.pushAttribute(");
        this.generateString(string, 43, element);
        if (this.namespace != null) {
            this.print(", _namespaces[" + this.namespaces.size());
            this.namespaces.add(this.namespace);
            this.print("]");
        }
        this.println(");");
        this.generateChildren(element);
        this.println("out.popAttribute();");
    }

    protected void printAttribute(Element element, String string, String string2) throws Exception {
        this.print("out.pushAttributeNs(");
        this.generateString(string, 43, element);
        this.print(", ");
        this.generateString(string2, 43, element);
        this.println(");");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popAttribute();");
    }

    protected void printPi(Element element) throws Exception {
        String string = element.getAttribute("name");
        if (string.equals("")) {
            throw this.error("xsl:pi expected `name' attribute.");
        }
        this.print("out.pushPi(");
        this.generateString(string, 43, element);
        this.println(");");
        this.generateChildren(element);
        this.println("out.popPi();");
    }

    protected void printComment(Element element) throws Exception {
        this.println("out.pushComment();");
        this.generateChildren(element);
        this.println("out.popComment();");
    }

    protected void printError(String string) throws Exception {
        this.println("if (true) throw new XslParseException(\"" + string + "\");");
    }

    protected void printMessage(Element element) throws Exception {
        this.println("out.pushFragment();");
        this.generateChildren(element);
        String string = element.getAttribute("terminate");
        if (string.equals("yes")) {
            this.println("if (true) throw new IOException(((CauchoNode) out.popFragment()).getTextValue());");
        } else {
            this.println("System.err.println(((CauchoNode) out.popFragment()).getTextValue());");
        }
    }

    protected void printExpression(Element element) throws Exception {
        this.print("out.print(");
        this.print(((CauchoNode)((Object)element)).getTextValue());
        this.println(");");
    }

    protected void printScriptlet(Element element) throws Exception {
        this.println(((CauchoNode)((Object)element)).getTextValue());
    }

    protected void printDeclaration(Element element) throws Exception {
        this.println(((CauchoNode)((Object)element)).getTextValue());
    }

    protected void printCacheDepends(String string) throws Exception {
        this.print("out.addCacheDepend(out.getPwd().lookup(\"");
        this.printString(string);
        this.println("\"));");
    }

    String getElement() {
        return "node" + this.loopDepth;
    }

    void pushLoop() {
        ++this.loopDepth;
    }

    void popLoop() {
        --this.loopDepth;
    }

    String getEnv() {
        return "env";
    }

    void pushEnv() {
        this.envDepth.add(0);
    }

    void popEnv() {
        this.envDepth.pop();
    }

    void printPattern(Pattern pattern) throws Exception {
        if (pattern == null) {
            this.print("null");
        } else {
            this.print("_match_patterns[" + this.matchPatterns.size() + "]");
            this.matchPatterns.add(pattern);
        }
    }

    private int createNodeSet(String string, Element element) throws Exception {
        Pattern pattern = this.parseSelect(string);
        this.selectPatterns.add(pattern);
        return this.selectPatterns.size() - 1;
    }

    int createSelectPattern(Pattern pattern) throws Exception {
        this.selectPatterns.add(pattern);
        return this.selectPatterns.size() - 1;
    }

    int createMatchPattern(String string, Element element) throws Exception {
        Pattern pattern = this.parseMatch(string);
        this.matchPatterns.add(pattern);
        return this.matchPatterns.size() - 1;
    }

    String getName(String string) {
        CharBuffer charBuffer = new CharBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '(': 
                case ')': {
                    break;
                }
                case '.': 
                case ':': 
                case '|': {
                    charBuffer.append('_');
                    break;
                }
                default: {
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c < '0' || c > '9')) break;
                    charBuffer.append(c);
                }
            }
            ++n;
        }
        string = charBuffer.toString();
        if (this.names.get(string) == null) {
            this.names.put(string, string);
            return string;
        }
        n = 0;
        while (true) {
            String string2;
            if (this.names.get(string2 = string + n) == null) {
                this.names.put(string2, string2);
                return string2;
            }
            ++n;
        }
    }

    void printExprTest(Expr expr, String string) throws Exception {
        this.print("_exprs[" + this.addExpr(expr) + "].evalBoolean(" + string + ", " + this.getEnv() + ")");
    }

    void generateString(String string, int n, Element element) throws Exception {
        CharBuffer charBuffer = new CharBuffer();
        int n2 = 0;
        boolean bl = true;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c == '\n') {
                charBuffer.append("\\n");
            } else if (c == '\"') {
                charBuffer.append("\\\"");
            } else if (c == '{' && n2 + 1 < n3) {
                if (string.charAt(n2 + 1) == '{') {
                    charBuffer.append('{');
                    ++n2;
                } else {
                    if (n == 44) {
                        if (charBuffer.length() > 0) {
                            this.println("out.print(\"" + charBuffer.toString() + "\");");
                        }
                    } else {
                        if (!bl) {
                            this.print((char)n);
                        }
                        if (charBuffer.length() > 0) {
                            this.print("\"");
                            this.print(charBuffer.toString());
                            this.print("\"");
                            this.print((char)n);
                        }
                    }
                    charBuffer.clear();
                    ++n2;
                    while (n2 < n3 && string.charAt(n2) != '}') {
                        charBuffer.append(string.charAt(n2));
                        ++n2;
                    }
                    if (n == 44) {
                        this.printStringExpr(charBuffer.toString(), element);
                    } else {
                        this.stringExpr(charBuffer.toString(), element);
                    }
                    charBuffer.clear();
                    bl = false;
                }
            } else if (c == '}' && n2 + 1 < n3) {
                if (string.charAt(n2 + 1) == '}') {
                    charBuffer.append('}');
                    ++n2;
                } else {
                    charBuffer.append('}');
                }
            } else if (n2 + 2 < n3 && c == '<' && string.charAt(n2 + 1) == '#' && string.charAt(n2 + 2) == '=') {
                if (n == 44) {
                    if (charBuffer.length() > 0) {
                        this.println("out.print(\"" + charBuffer.toString() + "\");");
                    }
                } else {
                    if (!bl) {
                        this.print((char)n);
                    }
                    if (charBuffer.length() > 0) {
                        this.print("\"");
                        this.print(charBuffer.toString());
                        this.print("\"");
                        this.print((char)n);
                    }
                }
                charBuffer.clear();
                n2 += 3;
                while (n2 + 1 < n3 && string.charAt(n2) != '#' && string.charAt(n2 + 1) != '>') {
                    charBuffer.append(string.charAt(n2));
                    ++n2;
                }
                ++n2;
                if (n == 44) {
                    this.println("out.print(" + charBuffer + ");");
                } else {
                    this.print("(" + charBuffer + ")");
                }
                charBuffer.clear();
                bl = false;
            } else {
                charBuffer.append(c);
            }
            ++n2;
        }
        if (charBuffer.length() > 0) {
            if (n == 44) {
                this.println("out.print(\"" + charBuffer + "\");");
            } else {
                if (!bl) {
                    this.print((char)n);
                }
                this.print("\"" + charBuffer + "\"");
            }
        } else if (bl && n == 43) {
            this.print("\"\"");
        }
    }

    private void printStringExpr(String string, Element element) throws Exception {
        this.println("out.valueOf(_exprs[" + this.addExpr(string) + "].evalObject(node, " + this.getEnv() + "));");
    }

    private void stringExpr(String string, Element element) throws Exception {
        this.print("_exprs[" + this.addExpr(string) + "].evalString(node, " + this.getEnv() + ")");
    }

    private int addExpr(Expr expr) throws IOException {
        this.exprs.add(expr);
        return this.exprs.size() - 1;
    }

    private int addExpr(String string) throws IOException {
        Expr expr = (Expr)this.exprMap.get(string);
        if (expr == null) {
            expr = this.parseExpr(string);
            this.exprs.add(expr);
            this.exprMap.put(string, expr);
            return this.exprs.size() - 1;
        }
        return this.exprs.indexOf(expr);
    }

    protected StylesheetImpl completeGenerate(ArrayList arrayList) throws Exception {
        this.println("protected void applyNode(XslWriter out, Node node, Env env, String mode, int _xsl_min, int _xsl_max)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("Object _xsl_tmp;");
        this.println();
        this.println("switch (getTemplateId(node, env, mode, _xsl_min, _xsl_max)) {");
        int n = 0;
        while (n < this.functions.size()) {
            this.println("case " + (n + 1) + ":");
            this.println("  " + this.functions.get(n) + "(out, node, env, mode);");
            this.println("  break;");
            ++n;
        }
        this.println("default:");
        this.println("  applyNodeDefault(out, node, env, mode);");
        this.println("  break;");
        this.println("}");
        this.popDepth();
        this.println("}");
        this.printInit(arrayList);
        this.printMacros();
        this.printFragments();
        this.printTemplates();
        this.printStrings();
        this.printExpressions();
        this.printPatterns();
        this.popDepth();
        this.println("}");
        this.s.close();
        if (dbg.canWrite()) {
            ReadStream readStream = this.path.openRead();
            dbg.writeStream(readStream);
            readStream.close();
        }
        if (this.parentLoader instanceof DynamicClassLoader) {
            ((DynamicClassLoader)this.parentLoader).makeAll();
        }
        this.compiler.compile(this.path.getPath(), this.lineMap);
        StylesheetImpl stylesheetImpl = (StylesheetImpl)Xsl.loadStylesheet(this.pkg + "." + this.className, this.parentLoader);
        return stylesheetImpl;
    }

    private long getLastModified() {
        long l = 0L;
        int n = 0;
        while (n < this.depends.size()) {
            Path path = (Path)this.depends.get(n);
            if (path.getLastModified() > l) {
                l = path.getLastModified();
            }
            ++n;
        }
        return l;
    }

    protected void printInit(ArrayList arrayList) throws Exception {
        Object object;
        this.println("protected void _xsl_init(XslWriter out, Node node, Env env)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("Object _xsl_tmp;");
        int n = 0;
        while (n < arrayList.size()) {
            String string;
            String string2;
            object = (CauchoElement)arrayList.get(n);
            if (object.getLocalName() == "variable") {
                string2 = object.getAttribute("name");
                string = object.getAttribute("select");
                this.print("env.setGlobal(\"" + string2 + "\", ");
                if (!string.equals("")) {
                    this.printVariableValue(this.parseExpr(string));
                } else {
                    this.printVariableValue(object);
                }
                this.println(");");
            } else if (object.getLocalName() == "param") {
                if (object.getLocalName() == "variable") {
                    string2 = object.getAttribute("name");
                    string = object.getAttribute("select");
                    this.print("env.setGlobal(\"" + string2 + "\", ");
                    if (!string.equals("")) {
                        this.printVariableValue(this.parseExpr(string));
                    } else {
                        this.printVariableValue(object);
                    }
                    this.println(");");
                } else {
                    throw new RuntimeException();
                }
            }
            ++n;
        }
        this.println("templates = _staticTemplates;");
        this.popDepth();
        this.println("}");
        this.println("public boolean isModified()");
        this.println("{");
        this.pushDepth();
        this.println("return com.caucho.util.CauchoSystem.getVersionId() != " + CauchoSystem.getVersionId() + " ||");
        this.println("       super.isModified();");
        this.popDepth();
        this.println("}");
        this.println("public void init(com.caucho.vfs.Path pwd)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("super.init(pwd);");
        n = 0;
        while (n < this.depends.size()) {
            object = (Path)this.depends.get(n);
            if (((Path)object).getLastModified() > 0L) {
                this.print("addDepend(pwd.lookup(\"");
                this.printString(((Path)object).getPath());
                this.println("\"), " + ((Path)object).getLastModified() + "L);");
            }
            ++n;
        }
        n = 0;
        while (n < this.cacheDepends.size()) {
            object = (String)this.cacheDepends.get(n);
            this.print("addCacheDepend(\"");
            this.printString((String)object);
            this.println("\");");
            ++n;
        }
        this.println("HashMap preserve = new HashMap();");
        Iterator iterator = this.preserve.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.println("preserve.put(\"" + (String)object + "\", \"true\");");
        }
        this.println("HashMap strip = new HashMap();");
        iterator = this.strip.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.println("strip.put(\"" + (String)object + "\", \"true\");");
        }
        this.println("setSpaces(preserve, strip);");
        this.printOutput();
        this.printSorts();
        this.printFormats();
        this.printNamespaces();
        this.printFunctions();
        if (this.errorPage != null) {
            this.print("errorPage = \"");
            this.printString(this.errorPage);
            this.println("\";");
        }
        this.popDepth();
        this.println("}");
    }

    private void printOutput() throws Exception {
        String string;
        if (this.outputAttributes == null || this.outputAttributes.size() == 0) {
            return;
        }
        this.println();
        Iterator iterator = this.outputAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            String string2 = (String)this.outputAttributes.get(string);
            this.println("setOutputAttribute(\"" + string + "\", \"" + string2 + "\");");
        }
        string = null;
        if (this.outputAttributes != null) {
            string = (String)this.outputAttributes.get("disable-output-escaping");
        }
        if (string != null && !string.equals("no") && !string.equals("false")) {
            this.println("defaultDisableEscaping = true;");
        }
    }

    private void printSorts() throws Exception {
        if (this.sorts.size() == 0) {
            return;
        }
        this.println();
        this.println("_xsl_sorts = new com.caucho.xsl.Sort[][] { ");
        this.pushDepth();
        int n = 0;
        while (n < this.sorts.size()) {
            Sort[] sortArray = (Sort[])this.sorts.get(n);
            this.print("new com.caucho.xsl.Sort[] {");
            int n2 = 0;
            while (n2 < sortArray.length) {
                this.print("new com.caucho.xsl.Sort(\"" + sortArray[n2].getExpr() + "\", " + sortArray[n2].isAscending() + ", " + sortArray[n2].isText() + "), ");
                ++n2;
            }
            this.println("},");
            ++n;
        }
        this.popDepth();
        this.println("};");
    }

    private void printFormats() throws Exception {
        if (this.formats.size() == 0) {
            return;
        }
        this.println();
        this.println("_xsl_formats = new XslNumberFormat[] { ");
        this.pushDepth();
        int n = 0;
        while (n < this.formats.size()) {
            XslNumberFormat xslNumberFormat = (XslNumberFormat)this.formats.get(n);
            this.println("new XslNumberFormat(\"" + xslNumberFormat.getFormat() + "\", \"" + xslNumberFormat.getLang() + "\", " + xslNumberFormat.isAlphabetic() + ", \"" + xslNumberFormat.getGroupSeparator() + "\", " + xslNumberFormat.getGroupSize() + "),");
            ++n;
        }
        this.popDepth();
        this.println("};");
    }

    private void printNamespaces() throws Exception {
        if (this.namespaces.size() == 0) {
            return;
        }
        this.println();
        this.println("_namespaces = new NamespaceContext[] { ");
        this.pushDepth();
        int n = 0;
        while (n < this.namespaces.size()) {
            NamespaceContext namespaceContext = (NamespaceContext)this.namespaces.get(n);
            this.printNamespace(namespaceContext);
            this.println(",");
            ++n;
        }
        this.popDepth();
        this.println("};");
    }

    private void printNamespace(NamespaceContext namespaceContext) throws Exception {
        if (namespaceContext == null) {
            this.print("null");
            return;
        }
        this.print("new NamespaceContext(");
        this.printNamespace(namespaceContext.getPrev());
        this.print(", \"" + namespaceContext.getPrefix() + "\", \"" + namespaceContext.getUrl() + "\")");
    }

    private void printFunctions() throws Exception {
        Object object;
        Object object2;
        this.println();
        this.println("KeyFun keyFun = new KeyFun();");
        HashMap hashMap = this.keyFun.getKeys();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (KeyFun.Key)hashMap.get(object2);
            this.println("keyFun.add(\"" + (String)object2 + "\", XPath.parseMatch(\"" + ((KeyFun.Key)object).getMatch() + "\"), XPath.parseExpr(\"" + ((KeyFun.Key)object).getUse() + "\"));");
        }
        this.println("addFunction(\"key\", keyFun);");
        this.println();
        this.println("FormatNumberFun formatFun = new FormatNumberFun();");
        this.println("java.text.DecimalFormatSymbols symbols;");
        object2 = this.formatNumberFun.getLocales();
        iterator = ((HashMap)object2).keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)((HashMap)object2).get(object);
            this.println("symbols = new java.text.DecimalFormatSymbols();");
            this.println("symbols.setDecimalSeparator('" + decimalFormatSymbols.getDecimalSeparator() + "');");
            this.println("symbols.setGroupingSeparator('" + decimalFormatSymbols.getGroupingSeparator() + "');");
            this.println("symbols.setInfinity(\"" + decimalFormatSymbols.getInfinity() + "\");");
            this.println("symbols.setMinusSign('" + decimalFormatSymbols.getMinusSign() + "');");
            this.println("symbols.setNaN(\"" + decimalFormatSymbols.getNaN() + "\");");
            this.println("symbols.setPercent('" + decimalFormatSymbols.getPercent() + "');");
            this.println("symbols.setPerMill('" + decimalFormatSymbols.getPerMill() + "');");
            this.println("symbols.setZeroDigit('" + decimalFormatSymbols.getZeroDigit() + "');");
            this.println("symbols.setDigit('" + decimalFormatSymbols.getDigit() + "');");
            this.println("symbols.setPatternSeparator('" + decimalFormatSymbols.getPatternSeparator() + "');");
            this.println("formatFun.addLocale(\"" + (String)object + "\", symbols);");
        }
        this.println("addFunction(\"format-number\", formatFun);");
    }

    private void printMacros() throws Exception {
        int n = 0;
        while (n < this.macros.size()) {
            Element element = (Element)this.macros.get(n);
            String string = element.getAttribute("name");
            this.println("void _xsl_macro_" + this.toJavaIdentifier(string) + "(XslWriter out, Node inputNode, Env env)");
            this.println("  throws Exception");
            this.println("{");
            this.pushDepth();
            this.println("Object _xsl_tmp;");
            this.println("Node node = inputNode;");
            this.generateChildren(element);
            this.popDepth();
            this.println("}");
            ++n;
        }
    }

    private void printFragments() throws Exception {
        int n = 0;
        while (n < this.fragments.size()) {
            Element element = (Element)this.fragments.get(n);
            this.println("Object _xsl_fragment" + n + "(XslWriter out, Node inputNode, Env env )");
            this.println("  throws Exception");
            this.println("{");
            this.pushDepth();
            this.println("Object _xsl_tmp;");
            this.println("Node node = inputNode;");
            this.println("out.pushFragment();");
            this.generateChildren(element);
            this.println("return out.popFragment();");
            this.popDepth();
            this.println("}");
            ++n;
        }
    }

    private void printTemplates() throws Exception {
        this.println("static HashMap _staticTemplates;");
        this.println("static {");
        this.pushDepth();
        this.println("_staticTemplates = new HashMap();");
        this.println("Template []values;");
        this.println("try {");
        this.pushDepth();
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)this.templates.get(string);
            this.println("values = new Template[" + arrayList.size() + "];");
            this.println("_staticTemplates.put(\"" + string + "\", values);");
            int n = 0;
            while (n < arrayList.size()) {
                Template template = (Template)arrayList.get(n);
                this.print("values[" + n + "] = new Template(");
                this.print("XPath.parseMatch(\"" + template.getPattern().toPatternString() + "\"), ");
                this.print("\"" + template.getMode() + "\", ");
                this.print(template.getMin() + ", ");
                this.print(template.getMax() + ", ");
                this.print(template.getPriority() + ", ");
                this.print("\"" + template.getFunction() + "\", ");
                this.println("" + template.getId() + ");");
                ++n;
            }
        }
        this.popDepth();
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printStrings() throws Exception {
        int n = 0;
        while (n < this.strings.size()) {
            String string = (String)this.strings.get(n);
            this.print("static char[] _xsl_string" + n + " = \"");
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case '\n': {
                        this.print("\\n");
                        break;
                    }
                    case '\r': {
                        this.print("\\r");
                        break;
                    }
                    case '\"': {
                        this.print("\\\"");
                        break;
                    }
                    case '\\': {
                        this.print("\\\\");
                        break;
                    }
                    default: {
                        this.print(c);
                    }
                }
                ++n2;
            }
            this.println("\".toCharArray();");
            ++n;
        }
    }

    private void printExpressions() throws Exception {
        if (this.exprs.size() == 0) {
            return;
        }
        this.println("private static Expr []_exprs;");
        this.println("static {");
        this.pushDepth();
        this.println("try {");
        this.pushDepth();
        this.println("_exprs = new Expr[] { ");
        this.pushDepth();
        int n = 0;
        while (n < this.exprs.size()) {
            Expr expr = (Expr)this.exprs.get(n);
            if (expr.getListContext() == null) {
                this.println("XPath.parseExpr(\"" + expr + "\"),");
            } else {
                this.print("XPath.parseExpr(\"" + expr + "\", null, ");
                this.println("XPath.parseMatch(\"" + expr.getListContext() + "\")),");
            }
            ++n;
        }
        this.popDepth();
        this.println("};");
        this.popDepth();
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printPatterns() throws Exception {
        Pattern pattern;
        if (this.selectPatterns.size() == 0 && this.matchPatterns.size() == 0) {
            return;
        }
        this.println("private static Pattern []_select_patterns;");
        this.println("private static Pattern []_match_patterns;");
        this.println("static {");
        this.pushDepth();
        this.println("try {");
        this.pushDepth();
        this.println("_select_patterns = new Pattern[] { ");
        this.pushDepth();
        int n = 0;
        while (n < this.selectPatterns.size()) {
            pattern = (Pattern)this.selectPatterns.get(n);
            this.println("XPath.parseSelect(\"" + pattern + "\"),");
            ++n;
        }
        this.popDepth();
        this.println("};");
        this.println("_match_patterns = new Pattern[] { ");
        this.pushDepth();
        n = 0;
        while (n < this.matchPatterns.size()) {
            pattern = (Pattern)this.matchPatterns.get(n);
            this.println("XPath.parseMatch(\"" + pattern + "\"),");
            ++n;
        }
        this.popDepth();
        this.println("};");
        this.popDepth();
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void print(char c) throws IOException {
        if (this.isLineBegin) {
            this.printDepth();
        }
        this.s.print(c);
        this.isLineBegin = false;
    }

    private void print(String string) throws IOException {
        if (this.isLineBegin) {
            this.printDepth();
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '\n') {
                ++this.destLine;
            }
            ++n2;
        }
        this.s.print(string);
        this.isLineBegin = false;
    }

    private void print(int n) throws IOException {
        if (this.isLineBegin) {
            this.printDepth();
        }
        this.s.print(String.valueOf(n));
        this.isLineBegin = false;
    }

    private void println() throws IOException {
        if (this.isLineBegin) {
            this.printDepth();
        }
        this.s.println();
        ++this.destLine;
        this.isLineBegin = true;
    }

    private void println(char c) throws IOException {
        if (this.isLineBegin) {
            this.printDepth();
        }
        this.s.println(c);
        ++this.destLine;
        this.isLineBegin = true;
    }

    private void println(String string) throws IOException {
        this.print(string);
        this.s.println();
        ++this.destLine;
        this.isLineBegin = true;
    }

    private void pushDepth() {
        this.depth += 2;
    }

    private void popDepth() {
        this.depth -= 2;
    }

    private void printDepth() throws IOException {
        int n = 0;
        while (n < this.depth) {
            this.s.print(' ');
            ++n;
        }
    }

    protected void printString(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                this.s.print("\\\\");
            } else {
                this.s.print(string.charAt(n));
            }
            ++n;
        }
    }

    private String toJavaIdentifier(String string) {
        CharBuffer charBuffer = new CharBuffer();
        char c = string.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            charBuffer.append(c);
        } else {
            charBuffer.append("_");
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c)) {
                charBuffer.append(c);
            } else {
                charBuffer.append("_");
            }
            ++n;
        }
        return charBuffer.toString();
    }

    JavaGenerator(Path path, Path[] pathArray, ClassLoader classLoader, String string, String string2) throws IOException {
        super(path, pathArray, classLoader);
        int n;
        this.parentLoader = classLoader;
        this.compiler = new JavaCompiler(this.parentLoader);
        if (string2 != null) {
            if (string2.equals("utf-16")) {
                string2 = "utf-8";
                this.compiler.setEncoding(string2);
            } else {
                this.compiler.setEncoding(string2);
            }
        }
        if ((n = string.lastIndexOf(46)) >= 0) {
            this.pkg = "_xsl." + string.substring(0, n);
            string = string.substring(n + 1);
        } else {
            this.pkg = "_xsl";
        }
        this.className = string;
        this.init((this.pkg + "." + string).replace('.', '/') + ".java");
        Path path2 = CauchoSystem.getWorkPath();
        String string3 = (this.pkg + "." + string).replace('.', '/') + ".java";
        this.path = path2.lookup(string3);
        this.path.getParent().mkdirs();
        this.s = this.path.openWrite();
        if (string2 != null) {
            this.s.setEncoding(string2);
        }
        this.xslScript = new JavaScriptStylesheet();
        this.matchPatterns = new ArrayList();
        this.selectPatterns = new ArrayList();
    }
}

